/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class RecordRuleOptionListPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String VALUE = "value";
    private static final String FTYPE = "ftype";
    private static final String FCODE = "fcode";
    private static final String FNAME = "fname";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equalsIgnoreCase(btn.getKey().toLowerCase())) {
            this.close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List ops = (List)(value instanceof List ? value : new ArrayList());
        if (!ops.isEmpty()) {
            IDataModel model = this.getModel();
            int[] rowKeys = model.batchCreateNewEntryRow(ENTRYENTITY, ops.size());
            int i = 0;
            for (Map op : ops) {
                Map opName = (Map)op.get("name");
                String operationName = "";
                String name = (String)opName.get("zh_CN");
                if (opName.containsKey(ResManager.getLanguage())) {
                    operationName = (String)opName.get(ResManager.getLanguage());
                } else if (StringUtils.isNotEmpty((String)name)) {
                    operationName = name;
                }
                model.setValue(FTYPE, op.get("type"), rowKeys[i]);
                model.setValue(FCODE, op.get("key"), rowKeys[i]);
                model.setValue(FNAME, (Object)operationName, rowKeys[i++]);
            }
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)ops));
    }

    private void close() {
        Map<String, String> para = this.getSelectedOperation();
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private Map<String, String> getSelectedOperation() {
        HashMap<String, String> op = new HashMap<String, String>();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int rowIndex = entryGrid.getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            op.put("optionkey", this.getModel().getValue(FCODE, rowIndex).toString());
            op.put("optionname", this.getModel().getValue(FNAME, rowIndex).toString());
        }
        return op;
    }
}

