/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.basedata;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.conm.utils.CommonUtils;

public class RecordRulePlugin
extends AbstractFormPlugin
implements ItemClickListener,
RowClickEventListener {
    private static final String PERFORMBILL = "performbill";
    public static final String PERFORMFIELDNAME = "performfieldname";
    public static final String PERFORMFIELD = "performfield";
    public static final String MAPPINGENTITY = "mappingentity";
    public static final String OPTIONENTITY = "optionentity";
    public static final String TBAR_MAPPINGENTITY = "tbar_mappingentity";
    public static final String RECORDBILL = "recordbill";
    public static final String RECORDFIELD = "recordfield";
    public static final String RECORDFIELDNAME = "recordfieldname";
    public static final String PERFORMFIELDCALLBACK = "performfieldcallback";
    public static final String BOTP_SELECTFIELD = "botp_selectfield";
    public static final String TREENODES = "treenodes";
    public static final String BTN_AUTOMATCHFIELD = "btn_automatchfield";
    public static final String OPTIONKEY = "optionkey";
    public static final String OPTIONNAME = "optionname";
    public static final String OPTIONNAMECALLBACK = "optionnamecallback";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PERFORMFIELDNAME});
        this.addClickListeners(new String[]{OPTIONNAME});
        this.addItemClickListeners(new String[]{TBAR_MAPPINGENTITY});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateMappingEntity();
    }

    private void updateMappingEntity() {
        Optional.ofNullable(this.getModel().getValue(MAPPINGENTITY)).ifPresent(mappingEntity -> Optional.ofNullable(this.getModel().getValue(RECORDBILL)).ifPresent(recordBill -> {
            MainEntityType recordEntityType = MetadataServiceHelper.getDataEntityType((String)((DynamicObject)recordBill).getPkValue().toString());
            DynamicObjectCollection entrys = (DynamicObjectCollection)mappingEntity;
            AtomicInteger rowIndex = new AtomicInteger(entrys.size());
            List keys = entrys.stream().map(entry -> entry.getString(RECORDFIELD)).collect(Collectors.toList());
            recordEntityType.getFields().forEach((fieldKey, value) -> {
                if (!keys.contains(fieldKey)) {
                    this.getModel().createNewEntryRow(MAPPINGENTITY);
                    this.getModel().setValue(RECORDFIELD, fieldKey, rowIndex.get());
                    DynamicProperty findProperty = (DynamicProperty)recordEntityType.findProperty(fieldKey);
                    this.getModel().setValue(RECORDFIELDNAME, (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%s", (String)"RecordRulePlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]), findProperty.getDisplayName()), rowIndex.get());
                    rowIndex.getAndIncrement();
                }
            });
            recordEntityType.getAllEntities().forEach((key, entityType) -> {
                if (entityType instanceof EntryType && !entityType.getName().endsWith("_lk")) {
                    Map entityTypeFields = entityType.getFields();
                    entityTypeFields.forEach((fieldKey, value) -> {
                        if (!keys.contains(key + "." + fieldKey)) {
                            this.getModel().createNewEntryRow(MAPPINGENTITY);
                            this.getModel().setValue(RECORDFIELD, (Object)(key + "." + fieldKey), rowIndex.get());
                            DynamicProperty findProperty = (DynamicProperty)recordEntityType.findProperty(fieldKey);
                            this.getModel().setValue(RECORDFIELDNAME, (Object)(entityType.getDisplayName() + "." + findProperty.getDisplayName()), rowIndex.get());
                            rowIndex.getAndIncrement();
                        }
                    });
                }
            });
        }));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet;
        String fieldName = e.getProperty().getName();
        block10: for (ChangeData changeData : valueSet = e.getChangeSet()) {
            if (!CommonUtils.isRealChanged((ChangeData)changeData)) continue;
            Object newValue = changeData.getNewValue();
            switch (fieldName) {
                case "performbill": {
                    if (this.getModel().getEntryRowCount(OPTIONENTITY) == 0) continue block10;
                    this.getModel().deleteEntryData(OPTIONENTITY);
                    continue block10;
                }
                case "recordbill": {
                    if (this.getModel().getEntryRowCount(MAPPINGENTITY) != 0) {
                        this.getModel().deleteEntryData(MAPPINGENTITY);
                    }
                    if (CommonUtils.isNull((Object)newValue)) continue block10;
                    this.createMappingEntity((String)((DynamicObject)newValue).getPkValue());
                    continue block10;
                }
                case "performfieldname": {
                    if (!CommonUtils.isNull((Object)newValue)) continue block10;
                    this.getModel().setValue(PERFORMFIELD, null, changeData.getRowIndex());
                }
            }
        }
    }

    private void createMappingEntity(String pkValue) {
        try {
            MainEntityType recordEntityType = MetadataServiceHelper.getDataEntityType((String)pkValue);
            Map fields = recordEntityType.getFields();
            if (!fields.isEmpty()) {
                this.getModel().batchCreateNewEntryRow(MAPPINGENTITY, fields.size());
                AtomicInteger rowIndex = new AtomicInteger(0);
                fields.forEach((fieldKey, value) -> {
                    this.getModel().setValue(RECORDFIELD, fieldKey, rowIndex.get());
                    DynamicProperty findProperty = (DynamicProperty)recordEntityType.findProperty(fieldKey);
                    this.getModel().setValue(RECORDFIELDNAME, (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934.%s", (String)"RecordRulePlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]), findProperty.getDisplayName()), rowIndex.get());
                    rowIndex.getAndIncrement();
                });
                Map entityTypes = recordEntityType.getAllEntities();
                entityTypes.forEach((key, entityType) -> {
                    if (entityType instanceof EntryType && !entityType.getName().endsWith("_lk")) {
                        Map entityTypeFields = entityType.getFields();
                        this.getModel().batchCreateNewEntryRow(MAPPINGENTITY, entityTypeFields.size());
                        entityTypeFields.forEach((fieldKey, value) -> {
                            this.getModel().setValue(RECORDFIELD, (Object)(key + "." + fieldKey), rowIndex.get());
                            DynamicProperty findProperty = (DynamicProperty)recordEntityType.findProperty(fieldKey);
                            this.getModel().setValue(RECORDFIELDNAME, (Object)(entityType.getDisplayName() + "." + findProperty.getDisplayName()), rowIndex.get());
                            rowIndex.getAndIncrement();
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "performfieldname": {
                this.openPerformFieldList();
                break;
            }
            case "optionname": {
                this.openOptionList();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (CommonUtils.isNull((Object)returnData)) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex(MAPPINGENTITY);
        switch (actionId) {
            case "performfieldcallback": {
                String fieldId = returnData.toString();
                Object performBill = this.getModel().getValue(PERFORMBILL);
                String performBillId = (String)((DynamicObject)performBill).getPkValue();
                MainEntityType performBillMainType = MetadataServiceHelper.getDataEntityType((String)performBillId);
                String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)performBillMainType, (String)fieldId);
                String[] sourceItems = fieldId.split("\\.");
                if (sourceItems.length > 2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u5c5e\u6027\u5c42\u7ea7\u4e0d\u80fd\u8d85\u8fc73\u7ea7\u3002", (String)"RecordRulePlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (sourceItems.length > 1) {
                    IDataEntityProperty findProperty = performBillMainType.findProperty(sourceItems[0]);
                    String parentName = findProperty.getParent().getName();
                    if (!performBillId.equals(parentName)) {
                        fieldId = parentName.concat(".").concat(sourceItems[0]).concat(".").concat(sourceItems[1]);
                    }
                } else {
                    IDataEntityProperty findProperty = performBillMainType.findProperty(fieldId);
                    if (findProperty == null) {
                        return;
                    }
                    String parentName = findProperty.getParent().getName();
                    if (!performBillId.equals(parentName)) {
                        fieldId = parentName.concat(".").concat(fieldId);
                    }
                }
                this.getModel().setValue(PERFORMFIELD, (Object)fieldId, row);
                this.getModel().setValue(PERFORMFIELDNAME, (Object)fieldCaption, row);
                break;
            }
            case "optionnamecallback": {
                int index = this.getModel().getEntryCurrentRowIndex(OPTIONENTITY);
                Map map = (Map)returnData;
                this.getModel().setValue(OPTIONKEY, map.get(OPTIONKEY), index);
                this.getModel().setValue(OPTIONNAME, map.get(OPTIONNAME), index);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (BTN_AUTOMATCHFIELD.equals(evt.getItemKey())) {
            this.autoMatchFields();
        }
    }

    private void openPerformFieldList() {
        PropTreeBuildOption option;
        int row = this.getModel().getEntryCurrentRowIndex(MAPPINGENTITY);
        Object performBill = this.getModel().getValue(PERFORMBILL);
        Object recordBill = this.getModel().getValue(RECORDBILL);
        String recordFieldValue = (String)this.getModel().getValue(RECORDFIELD, row);
        if (CommonUtils.isNull((Object)performBill) || CommonUtils.isNull((Object)recordFieldValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c65\u884c\u5355\u636e\u3001\u767b\u8bb0\u5355\u636e\u548c\u767b\u8bb0\u5355\u636e\u5b57\u6bb5\u3002", (String)"RecordRulePlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        String performBillId = (String)((DynamicObject)performBill).getPkValue();
        String recordBillId = (String)((DynamicObject)recordBill).getPkValue();
        MainEntityType performBillMainType = MetadataServiceHelper.getDataEntityType((String)performBillId);
        MainEntityType recordBillMainType = MetadataServiceHelper.getDataEntityType((String)recordBillId);
        IDataEntityProperty targetProperty = recordBillMainType.findProperty(recordFieldValue);
        if (targetProperty instanceof BigIntProp) {
            option = new PropTreeBuildOption(null, BigIntProp.class);
            option.setIncludeParentEntity(true);
            option.setIncludeChildEntity(true);
            option.setIncludePKField(true);
            option.addMatchedClassTypes(LongProp.class);
        } else {
            option = new PropTreeBuildOption(null, targetProperty);
            option.setIncludeParentEntity(true);
            option.setIncludeChildEntity(true);
            option.setIncludePKField(true);
        }
        TreeNode performBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)performBillMainType, (PropTreeBuildOption)option);
        this.showSrcFieldForm(performBillNode);
    }

    private void openOptionList() {
        Object performBill = this.getModel().getValue(PERFORMBILL);
        if (CommonUtils.isNull((Object)performBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c65\u884c\u5355\u636e\u3002", (String)"RecordRulePlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        String performBillId = (String)((DynamicObject)performBill).getPkValue();
        Optional.ofNullable(EntityMetadataCache.getDataEntityOperate((String)performBillId)).ifPresent(dataEntityOperate -> {
            FormShowParameter parameter = new FormShowParameter();
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.Modal);
            parameter.setOpenStyle(openStyle);
            parameter.setFormId("conm_option_list");
            parameter.setCustomParam("value", dataEntityOperate);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPTIONNAMECALLBACK));
            this.getView().showForm(parameter);
        });
    }

    private void showSrcFieldForm(TreeNode performBillNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOTP_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)performBillNode);
        showParameter.getCustomParams().put(TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PERFORMFIELDCALLBACK));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void autoMatchFields() {
        DynamicObject performBill = (DynamicObject)this.getModel().getValue(PERFORMBILL);
        DynamicObject recordBill = (DynamicObject)this.getModel().getValue(RECORDBILL);
        if (CommonUtils.isNull((Object)performBill) || CommonUtils.isNull((Object)recordBill)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c65\u884c\u5355\u636e\u548c\u767b\u8bb0\u5355\u636e\u3002", (String)"RecordRulePlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        String performBillId = (String)performBill.getPkValue();
        String recordBillId = (String)recordBill.getPkValue();
        MainEntityType performBillMainType = MetadataServiceHelper.getDataEntityType((String)performBillId);
        MainEntityType recordBillMainType = MetadataServiceHelper.getDataEntityType((String)recordBillId);
        IntStream.range(0, this.getModel().getEntryRowCount(MAPPINGENTITY)).forEach(rowIndex -> {
            String performFieldKey = (String)this.getModel().getValue(PERFORMFIELD, rowIndex);
            if (!CommonUtils.isNull((Object)performFieldKey)) {
                return;
            }
            String[] keyArray = this.getModel().getValue(RECORDFIELD, rowIndex).toString().split("\\.");
            String recordFieldKey = keyArray[keyArray.length - 1];
            DynamicProperty targetField = (DynamicProperty)recordBillMainType.findProperty(recordFieldKey);
            if (targetField == null) {
                return;
            }
            DynamicProperty performField = (DynamicProperty)performBillMainType.findProperty(recordFieldKey);
            if (performField == null) {
                return;
            }
            String performFieldName = EntityParseHelper.buildPropFullCaption((IDataEntityProperty)performField);
            String parentName = performField.getParent().getName();
            String fieldName = performField.getName();
            if (!performBillId.equals(parentName)) {
                fieldName = parentName.concat(".").concat(fieldName);
            }
            this.getModel().setValue(PERFORMFIELD, (Object)fieldName, rowIndex);
            this.getModel().setValue(PERFORMFIELDNAME, (Object)performFieldName, rowIndex);
        });
    }
}

