/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.basedata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.extension.FileServiceExtFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.mscon.common.utils.MetaDataHelper;
import kd.scmc.conm.business.helper.MetaDataParseHelper;
import kd.scmc.conm.formplugin.basedata.ContractPreviewPlugin;
import kd.scmc.conm.utils.CommonUtils;

public class TemplateEditPlugIn
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener,
WebOfficeDataListener {
    private static final Log log = LogFactory.getLog(ContractPreviewPlugin.class);
    private MainEntityType contractEntityType;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_terminsert"});
        EntryGrid grid = (EntryGrid)this.getControl("entry_contentity");
        grid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid markGrid = (EntryGrid)this.getControl("entry_varcontract");
        markGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid termGrid = (EntryGrid)this.getControl("entry_varterm");
        termGrid.addHyperClickListener((HyperLinkClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        this.getPageCache().put("entryid", (String)param.getCustomParam("entryid"));
        DynamicObject parentDataEntity = this.loadParentDataEntity();
        this.openWebOffice(parentDataEntity);
        Boolean treeVariable = (Boolean)SysParamHelper.getSysParam4conm((Long)RequestContext.get().getOrgId(), (String)"treevariable");
        if (!treeVariable.booleanValue()) {
            this.initContractField(parentDataEntity);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"varflex"});
        }
    }

    private Object getOperateDefaultName(String key) {
        Object defValue = null;
        switch (key) {
            case "operation": {
                TextProp textPropOp = (TextProp)this.getModel().getProperty("operation");
                defValue = textPropOp.getDefValue();
                if (!StringUtils.isEmpty((String)((String)defValue))) break;
                defValue = ResManager.loadKDString((String)"\u63d2\u5165\u53d8\u91cf", (String)"TemplateEditPlugIn_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "var_location": {
                TextProp textPropLoc = (TextProp)this.getModel().getProperty("var_location");
                defValue = textPropLoc.getDefValue();
                if (!StringUtils.isEmpty((String)((String)defValue))) break;
                defValue = ResManager.loadKDString((String)"\u5b9a\u4f4d\u53d8\u91cf", (String)"TemplateEditPlugIn_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "var_del": {
                TextProp textPropDel = (TextProp)this.getModel().getProperty("var_del");
                defValue = textPropDel.getDefValue();
                if (!StringUtils.isEmpty((String)((String)defValue))) break;
                defValue = ResManager.loadKDString((String)"\u5220\u9664\u53d8\u91cf", (String)"TemplateEditPlugIn_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "term_location": {
                TextProp textPropT_Loc = (TextProp)this.getModel().getProperty("term_location");
                defValue = textPropT_Loc.getDefValue();
                if (!StringUtils.isEmpty((String)((String)defValue))) break;
                defValue = ResManager.loadKDString((String)"\u5b9a\u4f4d\u6761\u6b3e", (String)"TemplateEditPlugIn_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                break;
            }
            case "term_del": {
                TextProp textPropT_Del = (TextProp)this.getModel().getProperty("term_del");
                defValue = textPropT_Del.getDefValue();
                if (!StringUtils.isEmpty((String)((String)defValue))) break;
                defValue = ResManager.loadKDString((String)"\u5220\u9664\u6761\u6b3e", (String)"TemplateEditPlugIn_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
            }
        }
        return defValue;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        switch (fieldName) {
            case "operation": {
                this.insertVariable(rowIndex);
                break;
            }
            case "var_location": {
                this.locateMark(rowIndex, "varkey");
                break;
            }
            case "var_del": {
                this.deleteMark(rowIndex, "varkey");
                this.getModel().deleteEntryRow("entry_varcontract", rowIndex);
                break;
            }
            case "term_location": {
                this.locateMark(rowIndex, "vartermkey");
                break;
            }
            case "term_del": {
                this.deleteMark(rowIndex, "vartermkey");
                this.getModel().deleteEntryRow("entry_varterm", rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (Objects.equals("btn_terminsert", key.toLowerCase())) {
            this.insertTerm();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String fileName = this.getFileName();
        switch (evt.getItemKey().toLowerCase()) {
            case "btn_save": {
                this.getView().getPageCache().put("isUpdate", "true");
                WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
                if (StringUtils.isNotEmpty((String)fileName)) {
                    webOffice.save(fileName);
                    break;
                }
            }
            case "savenew": {
                FormShowParameter parameter = new FormShowParameter();
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.Modal);
                parameter.setOpenStyle(openStyle);
                parameter.setFormId("conm_filesave");
                parameter.setCustomParam("filename", (Object)(fileName != null && !fileName.isEmpty() ? fileName.substring(0, fileName.lastIndexOf(46)) : ""));
                CloseCallBack closeCallBack = new CloseCallBack();
                closeCallBack.setActionId("savenew");
                closeCallBack.setClassName(this.getPluginName());
                parameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(parameter);
                break;
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        int size;
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u6863\u3002", (String)"TemplateEditPlugIn_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        Map urlData = (Map)urls[0];
        String tempUrl = (String)urlData.get("url");
        log.info("\u4e34\u65f6\u6587\u4ef6tempUrl : " + tempUrl);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream in = tempFileCache.getInputStream(tempUrl);
        try {
            size = in.available();
        }
        catch (IOException e) {
            String errInfo = String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u5b57\u8282\u6570\u8bfb\u53d6\u5931\u8d25\uff0c%s\u3002", (String)"TemplateEditPlugIn_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]), e.getMessage());
            throw new KDBizException(errInfo);
        }
        if (StringUtils.isEmpty((String)tempUrl)) {
            return;
        }
        if (Objects.equals("webofficeap", evt.getCallbackKey())) {
            String fileName = (String)urlData.get("name");
            String url = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)"conm", (String)"conm_template", (Object)"weboffice", (String)fileName, (boolean)true, (boolean)true);
            if (StringUtils.isEmpty((String)url)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TemplateEditPlugIn_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject template = this.loadParentDataEntity();
            DynamicObjectCollection entryentity = template.getDynamicObjectCollection("attachmententry");
            DynamicObject attachment = null;
            String isUpdate = this.getPageCache().get("isUpdate");
            String entryid = this.getPageCache().get("entryid");
            if ("true".equalsIgnoreCase(isUpdate) && StringUtils.isNotEmpty((String)entryid)) {
                for (DynamicObject object : entryentity) {
                    if (!entryid.equalsIgnoreCase(object.getPkValue().toString())) continue;
                    object.set("modifydate", (Object)new Date());
                    object.set("filemodifier", (Object)RequestContext.get().getUserId());
                    DynamicObjectCollection file = object.getDynamicObjectCollection("attachmentfile");
                    if (file != null && file.size() <= 0) {
                        DynamicObject aNew = file.addNew();
                        attachment = this.getBdAttachment((String)urlData.get("uid"), (String)urlData.get("name"), url, size);
                        aNew.set("fbasedataid", (Object)attachment);
                    } else if (file != null && file.size() > 0) {
                        Object fbasedataid = ((DynamicObject)file.get(0)).getDynamicObject("fbasedataid").getPkValue();
                        attachment = BusinessDataServiceHelper.loadSingle((Object)fbasedataid, (String)"bd_attachment");
                        attachment.set("url", (Object)url);
                        attachment.set("size", (Object)size);
                        object.set("filename", (Object)object.getString("filename"));
                    }
                    this.updateTemplateSubEntry(object);
                    break;
                }
            } else {
                attachment = this.getBdAttachment((String)urlData.get("uid"), (String)urlData.get("name"), url, size);
                this.setAttachmentFile(urlData, template, attachment);
            }
            log.info("get parentView template DataEntity : " + template);
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
            if (save != null && save.length > 0) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5408\u540c\u6a21\u7248\u6587\u4ef6\u6210\u529f\u3002", (String)"TemplateEditPlugIn_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u7248\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TemplateEditPlugIn_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateTemplateSubEntry(DynamicObject object) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection varEntity = dataEntity.getDynamicObjectCollection("varentity");
        DynamicObjectCollection subEntry = object.getDynamicObjectCollection("subentryentity");
        Iterator iterator = subEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject subVarRow = (DynamicObject)iterator.next();
            String subVarNum = subVarRow.getString("varnum");
            boolean has = false;
            for (Iterator varRow : varEntity) {
                String varNum = varRow.getString("varnum");
                if (!varNum.equals(subVarNum)) continue;
                has = true;
                break;
            }
            if (has) continue;
            iterator.remove();
        }
        for (DynamicObject varRow : varEntity) {
            String varNum = varRow.getString("varnum");
            boolean has = false;
            for (DynamicObject subRow : subEntry) {
                String subVarNum = subRow.getString("varnum");
                if (!varNum.equals(subVarNum)) continue;
                has = true;
                break;
            }
            if (has) continue;
            DynamicObject newRow = subEntry.addNew();
            newRow.set("varnum", (Object)varNum);
            newRow.set("srcfield", (Object)varRow.getString("srcfield"));
            newRow.set("settings_tag", (Object)varRow.getString("settings"));
            newRow.set("vartype", (Object)varRow.getString("vartype"));
        }
    }

    private void initContractField(DynamicObject parentDataEntity) {
        Map fields = MetaDataParseHelper.getHeadVisField((MainEntityType)this.contractEntityType);
        EntityType entryType = (EntityType)this.contractEntityType.getAllEntities().get("billentry");
        if (null != entryType) {
            fields.put("billentry", entryType.getDisplayName().getLocaleValue());
        }
        log.info("\u5b9e\u4f53\u5305\u542b\u7269\u6599\u660e\u7ec6\u5206\u5f55\u3002" + (entryType != null));
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection varEntry = dataEntity.getDynamicObjectCollection("entry_contentity");
        Object operation = this.getOperateDefaultName("operation");
        for (Map.Entry entry : fields.entrySet()) {
            DynamicObject dym = varEntry.addNew();
            dym.set("name", entry.getValue());
            dym.set("key", entry.getKey());
            dym.set("operation", operation);
        }
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.getAllBookmarks("initVariable");
        this.getView().updateView("entry_contentity");
    }

    private void openWebOffice(DynamicObject parentDataEntity) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object billId = param.getCustomParam("templateID");
        String entryid = (String)param.getCustomParam("entryid");
        if (billId == null || Objects.equals(billId, 0L)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TemplateEditPlugIn_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        String fileUrl = null;
        String fileType = null;
        if (StringUtils.isNotEmpty((String)entryid)) {
            DynamicObjectCollection entryentity1 = parentDataEntity.getDynamicObjectCollection("attachmententry");
            for (DynamicObject object : entryentity1) {
                if (!entryid.equalsIgnoreCase(object.getPkValue().toString())) continue;
                DynamicObjectCollection file = object.getDynamicObjectCollection("attachmentfile");
                if (file == null || file.size() <= 0) break;
                Object fbasedataid = ((DynamicObject)file.get(0)).getDynamicObject("fbasedataid").getPkValue();
                DynamicObject bd_attachment = BusinessDataServiceHelper.loadSingle((Object)fbasedataid, (String)"bd_attachment");
                fileUrl = bd_attachment.getString("url");
                fileType = bd_attachment.getString("type");
                break;
            }
        }
        if (!StringUtils.isEmpty(fileUrl)) {
            String realPath = FileServiceExtFactory.getAttachFileServiceExt().getRealPath(fileUrl);
            String fullUrl = UrlService.getAttachmentFullUrl((String)CommonUtils.urlEncode((String)realPath, (String)"utf-8"));
            log.info("\u76f8\u5bf9\u8def\u5f84 \uff1a " + fileUrl + ", \u7edd\u5bf9\u8def\u5f84 : " + fullUrl);
            this.getView().getPageCache().put("fileType", fileType);
            webOffice.open(fullUrl);
        } else {
            webOffice.openNew(WebOfficeFileType.word);
        }
    }

    private void locateMark(int rowIndex, String key) {
        String markKey = (String)this.getModel().getValue(key, rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.locateMark(markKey);
    }

    private void deleteMark(int rowIndex, String key) {
        String markKey = (String)this.getModel().getValue(key, rowIndex);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.deleteMarks(Collections.singletonList(markKey));
    }

    private void insertVariable(int rowIndex) {
        String name = (String)this.getModel().getValue("name", rowIndex);
        String number = (String)this.getModel().getValue("key", rowIndex);
        int row = this.getModel().insertEntryRow("entry_varcontract", 0);
        String key = "variable" + Uuid8.generateShortUuid().substring(0, 6) + "_" + number;
        this.getModel().setValue("varname", (Object)name, row);
        this.getModel().setValue("varnumber", (Object)number, row);
        this.getModel().setValue("varkey", (Object)key, row);
        this.getModel().setValue("varvalue", (Object)this.getMarkValue(name), row);
        this.getModel().setValue("var_location", this.getOperateDefaultName("var_location"), row);
        this.getModel().setValue("var_del", this.getOperateDefaultName("var_del"), row);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addMarks(new WebOfficeMark(key, this.getMarkValue(name)));
    }

    private String getMarkValue(String name) {
        return "${" + name + '}';
    }

    private void insertTerm() {
        DynamicObject term = (DynamicObject)this.getModel().getValue("term");
        if (term == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u6761\u6b3e\u3002", (String)"TemplateEditPlugIn_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        String markValue = term.getString("termcontent");
        String key = "term" + System.currentTimeMillis() + "_" + term.getPkValue();
        int row = this.getModel().insertEntryRow("entry_varterm", 0);
        this.getModel().setValue("varterm", term.getPkValue(), row);
        this.getModel().setValue("vartermkey", (Object)key, row);
        this.getModel().setValue("term_location", this.getOperateDefaultName("term_location"), row);
        this.getModel().setValue("term_del", this.getOperateDefaultName("term_del"), row);
        WebOffice webOffice = (WebOffice)this.getControl("webofficeap");
        webOffice.addMarks(new WebOfficeMark(key, markValue));
    }

    private DynamicObject loadParentDataEntity() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object billId = param.getCustomParam("templateID");
        if (billId == null || Objects.equals(billId, 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TemplateEditPlugIn_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject templateDym = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"conm_template");
        DynamicObject contEntity = templateDym.getDynamicObject("contentity");
        if (this.contractEntityType == null && contEntity != null) {
            this.contractEntityType = MetadataServiceHelper.getDataEntityType((String)contEntity.getString("number"));
        }
        return templateDym;
    }

    private String getFileName() {
        DynamicObject parentDataEntity = this.loadParentDataEntity();
        String entryid = this.getPageCache().get("entryid");
        if (StringUtils.isNotEmpty((String)entryid)) {
            DynamicObjectCollection entryentity1 = parentDataEntity.getDynamicObjectCollection("attachmententry");
            for (DynamicObject object : entryentity1) {
                if (!entryid.equalsIgnoreCase(object.getPkValue().toString())) continue;
                String filename = object.getString("filename");
                return filename;
            }
        }
        return null;
    }

    private void initVariable(List<String> bookmarks) {
        if (bookmarks == null || bookmarks.isEmpty()) {
            return;
        }
        DynamicObject template = this.loadParentDataEntity();
        Map fields = MetaDataParseHelper.getHeadVisField((MainEntityType)this.contractEntityType);
        FormShowParameter param = this.getView().getFormShowParameter();
        String entryid = (String)param.getCustomParam("entryid");
        Map<Object, Object> bookMarkMapping = new HashMap();
        if (StringUtils.isNotEmpty((String)entryid)) {
            bookMarkMapping = this.getBookMarkMapping(template, entryid);
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection varList = dataEntity.getDynamicObjectCollection("entry_varcontract");
        for (String mark : bookmarks) {
            String varType;
            String type;
            if (StringUtils.isEmpty((String)mark) || !mark.contains("_") || StringUtils.isEmpty((String)(type = mark.substring(0, mark.indexOf(95))))) continue;
            String value = mark.substring(mark.indexOf(95) + 1);
            if (type.contains("term")) {
                int row = this.getModel().createNewEntryRow("entry_varterm");
                this.getModel().setValue("varterm", (Object)value, row);
                this.getModel().setValue("vartermkey", (Object)mark, row);
                this.getModel().setValue("term_location", this.getOperateDefaultName("term_location"), row);
                this.getModel().setValue("term_del", this.getOperateDefaultName("term_del"), row);
                continue;
            }
            if (!type.contains("variable")) continue;
            Map markInfo = (Map)bookMarkMapping.get(mark);
            if (markInfo != null && "A".equals(varType = (String)markInfo.get("vartype"))) {
                value = (String)markInfo.get("srcfield");
            }
            String varDisplayName = MetaDataHelper.buildFullCaption((MainEntityType)this.contractEntityType, (String)value);
            DynamicObject var = varList.addNew();
            var.set("varnumber", (Object)value);
            var.set("varname", (Object)varDisplayName);
            var.set("varkey", (Object)mark);
            var.set("varvalue", (Object)this.getMarkValue((String)fields.get(value)));
            var.set("var_location", this.getOperateDefaultName("var_location"));
            var.set("var_del", this.getOperateDefaultName("var_del"));
        }
        this.getView().updateView("entry_varcontract");
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent e) {
        if (Objects.equals("initVariable", e.getId())) {
            this.initVariable(e.getBookmarks());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "savenew": {
                HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                this.getView().getPageCache().put("isUpdate", "false");
                WebOffice webOffice1 = (WebOffice)this.getControl("webofficeap");
                String version = (String)returnData.get("version");
                this.getPageCache().put("version", version);
                String fileType = this.getView().getPageCache().get("fileType");
                if (StringUtils.isEmpty((String)fileType)) {
                    fileType = "doc";
                }
                webOffice1.save((String)returnData.get("filename") + "." + fileType);
            }
        }
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent arg0) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent arg0) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent arg0) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent arg0) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent arg0) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent arg0) {
    }

    private void setAttachmentFile(Map<String, Object> urlData, DynamicObject template, DynamicObject attachment) {
        DynamicObjectCollection entryentity = template.getDynamicObjectCollection("attachmententry");
        int size = entryentity.size();
        DynamicObject entry = entryentity.addNew();
        for (DynamicObject obj : entryentity) {
            String v = obj.getString("version");
            if (!v.equals(this.getPageCache().get("version"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u7248\u4fdd\u5b58\u5931\u8d25\uff0c\u7248\u672c\u53f7\u5df2\u5b58\u5728\u3002", (String)"TemplateEditPlugIn_13", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        entry.set("version", (Object)this.getPageCache().get("version"));
        this.getPageCache().remove("version");
        entry.set("modifydate", (Object)new Date());
        entry.set("filename", urlData.get("name"));
        entry.set("filemodifier", (Object)RequestContext.get().getUserId());
        String entryid = String.valueOf(DB.genLongId((String)"conm_template.attachmententry"));
        this.getPageCache().put("entryid", entryid);
        entry.set("id", (Object)entryid);
        DynamicObjectCollection attachmentfield1 = entry.getDynamicObjectCollection("attachmentfile");
        DynamicObject aNew = attachmentfield1.addNew();
        aNew.set("fbasedataid", (Object)attachment);
        entry.set("attachmentfile", (Object)attachmentfield1);
        entry.set("entrynum", (Object)template.getString("number"));
        entry.set("rowenablestatus", (Object)Boolean.TRUE);
        entry.set("seq", (Object)size);
        this.updateTemplateSubEntry(entry);
    }

    private DynamicObject getBdAttachment(String uid, String fileName, String url, int size) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        long bd_attachment1 = DB.genLongId((String)"bd_attachment");
        attachment.set("id", (Object)bd_attachment1);
        attachment.set("name", (Object)fileName);
        attachment.set("uid", (Object)uid);
        attachment.set("url", (Object)url);
        attachment.set("type", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
        attachment.set("creator", (Object)RequestContext.get().getUserId());
        attachment.set("createtime", (Object)new Date());
        attachment.set("tempfile", (Object)"1");
        attachment.set("number", (Object)UUID.randomUUID().toString());
        attachment.set("status", (Object)"B");
        attachment.set("size", (Object)size);
        return attachment;
    }

    private Map<String, Map<String, String>> getBookMarkMapping(DynamicObject template, String entryId) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object billId = param.getCustomParam("templateID");
        if (billId == null || Objects.equals(billId, 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u53c2\u6570\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TemplateEditPlugIn_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Map<String, String>> bookMarkMapping = new HashMap<String, Map<String, String>>();
        if (StringUtils.isNotEmpty((String)entryId)) {
            DynamicObjectCollection entryEntity = template.getDynamicObjectCollection("attachmententry");
            for (DynamicObject entry : entryEntity) {
                if (!entryId.equalsIgnoreCase(entry.getPkValue().toString())) continue;
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subEntrys) {
                    HashMap<String, String> bookMarkInfo = new HashMap<String, String>();
                    bookMarkInfo.put("srcfield", subEntry.getString("srcfield"));
                    bookMarkInfo.put("vartype", subEntry.getString("vartype"));
                    bookMarkMapping.put(subEntry.getString("varnum"), bookMarkInfo);
                }
            }
        }
        return bookMarkMapping;
    }
}

