/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class Contract2Payapply
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        HashSet billIds = new HashSet(8);
        selectedRows.forEach(row -> billIds.add((Long)row.getPrimaryKeyValue()));
        QFilter idFilter = new QFilter("id", "in", billIds);
        QFilter payEntryIsPrePayFilter = new QFilter("payentry.isprepay", "=", (Object)Boolean.TRUE);
        QFilter payEntryPreTimePointFilter = new QFilter("payentry.pretimepoint", "=", (Object)" ");
        DynamicObjectCollection idCol = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{idFilter, payEntryIsPrePayFilter, payEntryPreTimePointFilter}, null);
        if (idCol == null || idCol.isEmpty()) {
            return;
        }
        HashSet hasPrePayAndPreTimePointIsBlankConmIds = new HashSet(10);
        idCol.forEach(id -> hasPrePayAndPreTimePointIsBlankConmIds.add(id.getLong("id")));
        QFilter conmBillIdFilter = new QFilter("billentry.conbillid", "in", hasPrePayAndPreTimePointIsBlankConmIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{conmBillIdFilter}, null);
        HashMap conBillIdAndPoBillIdMap = new HashMap(10);
        if (query == null || query.isEmpty()) {
            return;
        }
        query.forEach(row -> conBillIdAndPoBillIdMap.put(row.getLong("billentry.conbillid"), row.getLong("id")));
        QFilter hasJoinPayAmountFiter = new QFilter("purbillentry_pay.joinpayamount", ">", (Object)BigDecimal.ZERO);
        QFilter poBillIdFilter = new QFilter("id", "in", conBillIdAndPoBillIdMap.values());
        DynamicObjectCollection queryPO = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{hasJoinPayAmountFiter, poBillIdFilter}, null);
        if (queryPO == null || queryPO.isEmpty()) {
            return;
        }
        HashSet hasJoinAmountPOId = new HashSet(10);
        queryPO.forEach(row -> hasJoinAmountPOId.add(row.getLong("id")));
        if (!hasJoinAmountPOId.isEmpty()) {
            HashSet<Long> noPushIdSet = new HashSet<Long>(10);
            for (Map.Entry entry : conBillIdAndPoBillIdMap.entrySet()) {
                Long conid = (Long)entry.getKey();
                Long poId = (Long)entry.getValue();
                if (!hasJoinAmountPOId.contains(poId)) continue;
                noPushIdSet.add(conid);
            }
            if (noPushIdSet.isEmpty()) {
                return;
            }
            QFilter noPushIdFilter = new QFilter("id", "not in", noPushIdSet);
            e.getCustQFilters().add(noPushIdFilter);
            String noPushIdFilterExpression = noPushIdFilter.toCurrentString();
            e.setCustFilterExpression(noPushIdFilterExpression);
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u5df2\u7ecf\u53d1\u751f\u9884\u4ed8\u6b3e\uff0c\u5408\u540c\u4e0d\u80fd\u6267\u884c\u9884\u4ed8\u3002", (String)"Contract2Payapply_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet tgt = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = tgt.FindByEntityKey(this.getTgtMainType().toString());
    }

    public static Map<String, Object> getAccountBankInfo(DynamicObject asstact) {
        String accountStr = "";
        Long bebankId = 0L;
        DynamicObject bebank = null;
        String asstactType = asstact.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject erPayeeInfo = Contract2Payapply.getErPayeeInfo(asstact.getLong("id"));
            if (!ObjectUtils.isEmpty((Object)erPayeeInfo)) {
                bebank = erPayeeInfo.getDynamicObject("payerbank");
                if (!ObjectUtils.isEmpty((Object)bebank)) {
                    bebankId = bebank.getLong("id");
                }
                accountStr = erPayeeInfo.getString("payeraccount");
            }
        } else if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstactType);
            DynamicObjectCollection bankInfoCollection = asstact.getDynamicObjectCollection("entry_bank");
            DynamicObject bankInfo = null;
            if (bankInfoCollection.size() > 0) {
                bankInfo = (DynamicObject)bankInfoCollection.get(0);
            }
            for (int i = 0; i < bankInfoCollection.size(); ++i) {
                DynamicObject bank = (DynamicObject)bankInfoCollection.get(i);
                if (!bank.getBoolean("isdefault_bank")) continue;
                bankInfo = bank;
                break;
            }
            if (bankInfo != null) {
                accountStr = bankInfo.getString("bankaccount");
                bebank = bankInfo.getDynamicObject("bank");
                if (!ObjectUtils.isEmpty((Object)bebank)) {
                    bebankId = bebank.getLong("id");
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountStr", accountStr);
        map.put("bebankId", bebankId);
        map.put("bebank", bebank);
        return map;
    }

    private static DynamicObject getErPayeeInfo(long userId) {
        String orderBys;
        DynamicObject dynamicObject = new DynamicObject();
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,payerbank,payeraccount";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')))};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }
}

