/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.BillBotpHelper;
import kd.scmc.conm.business.helper.OperatorGroupHelper;
import kd.scmc.conm.enums.ContractSuitScopeEnum;

public class OrderDrawContractPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(OrderDrawContractPlugin.class);

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        super.afterBuildDrawFilter(e);
        DynamicObject order = e.getTargetDataEntity();
        DynamicObject org = order.getDynamicObject("org");
        String entityName = order.getDataEntityType().toString();
        if (org == null) {
            if ("pm_purorderbill".equals(entityName)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"OrderDrawContractPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            }
            if ("sm_salorder".equals(entityName)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9500\u552e\u7ec4\u7ec7\u3002", (String)"OrderDrawContractPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            }
        } else {
            QFilter orgFilter1 = new QFilter("suitscope", "=", (Object)ContractSuitScopeEnum.CURRENTORG.getValue()).and("org.id", "=", org.getPkValue());
            QFilter orgFilter2 = new QFilter("suitscope", "=", (Object)ContractSuitScopeEnum.ALLORG.getValue());
            QFilter orgFilter3 = new QFilter("suitscope", "=", (Object)ContractSuitScopeEnum.CHOSENORG.getValue()).and("suitentry.suitorg.id", "=", org.getPkValue());
            QFilter filter = orgFilter1.or(orgFilter2).or(orgFilter3);
            long orgId = (Long)org.getPkValue();
            String srcEntityName = this.getSrcMainType().getName();
            Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)srcEntityName, (Long)orgId, (String)"foperatorgroupisolate");
            if (Boolean.TRUE.equals(operatorGroupIsolate)) {
                ArrayList arList;
                ArrayList opGrpList;
                ArrayList validList;
                long userId = UserServiceHelper.getCurrentUserId();
                String grpType = "";
                if ("conm_purcontract".equals(srcEntityName)) {
                    grpType = "CGZ";
                } else if ("conm_salcontract".equals(srcEntityName)) {
                    grpType = "XSZ";
                }
                if (StringUtils.isNotEmpty((String)grpType) && !(validList = OperatorGroupHelper.getValidOperatorGroup((ArrayList)(opGrpList = OperatorGroupHelper.getOperatorGroupByOrg((long)orgId, (String)grpType)), (ArrayList)(arList = OperatorGroupHelper.getOperatorGroupByUser((long)orgId, (long)userId, (String)grpType)))).isEmpty()) {
                    filter.and(new QFilter("operatorgroup", "in", (Object)validList));
                }
            }
            e.setPlugFilter(filter);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        BillEntityType tgtMainType = this.getTgtMainType();
        String name = tgtMainType.getName();
        ExtendedDataEntitySet tgt = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = tgt.FindByEntityKey(tgtMainType.toString());
        if ("pm_purorderbill".equals(name)) {
            HashMap<String, DynamicObject> bizOrgCache = new HashMap<String, DynamicObject>();
            for (ExtendedDataEntity entity : entities) {
                Object settleOrgID;
                DynamicObject bill = entity.getDataEntity();
                DynamicObject org = bill.getDynamicObject("org");
                if (org == null) {
                    log.info("\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a");
                    continue;
                }
                Long orgId = (Long)org.getPkValue();
                DynamicObject settleOrg = null;
                String settleOrgCacheKey = orgId + "&settleorg4pur";
                Set bizSettleOrg4PurKeySet = bizOrgCache.keySet();
                if (bizSettleOrg4PurKeySet.contains(settleOrgCacheKey)) {
                    settleOrg = (DynamicObject)bizOrgCache.get(settleOrgCacheKey);
                } else {
                    Long settleOrgId = BillBotpHelper.getOrgRelationParam((Long)orgId, (String)"02", (String)"10", (String)"toorg");
                    if (settleOrgId == null || settleOrgId == 0L) {
                        bizOrgCache.put(settleOrgCacheKey, null);
                    } else {
                        settleOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)settleOrgId, (String)"bos_org");
                        bizOrgCache.put(settleOrgCacheKey, settleOrg);
                    }
                }
                DynamicObject payOrg = null;
                if (settleOrg != null && (settleOrgID = settleOrg.getPkValue()) != null) {
                    String payOrgCacheKey = settleOrgID + "&payorg4pur";
                    DynamicObject payOrgObj = (DynamicObject)bizOrgCache.get(payOrgCacheKey);
                    if (payOrgObj != null) {
                        payOrg = payOrgObj;
                    } else {
                        Long payOrgId = BillBotpHelper.getToOrg((String)"10", (String)"08", (Long)((Long)settleOrgID), (boolean)true);
                        if (payOrgId == null || payOrgId == 0L) {
                            bizOrgCache.put(payOrgCacheKey, null);
                        } else {
                            payOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)payOrgId, (String)"bos_org");
                            bizOrgCache.put(payOrgCacheKey, payOrg);
                        }
                    }
                }
                DynamicObject entryReqOrg = null;
                String reqOrgCacheKey = orgId + "&reqorg4pur";
                Set bizReqOrg4PurKeySet = bizOrgCache.keySet();
                if (bizReqOrg4PurKeySet.contains(reqOrgCacheKey)) {
                    entryReqOrg = (DynamicObject)bizOrgCache.get(reqOrgCacheKey);
                } else {
                    Long entryReqOrgId = BillBotpHelper.getOrgRelationParam((Long)orgId, null, (String)"02", (String)"fromorg");
                    if (entryReqOrgId == null || entryReqOrgId == 0L) {
                        bizOrgCache.put(reqOrgCacheKey, null);
                    } else {
                        entryReqOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)entryReqOrgId, (String)"bos_org");
                        bizOrgCache.put(reqOrgCacheKey, entryReqOrg);
                    }
                }
                DynamicObject entryRecOrg = null;
                String recOrgCacheKey = orgId + "&recorg4pur";
                Set bizRecOrg4PurKeySet = bizOrgCache.keySet();
                if (bizRecOrg4PurKeySet.contains(recOrgCacheKey)) {
                    entryRecOrg = (DynamicObject)bizOrgCache.get(recOrgCacheKey);
                } else {
                    Long entryRecOrgId = BillBotpHelper.getOrgRelationParam((Long)orgId, (String)"02", (String)"05", (String)"toorg");
                    if (entryRecOrgId == null || entryRecOrgId == 0L) {
                        bizOrgCache.put(recOrgCacheKey, null);
                    } else {
                        entryRecOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)entryRecOrgId, (String)"bos_org");
                        bizOrgCache.put(recOrgCacheKey, entryRecOrg);
                    }
                }
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    entry.set("entryreqorg", (Object)entryReqOrg);
                    entry.set("entryrecorg", (Object)entryRecOrg);
                    entry.set("entrysettleorg", (Object)settleOrg);
                    entry.set("entrypayorg", (Object)payOrg);
                }
            }
        }
    }
}

