/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.contract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.PurContractBillHelper;
import kd.scmc.conm.utils.CommonUtils;

public class PurContractImportPlugin
extends AbstractFormPlugin {
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List<Long> hasPermissionOrg = (List<Long>)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            String dataEntityName = model.getDataEntityType().getName();
            hasPermissionOrg = PurContractImportPlugin.getHasPermissionOrg(dataEntityName, "02");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (PurContractImportPlugin.isSkip(billcretype)) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        if (!BillImportHelper.isImport((String)billcretype)) {
            this.verifySupplier(e, org);
            this.verifyGroupIsolate(e, org);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (PurContractImportPlugin.isSkip(billcretype)) {
            return;
        }
        if (CommonUtils.isNull((Object)this.getModel().getValue("billcretype"))) {
            this.getModel().setValue("billcretype", (Object)"1");
        }
        if (!BillImportHelper.isImport((String)billcretype)) {
            this.getModel().setValue("iscollaconsult", (Object)Boolean.FALSE);
            this.getModel().setValue("confirmstatus", (Object)"E");
            this.getModel().setValue("confirmer", null);
            this.getModel().setValue("confirmdate", null);
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            PurContractBillHelper.completeBillInfo(Collections.singletonList(bill));
        }
    }

    private static boolean isSkip(String billcretype) {
        return "2".equals(billcretype);
    }

    private static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private void verifyGroupIsolate(BeforeImportDataEventArgs e, DynamicObject org) {
        Object operatorGroupIsolate;
        Map<Object, Object> operatorGroupMap = this.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
        Map<Object, Object> operatorMap = this.format4ImportAndApi(e.getSourceData().get("operator"));
        if (org != null && (operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"conm_purcontract", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate")) instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            if (operatorMap == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u91c7\u8d2d\u5458\u3002", (String)"PurContractImportPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
            if (operatorGroupMap == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u3002", (String)"PurContractImportPlugin_5", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
        }
    }

    private void verifySupplier(BeforeImportDataEventArgs e, DynamicObject org) {
        Map<Object, Object> supplierMap;
        QFilter supplierOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_supplierOrgFilter");
        if (supplierOrgFilter == null) {
            supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_supplierOrgFilter", supplierOrgFilter);
        }
        if ((supplierMap = this.format4ImportAndApi(e.getSourceData().get("supplier"))) != null) {
            DynamicObject receiveSupplier;
            Map<Object, Object> receiveSupplierMap;
            DynamicObject invoiceSupplier;
            Map<Object, Object> invoiceSupplierMap;
            DynamicObject providerSupplier;
            Map<Object, Object> providerSuppliersMap;
            HashMap<String, Object> newOperator;
            Map<Object, Object> linkmanMap;
            DynamicObject providerSupplier2;
            DynamicObject supplier = this.getBaseDataFromCache(e.getSourceData(), "supplier", "bd_supplier", "id,enablevmi,bizfunction,invoicesupplierid,deliversupplierid,receivingsupplierid", new QFilter[]{new QFilter((String)supplierMap.get("importprop"), "=", supplierMap.get(supplierMap.get("importprop"))), supplierOrgFilter});
            if (supplier == null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"PurContractImportPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]), supplierMap.get(supplierMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            String supplierBizFunction = supplier.getString("bizfunction");
            if (StringUtils.isEmpty((String)supplierBizFunction) || !supplierBizFunction.contains("1")) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%s\u201d\u6ca1\u6709\u91c7\u8d2d\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PurContractImportPlugin_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]), supplierMap.get(supplierMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            Map<Object, Object> providerSupplierMap = this.format4ImportAndApi(e.getSourceData().get("providersupplier"));
            if (providerSupplierMap != null && (providerSupplier2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("number", "=", providerSupplierMap.get(providerSupplierMap.get("importprop")))})) != null && (linkmanMap = this.format4ImportAndApi(e.getSourceData().get("providerlinkman"))) != null) {
                Map providerLinkMans = BusinessDataServiceHelper.loadFromCache((String)"bd_supplierlinkman", (String)"supplierid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("supplierid", "=", providerSupplier2.getPkValue()), new QFilter("phone", "=", linkmanMap.get(linkmanMap.get("importprop")))});
                if (providerLinkMans == null || providerLinkMans.size() == 0) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546\u201c%1$s\u201d\u7684\u4f9b\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"PurContractImportPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]), providerSupplierMap.get(providerSupplierMap.get("importprop")), linkmanMap.get(linkmanMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
                if (providerLinkMans.size() != 1) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546\u201c%1$s\u201d\u7684\u9001\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd\u201c%2$s\u201d\u5df2\u5b58\u5728\u3002", (String)"PurContractImportPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]), providerSupplierMap.get(providerSupplierMap.get("importprop")), linkmanMap.get(linkmanMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
                newOperator = new HashMap();
                newOperator.put("id", ((DynamicObject)providerLinkMans.values().stream().findFirst().get()).getPkValue());
                e.getSourceData().put("providerlinkman", newOperator);
            }
            if ((providerSuppliersMap = this.format4ImportAndApi(e.getSourceData().get("providersupplier"))) != null) {
                providerSupplier = this.getBaseDataFromCache(e.getSourceData(), "providersupplier", "bd_supplier", "id,bizfunction", new QFilter[]{new QFilter((String)providerSuppliersMap.get("importprop"), "=", providerSuppliersMap.get(providerSuppliersMap.get("importprop"))), supplierOrgFilter});
                if (providerSupplier == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u91c7\u8d2d\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"PurContractImportPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]), providerSuppliersMap.get(providerSuppliersMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bizFunction = providerSupplier.getString("bizfunction");
                if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("4")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546\u201c%s\u201d\u6ca1\u6709\u4f9b\u8d27\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PurContractImportPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]), providerSuppliersMap.get(providerSuppliersMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            } else {
                providerSupplier = supplier.getDynamicObject("deliversupplierid");
                HashMap<String, Object> newOperator2 = new HashMap<String, Object>();
                if (providerSupplier != null) {
                    newOperator2.put("id", providerSupplier.getPkValue());
                    e.getSourceData().put("providersupplier", newOperator2);
                }
            }
            if ((invoiceSupplierMap = this.format4ImportAndApi(e.getSourceData().get("invoicesupplier"))) != null) {
                invoiceSupplier = this.getBaseDataFromCache(e.getSourceData(), "invoicesupplier", "bd_supplier", "id,bizfunction", new QFilter[]{new QFilter((String)invoiceSupplierMap.get("importprop"), "=", invoiceSupplierMap.get(invoiceSupplierMap.get("importprop"))), supplierOrgFilter});
                if (invoiceSupplier == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u91c7\u8d2d\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"PurContractImportPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]), invoiceSupplierMap.get(invoiceSupplierMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bizFunction = invoiceSupplier.getString("bizfunction");
                if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("2")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546\u201c%s\u201d\u6ca1\u6709\u7ed3\u7b97\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PurContractImportPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]), invoiceSupplierMap.get(invoiceSupplierMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            } else {
                invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
                newOperator = new HashMap<String, Object>();
                if (invoiceSupplier != null) {
                    newOperator.put("id", invoiceSupplier.getPkValue());
                    e.getSourceData().put("invoicesupplier", newOperator);
                }
            }
            if ((receiveSupplierMap = this.format4ImportAndApi(e.getSourceData().get("receivesupplier"))) != null) {
                receiveSupplier = this.getBaseDataFromCache(e.getSourceData(), "receivesupplier", "bd_supplier", "id,bizfunction", new QFilter[]{new QFilter((String)receiveSupplierMap.get("importprop"), "=", receiveSupplierMap.get(receiveSupplierMap.get("importprop"))), supplierOrgFilter});
                if (receiveSupplier == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u91c7\u8d2d\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"PurContractImportPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]), receiveSupplierMap.get(receiveSupplierMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bizFunction = receiveSupplier.getString("bizfunction");
                if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("3")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546\u201c%s\u201d\u6ca1\u6709\u6536\u6b3e\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PurContractImportPlugin_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]), receiveSupplierMap.get(receiveSupplierMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            } else {
                receiveSupplier = supplier.getDynamicObject("receivingsupplierid");
                HashMap<String, Object> newOperator3 = new HashMap<String, Object>();
                if (receiveSupplier != null) {
                    newOperator3.put("id", receiveSupplier.getPkValue());
                    e.getSourceData().put("receivesupplier", newOperator3);
                }
            }
        }
    }

    public Map<Object, Object> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return (Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class);
        }
        if (sourceData instanceof Map) {
            Map propMap = (Map)sourceData;
            if (propMap.get("id") != null) {
                propMap.put("importprop", "id");
            } else if (propMap.get("number") != null) {
                propMap.put("importprop", "number");
            } else if (propMap.get("name") != null) {
                propMap.put("importprop", "name");
            }
            return (Map)sourceData;
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        if (sourceData instanceof ArrayList) {
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((ArrayList)sourceData).size());
            propMap.put("sourceData", sourceData);
            return propMap;
        }
        return null;
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map<Object, Object> propMap = this.format4ImportAndApi(sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }
}

