/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.contract;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.AppParameterHelper;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.SalContractBillHelper;
import kd.scmc.conm.enums.MaterialConfigPropertiesEnum;
import kd.scmc.conm.formplugin.tpl.BillTplImportPlugin;
import kd.scmc.conm.utils.CommonUtils;

public class SalContractImportPlugin
extends BillTplImportPlugin {
    private Map<String, Object> tempCache = new HashMap<String, Object>();

    @Override
    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        SalContractImportPlugin.billCreTypeFlag(pageCache, sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List<Long> hasPermissionOrg = (List<Long>)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            String dataEntityName = model.getDataEntityType().getName();
            hasPermissionOrg = SalContractImportPlugin.getHasPermissionOrg(dataEntityName, "03");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    @Override
    public void beforeImportData(BeforeImportDataEventArgs e) {
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null, null);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype)) {
            this.verifyCustomer(e, org);
            this.verifyGroupIsolate(e, org);
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
            for (DynamicObject billentry : billentrys) {
                DynamicObject material = billentry.getDynamicObject("material");
                if (material == null || material.getDynamicObject("masterid") == null) continue;
                if (billentry.getDynamicObject("productline") == null) {
                    DynamicObject productLine = material.getDynamicObject("masterid").getDynamicObject("productline");
                    billentry.set("productline", (Object)productLine);
                }
                if (MaterialConfigPropertiesEnum.CONFIG.getValue().equals(material.getDynamicObject("masterid").getString("configproperties"))) continue;
                billentry.set("configuredcode", null);
            }
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            SalContractBillHelper.completeBillInfo(Collections.singletonList(bill));
        }
    }

    private static void billCreTypeFlag(IPageCache pageCache, List<Map<String, Object>> sourceDataList) {
        for (Map<String, Object> sourceData : sourceDataList) {
            if ("1".equals(sourceData.get("billcretype"))) {
                pageCache.put("billcretype", "1");
                continue;
            }
            if (!"2".equals(sourceData.get("billcretype"))) continue;
            pageCache.put("billcretype", "2");
        }
    }

    private static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private void verifyGroupIsolate(BeforeImportDataEventArgs e, DynamicObject org) {
        Object operatorGroupIsolate;
        Map<Object, Object> operatorGroupMap = this.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
        Map<Object, Object> operatorMap = this.format4ImportAndApi(e.getSourceData().get("operator"));
        if (org != null && (operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"conm_purcontract", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate")) instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            if (operatorMap == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u9500\u552e\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb\uff0c\u8bf7\u586b\u5199\u9500\u552e\u5458\u3002", (String)"SalContractImportPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
            if (operatorGroupMap == null) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f53\u524d\u9500\u552e\u7ec4\u7ec7\u5df2\u542f\u7528\u4e1a\u52a1\u7ec4\u6570\u636e\u9694\u79bb,\u8bf7\u586b\u5199\u9500\u552e\u7ec4\u3002", (String)"SalContractImportPlugin_5", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
                return;
            }
        }
    }

    private void verifyCustomer(BeforeImportDataEventArgs e, DynamicObject org) {
        Map<Object, Object> customerMap;
        if (org == null) {
            return;
        }
        QFilter customerOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_customerOrgFilter");
        if (customerOrgFilter == null) {
            customerOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_customerOrgFilter", customerOrgFilter);
        }
        if ((customerMap = this.format4ImportAndApi(e.getSourceData().get("customer"))) != null) {
            DynamicObject payingCustomer;
            Map<Object, Object> payingCustomerMap;
            DynamicObject settleCustomer;
            Map<Object, Object> settleCustomerMap;
            DynamicObject recCustomer;
            Map<Object, Object> recCustomersMap;
            HashMap<String, Object> newOperator;
            Map<Object, Object> linkmanMap;
            DynamicObject recCustomer2;
            DynamicObject customer = this.getBaseDataFromCache(e.getSourceData(), "customer", "bd_customer", "id,bizfunction,delivercustomerid,paymentcustomerid,invoicecustomerid", new QFilter[]{new QFilter((String)customerMap.get("importprop"), "=", customerMap.get(customerMap.get("importprop"))), customerOrgFilter});
            if (customer == null) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalContractImportPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            String customerBizFunction = customer.getString("bizfunction");
            if (StringUtils.isEmpty((String)customerBizFunction) || !customerBizFunction.contains("1")) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u9500\u552e\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SalContractImportPlugin_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]), customerMap.get(customerMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            Map<Object, Object> recCustomerMap = this.format4ImportAndApi(e.getSourceData().get("reccustomer"));
            if (recCustomerMap != null && (recCustomer2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("number", "=", recCustomerMap.get(recCustomerMap.get("importprop")))})) != null && (linkmanMap = this.format4ImportAndApi(e.getSourceData().get("reclinkman"))) != null) {
                Map providerLinkMans = BusinessDataServiceHelper.loadFromCache((String)"bd_customerlinkman", (String)"customerid,id,contactperson,phone", (QFilter[])new QFilter[]{new QFilter("customerid", "=", recCustomer2.getPkValue()), new QFilter("phone", "=", linkmanMap.get(linkmanMap.get("importprop")))});
                if (providerLinkMans == null || providerLinkMans.size() == 0) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u201c%1$s\u201d\u7684\u8054\u7cfb\u4eba\u7535\u8bdd\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"SalContractImportPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]), recCustomerMap.get(recCustomerMap.get("importprop")), linkmanMap.get(linkmanMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
                if (providerLinkMans.size() != 1) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u201c%1$s\u201d\u7684\u8054\u7cfb\u4eba\u7535\u8bdd\u201c%2$s\u201d\u5df2\u5b58\u5728\u3002", (String)"SalContractImportPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]), recCustomerMap.get(recCustomerMap.get("importprop")), linkmanMap.get(linkmanMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
                newOperator = new HashMap();
                newOperator.put("id", ((DynamicObject)providerLinkMans.values().stream().findFirst().get()).getPkValue());
                e.getSourceData().put("reclinkman", newOperator);
            }
            if ((recCustomersMap = this.format4ImportAndApi(e.getSourceData().get("reccustomer"))) != null) {
                recCustomer = this.getBaseDataFromCache(e.getSourceData(), "reccustomer", "bd_customer", "id,bizfunction", new QFilter[]{new QFilter((String)recCustomersMap.get("importprop"), "=", recCustomersMap.get(recCustomersMap.get("importprop"))), customerOrgFilter});
                if (recCustomer == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6536\u8d27\u5ba2\u6237\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"SalContractImportPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]), recCustomersMap.get(recCustomersMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bizFunction = recCustomer.getString("bizfunction");
                if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("4")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6536\u8d27\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u6536\u8d27\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SalContractImportPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]), recCustomersMap.get(recCustomersMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            } else {
                recCustomer = customer.getDynamicObject("delivercustomerid");
                HashMap<String, Object> newOperator2 = new HashMap<String, Object>();
                if (recCustomer != null) {
                    newOperator2.put("id", recCustomer.getPkValue());
                    e.getSourceData().put("reccustomer", newOperator2);
                }
            }
            if ((settleCustomerMap = this.format4ImportAndApi(e.getSourceData().get("settlecustomer"))) != null) {
                settleCustomer = this.getBaseDataFromCache(e.getSourceData(), "settlecustomer", "bd_customer", "id,bizfunction", new QFilter[]{new QFilter((String)settleCustomerMap.get("importprop"), "=", settleCustomerMap.get(settleCustomerMap.get("importprop"))), customerOrgFilter});
                if (settleCustomer == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"SalContractImportPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]), settleCustomerMap.get(settleCustomerMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bizFunction = settleCustomer.getString("bizfunction");
                if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("2")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u7ed3\u7b97\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SalContractImportPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]), settleCustomerMap.get(settleCustomerMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            } else {
                settleCustomer = customer.getDynamicObject("invoicecustomerid");
                newOperator = new HashMap<String, Object>();
                if (settleCustomer != null) {
                    newOperator.put("id", settleCustomer.getPkValue());
                    e.getSourceData().put("settlecustomer", newOperator);
                }
            }
            if ((payingCustomerMap = this.format4ImportAndApi(e.getSourceData().get("payingcustomer"))) != null) {
                payingCustomer = this.getBaseDataFromCache(e.getSourceData(), "payingcustomer", "bd_customer", "id,bizfunction", new QFilter[]{new QFilter((String)payingCustomerMap.get("importprop"), "=", payingCustomerMap.get(payingCustomerMap.get("importprop"))), customerOrgFilter});
                if (payingCustomer == null) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5ba2\u6237\u7f16\u7801\u201c%1$s\u201d\u672a\u5206\u914d\u7ed9\u9500\u552e\u7ec4\u7ec7\u201c%2$s\u201d\u3002", (String)"SalContractImportPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]), payingCustomerMap.get(payingCustomerMap.get("importprop")), org.get("number")));
                    e.setFireAfterImportData(false);
                    return;
                }
                String bizFunction = payingCustomer.getString("bizfunction");
                if (StringUtils.isEmpty((String)bizFunction) || !bizFunction.contains("3")) {
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5ba2\u6237\u201c%s\u201d\u6ca1\u6709\u4ed8\u6b3e\u804c\u80fd\u3002\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SalContractImportPlugin_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]), payingCustomerMap.get(payingCustomerMap.get("importprop"))));
                    e.setFireAfterImportData(false);
                    return;
                }
            } else {
                payingCustomer = customer.getDynamicObject("paymentcustomerid");
                HashMap<String, Object> newOperator3 = new HashMap<String, Object>();
                if (payingCustomer != null) {
                    newOperator3.put("id", payingCustomer.getPkValue());
                    e.getSourceData().put("payingcustomer", newOperator3);
                }
            }
        }
    }

    @Override
    public Map<Object, Object> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return (Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class);
        }
        if (sourceData instanceof Map) {
            Map propMap = (Map)sourceData;
            if (propMap.get("id") != null) {
                propMap.put("importprop", "id");
            } else if (propMap.get("number") != null) {
                propMap.put("importprop", "number");
            } else if (propMap.get("name") != null) {
                propMap.put("importprop", "name");
            }
            return (Map)sourceData;
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        if (sourceData instanceof ArrayList) {
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((ArrayList)sourceData).size());
            propMap.put("sourceData", sourceData);
            return propMap;
        }
        return null;
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map<Object, Object> propMap = this.format4ImportAndApi(sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }
}

