/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.contract;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.conm.business.helper.XContractHelper;
import kd.scmc.conm.enums.ExcuteControlEnum;
import kd.scmc.conm.utils.CommonUtils;

public class XPurContractPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener {
    private static final String DELETEROW = "deleterow";
    private static final String BIZVALID = "bizvalid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmainentry");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Boolean rowCancel;
        super.beforeItemClick(evt);
        IDataModel model = this.getModel();
        DynamicObject bill = this.getModel().getDataEntity(true);
        if (bill == null || bill.getDynamicObjectType() == null) {
            return;
        }
        String itemKey = evt.getItemKey();
        if (DELETEROW.equals(itemKey) && (rowCancel = XContractHelper.isRowCancel((String)bill.getDynamicObjectType().getName())).booleanValue()) {
            int[] selectRows;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            if (entryGrid == null) {
                return;
            }
            for (int row : selectRows = entryGrid.getSelectRows()) {
                model.setValue("qty", (Object)BigDecimal.ZERO, row);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.excCtrlMustInput(this.getModel().getValue("type"));
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        this.excCtrlMustInput(this.getModel().getValue("type"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("false".equals(this.getPageCache().get("ppcvar"))) {
            return;
        }
        if ("true".equals(this.getPageCache().get("stopChange"))) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        block6: for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            Object newValue = valueSet[i].getNewValue();
            int rowIndex = valueSet[i].getRowIndex();
            String propName = e.getProperty().getName();
            switch (propName = propName.toLowerCase(RequestContext.get().getLang().getLocale())) {
                case "type": {
                    this.excCtrlMustInput(newValue);
                    continue block6;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.excCtrlMustInput(this.getModel().getValue("type"));
        }
    }

    private void excCtrlMustInput(Object newValue) {
        if (this.getModel().getDataEntityType() == null) {
            return;
        }
        Boolean rowCancel = XContractHelper.isRowCancel((String)this.getModel().getDataEntityType().getName());
        if (newValue != null && rowCancel.booleanValue()) {
            String contCtrl = ((DynamicObject)newValue).getString("excutecontrol");
            AmountEdit amountEdit = (AmountEdit)this.getControl("totalallamount");
            QtyEdit qtyEdit = (QtyEdit)this.getControl("qty");
            AmountEdit priceEdit = (AmountEdit)this.getControl("price");
            if (ExcuteControlEnum.QTY.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(false);
            }
            if (ExcuteControlEnum.AMOUNT.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(false);
            }
            if (ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(false);
            }
            if (ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(true);
            }
            if (ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(true);
            }
        }
    }
}

