/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.receivematch;

import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ReceiveMatchRecordListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = showParameter.getCustomParams();
        String billno = (String)params.get("billno");
        if (StringUtils.isNotEmpty((String)billno)) {
            e.getQFilters().add(new QFilter("entry.billno", "=", (Object)billno));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        String fieldName = e.getFieldName();
        BillListHyperLinkClickEvent evt = (BillListHyperLinkClickEvent)e.getHyperLinkClickEvent();
        ListSelectedRow curRow = evt.getCurrentRow();
        if ("billno".equalsIgnoreCase(fieldName)) {
            e.setCancel(true);
            this.showBill(curRow, "conm_salcontract");
        } else if ("assbillno".equalsIgnoreCase(fieldName)) {
            e.setCancel(true);
            this.showBill(curRow, "cas_recbill");
        }
    }

    private void showBill(ListSelectedRow row, String billType) {
        if (row == null) {
            return;
        }
        Object entryID = row.getEntryPrimaryKeyValue();
        if (entryID == null || Objects.equals(0L, entryID)) {
            return;
        }
        String idField = "";
        if ("conm_salcontract".equalsIgnoreCase(billType)) {
            idField = "entry.billid";
        } else if ("cas_recbill".equalsIgnoreCase(billType)) {
            idField = "entry.assbillid";
        }
        QFilter q = new QFilter("entry.id", "=", entryID);
        DynamicObject res = QueryServiceHelper.queryOne((String)"conm_scmatch", (String)idField, (QFilter[])new QFilter[]{q});
        if (res == null) {
            return;
        }
        BillShowParameter bs = new BillShowParameter();
        bs.setFormId(billType);
        bs.setPkId(res.get(idField));
        bs.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        bs.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)bs);
    }
}

