/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.helper.WebOfficeBrowserHelper;
import kd.bos.mvc.form.helper.WebOfficeBrowserParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.BillTypeParameterHelper;
import kd.scmc.conm.business.helper.ConmAppCacheHelper;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.enums.FilingStatusEnum;
import kd.scmc.conm.enums.StatusEnum;
import kd.scmc.conm.utils.CommonUtils;

public class AgreementTplPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
UploadListener {
    private static final Log LOG = LogFactory.getLog(AgreementTplPlugin.class);
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void registerListener(EventObject e) {
        BasedataEdit templateversion;
        BasedataEdit templateEdit;
        super.registerListener(e);
        BasedataEdit typeEdit = (BasedataEdit)this.getView().getControl("type");
        if (typeEdit != null) {
            typeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((templateEdit = (BasedataEdit)this.getView().getControl("template")) != null) {
            templateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((templateversion = (BasedataEdit)this.getView().getControl("templateversion")) != null) {
            templateversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        AttachmentPanel signattachment = (AttachmentPanel)this.getView().getControl("signattachment");
        signattachment.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.barBtnProcess();
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject billtype = (DynamicObject)this.getModel().getValue("billtype");
        if (billtype != null) {
            LOG.info("biitype =" + billtype.getPkValue());
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((MainEntityType)this.getModel().getDataEntityType(), (long)((Long)billtype.getPkValue()));
            LOG.info("billTypeParam = " + billTypeParam);
            DynamicObject category = null;
            if (billTypeParam != null && (category = billTypeParam.getDynamicObject("category")) != null) {
                this.getModel().setValue("category", category.getPkValue());
                QFilter contcategoryQF = new QFilter("contcategory", "=", category.getPkValue());
                QFilter isdefaultQF = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
                QFilter enableQF = new QFilter("enable", "=", (Object)"1");
                DynamicObject contType = BusinessDataServiceHelper.loadSingle((String)"conm_type", (String)"conmprop,signstatus,reviewstatus,filingstatus", (QFilter[])new QFilter[]{contcategoryQF, isdefaultQF, enableQF});
                if (contType != null) {
                    this.getModel().setValue("type", contType.getPkValue());
                    this.setHeadStatus();
                } else {
                    contType = this.getModel().getDataEntity().getDynamicObject("type");
                    if (contType != null) {
                        this.getModel().setValue("type", contType.getPkValue());
                        this.setHeadStatus();
                    }
                }
            }
        }
    }

    private void preview() {
        DynamicObject template = (DynamicObject)this.getModel().getValue("template");
        if (template == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5408\u540c\u6a21\u677f\u6587\u4ef6\u4fe1\u606f\u3002", (String)"AgreementTplPlugin_5", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject templateversion = (DynamicObject)this.getModel().getValue("templateversion");
        if (templateversion == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u7248\u7248\u672c\u3002", (String)"AgreementTplPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        String pageId = CommonUtils.urlEncode((String)CommonUtils.urlEncode((String)this.getView().getPageId(), (String)"utf-8"), (String)"utf-8");
        params.put("contractPageID", pageId);
        String entityId = CommonUtils.urlEncode((String)CommonUtils.urlEncode((String)this.getView().getEntityId(), (String)"utf-8"), (String)"utf-8");
        params.put("entityId", entityId);
        params.put("billId", this.getModel().getDataEntity().getPkValue());
        String requestId = RequestContext.get().getRequestId();
        ConmAppCacheHelper.put((String)requestId, (Object)this.getView().getPageId());
        params.put("requestId", requestId);
        WebOfficeBrowserParam webOfficeBrowserParam = new WebOfficeBrowserParam("conm_contractpreview");
        webOfficeBrowserParam.setParams(params);
        String tturl = WebOfficeBrowserHelper.buildUrl((WebOfficeBrowserParam)webOfficeBrowserParam);
        this.getView().openUrl(tturl);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("template".equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.size() <= 0) {
                return;
            }
            DynamicObject template = this.getModel().getDataEntity().getDynamicObject("template");
            if (template != null) {
                this.getPageCache().put("oldTemplateId", template.getPkValue().toString());
            }
            this.getModel().setValue("templateversion", returnData.get(0).getPrimaryKeyValue());
            DynamicObject entry = QueryServiceHelper.queryOne((String)"conm_template", (String)"id,attachmententry.version", (QFilter[])new QFilter("attachmententry.id", "=", returnData.get(0).getPrimaryKeyValue()).toArray());
            if (entry != null) {
                this.getModel().setValue("template", entry.get("id"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "billtype": {
                if (newValue != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgreementTplPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("billtype", e.getChangeSet()[0].getOldValue());
                break;
            }
            case "template": {
                if (newValue != null) {
                    DynamicObjectCollection attachmentEntry = ((DynamicObject)newValue).getDynamicObjectCollection("attachmententry");
                    DynamicObject version = null;
                    for (DynamicObject entry : attachmentEntry) {
                        boolean defVersion = entry.getBoolean("isdefversion");
                        boolean enable = entry.getBoolean("rowenablestatus");
                        if (!defVersion || !enable) continue;
                        Object pkValue = entry.getPkValue();
                        version = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"conm_tempfileentry");
                        break;
                    }
                    this.getModel().setValue("templateversion", version);
                    break;
                }
                this.getModel().setValue("templateversion", null);
                break;
            }
            case "type": {
                this.getModel().setValue("template", null);
                this.setHeadStatus();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        switch (key) {
            case "type": {
                DynamicObject category = (DynamicObject)bill.getValue("category");
                if (category != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u4fe1\u606f\u3002", (String)"AgreementTplPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "template": {
                DynamicObject type = (DynamicObject)bill.getValue("type");
                if (type != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5408\u540c\u7c7b\u578b\u201d\u3002", (String)"AgreementTplPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "templateversion": {
                DynamicObject template = (DynamicObject)bill.getValue("template");
                if (template != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u6a21\u677f\u3002", (String)"AgreementTplPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        Date nowTime = new Date(System.currentTimeMillis());
        switch (key) {
            case "bizvalid": {
                DynamicObject org;
                if (!"conm_pursupagrt".equals(this.getModel().getDataEntityType().getName()) && !"conm_salsupagrt".equals(this.getModel().getDataEntityType().getName()) || (org = (DynamicObject)this.getModel().getValue("org")) == null) break;
                Date biztimebegin = (Date)this.getModel().getValue("biztimebegin");
                String validStatus = (String)this.getModel().getValue("validstatus");
                String signStatus = (String)this.getModel().getValue("signstatus");
                String reviewStatus = (String)this.getModel().getValue("reviewstatus");
                String auditStatus = (String)this.getModel().getValue("billstatus");
                Boolean isCheck = Boolean.FALSE;
                if (BizSignStatusEnum.INACTIVE.getValue().equals(signStatus) && BizReviewStatusEnum.INACTIVE.getValue().equals(reviewStatus) && StatusEnum.AUDIT.getValue().equals(auditStatus) && BizValidStatusEnum.UNVALID.getValue().equals(validStatus) && nowTime.before(biztimebegin)) {
                    isCheck = Boolean.TRUE;
                } else if (BizSignStatusEnum.INACTIVE.getValue().equals(signStatus) && !BizReviewStatusEnum.INACTIVE.getValue().equals(reviewStatus) && BizReviewStatusEnum.PASS.getValue().equals(reviewStatus) && BizValidStatusEnum.UNVALID.getValue().equals(validStatus) && nowTime.before(biztimebegin)) {
                    isCheck = Boolean.TRUE;
                } else if (BizSignStatusEnum.SIGN.getValue().equals(signStatus) && BizValidStatusEnum.UNVALID.getValue().equals(validStatus) && nowTime.before(biztimebegin)) {
                    isCheck = Boolean.TRUE;
                }
                if (!isCheck.booleanValue()) break;
                FormOperate operate = (FormOperate)args.getSource();
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bizvalid", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u65f6\u95f4\u5c0f\u4e8e\u534f\u8bae\u8d77\u59cb\u65f6\u95f4\uff0c\u662f\u5426\u63d0\u524d\u751f\u6548\uff1f", (String)"AgreementTplPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "bizinvalid": {
                if (!"conm_pursupagrt".equals(this.getModel().getDataEntityType().getName()) && !"conm_salsupagrt".equals(this.getModel().getDataEntityType().getName())) break;
                FormOperate operate = (FormOperate)args.getSource();
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bizinvalid", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u201c\u5931\u6548\u201d\u64cd\u4f5c\u540e\uff0c\u534f\u8bae\u5c06\u65e0\u6cd5\u751f\u6548\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AgreementTplPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        OperationResult result = evt.getOperationResult();
        switch (operateKey) {
            case "officeedit": {
                if (!result.getValidateResult().isSuccess()) break;
                this.preview();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        OperateOption operateOption;
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("bizvalid") && evt.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("bizvalid", operateOption);
        }
        if (evt.getCallBackId().equals("bizinvalid") && evt.getResult() == MessageBoxResult.Yes) {
            operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("bizinvalid", operateOption);
        }
    }

    public void afterRemove(UploadEvent evt) {
        AttachmentPanel source = (AttachmentPanel)evt.getSource();
        if ("signattachment".equals(source.getKey())) {
            Object[] urls = evt.getUrls();
            ArrayList<String> uids = new ArrayList<String>(urls.length);
            for (Object url : urls) {
                Map map = (Map)url;
                String uid = (String)map.get("uid");
                uids.add(uid);
            }
            QFilter id = new QFilter("fnumber", "in", uids);
            DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])id.toArray());
        }
    }

    private void setHeadStatus() {
        DynamicObject bill = this.getModel().getDataEntity();
        DynamicObject type = bill.getDynamicObject("type");
        if (type != null) {
            this.getModel().setValue("signstatus", (Object)(type.getBoolean("activesign") ? BizSignStatusEnum.UNSIGN.getValue() : BizSignStatusEnum.INACTIVE.getValue()));
            this.getModel().setValue("reviewstatus", (Object)(type.getBoolean("activereview") ? BizReviewStatusEnum.UNREVIEW.getValue() : BizReviewStatusEnum.INACTIVE.getValue()));
            this.getModel().setValue("filingstatus", (Object)(type.getBoolean("activearchive") ? FilingStatusEnum.UNFILED.getValue() : FilingStatusEnum.INACTIVE.getValue()));
        } else {
            this.getModel().setValue("signstatus", (Object)BizSignStatusEnum.INACTIVE.getValue());
            this.getModel().setValue("reviewstatus", (Object)BizReviewStatusEnum.INACTIVE.getValue());
            this.getModel().setValue("filingstatus", (Object)FilingStatusEnum.INACTIVE.getValue());
        }
        this.getModel().setValue("iselecsignature", (Object)Boolean.FALSE);
        this.barBtnProcess();
    }

    private void barBtnProcess() {
        Object activereview = this.getModel().getValue("reviewstatus");
        String filingStatus = (String)this.getModel().getValue("filingstatus");
        DynamicObject type = (DynamicObject)this.getModel().getValue("type");
        if (type != null) {
            boolean enablearchive = type.getBoolean("enablearchive");
            if (!FilingStatusEnum.INACTIVE.getValue().equalsIgnoreCase(filingStatus) && enablearchive) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_filingapply"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_filing"});
            } else if (!FilingStatusEnum.INACTIVE.getValue().equalsIgnoreCase(filingStatus) && !enablearchive) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_filingapply"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_filing"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_filingapply"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_filing"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_filingapply"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_filing"});
        }
        if (activereview instanceof String && !((String)activereview).equalsIgnoreCase(BizReviewStatusEnum.INACTIVE.getValue())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_review"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_review"});
        }
    }

    public void afterUpload(UploadEvent evt) {
        AttachmentPanel panel;
        String key;
        Object source = evt.getSource();
        DynamicObject bill = this.getModel().getDataEntity();
        Object pkValue = bill.getPkValue();
        String formId = bill.getDataEntityType().getName();
        Object[] urls = evt.getUrls();
        if (source instanceof AttachmentPanel && "signattachment".equalsIgnoreCase(key = (panel = (AttachmentPanel)source).getKey()) && ((Long)pkValue).compareTo(0L) != 0 && urls.length > 0) {
            ArrayList<Map> data = new ArrayList<Map>(urls.length);
            HashSet<String> uids = new HashSet<String>(16);
            for (Object url : urls) {
                Map map = (Map)url;
                String tempUrl = (String)map.get("url");
                String fileName = (String)map.get("name");
                String uid = (String)map.get("uid");
                String purl = AttachmentServiceHelper.saveTempToFileService((String)tempUrl, (String)"conm", (String)formId, (Object)pkValue, (String)fileName, (boolean)false, (boolean)false);
                if (StringUtils.isEmpty((String)purl)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6587\u4ef6%s\u4e0a\u4f20\u5931\u8d25\u3002", (String)"ContractTplPlugin_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]), fileName));
                    return;
                }
                map.put("url", purl);
                data.add(map);
                uids.add(uid);
            }
            if (uids.size() > 0) {
                this.removeAttachmentCache(uids);
                AttachmentServiceHelper.upload((String)formId, (Object)pkValue, (String)"signattachment", data);
            }
        }
    }

    private void removeAttachmentCache(Set<String> uids) {
        Map attachmentInfo;
        IPageCache cache = this.getView().getPageCache();
        String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
        if (uids != null && uids.size() > 0 && !StringUtils.isEmpty((String)cacheJsonString) && (attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class)) != null) {
            List signattachment = (List)attachmentInfo.get("signattachment");
            ArrayList<HashMap> removeCache = new ArrayList<HashMap>(16);
            if (signattachment != null) {
                for (HashMap attMap : signattachment) {
                    String uid;
                    if (attMap == null || !StringUtils.isNotEmpty((String)(uid = (String)attMap.get("uid"))) || !uids.contains(uid)) continue;
                    removeCache.add(attMap);
                }
                for (HashMap rmCache : removeCache) {
                    signattachment.remove(rmCache);
                }
                cacheJsonString = SerializationUtils.toJsonString((Object)attachmentInfo);
                cache.put("TampAttCache" + this.getView().getPageId(), cacheJsonString);
            }
        }
    }
}

