/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.tpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.conm.business.helper.AmountHelper;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.conm.business.helper.BillTypeParameterHelper;
import kd.scmc.conm.business.helper.CurrencyHelper;
import kd.scmc.conm.enums.BizCloseStatusEnum;
import kd.scmc.conm.enums.BizFreezeStatusEnum;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizRowTerminateStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.BizTerminateStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.enums.ContractBizModeEnum;
import kd.scmc.conm.enums.ContractSuitScopeEnum;
import kd.scmc.conm.enums.DiscountTypeEnum;
import kd.scmc.conm.enums.ExChangeTypeEnum;
import kd.scmc.conm.enums.FilingStatusEnum;
import kd.scmc.conm.enums.StatusEnum;
import kd.scmc.conm.utils.CommonUtils;

public class BillTplImportPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(BillTplImportPlugin.class);
    private static BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private Map<String, Object> tempCache = new HashMap<String, Object>();
    private static final String UnitConvertDir_UINV_U2ND = "A";
    private static final String UnitConvertDir_U2ND_UINV = "B";
    private static final String UnitConvertDir_UINVANDU2ND = "C";

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        IPageCache pageCache = this.getPageCache();
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        IDataModel model = (IDataModel)e.getSource();
        List<Long> hasPermissionOrg = (List<Long>)this.tempCache.get("hasPermissionOrg");
        long userID = RequestContext.get().getCurrUserId();
        if (hasPermissionOrg == null) {
            String viewType = "15";
            String dataEntityName = model.getDataEntityType().getName();
            if (dataEntityName.equals("conm_purcontract")) {
                viewType = "02";
            } else if (dataEntityName.equals("conm_salcontract")) {
                viewType = "03";
            }
            hasPermissionOrg = BillTplImportPlugin.getHasPermissionOrg(dataEntityName, viewType);
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
        DynamicObject[] conm_types = BusinessDataServiceHelper.load((String)"conm_type", (String)"activereview,activesign,activearchive", null);
        HashMap<Long, DynamicObject> maps = new HashMap<Long, DynamicObject>(conm_types.length);
        for (DynamicObject conm_type : conm_types) {
            maps.put((Long)conm_type.getPkValue(), conm_type);
        }
        this.tempCache.put("conm_types", maps);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        long headBegin = System.currentTimeMillis();
        String billcretype = this.getPageCache().get("billcretype");
        if (BillTplImportPlugin.isSkip(billcretype)) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Map<Object, Object> propMap = this.format4ImportAndApi(e.getSourceData().get("org"));
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BillTplImportPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            this.vertifyOperatorAndGroup(org, e);
        }
        if (!BillImportHelper.isImport((String)billcretype)) {
            DynamicObject billtype = this.getBaseDataFromCache(e.getSourceData(), "billtype", "bos_billtype", "billformid", null);
            if (billtype == null) {
                return;
            }
            String formId = this.getView().getFormShowParameter().getFormId();
            if (!billtype.getDynamicObject("billformid").getPkValue().equals(formId)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u7b26\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"BillTplImportPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
            }
            long operatorBegin = System.currentTimeMillis();
            log.info("\u5904\u7406\u5355\u5934\u5b57\u6bb5\u8017\u65f6\uff1a" + (operatorBegin - headBegin) + "\u6beb\u79d2");
            this.vertifyOperator(org, e);
            long operatorEnd = System.currentTimeMillis();
            log.info("\u5904\u7406\u4e1a\u52a1\u5458\u4e1a\u52a1\u7ec4\u603b\u8017\u65f6\uff1a" + (operatorEnd - operatorBegin) + "\u6beb\u79d2");
            Boolean istax = (Boolean)e.getSourceData().get("istax");
            Map<Object, Object> materialMap = this.format4ImportAndApi(e.getSourceData().get("billentry"));
            if (materialMap != null) {
                List billentry = (List)materialMap.get("sourceData");
                JSONArray maps = this.dealMaterialEntry(org, billentry);
                e.getSourceData().put("billentry", maps);
                ArrayList<String> errorMeg = new ArrayList<String>();
                int num = 0;
                for (int i = 0; i < billentry.size(); ++i) {
                    Map entry = (Map)billentry.get(i);
                    if (entry == null) continue;
                    ++num;
                    if (entry.get("discountrate") == null || entry.get("discounttype") == null) continue;
                    BigDecimal discountRate = new BigDecimal(String.valueOf(entry.get("discountrate")));
                    String discounttype = String.valueOf(entry.get("discounttype"));
                    if (!StringUtils.isNotEmpty((CharSequence)discounttype) || !discounttype.equals(DiscountTypeEnum.UNITDIS.getValue()) && !discounttype.equals(DiscountTypeEnum.FIXEDDIS.getValue())) continue;
                    if (istax.booleanValue()) {
                        BigDecimal priceandtax = BigDecimal.ZERO;
                        if (entry.get("priceandtax") != null) {
                            priceandtax = new BigDecimal(String.valueOf(entry.get("priceandtax")));
                        }
                        if (discountRate != null && priceandtax != null && discountRate.compareTo(priceandtax) > 0) {
                            errorMeg.add(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"BillTplImportPlugin_5", (String)"scmc-conm-formplugin", (Object[])new Object[0]), num));
                        }
                    }
                    if (istax.booleanValue()) continue;
                    BigDecimal price = BigDecimal.ZERO;
                    if (entry.get("price") != null) {
                        price = new BigDecimal(String.valueOf(entry.get("price")));
                    }
                    if (discountRate == null || price == null || discountRate.compareTo(price) <= 0) continue;
                    errorMeg.add(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u5355\u4f4d\u6298\u6263(\u7387)\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u5355\u4ef7\u201d\u3002", (String)"BillTplImportPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]), num));
                }
                if (errorMeg != null && errorMeg.size() > 0) {
                    e.setCancel(true);
                    e.setCancelMessage(((Object)errorMeg).toString());
                    e.setFireAfterImportData(false);
                }
            }
            this.verfityTemplateVersion(e);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        long amountBegin = System.currentTimeMillis();
        String billcretype = this.getPageCache().get("billcretype");
        if (BillTplImportPlugin.isSkip(billcretype)) {
            return;
        }
        if (!BillImportHelper.isImport((String)billcretype)) {
            String suitScope;
            DynamicObject type;
            DynamicObject billtype;
            DynamicObject category;
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            String cretype = (String)model.getValue("billcretype");
            if (cretype == null) {
                model.setValue("billcretype", (Object)"1");
            }
            if ((category = (DynamicObject)this.getModel().getValue("category")) == null && (billtype = (DynamicObject)model.getValue("billtype")) != null) {
                Long categoryId = (Long)this.tempCache.get("import_billtype_category" + billtype.getPkValue());
                if (categoryId != null) {
                    this.getModel().setValue("category", (Object)categoryId);
                } else {
                    DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter((MainEntityType)this.getModel().getDataEntityType(), (long)((Long)billtype.getPkValue()));
                    if (billTypeParam != null && (category = billTypeParam.getDynamicObject("category")) != null) {
                        this.getModel().setValue("category", category.getPkValue());
                        this.tempCache.put("import_billtype_category" + billtype.getPkValue(), category.getPkValue());
                    }
                }
            }
            if ((type = (DynamicObject)this.getModel().getValue("type")) != null) {
                this.getModel().setValue("conmprop", (Object)type.getString("conmprop"));
            }
            this.setBillOther(model, this.tempCache, org);
            if (type != null) {
                this.setSeveralStatus(model, type);
            }
            String bizMode = (String)model.getValue("bizmode");
            if (ContractBizModeEnum.UNIFIEDNEGOANDSIGN.getValue().equals(bizMode) || ContractBizModeEnum.SEPARATENEGO_SUBSIGN.getValue().equals(bizMode)) {
                model.setValue("suitscope", (Object)ContractSuitScopeEnum.CURRENTORG.getValue());
            } else if (ContractBizModeEnum.UNIFIEDNEGO_SUBSIGN.getValue().equals(bizMode) && StringUtils.isEmpty((CharSequence)(suitScope = (String)model.getValue("suitscope")))) {
                model.setValue("suitscope", (Object)ContractSuitScopeEnum.ALLORG.getValue());
            }
            this.setBillentrys(model, type, amountBegin);
        }
    }

    public void vertifyOperator(DynamicObject org, BeforeImportDataEventArgs e) {
        Map<Object, Object> operatorGroupMap = this.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
        Map<Object, Object> operatorMap = this.format4ImportAndApi(e.getSourceData().get("operator"));
        if (operatorGroupMap != null || operatorMap != null) {
            Map groups;
            QFilter groupFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
            String orgProp = ((BasedataProp)this.getModel().getProperty("operatorgroup")).getOrgProp();
            String orgFunc = ((OrgProp)this.getModel().getProperty(orgProp)).getOrgFunc();
            QFilter typeFilter = new QFilter("operatorgrouptype", "=", (Object)("02".equalsIgnoreCase(orgFunc) ? "CGZ" : "XSZ"));
            QFilter filter = typeFilter.and(groupFilter);
            HashMap<String, Object> newOperator = new HashMap<String, Object>();
            HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
            if (operatorGroupMap != null) {
                filter.and(new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop"))));
            }
            if ((groups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{filter})) != null && groups.size() > 0) {
                block0: for (DynamicObject group : groups.values()) {
                    DynamicObjectCollection entryentity = group.getDynamicObjectCollection("entryentity");
                    if (operatorMap != null) {
                        for (DynamicObject operator : entryentity) {
                            if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                            newOperator.put("id", operator.getPkValue());
                            newOperatorGroup.put("id", group.getPkValue());
                            continue block0;
                        }
                        continue;
                    }
                    if (operatorGroupMap == null) continue;
                    newOperatorGroup.put("id", group.getPkValue());
                    break;
                }
                if (operatorMap != null && operatorMap.size() > 0 && newOperator.size() <= 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u53ef\u9009\u8303\u56f4\u5185\u627e\u4e0d\u5230\u201c%1$s\u201d\u4e3a\u201c%2$s\u201d\u7684\u4e1a\u52a1\u5458\u3002", (String)"BillTplImportPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]), operatorMap.get("importprop"), operatorMap.get(operatorMap.get("importprop"))));
                }
                if (newOperator.size() > 0) {
                    e.getSourceData().put("operator", newOperator);
                }
                if (newOperatorGroup.size() > 0) {
                    e.getSourceData().put("operatorgroup", newOperatorGroup);
                }
            }
        }
    }

    public void verfityTemplateVersion(BeforeImportDataEventArgs e) {
        Map<Object, Object> templateversionMap;
        DynamicObject template;
        Map<Object, Object> templateMap = this.format4ImportAndApi(e.getSourceData().get("template"));
        if (templateMap != null && (template = BusinessDataServiceHelper.loadSingleFromCache((String)"conm_template", (QFilter[])new QFilter[]{new QFilter("number", "=", templateMap.get(templateMap.get("importprop")))})) != null && (templateversionMap = this.format4ImportAndApi(e.getSourceData().get("templateversion"))) != null) {
            int count = 0;
            DynamicObjectCollection attachmententry = template.getDynamicObjectCollection("attachmententry");
            Object pkValue = null;
            for (DynamicObject attachment : attachmententry) {
                String version = attachment.getString("version");
                if (!templateversionMap.get(templateversionMap.get("importprop")).equals(version)) continue;
                pkValue = attachment.getPkValue();
                ++count;
            }
            if (count == 0) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u7248\u201c%1$s\u201d\u7684\u7248\u672c\u53f7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"BillTplImportPlugin_14", (String)"scmc-conm-formplugin", (Object[])new Object[0]), templateMap.get(templateMap.get("importprop")), templateversionMap.get(templateversionMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            if (count != 1) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5408\u540c\u6a21\u7248\u201c%1$s\u201d\u7684\u7248\u672c\u53f7\u201c%2$s\u201d\u91cd\u590d\u3002", (String)"BillTplImportPlugin_15", (String)"scmc-conm-formplugin", (Object[])new Object[0]), templateMap.get(templateMap.get("importprop")), templateversionMap.get(templateversionMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
            HashMap<String, Object> newOperator = new HashMap<String, Object>();
            newOperator.put("id", pkValue);
            e.getSourceData().put("templateversion", newOperator);
        }
    }

    public void vertifyOperatorAndGroup(DynamicObject org, BeforeImportDataEventArgs e) {
        Map<Object, Object> operatorGroupMap = this.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
        Map<Object, Object> operatorMap = this.format4ImportAndApi(e.getSourceData().get("operator"));
        Map data = e.getSourceData();
        if (operatorGroupMap != null || operatorMap != null) {
            if (operatorGroupMap != null && operatorGroupMap.get("importprop") != null && operatorGroupMap.get(operatorGroupMap.get("importprop")) != null && operatorGroupMap.get(operatorGroupMap.get("importprop")).equals("") && operatorMap != null && operatorMap.get("importprop") != null && operatorMap.get(operatorMap.get("importprop")) != null && operatorMap.get(operatorMap.get("importprop")).equals("")) {
                return;
            }
            QFilter operatorgroupOrgFilter = this.getBaseDataOrgFilterFromCache(org, "operatorgroup", "bd_operatorgroup");
            String orgProp = ((BasedataProp)this.getModel().getProperty("operatorgroup")).getOrgProp();
            String orgFunc = ((OrgProp)this.getModel().getProperty(orgProp)).getOrgFunc();
            QFilter operatorgroupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)("02".equalsIgnoreCase(orgFunc) ? "CGZ" : "XSZ"));
            QFilter invalidFilter = new QFilter("entryentity.invalid", "=", (Object)Boolean.FALSE);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            if (operatorGroupMap != null && operatorGroupMap.get("importprop") != null && operatorGroupMap.get(operatorGroupMap.get("importprop")) != null && !operatorGroupMap.get(operatorGroupMap.get("importprop")).equals("")) {
                invalidFilter.and(new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop"))));
            }
            Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operator,operatornumber,operatorname,invalid,enable", (QFilter[])new QFilter[]{operatorgroupOrgFilter, operatorgroupTypeFilter, invalidFilter, enableFilter});
            block0: for (DynamicObject operatorGroup : operatorgroups.values()) {
                DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                if (operatorMap == null) continue;
                for (DynamicObject operator : entryentity) {
                    if ((operator == null || operatorMap.get("importprop") == null || !operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) && (operator == null || operatorMap.get("operatornumber") == null || operator.getDynamicObject("operator") == null || !operatorMap.get("operatornumber").equals(operator.getDynamicObject("operator").getString("number")))) continue;
                    HashMap<String, Object> newOperator = new HashMap<String, Object>();
                    newOperator.put("id", operator.getPkValue());
                    data.put("operator", newOperator);
                    HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
                    newOperatorGroup.put("id", operatorGroup.getPkValue());
                    data.put("operatorgroup", newOperatorGroup);
                    continue block0;
                }
            }
        }
    }

    private void setBillOther(IDataModel model, Map tempCache, DynamicObject org) {
        model.setValue("billcretype", (Object)"1");
        model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        model.setValue("auditor", (Object)"");
        model.setValue("auditdate", (Object)"");
        model.setValue("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        model.setValue("validdate", (Object)"");
        model.setValue("valider", (Object)"");
        model.setValue("terminatestatus", (Object)BizTerminateStatusEnum.UNTERMINATE.getValue());
        model.setValue("terminator", (Object)"");
        model.setValue("terminatedate", (Object)"");
        model.setValue("cancelstatus", (Object)BizTerminateStatusEnum.UNTERMINATE.getValue());
        model.setValue("canceler", (Object)"");
        model.setValue("canceldate", (Object)"");
        model.setValue("freezestatus", (Object)BizFreezeStatusEnum.UNFREEZE.getValue());
        model.setValue("freezer", (Object)"");
        model.setValue("freezedate", (Object)"");
        model.setValue("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
        model.setValue("closer", (Object)"");
        model.setValue("closedate", (Object)"");
        model.setValue("changestatus", (Object)UnitConvertDir_UINV_U2ND);
        model.setValue("changer", (Object)"");
        model.setValue("changedate", (Object)"");
        model.setValue("signer", (Object)"");
        model.setValue("signdate", (Object)"");
        model.setValue("reviewdate", (Object)"");
        model.setValue("filinger", (Object)"");
        model.setValue("filingdate", (Object)"");
        Date exratedate = (Date)model.getValue("exratedate");
        Calendar instance = Calendar.getInstance();
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        Date time = instance.getTime();
        if (exratedate.compareTo(time) == 0) {
            model.setValue("exratedate", (Object)exratedate);
        }
        DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (exRateTable == null) {
            Map exRateMap = (Map)tempCache.get(org.getPkValue() + "-exRateMap");
            if (exRateMap == null) {
                exRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
                if (exRateMap != null) {
                    tempCache.put(org.getPkValue() + "-exRateMap", exRateMap);
                    model.setValue("exratetable", exRateMap.get("exchangeRateTableID"));
                }
            } else {
                model.setValue("exratetable", exRateMap.get("exchangeRateTableID"));
            }
        }
        if (currency == null) {
            Map currencyMap = (Map)tempCache.get(org.getPkValue() + "-currencyMap");
            if (currencyMap == null) {
                currencyMap = CurrencyHelper.getCurrencyAndExRateTable((Long)((Long)org.getPkValue()));
                if (currencyMap != null) {
                    tempCache.put(org.getPkValue() + "-currencyMap", currencyMap);
                    model.setValue("currency", currencyMap.get("baseCurrencyID"));
                }
            } else {
                model.setValue("currency", currencyMap.get("baseCurrencyID"));
            }
        }
        if (model.getValue("currency") == null) {
            return;
        }
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        if (settleCurrency == null) {
            model.setValue("settlecurrency", ((DynamicObject)model.getValue("currency")).getPkValue());
            model.setValue("exchangerate", (Object)BigDecimal.ONE);
        }
        long settlecurrencyId = model.getValue("settlecurrency") == null ? 0L : (Long)((DynamicObject)model.getValue("settlecurrency")).getPkValue();
        long currencyId = model.getValue("currency") == null ? 0L : (Long)((DynamicObject)model.getValue("currency")).getPkValue();
        long exratetableId = model.getValue("exratetable") == null ? 0L : (Long)((DynamicObject)model.getValue("exratetable")).getPkValue();
        Map exchangeRateMap = CurrencyHelper.getExchangeRateMap((Long)settlecurrencyId, (Long)currencyId, (Long)exratetableId, (Date)((Date)model.getValue("exratedate")));
        if (exchangeRateMap != null && exchangeRateMap.size() > 0) {
            BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
            if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("exchangerate", exchangeRateMap.get("exchangeRate"));
            }
            if (((Boolean)exchangeRateMap.get("quoteType")).booleanValue()) {
                model.setValue("exchangetype", (Object)ExChangeTypeEnum.INDIRECTRATE.getValue());
            } else {
                model.setValue("exchangetype", (Object)ExChangeTypeEnum.DIRECTRATE.getValue());
            }
        }
    }

    private void setSeveralStatus(IDataModel model, DynamicObject type) {
        Long pkValue = (Long)type.getPkValue();
        Map conm_types = (Map)this.tempCache.get("conm_types");
        if (conm_types == null) {
            return;
        }
        DynamicObject conm_type = (DynamicObject)conm_types.get(pkValue);
        if (conm_type == null) {
            return;
        }
        boolean activereview = conm_type.getBoolean("activereview");
        boolean activearchive = conm_type.getBoolean("activearchive");
        boolean activeSign = conm_type.getBoolean("activesign");
        if (this.tempCache.get("reviewstatus") == null) {
            if (!activereview) {
                model.setValue("reviewstatus", (Object)BizReviewStatusEnum.INACTIVE.getValue());
            } else {
                model.setValue("reviewstatus", (Object)BizReviewStatusEnum.UNREVIEW.getValue());
            }
        }
        if (this.tempCache.get("signstatus") == null) {
            if (!activeSign) {
                model.setValue("signstatus", (Object)BizSignStatusEnum.INACTIVE.getValue());
                model.setValue("iselecsignature", (Object)Boolean.FALSE);
            } else {
                model.setValue("signstatus", (Object)BizSignStatusEnum.UNSIGN.getValue());
            }
        }
        if (this.tempCache.get("filingstatus") == null) {
            if (!activearchive) {
                model.setValue("filingstatus", (Object)FilingStatusEnum.INACTIVE.getValue());
            } else {
                model.setValue("filingstatus", (Object)FilingStatusEnum.UNFILED.getValue());
            }
        }
    }

    private void setBillentrys(IDataModel model, DynamicObject type, long amountBegin) {
        Boolean isentrysumamt = (Boolean)model.getValue("isentrysumamt");
        if (isentrysumamt.booleanValue()) {
            model.setValue("totalamount", (Object)ZERO);
            model.setValue("totaltaxamount", (Object)ZERO);
            model.setValue("totalallamount", (Object)ZERO);
        }
        DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
        for (DynamicObject billentry : billentrys) {
            DynamicObject baseUnit;
            BasedataEntityType materialType;
            billentry.set("rowclosestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            billentry.set("rowterminatestatus", (Object)BizRowTerminateStatusEnum.UNTERMINATE.getValue());
            DynamicObject material = billentry.getDynamicObject("material");
            if (material == null || material.getDynamicObject("masterid") == null) continue;
            billentry.set("materialmasterid", material.getDynamicObject("masterid").getPkValue());
            if (material.getDynamicObject("masterid").getBoolean("isdisposable")) {
                if (StringUtils.isEmpty((CharSequence)billentry.getString("materialname"))) {
                    billentry.set("materialname", (Object)material.getDynamicObject("masterid").getLocaleString("name").getLocaleValue());
                }
            } else {
                billentry.set("materialname", (Object)material.getDynamicObject("masterid").getLocaleString("name").getLocaleValue());
            }
            billentry.set("baseunit", (Object)material.getDynamicObject("masterid").getDynamicObject("baseunit"));
            billentry.set("auxunit", (Object)material.getDynamicObject("masterid").getDynamicObject("auxptyunit"));
            DynamicObject unit = billentry.getDynamicObject("unit");
            if (unit == null && material != null && (materialType = (BasedataEntityType)material.getDataEntityType()) != null) {
                int masteridType = materialType.getMasteridType();
                if (masteridType == 1 && (baseUnit = billentry.getDynamicObject("baseunit")) != null) {
                    billentry.set("unit", (Object)baseUnit);
                }
                if (masteridType == 2) {
                    String materialName = materialType.getName();
                    String unitForName = "";
                    if ("bd_materialpurchaseinfo".equals(materialName)) {
                        unitForName = "purchaseunit";
                    }
                    if ("bd_materialsalinfo".equals(materialName)) {
                        unitForName = "salesunit";
                    }
                    if (StringUtils.isNotBlank((CharSequence)unitForName)) {
                        unit = material.getDynamicObject(unitForName);
                        billentry.set("unit", (Object)unit);
                    }
                }
            }
            DynamicObject baseunit = billentry.getDynamicObject("baseunit");
            if (unit != null && baseunit != null) {
                if (unit.getPkValue().equals(baseunit.getPkValue())) {
                    billentry.set("baseqty", (Object)billentry.getBigDecimal("qty"));
                } else {
                    billentry.set("baseqty", (Object)BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)unit, (BigDecimal)billentry.getBigDecimal("qty"), (DynamicObject)baseunit));
                }
            }
            BigDecimal qty = billentry.getBigDecimal("qty");
            baseUnit = billentry.getDynamicObject("baseunit");
            BigDecimal baseQty = billentry.getBigDecimal("baseqty");
            DynamicObject auxptyUnit = billentry.getDynamicObject("auxunit");
            BigDecimal auxQty = billentry.getBigDecimal("auxqty");
            String unitConvertDir = material.getString("masterid.unitconvertdir");
            if (auxptyUnit == null) {
                auxQty = BigDecimal.ZERO;
            } else {
                if (UnitConvertDir_U2ND_UINV.equals(unitConvertDir) && BigDecimalUtil.isBlank((BigDecimal)qty)) {
                    baseQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)auxptyUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                    qty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                }
                if (UnitConvertDir_UINV_U2ND.equals(unitConvertDir) && BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                    auxQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
                }
                if (UnitConvertDir_UINVANDU2ND.equals(unitConvertDir)) {
                    if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                        qty = BigDecimal.ZERO;
                        baseQty = BigDecimal.ZERO;
                        auxQty = BigDecimal.ZERO;
                    }
                    if (BigDecimalUtil.isNotBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                        auxQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
                    }
                    if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)auxQty)) {
                        baseQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)auxptyUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                        qty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)material.getDynamicObject("masterid"), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    }
                }
            }
            billentry.set("qty", (Object)qty);
            billentry.set("baseqty", (Object)baseQty);
            billentry.set("auxqty", (Object)auxQty);
            AmountInfo amountInfo = new AmountInfo();
            DynamicObject taxRateId = billentry.getDynamicObject("taxrateid");
            if (taxRateId == null) {
                amountInfo.setTaxRate(ZERO);
                billentry.set("taxrate", (Object)ZERO);
            } else {
                BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                amountInfo.setTaxRate(taxRate);
                billentry.set("taxrate", (Object)taxRate);
            }
            BigDecimal disCountRate = billentry.getBigDecimal("discountrate");
            if (billentry.getString("discounttype").equals(DiscountTypeEnum.DISRATE.getValue())) {
                if (disCountRate.compareTo(new BigDecimal(100)) > 0) {
                    billentry.set("discountrate", (Object)new BigDecimal(100));
                } else if (disCountRate.compareTo(ZERO) < 0) {
                    billentry.set("discountrate", (Object)ZERO);
                }
            }
            Object discountType = billentry.get("discounttype");
            amountInfo.setDiscountRate(billentry.getBigDecimal("discountrate"));
            if (discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                billentry.set("discountrate", (Object)ZERO);
            }
            if (billentry.getBoolean("ispresent")) {
                Boolean istax = (Boolean)model.getValue("istax");
                BigDecimal price = BigDecimal.ZERO;
                price = istax != false ? billentry.getBigDecimal("priceandtax") : billentry.getBigDecimal("price");
                if (price.compareTo(BigDecimal.ZERO) == 0) {
                    billentry.set("discountrate", (Object)BigDecimal.ZERO);
                    billentry.set("discounttype", (Object)"NULL");
                } else {
                    billentry.set("discountrate", (Object)100);
                    billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                }
            }
            if (model.getValue("istax") == null) {
                amountInfo.setTax(true);
            } else {
                amountInfo.setTax((Boolean)model.getValue("istax"));
            }
            amountInfo.setQty(billentry.getBigDecimal("qty"));
            amountInfo.setPrice(billentry.getBigDecimal("price"));
            amountInfo.setPriceAndTax(billentry.getBigDecimal("priceandtax"));
            amountInfo.setAmount(billentry.getBigDecimal("amount"));
            amountInfo.setTaxAmount(billentry.getBigDecimal("taxamount"));
            amountInfo.setDiscountType(billentry.getString("discounttype"));
            amountInfo.setDiscountRate(billentry.getBigDecimal("discountrate"));
            amountInfo.setExChangeRate((BigDecimal)model.getValue("exchangerate"));
            amountInfo.setSettleAmtPrecision(model.getValue("settlecurrency") == null ? 10 : ((DynamicObject)model.getValue("settlecurrency")).getInt("amtprecision"));
            amountInfo.setSettlePricePrecision(10);
            amountInfo.setCurrencyAmtPrecision(model.getValue("currency") == null ? 10 : ((DynamicObject)model.getValue("currency")).getInt("amtprecision"));
            amountInfo.setExchangetype((String)model.getValue("exchangetype"));
            amountInfo = BillTplImportPlugin.getAmount(amountInfo);
            billentry.set("price", (Object)amountInfo.getPrice());
            billentry.set("priceandtax", (Object)amountInfo.getPriceAndTax());
            billentry.set("discountamount", (Object)amountInfo.getDiscountAmount());
            billentry.set("taxamount", (Object)amountInfo.getTaxAmount());
            billentry.set("amount", (Object)amountInfo.getAmount());
            billentry.set("amountandtax", (Object)amountInfo.getAmountAndTax());
            billentry.set("curtaxamount", (Object)amountInfo.getCurTaxAmount());
            billentry.set("curamount", (Object)amountInfo.getCurAmount());
            billentry.set("curamountandtax", (Object)amountInfo.getCurAmountAndTax());
            if (!isentrysumamt.booleanValue()) continue;
            model.setValue("totalamount", (Object)billentry.getBigDecimal("amount").add((BigDecimal)model.getValue("totalamount")));
            model.setValue("totaltaxamount", (Object)billentry.getBigDecimal("taxamount").add((BigDecimal)model.getValue("totaltaxamount")));
            model.setValue("totalallamount", (Object)billentry.getBigDecimal("amountandtax").add((BigDecimal)model.getValue("totalallamount")));
        }
        long amountEnd = System.currentTimeMillis();
        log.info("\u5904\u7406\u91d1\u989d\u5b57\u6bb5\u8017\u65f6\uff1a" + (amountEnd - amountBegin) + "\u6beb\u79d2");
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map<Object, Object> propMap = this.format4ImportAndApi(sourceData.get(propName));
        String importProp = null;
        if (propMap != null) {
            importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", propMap.get(importProp))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private static boolean isSkip(String billcretype) {
        return "2".equals(billcretype);
    }

    private JSONArray dealMaterialEntry(DynamicObject org, List<Map<String, Map>> billentry) {
        JSONArray billEntryArray = new JSONArray();
        HashMap<String, Object> entryPurOrgMap = new HashMap<String, Object>();
        entryPurOrgMap.put("id", org.getPkValue());
        entryPurOrgMap.put("importprop", "number");
        entryPurOrgMap.put("number", org.getString("number"));
        for (Map<String, Map> entry : billentry) {
            entry.put("entrypurorg", entryPurOrgMap);
            billEntryArray.add(entry);
        }
        return billEntryArray;
    }

    public static AmountInfo getAmount(AmountInfo amountInfo) {
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = amountInfo.getTaxRate().divide(HUNDRED);
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = amountInfo.getSettlePricePrecision();
        int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        String exchangetype = amountInfo.getExchangetype();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), 10, 4);
                if (discountRate == null || StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue()) || discountRate.compareTo(ZERO) == 0) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(HUNDRED);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, 4);
                    amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, 4);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, 4);
                    amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, 4);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(10, 4);
                if (discountRate == null || StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue()) || discountRate.compareTo(ZERO) == 0) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(HUNDRED);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, 4);
                    amount = qty.multiply(price).multiply(ONE.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settleAmtPrecision, 4);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, 4);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, 4);
            } else {
                priceAndTax = ZERO;
                price = ZERO;
            }
            if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
                BigDecimal curAmount = ZERO;
                BigDecimal curTaxAmount = ZERO;
                BigDecimal curAmountAndTax = ZERO;
                curTaxAmount = AmountHelper.getCurAmountByRate((BigDecimal)taxAmount, (BigDecimal)exChangeRate, (int)currencyAmtPrecision, (String)exchangetype);
                if (isTax) {
                    curAmountAndTax = AmountHelper.getCurAmountByRate((BigDecimal)amountAndTax, (BigDecimal)exChangeRate, (int)currencyAmtPrecision, (String)exchangetype);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                } else {
                    curAmount = AmountHelper.getCurAmountByRate((BigDecimal)amount, (BigDecimal)exChangeRate, (int)currencyAmtPrecision, (String)exchangetype);
                    curAmountAndTax = curAmount.add(curTaxAmount);
                }
                amountInfo.setCurAmount(curAmount);
                amountInfo.setCurTaxAmount(curTaxAmount);
                amountInfo.setCurAmountAndTax(curAmountAndTax);
            }
        } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
            priceAndTax = priceAndTax.setScale(settlePricePrecision, 4);
            price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
        } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
            price = price.setScale(settlePricePrecision, 4);
            priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
        } else {
            priceAndTax = ZERO;
            price = ZERO;
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        return amountInfo;
    }

    private QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName) {
        QFilter baseDataOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }

    public Map<Object, Object> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return (Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class);
        }
        if (sourceData instanceof Map) {
            Map propMap = (Map)sourceData;
            if (propMap.get("id") != null) {
                propMap.put("importprop", "id");
            } else if (propMap.get("number") != null) {
                propMap.put("importprop", "number");
            } else if (propMap.get("name") != null) {
                propMap.put("importprop", "name");
            } else if (propMap.get("operatornumber") != null) {
                propMap.put("importprop", "operatornumber");
            }
            return (Map)sourceData;
        }
        if (sourceData instanceof JSONArray) {
            ArrayList<Object> list = new ArrayList<Object>(((JSONArray)sourceData).size());
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((JSONArray)sourceData).size());
            JSONArray Ids = (JSONArray)sourceData;
            for (int i = 0; i < Ids.size(); ++i) {
                Object obj1 = Ids.toArray()[i];
                list.add(obj1);
            }
            propMap.put("sourceData", list);
            return propMap;
        }
        if (sourceData instanceof ArrayList) {
            HashMap<Object, Object> propMap = new HashMap<Object, Object>(((ArrayList)sourceData).size());
            propMap.put("sourceData", sourceData);
            return propMap;
        }
        return null;
    }

    public static class AmountInfo {
        private boolean isTax = true;
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal price = BigDecimal.ZERO;
        private BigDecimal priceAndTax = BigDecimal.ZERO;
        private BigDecimal taxRate = BigDecimal.ZERO;
        private String discountType = "";
        private BigDecimal discountRate = BigDecimal.ZERO;
        private int settleAmtPrecision = 10;
        private int settlePricePrecision = 10;
        private int currencyAmtPrecision = 10;
        private BigDecimal exChangeRate = BigDecimal.ZERO;
        private String exchangetype = "";
        private BigDecimal amount = BigDecimal.ZERO;
        private BigDecimal taxAmount = BigDecimal.ZERO;
        private BigDecimal discountAmount = BigDecimal.ZERO;
        private BigDecimal amountAndTax = BigDecimal.ZERO;
        private BigDecimal curAmount = BigDecimal.ZERO;
        private BigDecimal curTaxAmount = BigDecimal.ZERO;
        private BigDecimal curAmountAndTax = BigDecimal.ZERO;

        public boolean isTax() {
            return this.isTax;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public BigDecimal getPriceAndTax() {
            return this.priceAndTax;
        }

        public BigDecimal getTaxRate() {
            return this.taxRate;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        public BigDecimal getDiscountRate() {
            return this.discountRate;
        }

        public int getSettleAmtPrecision() {
            return this.settleAmtPrecision;
        }

        public int getSettlePricePrecision() {
            return this.settlePricePrecision;
        }

        public int getCurrencyAmtPrecision() {
            return this.currencyAmtPrecision;
        }

        public BigDecimal getExChangeRate() {
            return this.exChangeRate;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public BigDecimal getDiscountAmount() {
            return this.discountAmount;
        }

        public BigDecimal getAmountAndTax() {
            return this.amountAndTax;
        }

        public BigDecimal getCurAmount() {
            return this.curAmount;
        }

        public BigDecimal getCurTaxAmount() {
            return this.curTaxAmount;
        }

        public BigDecimal getCurAmountAndTax() {
            return this.curAmountAndTax;
        }

        public void setTax(boolean isTax) {
            this.isTax = isTax;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceAndTax(BigDecimal priceAndTax) {
            this.priceAndTax = priceAndTax;
        }

        public void setTaxRate(BigDecimal taxRate) {
            this.taxRate = taxRate;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        public void setDiscountRate(BigDecimal discountRate) {
            this.discountRate = discountRate;
        }

        public void setSettleAmtPrecision(int settleAmtPrecision) {
            this.settleAmtPrecision = settleAmtPrecision;
        }

        public void setSettlePricePrecision(int settlePricePrecision) {
            this.settlePricePrecision = settlePricePrecision;
        }

        public void setCurrencyAmtPrecision(int currencyAmtPrecision) {
            this.currencyAmtPrecision = currencyAmtPrecision;
        }

        public void setExChangeRate(BigDecimal exChangeRate) {
            this.exChangeRate = exChangeRate;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public void setDiscountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
        }

        public void setAmountAndTax(BigDecimal amountAndTax) {
            this.amountAndTax = amountAndTax;
        }

        public void setCurAmount(BigDecimal curAmount) {
            this.curAmount = curAmount;
        }

        public void setCurTaxAmount(BigDecimal curTaxAmount) {
            this.curTaxAmount = curTaxAmount;
        }

        public void setCurAmountAndTax(BigDecimal curAmountAndTax) {
            this.curAmountAndTax = curAmountAndTax;
        }

        public String getExchangetype() {
            return this.exchangetype;
        }

        public void setExchangetype(String exchangetype) {
            this.exchangetype = exchangetype;
        }
    }
}

