/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.conm.business.helper.AmountHelper;
import kd.scmc.conm.business.helper.BillImportHelper;
import kd.scmc.conm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.conm.business.helper.PrecisionAccountHelper;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.DiscountTypeEnum;
import kd.scmc.conm.enums.ExcuteControlEnum;
import kd.scmc.conm.utils.CommonUtils;

public class MatContractTplPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String CACHE_SUMAMOUNT = "MatContractTplPlugin_sumAmount";

    public void registerListener(EventObject e) {
        BasedataEdit taxrateid;
        EntryGrid billentry;
        BasedataEdit unit;
        BasedataEdit materialversion;
        BasedataEdit materialEdit;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmainentry");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialversion = (BasedataEdit)this.getView().getControl("materialversion")) != null) {
            materialversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((billentry = (EntryGrid)this.getView().getControl("billentry")) != null) {
            billentry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl("taxrateid")) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject entity = this.getModel().getDataEntity(true);
        DynamicObjectCollection billEntry = entity.getDynamicObjectCollection("billentry");
        for (DynamicObject row : billEntry) {
            row.set("entrypurorg", (Object)org);
        }
        this.getView().updateView("billentry");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.excCtrlMustInput(this.getModel().getValue("type"));
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.excCtrlMustInput(this.getModel().getValue("type"));
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        switch (key) {
            case "materialversion": {
                if (material != null) {
                    DynamicObject masterMaterial = (DynamicObject)this.getMatPropValue(material, "masterid");
                    QFilter qFilter = new QFilter("material", "=", masterMaterial.getPkValue());
                    showParameter.getListFilterParameter().setFilter(qFilter);
                    showParameter.setCustomParam("material", masterMaterial.getPkValue());
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"MatContractTplPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "unit": {
                if (material != null) {
                    DynamicObject masterMaterial = (DynamicObject)this.getMatPropValue(material, "masterid");
                    DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
                    Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                    List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)((Long)masterMaterial.getPkValue()), (Long)srcmuId, (String)"1");
                    QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                    showParameter.getListFilterParameter().setFilter(qFilter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"MatContractTplPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "taxrateid": {
                Date bizTime = (Date)this.getModel().getValue("biztime");
                QFilter activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
                QFilter qFilter = expQfilter.and(activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        switch (key = op.getOperateKey()) {
            case "discountamount": {
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                if (settleCurrency == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7ed3\u7b97\u5e01\u3002", (String)"MatContractTplPlugin_13", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("billentry");
                Boolean isHasRow = Boolean.FALSE;
                for (int i = 0; i < rowCount; ++i) {
                    BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i);
                    BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent || amountAndTax.add(discountAmount).compareTo(BigDecimal.ZERO) <= 0) continue;
                    isHasRow = Boolean.TRUE;
                    break;
                }
                if (isHasRow.booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"MatContractTplPlugin_14", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "batchfillentry": {
                Object value;
                EntryGrid entry = (EntryGrid)this.getControl("billentry");
                String focusField = entry.getEntryState().getFocusField();
                int focusRow = entry.getEntryState().getFocusRow();
                if (focusRow <= -1 || !"discountrate".equals(focusField) && !"discounttype".equals(focusField) || (value = this.getModel().getValue(focusField, focusRow)) == null) break;
                for (int i = focusRow; i < this.getModel().getEntryRowCount("billentry"); ++i) {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent) continue;
                    this.getModel().setValue(focusField, value, i);
                }
                e.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("discountamount".equals(e.getOperateKey())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("conm_discountamount");
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            customParams.put("currency", settleCurrency.getPkValue());
            formShowParameter.setCustomParams(customParams);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "conm_discountamount"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        block3 : switch (actionId) {
            case "conm_discountamount": {
                BigDecimal rowDistAmount;
                int i;
                boolean isPresent;
                BigDecimal amountAndTax;
                BigDecimal discountAmount;
                int i2;
                Map discountMap;
                if (returnData == null || (discountMap = (Map)returnData) == null || discountMap.isEmpty() || discountMap.get("discountamount") == null) break;
                BigDecimal totalDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                BigDecimal remainDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
                BigDecimal allAmountAndTaxAndDiscount = BigDecimal.ZERO;
                int rowCount = this.getModel().getEntryRowCount("billentry");
                for (i2 = 0; i2 < rowCount; ++i2) {
                    discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                    amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    if (isPresent) continue;
                    allAmountAndTaxAndDiscount = allAmountAndTaxAndDiscount.add(discountAmount).add(amountAndTax);
                }
                if (totalDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || totalDiscountAmount.compareTo(allAmountAndTaxAndDiscount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\u5927\u4e8e0\u65f6\uff0c\u603b\u6298\u6263\u989d\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\uff08\u8d60\u54c1\u9664\u5916\uff09\u3002", (String)"MatContractTplPlugin_15", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (i2 = 0; i2 < rowCount; ++i2) {
                    discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                    amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    if (isPresent || discountAmount.add(amountAndTax).compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i2);
                }
                BigDecimal allAmountAndTax = BigDecimal.ZERO;
                ArrayList<Integer> allDistRows = new ArrayList<Integer>(16);
                for (i = 0; i < rowCount; ++i) {
                    BigDecimal amountAndTax2 = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent2 = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent2 || amountAndTax2.compareTo(BigDecimal.ZERO) <= 0) continue;
                    allAmountAndTax = allAmountAndTax.add(amountAndTax2);
                    allDistRows.add(i);
                }
                if (allAmountAndTax.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"MatContractTplPlugin_14", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (i = 0; i < allDistRows.size(); ++i) {
                    int rowIndex = (Integer)allDistRows.get(i);
                    BigDecimal amountAndTax3 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex);
                    rowDistAmount = BigDecimal.ZERO;
                    rowDistAmount = i == allDistRows.size() - 1 ? remainDiscountAmount : totalDiscountAmount.multiply(amountAndTax3).divide(allAmountAndTax, settleAmtPrecision, 4);
                    if (rowDistAmount.compareTo(amountAndTax3) > 0) {
                        rowDistAmount = amountAndTax3;
                    }
                    remainDiscountAmount = remainDiscountAmount.subtract(rowDistAmount);
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.FIXEDDIS.getValue(), rowIndex);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount, rowIndex);
                }
                if (remainDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || allDistRows.isEmpty()) break;
                for (i = allDistRows.size() - 1; i >= 0; --i) {
                    Integer rowIndex = (Integer)allDistRows.get(i);
                    if (remainDiscountAmount.compareTo(BigDecimal.ZERO) == 0) break block3;
                    BigDecimal amountAndTax4 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex.intValue());
                    rowDistAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex.intValue());
                    if (amountAndTax4.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (remainDiscountAmount.compareTo(amountAndTax4) < 0) {
                        remainDiscountAmount = BigDecimal.ZERO;
                        this.getModel().setValue("discountamount", (Object)rowDistAmount.add(remainDiscountAmount), rowIndex.intValue());
                        continue;
                    }
                    remainDiscountAmount = remainDiscountAmount.subtract(amountAndTax4);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount.add(amountAndTax4), rowIndex.intValue());
                }
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("false".equals(this.getPageCache().get("ppcvar"))) {
            return;
        }
        if ("true".equals(this.getPageCache().get("stopChange"))) {
            return;
        }
        ChangeData[] valueSet = e.getChangeSet();
        block49: for (int i = 0; i < valueSet.length; ++i) {
            if (!CommonUtils.isRealChanged((ChangeData)valueSet[i])) continue;
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            int rowIndex = valueSet[i].getRowIndex();
            String propName = e.getProperty().getName();
            switch (propName = propName.toLowerCase(RequestContext.get().getLang().getLocale())) {
                case "material": {
                    this.changeMaterial((DynamicObject)newValue, rowIndex);
                    continue block49;
                }
                case "auxqty": {
                    BillQtyAndUnitHelper.setAuxBizQtyAndUnit((IDataModel)this.getModel(), (int)rowIndex, (String)propName);
                    this.changeAmountField(rowIndex);
                    this.getView().updateView("qty", rowIndex);
                    this.getView().updateView("baseqty", rowIndex);
                    continue block49;
                }
                case "baseqty": {
                    BillQtyAndUnitHelper.setAuxBizQtyAndUnit((IDataModel)this.getModel(), (int)rowIndex, (String)propName);
                    this.getView().updateView("auxqty", rowIndex);
                    continue block49;
                }
                case "taxamount": 
                case "amount": 
                case "amountandtax": {
                    this.changeTotalAmount(valueSet[i]);
                    continue block49;
                }
                case "billentrychangetype": {
                    this.xChangeType(valueSet[i]);
                    continue block49;
                }
                case "settlecurrency": {
                    this.changeSettleCur((DynamicObject)oldValue, (DynamicObject)newValue);
                    this.excCtrlMustInput(this.getModel().getValue("type"));
                    this.setDiscountRateScale(newValue);
                    continue block49;
                }
                case "exratetable": {
                    this.excCtrlMustInput(this.getModel().getValue("type"));
                    continue block49;
                }
                case "istax": {
                    this.changeIsNotTax(newValue);
                    this.changeIsTax(newValue);
                    continue block49;
                }
                case "taxrateid": {
                    this.changeTaxRateID((DynamicObject)newValue, rowIndex);
                    continue block49;
                }
                case "price": 
                case "priceandtax": 
                case "taxrate": {
                    if (!this.isCanChangeAmount(e.getProperty().getName(), oldValue, newValue, rowIndex)) {
                        return;
                    }
                    this.changePriceForIsPresent(rowIndex);
                    this.changeAmountField(rowIndex);
                    continue block49;
                }
                case "qty": {
                    this.changeQty((BigDecimal)newValue, rowIndex);
                    continue block49;
                }
                case "unit": {
                    this.changeQty((BigDecimal)this.getModel().getValue("qty", rowIndex), rowIndex);
                    continue block49;
                }
                case "ispresent": {
                    this.changePriceForIsPresent(rowIndex);
                    this.changeIsPresent(newValue, rowIndex);
                    continue block49;
                }
                case "discounttype": 
                case "discountrate": {
                    String fieldName = e.getProperty().getName();
                    this.changeDiscountType(fieldName, oldValue, newValue, rowIndex);
                    this.changeAmountField(rowIndex);
                    continue block49;
                }
                case "discountamount": {
                    this.changeDiscountAmount(e.getProperty().getName(), oldValue, newValue, rowIndex);
                    this.changeAmountField(rowIndex, Boolean.TRUE);
                    continue block49;
                }
                case "exchangerate": {
                    this.changeExChangeRate(newValue);
                    continue block49;
                }
                case "exchangetype": {
                    Object exchangeRate = this.getModel().getValue("exchangerate");
                    this.changeExChangeRate(exchangeRate);
                    continue block49;
                }
                case "isentrysumamt": {
                    this.changeSumAmt((Boolean)newValue);
                    continue block49;
                }
                case "type": {
                    this.excCtrlMustInput(newValue);
                    continue block49;
                }
                case "suitorg": {
                    if (newValue == null) continue block49;
                    DynamicObjectCollection suitEntrys = this.getModel().getEntryEntity("suitentry");
                    int count = 0;
                    for (int s = 0; s < suitEntrys.size(); ++s) {
                        DynamicObject suitEntry;
                        String suitentrychangetype;
                        ++count;
                        if (s == rowIndex || (suitentrychangetype = (suitEntry = (DynamicObject)suitEntrys.get(s)).getString("suitentrychangetype")) != null && "C".equals(suitentrychangetype)) continue;
                        DynamicObject suitOrg = suitEntry.getDynamicObject("suitorg");
                        DynamicObject newOrg = (DynamicObject)newValue;
                        if (suitOrg == null || newOrg == null || !suitOrg.getPkValue().equals(newOrg.getPkValue())) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u884c\u4e0e\u7b2c%1$s\u884c\u7ec4\u7ec7\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"MatContractTplPlugin_16", (String)"scmc-conm-formplugin", (Object[])new Object[0]), count));
                        this.getModel().setValue("suitorg", null, rowIndex);
                        return;
                    }
                    continue block49;
                }
            }
        }
    }

    private void setDiscountRateScale(Object newValue) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt("priceprecision");
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("billentry", "setColEditorProp", new Object[]{"discountrate", "sc", priceRecision});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        IDataModel bill;
        DynamicObject org;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities.length > 0 && "billentry".equals(entryName) && !CommonUtils.isNull((Object)(org = (DynamicObject)(bill = this.getModel()).getValue("org")))) {
            this.begin();
            int[] selRows = new int[rowDataEntities.length];
            for (int i = 0; i < rowDataEntities.length; ++i) {
                RowDataEntity rowDataEntity = rowDataEntities[i];
                bill.setValue("entrypurorg", org.getPkValue(), rowDataEntity.getRowIndex());
                selRows[i] = rowDataEntity.getRowIndex();
            }
            this.end();
            Boolean isOnList = (Boolean)this.getModel().getValue("isentrysumamt");
            if (isOnList.booleanValue()) {
                this.calcTotalAmount();
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if ("billentry".equals(e.getEntryProp().getName()) && ((Boolean)this.getModel().getValue("isentrysumamt")).booleanValue()) {
            this.calcTotalAmount();
        }
    }

    private void changeSumAmt(Boolean isEntrySumAmt) {
        if (isEntrySumAmt == null || isEntrySumAmt.equals(Boolean.FALSE)) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("billentry");
        if (entry == null) {
            return;
        }
        BigDecimal totalTaxAmt = BigDecimal.ZERO;
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal totalAllAmt = BigDecimal.ZERO;
        for (DynamicObject row : entry) {
            if (row.getString("billentrychangetype") == null || ChangeTypeEnum.CANCEL.getValue().equals(row.getString("billentrychangetype"))) continue;
            totalTaxAmt = totalTaxAmt.add(row.getBigDecimal("taxamount"));
            totalAmt = totalAmt.add(row.getBigDecimal("amount"));
            totalAllAmt = totalAllAmt.add(row.getBigDecimal("amountandtax"));
        }
        this.begin();
        this.getModel().setValue("totaltaxamount", (Object)totalTaxAmt);
        this.getModel().setValue("totalamount", (Object)totalAmt);
        this.end();
        this.getModel().setValue("totalallamount", (Object)totalAllAmt);
    }

    private void changePriceForIsPresent(int rowIndex) {
        Boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
        if (isPresent.booleanValue()) {
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            BigDecimal price = BigDecimal.ZERO;
            price = isTax ? (BigDecimal)this.getModel().getValue("priceandtax", rowIndex) : (BigDecimal)this.getModel().getValue("price", rowIndex);
            this.getPageCache().put("stopChange", "true");
            if (price.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            } else {
                this.getModel().setValue("discountrate", (Object)100, rowIndex);
                this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
            }
            this.getPageCache().put("stopChange", "false");
        }
    }

    private void changeQty(BigDecimal qty, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        if (unit != null) {
            qty = PrecisionAccountHelper.dealWithprecision((IDataModel)this.getModel(), (String)"unit", (int)rowIndex, (BigDecimal)qty);
        }
        this.begin();
        model.setValue("qty", (Object)qty, rowIndex);
        this.end();
        this.getView().updateView("qty", rowIndex);
        DynamicObject baseUnit = null;
        baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
        if (baseUnit != null) {
            BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((DynamicObject)((DynamicObject)this.getMatPropValue(material, "masterid")), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            model.setValue("baseqty", (Object)baseQty, rowIndex);
        }
        this.changeAmountField(rowIndex);
    }

    private void xChangeType(ChangeData changeData) {
        IDataModel model = this.getModel();
        Boolean isOnList = (Boolean)model.getValue("isentrysumamt");
        if (!isOnList.booleanValue()) {
            return;
        }
        this.calcTotalAmount();
    }

    private void changeTotalAmount(ChangeData data) {
        IDataModel model = this.getModel();
        Boolean isOnList = (Boolean)model.getValue("isentrysumamt");
        if (!isOnList.booleanValue()) {
            return;
        }
        this.calcTotalAmount();
    }

    private void changeMaterial(DynamicObject material, int rowIndex) {
        IDataModel model = this.getModel();
        if (material == null) {
            this.begin();
            model.setValue("materialmasterid", null, rowIndex);
            model.setValue("materialname", null, rowIndex);
            model.setValue("materialversion", null, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("qty", null, rowIndex);
            model.setValue("price", null, rowIndex);
            model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            model.setValue("discountrate", null, rowIndex);
            model.setValue("discountamount", null, rowIndex);
            model.setValue("baseqty", null, rowIndex);
            model.setValue("baseunit", null, rowIndex);
            model.setValue("auxqty", null, rowIndex);
            model.setValue("auxunit", null, rowIndex);
            model.setValue("auxpty", null, rowIndex);
            model.setValue("curamount", null, rowIndex);
            model.setValue("curamountandtax", null, rowIndex);
            model.setValue("curtaxamount", null, rowIndex);
            model.setValue("taxamount", null, rowIndex);
            model.setValue("amount", null, rowIndex);
            model.setValue("amountandtax", null, rowIndex);
            model.setValue("priceandtax", null, rowIndex);
            model.setValue("entrycomment", null, rowIndex);
            Boolean isOnList = (Boolean)model.getValue("isentrysumamt");
            if (isOnList.booleanValue()) {
                this.calcTotalAmount();
            }
            this.end();
            return;
        }
        this.begin();
        model.setValue("materialversion", null, rowIndex);
        DynamicObject masterid = (DynamicObject)this.getMatPropValue(material, "masterid");
        model.setValue("materialmasterid", masterid == null ? null : masterid.getPkValue(), rowIndex);
        OrmLocaleValue materialName = (OrmLocaleValue)this.getMatPropValue(material, "name");
        model.setValue("materialname", (Object)(materialName == null ? null : materialName.getLocaleValue()), rowIndex);
        DynamicObject taxRate = (DynamicObject)this.getMatPropValue(material, "taxrate");
        if (taxRate != null) {
            model.setValue("taxrateid", taxRate.getPkValue(), rowIndex);
            if (taxRate != null && taxRate.getDynamicObjectType().getProperty("taxrate") == null) {
                taxRate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate", (QFilter[])new QFilter[]{new QFilter("id", "=", taxRate.getPkValue())});
            }
            Object taxRateTxt = taxRate.get("taxrate");
            model.setValue("taxrate", taxRateTxt, rowIndex);
        } else {
            model.setValue("taxrate", null, rowIndex);
            model.setValue("taxrateid", null, rowIndex);
        }
        DynamicObject baseunit = (DynamicObject)this.getMatPropValue(material, "baseunit");
        model.setValue("baseunit", baseunit == null ? null : baseunit.getPkValue(), rowIndex);
        DynamicObject auxunit = (DynamicObject)this.getMatPropValue(material, "auxptyunit");
        model.setValue("auxunit", auxunit == null ? null : auxunit.getPkValue(), rowIndex);
        model.setValue("entrycomment", null, rowIndex);
        model.setValue("qty", null, rowIndex);
        model.setValue("baseqty", null, rowIndex);
        model.setValue("auxqty", null, rowIndex);
        model.setValue("price", null, rowIndex);
        model.setValue("priceandtax", null, rowIndex);
        model.setValue("ispresent", (Object)Boolean.FALSE, rowIndex);
        model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
        model.setValue("discountrate", null, rowIndex);
        model.setValue("discountamount", null, rowIndex);
        model.setValue("curamount", null, rowIndex);
        model.setValue("curamountandtax", null, rowIndex);
        model.setValue("curtaxamount", null, rowIndex);
        model.setValue("taxamount", null, rowIndex);
        model.setValue("amount", null, rowIndex);
        model.setValue("amountandtax", null, rowIndex);
        Boolean isOnList = (Boolean)model.getValue("isentrysumamt");
        if (isOnList.booleanValue()) {
            this.calcTotalAmount();
        }
        this.end();
    }

    private Object getMatPropValue(DynamicObject material, String key) {
        if (material == null) {
            return null;
        }
        String tyepName = material.getDataEntityType().getName();
        if ("masterid".equals(key)) {
            return "bd_material".equals(tyepName) ? material : material.get("masterid");
        }
        return "bd_material".equals(tyepName) ? material.get(key) : material.get("masterid." + key);
    }

    private void changeTaxRateID(DynamicObject taxRateID, int rowIndex) {
        IDataModel model = this.getModel();
        if (taxRateID != null) {
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
    }

    private void changeExChangeRate(Object newValue) {
        BigDecimal exChangeRate = newValue == null ? BigDecimal.ZERO : (BigDecimal)newValue;
        int currencyPrecision = 10;
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            currencyPrecision = currency.getInt("amtprecision");
        }
        boolean isTax = bill.getBoolean("istax");
        DynamicObjectCollection entryRows = bill.getDynamicObjectCollection("billentry");
        BigDecimal curAmountAndTax = BigDecimal.ZERO;
        BigDecimal curAmount = BigDecimal.ZERO;
        BigDecimal curTaxAmout = BigDecimal.ZERO;
        String exchangetype = (String)this.getModel().getValue("exchangetype");
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject row = (DynamicObject)entryRows.get(i);
            BigDecimal amount = row.getBigDecimal("amount");
            BigDecimal taxAmount = row.getBigDecimal("taxamount");
            BigDecimal amountAndTax = row.getBigDecimal("amountandtax");
            curTaxAmout = AmountHelper.getCurAmountByRate((BigDecimal)taxAmount, (BigDecimal)exChangeRate, (int)currencyPrecision, (String)exchangetype);
            if (isTax) {
                curAmountAndTax = AmountHelper.getCurAmountByRate((BigDecimal)amountAndTax, (BigDecimal)exChangeRate, (int)currencyPrecision, (String)exchangetype);
                curAmount = curAmountAndTax.subtract(curTaxAmout);
            } else {
                curAmount = AmountHelper.getCurAmountByRate((BigDecimal)amount, (BigDecimal)exChangeRate, (int)currencyPrecision, (String)exchangetype);
                curAmountAndTax = curAmount.add(curTaxAmout);
            }
            row.set("curamount", (Object)curAmount);
            row.set("curtaxamount", (Object)curTaxAmout);
            row.set("curamountandtax", (Object)curAmountAndTax);
        }
        this.getView().updateView("billentry");
    }

    private void changeAmountField(int rowIndex) {
        this.changeAmountField(rowIndex, Boolean.FALSE);
    }

    private void changeAmountField(int rowIndex, Boolean isCalDiscountRate) {
        IDataModel model = this.getModel();
        AmountHelper.setAmount((IDataModel)model, (int)rowIndex, (Boolean)isCalDiscountRate);
        this.getView().updateView("price", rowIndex);
        this.getView().updateView("priceandtax", rowIndex);
        this.getView().updateView("discountrate", rowIndex);
        this.getView().updateView("discountamount", rowIndex);
    }

    private void changeDiscountType(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate != null && DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            double rate = discountRate.doubleValue();
            if (rate > 100.0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"MatContractTplPlugin_1", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (discountRate != null && (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType))) {
            if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            }
            double amount = discountRate.doubleValue();
            boolean isTax = (Boolean)model.getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (amount > priceAndTax.doubleValue()) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"MatContractTplPlugin_2", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"MatContractTplPlugin_8", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (amount > price.doubleValue()) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"MatContractTplPlugin_3", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"MatContractTplPlugin_9", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    }
                    return;
                }
            }
        } else {
            model.setValue("discountrate", null, rowIndex);
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
        }
    }

    private void changeDiscountAmount(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex);
            discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
            BigDecimal amountAndTax = BigDecimal.ZERO;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (qty != null && priceAndTax != null) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                }
            } else {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (qty != null && price != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    if (taxRate == null) {
                        taxRate = BigDecimal.ZERO;
                    }
                    amountAndTax = qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")))).setScale(settleAmtPrecision, 4);
                }
            }
            if (discountAmount.compareTo(amountAndTax) > 0) {
                model.setValue(fieldName, oldValue, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u6298\u6263\u989d\u4e0d\u80fd\u5927\u4e8e\u201c\u6570\u91cf\u201d\u4e58\u4ee5\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"MatContractTplPlugin_10", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean isCanChangeAmount(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        Object discountType = model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        if (discountRate != null && (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType))) {
            boolean isTax = (Boolean)model.getValue("istax");
            boolean ispresent = (Boolean)model.getValue("ispresent", rowIndex);
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (!ispresent && priceAndTax.doubleValue() < discountRate.doubleValue()) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263(\u7387)\u3002", (String)"MatContractTplPlugin_6", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263(\u7387)\u3002", (String)"MatContractTplPlugin_11", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    }
                    return false;
                }
            } else {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                if (!ispresent && price.doubleValue() < discountRate.doubleValue()) {
                    model.setValue(fieldName, oldValue, rowIndex);
                    if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263(\u7387)\u3002", (String)"MatContractTplPlugin_7", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u5355\u4f4d\u6298\u6263(\u7387)\u3002", (String)"MatContractTplPlugin_12", (String)"scmc-conm-formplugin", (Object[])new Object[0]));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private void changeSettleCur(DynamicObject oldSettleCur, DynamicObject newSettleCur) {
        if (oldSettleCur != null && newSettleCur != null && (oldSettleCur.getInt("amtprecision") != newSettleCur.getInt("amtprecision") || oldSettleCur.getInt("priceprecision") != newSettleCur.getInt("priceprecision"))) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.changeAmountField(i);
            }
        }
        AmountHelper.getAmountPlan((IFormView)this.getView());
    }

    private void changeIsNotTax(Object newValue) {
        boolean isTax = (Boolean)newValue;
        if (isTax) {
            return;
        }
        IDataModel model = this.getModel();
        int rows = model.getEntryRowCount("billentry");
        if (rows > 0) {
            StringBuilder incorrectRowIndexs = new StringBuilder();
            for (int i = 0; i < rows; ++i) {
                BigDecimal price;
                double amount;
                String discountType = (String)model.getValue("discounttype", i);
                BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", i);
                if (discountRate == null || !DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && !DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) || !((amount = discountRate.doubleValue()) > (price = (BigDecimal)model.getValue("price", i)).doubleValue())) continue;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    model.setValue("discountrate", null, i);
                } else {
                    model.setValue("discountamount", null, i);
                }
                incorrectRowIndexs.append(i + 1).append(',');
            }
            if (incorrectRowIndexs != null && incorrectRowIndexs.length() > 0) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u884c\u201c%s\u201d\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u5f53\u524d\u6298\u6263\u65b9\u5f0f\u4e0b\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"MatContractTplPlugin_4", (String)"scmc-conm-formplugin", (Object[])new Object[0]), incorrectRowIndexs.substring(0, incorrectRowIndexs.length() - 1));
                this.getView().showTipNotification(errorMsg);
                return;
            }
        }
    }

    private void changeIsTax(Object newValue) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            boolean isPrensent = (Boolean)model.getValue("ispresent");
            if (isPrensent) continue;
            this.changeAmountField(i);
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue == null) {
            return;
        }
        boolean isPresent = (Boolean)newValue;
        if (!isPresent) {
            model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("discounttype", (Object)"NULL", rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
        } else {
            this.changeAmountField(rowIndex);
        }
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true), (String)"billentrychangetype").entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void begin() {
        this.getPageCache().put("ppcvar", "false");
    }

    private void end() {
        this.getPageCache().put("ppcvar", "true");
    }

    private void excCtrlMustInput(Object newValue) {
        if (newValue != null) {
            String contCtrl = ((DynamicObject)newValue).getString("excutecontrol");
            AmountEdit amountEdit = (AmountEdit)this.getControl("totalallamount");
            QtyEdit qtyEdit = (QtyEdit)this.getControl("qty");
            AmountEdit priceEdit = (AmountEdit)this.getControl("price");
            if (ExcuteControlEnum.AMOUNT.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(true);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(false);
            }
            if (ExcuteControlEnum.QTY.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(true);
                priceEdit.setMustInput(false);
            }
            if (ExcuteControlEnum.PRICE.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(true);
            }
            if (ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(true);
                qtyEdit.setMustInput(true);
                priceEdit.setMustInput(false);
            }
            if (ExcuteControlEnum.AMOUNT_PRICE.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(true);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(true);
            }
            if (ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(true);
                qtyEdit.setMustInput(true);
                priceEdit.setMustInput(true);
            }
            if (ExcuteControlEnum.NOCONTROL.getValue().equals(contCtrl)) {
                amountEdit.setMustInput(false);
                qtyEdit.setMustInput(false);
                priceEdit.setMustInput(false);
            }
        }
    }
}

