/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.wb;

import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SrcContract2PurContractWbPlugin
extends AbstractWriteBackPlugIn {
    private static Log log = LogFactory.getLog(SrcContract2PurContractWbPlugin.class);

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        if ("src_contract".equals(e.getSrcMainType().getName())) {
            e.getFieldKeys().add("billstatus");
            e.getFieldKeys().add("auditor");
            e.getFieldKeys().add("auditdate");
            e.getFieldKeys().add("currentnode");
            e.getFieldKeys().add("source");
            e.getFieldKeys().add("bizstatus");
            e.getFieldKeys().add("entrymainflow.biznode");
            e.getFieldKeys().add("entrymainflow.bizobject");
            e.getFieldKeys().add("entrymainflow.extobject");
            e.getFieldKeys().add("entrymainflow.isflowchart");
            e.getFieldKeys().add("entrymainflow.flowbillstatus");
            e.getFieldKeys().add("entrymainflow.flowbizstatus");
            e.getFieldKeys().add("entrymainflow.subbiznode");
            e.getFieldKeys().add("entrysubflow.subisaudit");
            e.getFieldKeys().add("entrysubflow.subbizobject");
            e.getFieldKeys().add("entrysubflow.subextobject");
            e.getFieldKeys().add("entrysubflow.subisflowchart");
            e.getFieldKeys().add("entrysubflow.subflowbillstatus");
            e.getFieldKeys().add("entrysubflow.subflowbizstatus");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        String opType;
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        if ("src_contract".equals(srcSubMainType.getName()) && ("Delete".equals(opType = this.getOpType()) || "Draft".equals(opType))) {
            DynamicObject[] srcDataEntities;
            for (DynamicObject srcDataEntity : srcDataEntities = e.getSrcDataEntities()) {
                String operationKey;
                String bizStatus = srcDataEntity.getString("bizstatus");
                String billStatus = srcDataEntity.getString("billstatus");
                if ("C".equals(bizStatus) && !"C".equals(billStatus)) {
                    operationKey = "audit";
                    srcDataEntity.set("billstatus", (Object)"C");
                    srcDataEntity.set("auditor", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    srcDataEntity.set("auditdate", (Object)TimeServiceHelper.now());
                    this.backWriteSourceBill(srcDataEntity, operationKey);
                    continue;
                }
                if (!"B".equals(bizStatus) || "A".equals(billStatus)) continue;
                operationKey = "unaudit";
                srcDataEntity.set("billstatus", (Object)"A");
                srcDataEntity.set("auditor", (Object)0L);
                srcDataEntity.set("auditdate", null);
                this.backWriteSourceBill(srcDataEntity, operationKey);
            }
            SaveServiceHelper.save((DynamicObject[])srcDataEntities);
        }
    }

    private void backWriteSourceBill(DynamicObject srcDataEntity, String operationKey) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"src", (String)"SrcContractBillService", (String)"executeOperate", (Object[])new Object[]{srcDataEntity, operationKey});
        if (CollectionUtils.isEmpty((Map)result)) {
            log.error("\u3010\u7b7e\u7ea6\u751f\u6210\u5408\u540c\u56de\u5199\u3011 -> \u8c03\u7528\u5fae\u670d\u52a1\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            return;
        }
        srcDataEntity.set("currentnode", result.get("currNodeId"));
        DynamicObject currNode = (DynamicObject)result.get("currNode");
        DynamicObjectCollection rows = srcDataEntity.getDynamicObjectCollection("entrymainflow");
        for (DynamicObject row : rows) {
            if (!Objects.equals(row.getPkValue(), currNode.getPkValue())) continue;
            row.set("flowbizstatus", currNode.get("flowbizstatus"));
            row.set("flowbillstatus", currNode.get("flowbillstatus"));
            break;
        }
    }
}

