/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.blockchain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.conm.business.helper.AppParameterHelper;

public class BlockChainConditionServiceImpl {
    private static final Log log = LogFactory.getLog(BlockChainConditionServiceImpl.class);

    public List<DynamicObject> query(Long mappingPkId, Long lastStcTime, String billNo) {
        long start = System.currentTimeMillis();
        log.info("\u4e0a\u94fe\u6761\u4ef6\u63d2\u4ef6\u89e6\u53d1\u67e5\u8be2\uff1amappingPkId:" + mappingPkId + ",lastStcTime:" + lastStcTime + ",billno:" + billNo);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObject beaMapping = BusinessDataServiceHelper.loadSingleFromCache((String)"bea_mapping", (QFilter[])new QFilter("id", "=", (Object)mappingPkId).toArray());
        if (beaMapping == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u7684\u4e1a\u52a1\u5173\u8054\uff01" + mappingPkId);
            return list;
        }
        DynamicObject datatype = beaMapping.getDynamicObject("datatype");
        if (datatype == null) {
            log.error("\u4e1a\u52a1\u5173\u8054\u7684\u5b58\u8bc1\u5b9e\u4f53\u4e3a\u7a7a\uff01" + mappingPkId);
            return list;
        }
        String formId = beaMapping.getString("bizmodel.number");
        String fields = BlockChainConditionServiceImpl.constructSelectProp(beaMapping);
        String eventType = "";
        if (StringUtils.isNotEmpty((CharSequence)billNo)) {
            eventType = "event";
            QFilter billno = new QFilter("billno", "=", (Object)billNo);
            boolean flag = true;
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)formId, (String)fields, (QFilter[])billno.toArray());
            if ("conm_purcontract".equals(formId) || "conm_purendagrt".equals(formId) || "conm_pursupagrt".equals(formId)) {
                Object parameter = AppParameterHelper.getConmAppParameter((String)"15", (Long)((Long)bill.getDynamicObject("org").getPkValue()));
                flag = (Boolean)parameter.get("fupchainctrl");
            }
            if (flag) {
                list.add(bill);
            }
        } else {
            eventType = "event";
            String mappingId = String.valueOf(beaMapping.getPkValue());
            QFilter modifytimeFilter = new QFilter("modifytime", ">=", (Object)new Date(lastStcTime));
            DynamicObject[] bills = null;
            switch (mappingId) {
                case "1239865276254655488": {
                    bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)fields, (QFilter[])new QFilter("billstatus", "=", (Object)"C").and(new QFilter("auditdate", ">=", (Object)new Date(lastStcTime))).toArray());
                    break;
                }
                case "1239876835412545536": {
                    bills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)fields, (QFilter[])modifytimeFilter.copy().and(new QFilter("billstatus", "=", (Object)"D")).toArray());
                    break;
                }
                case "1240409424007270400": {
                    bills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)fields, (QFilter[])modifytimeFilter.copy().and(new QFilter("billstatus", "in", (Object)new String[]{"F", "I"})).toArray());
                }
            }
            if (bills != null && bills.length > 0) {
                list.addAll(Arrays.asList(bills));
            }
        }
        log.info("\u6570\u636e\u626b\u63cf\u7ed3\u679c\uff1a" + list.size());
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject bill : list) {
            boolean exists;
            String entryField = "";
            String cField = "";
            switch (formId) {
                case "conm_purcontract": 
                case "conm_purendagrt": 
                case "conm_pursupagrt": {
                    result.add(bill);
                    break;
                }
                case "pm_purorderbill": {
                    entryField = "billentry";
                    cField = "conbillnumber";
                    break;
                }
                case "ap_finapbill": {
                    entryField = "detailentry";
                    cField = "e_contract";
                    break;
                }
                case "cas_paybill": {
                    entryField = "entry";
                    cField = "contractnumber";
                }
            }
            if ("conm_purcontract".equals(formId) || "conm_purendagrt".equals(formId) || "conm_pursupagrt".equals(formId) || !StringUtils.isNotEmpty((CharSequence)entryField) || !StringUtils.isNotEmpty((CharSequence)cField)) continue;
            DynamicObjectCollection collection = bill.getDynamicObjectCollection(entryField);
            HashSet<String> conmNos = new HashSet<String>();
            for (DynamicObject entry : collection) {
                String conmNo = entry.getString(cField);
                if (!StringUtils.isNotEmpty((CharSequence)conmNo)) continue;
                conmNos.add(conmNo);
            }
            if (conmNos.size() == 0 || !(exists = QueryServiceHelper.exists((String)"bea_stc_log", (QFilter[])new QFilter[]{new QFilter("bizbillno", "in", conmNos), new QFilter("bizobjno", "=", (Object)"conm_purcontract"), new QFilter("status", "=", (Object)"A")}))) continue;
            result.add(bill);
        }
        long end = System.currentTimeMillis();
        log.info("\u4e0a\u94fe\u6761\u4ef6\u63d2\u4ef6\u89e6\u53d1\u67e5\u8be2\u7ed3\u675f,\u603b\u8017\u65f6\uff1a" + (end - start) + "ms");
        return result;
    }

    public static String constructSelectProp(DynamicObject beaMapping) {
        DynamicObjectCollection mapping_entry = beaMapping.getDynamicObjectCollection("mapping_entry");
        List fieldNames = mapping_entry.stream().map(e -> Arrays.asList(e.getString("bizname").split(","))).flatMap(Collection::stream).filter(e -> StringUtils.isNotEmpty((CharSequence)e) && !"signattachment".equals(e)).collect(Collectors.toList());
        List extraFieldNames = fieldNames.stream().map(BlockChainConditionServiceImpl::extraEntrySelectProp).filter(Objects::nonNull).collect(Collectors.toList());
        return Stream.of(Stream.of("billno"), fieldNames.stream(), extraFieldNames.stream()).flatMap(i -> i).map(BlockChainConditionServiceImpl::transformEntryFieldName).distinct().collect(Collectors.joining(","));
    }

    private static String extraEntrySelectProp(String fieldName) {
        String[] nameSlices = fieldName.split("\\.");
        int index = -1;
        for (int i = 0; i < nameSlices.length; ++i) {
            if (!nameSlices[i].contains("[") || !nameSlices[i].contains("]")) continue;
            index = i;
            break;
        }
        if (index > -1) {
            CharSequence[] elements = Arrays.copyOf(nameSlices, index + 2);
            return String.join((CharSequence)".", elements);
        }
        return null;
    }

    private static String transformEntryFieldName(String name) {
        return name.replaceAll("[\\[\\] ]", "");
    }
}

