/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.cooperate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.conm.business.service.cooperate.impl.CooperateServiceExecutor;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;
import kd.scmc.conm.enums.BizConfirmStatusEnum;
import kd.scmc.conm.mservice.api.cooperate.ICooperateDataService;

public class SupplierDataServiceImpl
implements ICooperateDataService {
    private static final String entryEntity = "attachmententry";
    private static final String attachmentField = "attachment";
    private static final String sourceEntryIdField = "mappingid";
    private static final HashSet<String> entitySet = new HashSet(10);
    private static final HashMap<String, String> operateMap = new HashMap(10);

    public void cooperate(String entity, String billNo, String opType, Long operator) {
        CooperateResponse response;
        DynamicObject xbill;
        if ("conm_xpurcontract".equalsIgnoreCase(entity) && "bizvalid".equalsIgnoreCase(opType) && (xbill = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (QFilter[])new QFilter[]{new QFilter("changebillno", "=", (Object)billNo)})) != null && (response = CooperateServiceExecutor.sync(Collections.singletonList(xbill), (String)entity, (String)"xbizvalid", (Long)operator, (Date)xbill.getDate("validdate"))) != null && !response.isSuccess().booleanValue()) {
            throw new KDBizException(response.getMsg());
        }
    }

    public void fileSync(String entity, Object pkId, String opType, Long operator, Date time, List<Map<String, Object>> fileInfos) {
        DynamicObject bill;
        if (entitySet.contains(entity) && (bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entity)) != null && "attachSync".equals(opType)) {
            this.attachSync(bill, fileInfos);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
    }

    public void operateInfoSync(String entityName, Object[] pkArray, String opType, Long operator, Date time) {
        MainEntityType type;
        Object[] bills;
        if (entitySet.contains(entityName) && !ObjectUtils.isEmpty((Object[])(bills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)(type = MetadataServiceHelper.getDataEntityType((String)entityName)))))) {
            String confirmStatus = operateMap.get(opType);
            if (confirmStatus != null) {
                for (Object bill : bills) {
                    bill.set("confirmstatus", (Object)confirmStatus);
                    if (BizConfirmStatusEnum.UNCONFIRM.getValue().equals(confirmStatus)) {
                        bill.set("confirmer", null);
                        bill.set("confirmdate", null);
                        continue;
                    }
                    bill.set("confirmer", (Object)operator);
                    bill.set("confirmdate", (Object)time);
                }
            }
            SaveServiceHelper.update((DynamicObject[])bills);
        }
    }

    private void attachSync(DynamicObject bill, List<Map<String, Object>> fileInfos) {
        DynamicObjectCollection attachEntry = bill.getDynamicObjectCollection(entryEntity);
        ArrayList<Object> sourceEntryIds = new ArrayList<Object>();
        if (fileInfos != null) {
            for (Map<String, Object> fileInfo : fileInfos) {
                String position = (String)fileInfo.get("position");
                if (!attachmentField.equals(position)) continue;
                Set attachIds = (Set)fileInfo.get("attachIds");
                Object entryId = fileInfo.get("mappingId");
                sourceEntryIds.add(entryId);
                boolean hasEntry = false;
                for (DynamicObject entry2 : attachEntry) {
                    Object sourceEntryId = entry2.get(sourceEntryIdField);
                    String attachSource = entry2.getString("attachsource");
                    if (sourceEntryId == null || !"B".equals(attachSource) || !sourceEntryId.equals(entryId)) continue;
                    hasEntry = true;
                    if (attachIds != null && attachIds.size() > 0) {
                        DynamicObjectCollection attachments = entry2.getDynamicObjectCollection(attachmentField);
                        for (Object attachId : attachIds) {
                            boolean hasAttach = false;
                            Iterator iterator = attachments.iterator();
                            while (iterator.hasNext()) {
                                DynamicObject attachment = (DynamicObject)iterator.next();
                                DynamicObject baseDataId = attachment.getDynamicObject("fbasedataid");
                                Object pkValue = baseDataId.getPkValue();
                                if (!attachIds.contains(pkValue)) {
                                    iterator.remove();
                                    continue;
                                }
                                if (!attachId.equals(pkValue)) continue;
                                hasAttach = true;
                            }
                            if (hasAttach) continue;
                            DynamicObject newFile = attachments.addNew();
                            newFile.set("fbasedataid", attachId);
                        }
                    } else {
                        entry2.set(attachmentField, null);
                    }
                    this.setEntryOtherField(entry2, fileInfo);
                }
                if (hasEntry) continue;
                DynamicObject entry3 = attachEntry.addNew();
                entry3.set("seq", (Object)(attachEntry.size() + 1));
                DynamicObjectCollection attachment = entry3.getDynamicObjectCollection(attachmentField);
                for (Object fileId : attachIds) {
                    DynamicObject newFile = attachment.addNew();
                    newFile.set("fbasedataid", fileId);
                }
                this.setEntryOtherField(entry3, fileInfo);
            }
        }
        attachEntry.removeIf(entry -> {
            Object sourceEntryId = entry.get(sourceEntryIdField);
            String attachsource = entry.getString("attachsource");
            return sourceEntryId != null && "B".equals(attachsource) && !sourceEntryIds.contains(sourceEntryId);
        });
    }

    private void setEntryOtherField(DynamicObject entry, Map<String, Object> fileInfo) {
        entry.set("attachname", fileInfo.get("attachName"));
        entry.set("attachsource", (Object)"B");
        entry.set("uploader", fileInfo.get("uploader"));
        entry.set("isconsultrecord", fileInfo.get("isconsult"));
        entry.set("attachcomment", fileInfo.get("remark"));
        entry.set("uploadtime", fileInfo.get("uploadTime"));
        entry.set(sourceEntryIdField, fileInfo.get("mappingId"));
    }

    static {
        entitySet.add("conm_purcontract");
        entitySet.add("conm_xpurcontract");
        entitySet.add("conm_pursupagrt");
        entitySet.add("conm_purendagrt");
        operateMap.put("unconfirm", "A");
        operateMap.put("confirm", "B");
        operateMap.put("reject", "C");
        operateMap.put("consult", "D");
    }
}

