/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.elecsign;

import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.HttpClientHelper;
import kd.scmc.conm.business.service.cooperate.impl.CooperateServiceExecutor;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;
import kd.scmc.conm.mservice.api.elecsign.IElectronicSignNotifyService;

public class ElectronicSignNotifyService
implements IElectronicSignNotifyService {
    private static Log logger = LogFactory.getLog(ElectronicSignNotifyService.class);

    public void notify(Map<String, Object> argMap) {
        logger.info("\u56de\u8c03\u5408\u540c\u7ba1\u7406\u6210\u529f");
        Boolean isSuccess = (Boolean)argMap.get("isSuccess");
        String contractNo = (String)argMap.get("contractNo");
        String formId = (String)argMap.get("formId");
        DynamicObject signer = (DynamicObject)argMap.get("signer");
        Long time = Long.valueOf((String)argMap.get("createTime"));
        Date createTime = new Date(time);
        String remoteFileUrl = (String)argMap.get("fileUrl");
        logger.info("\u56de\u8c03\u53c2\u6570\uff1a" + isSuccess + ",billNo:" + contractNo + ",formId:" + formId + ",remoteUrl:" + remoteFileUrl + ",createDate:" + argMap.get("createTime"));
        if (isSuccess.booleanValue() && StringUtils.isNotEmpty((String)contractNo) && StringUtils.isNotEmpty((String)formId)) {
            boolean isSuppcolla;
            QFilter billnoFilter = new QFilter("billno", "=", (Object)contractNo);
            DynamicObject contract = BusinessDataServiceHelper.loadSingleFromCache((String)formId, (QFilter[])new QFilter[]{billnoFilter});
            if (contract == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"ElectronicSignNotifyService_0", (String)"scmc-conm-mservice", (Object[])new Object[0]));
            }
            logger.info("\u5f00\u59cb\u66f4\u65b0\u7b7e\u7ae0\u72b6\u6001");
            this.updateSignStatus(contract, signer, createTime);
            String signstatus = contract.getString("signstatus");
            if (("conm_purcontract".equals(formId) || "conm_pursupagrt".equals(formId) || "conm_purendagrt".equals(formId)) && (isSuppcolla = contract.getBoolean("supplier.issuppcolla"))) {
                String subfix = "";
                if ("E".equalsIgnoreCase(signstatus)) {
                    subfix = "parta";
                } else if ("D".equalsIgnoreCase(signstatus)) {
                    subfix = "partb";
                } else if ("B".equalsIgnoreCase(signstatus)) {
                    subfix = "finish";
                }
                if (StringUtils.isNotEmpty((String)subfix)) {
                    logger.info("\u5f00\u59cb\u8c03\u7528\u534f\u540c\u5fae\u670d\u52a1\uff0cformId:" + formId + ",\u7f16\u53f7\uff1a" + contractNo + ",optype:sign-" + subfix);
                    CooperateResponse response = CooperateServiceExecutor.sync(Collections.singletonList(contract), (String)formId, (String)("sign-" + subfix), (Long)RequestContext.get().getCurrUserId(), (Date)createTime);
                    if (response != null && !response.isSuccess().booleanValue()) {
                        throw new KDBizException(response.getMsg());
                    }
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u56de\u8c03\u5408\u540c\u7ba1\u7406\u53c2\u6570\u7f3a\u5931\u3002", (String)"ElectronicSignNotifyService_2", (String)"scmc-conm-mservice", (Object[])new Object[0]));
        }
    }

    private void updateSignStatus(DynamicObject contract, DynamicObject signer, Date createTime) {
        String signStatus;
        String role = signer.getDataEntityType().getName();
        String entity = contract.getDynamicObjectType().getName();
        switch (signStatus = contract.getString("signstatus")) {
            case "F": {
                if (this.isPur(entity)) {
                    if ("bos_org".equals(role)) {
                        signStatus = "E";
                        break;
                    }
                    if (!"bd_bizpartner".equals(role)) break;
                    signStatus = "D";
                    break;
                }
                if (!this.isSal(entity)) break;
                if ("bos_org".equals(role)) {
                    signStatus = "D";
                    break;
                }
                if (!"bd_bizpartner".equals(role)) break;
                signStatus = "E";
                break;
            }
            case "E": {
                if ((!this.isPur(entity) || !"bd_bizpartner".equals(role)) && (!this.isSal(entity) || !"bos_org".equals(role))) break;
                signStatus = "B";
                break;
            }
            case "D": {
                if ((!this.isPur(entity) || !"bos_org".equals(role)) && (!this.isSal(entity) || !"bd_bizpartner".equals(role))) break;
                signStatus = "B";
            }
        }
        contract.set("signstatus", (Object)signStatus);
        contract.set("signdate", (Object)createTime);
        SaveServiceHelper.update((DynamicObject)contract);
    }

    private String downloadAsTempFile(String remoteFileUrl, String fileName) {
        InputStream inputStream = HttpClientHelper.getInputStreamByWebUrl((String)remoteFileUrl);
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = fileCache.saveAsUrl(fileName, inputStream, 20000);
        tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
        return tempUrl;
    }

    private boolean isSal(String entity) {
        return "conm_salcontract".equalsIgnoreCase(entity) || "conm_salendagrt".equalsIgnoreCase(entity) || "conm_salsupagrt".equalsIgnoreCase(entity);
    }

    private boolean isPur(String entity) {
        return "conm_purcontract".equalsIgnoreCase(entity) || "conm_purendagrt".equalsIgnoreCase(entity) || "conm_pursupagrt".equalsIgnoreCase(entity);
    }
}

