/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPools;

public class PurContractRowNumUpGrade
implements IUpgradeService {
    private static final int BATCH_COUNT = 5000;
    private Log logger = LogFactory.getLog(PurContractRowNumUpGrade.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        ThreadPools.executeOnce((String)"PurContractRowNumUpGrade", () -> {
            this.updatePurContract();
            this.updateXpurContract();
        });
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        return result;
    }

    public void updateXpurContract() {
        String xHeadSql = "select fid from t_conm_xpurcontract where fvalidstatus = 'A'";
        DataSet xHead = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)xHeadSql);
        String xEntrysql = "select fid, fentryid, fseq from t_conm_xpurcontractentry where frownum is null or frownum = ' '";
        DataSet xEntry = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)xEntrysql);
        DataSet xRes = xHead.leftJoin(xEntry).on("fid", "fid").select(new String[]{"fentryid", "fseq"}).finish().where("fentryid <> null");
        String xUpdateSql = "update t_conm_xpurcontractentry set frownum = ? where fentryid = ?";
        ArrayList<Object[]> xparam = new ArrayList<Object[]>(5000);
        int xRowCount = 0;
        for (Row row : xRes) {
            Long entryid = row.getLong("fentryid");
            Long fseq = row.getLong("fseq");
            if (entryid == null || entryid == 0L || fseq == null || fseq == 0L) continue;
            xparam.add(new Object[]{String.valueOf(fseq), entryid});
            if (++xRowCount % 5000 != 0) continue;
            this.doUpdate(xUpdateSql, xparam);
            xparam.clear();
        }
        if (!xparam.isEmpty()) {
            this.doUpdate(xUpdateSql, xparam);
            this.logger.info("end upgrade conm_xpurcontractentry rownum. The upgrade " + xRowCount);
        }
        xparam.clear();
        xRes.close();
    }

    public void updatePurContract() {
        this.logger.info("start upgrade t_conm_purcontractentry rownum.");
        String contSql = "select fentryid, fseq from t_conm_purcontractentry where frownum is null or frownum = ' '";
        DataSet contRes = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)contSql);
        String sql = "update t_conm_purcontractentry set frownum = ? where fentryid = ?";
        ArrayList<Object[]> param = new ArrayList<Object[]>(5000);
        int rowCount = 0;
        for (Row row : contRes) {
            Long entryid = row.getLong("fentryid");
            Long fseq = row.getLong("fseq");
            if (entryid == null || entryid == 0L || fseq == null || fseq == 0L) continue;
            param.add(new Object[]{String.valueOf(fseq), entryid});
            if (++rowCount % 5000 != 0) continue;
            this.doUpdate(sql, param);
            param.clear();
        }
        if (!param.isEmpty()) {
            this.doUpdate(sql, param);
            this.logger.info("end upgrade t_conm_purcontractentry rownum. The upgrade " + rowCount);
        }
        param.clear();
        contRes.close();
    }

    private void doUpdate(String sql, List<Object[]> param) {
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, param);
            }
            catch (Exception e) {
                h.markRollback();
                String err = "database execution failed,errorInfo" + e.getMessage();
                this.logger.info(err);
            }
        }
    }
}

