/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.blockchain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.conm.report.blockchain.helper.BlockChainRptHelper;

public class UpChainDetailRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filter = reportQueryParam.getFilter();
        String hbillno = filter.getString("hbillno");
        Map customParam = reportQueryParam.getCustomParam();
        Long settlecurrency = (Long)customParam.get("settlecurrency");
        DataSet conmValid = this.getConmValidDataSet(hbillno);
        DataSet order = this.getOrderDataSet(hbillno);
        DataSet apBill = this.getApDataSet(hbillno);
        DataSet payBill = this.getPayDataSet(hbillno);
        DataSet supartBill = this.getAgrtDataSet(hbillno, "conm_pursupagrt");
        DataSet endartBill = this.getAgrtDataSet(hbillno, "conm_purendagrt");
        DataSet union = order.union(conmValid).union(apBill).union(payBill).union(supartBill).union(endartBill);
        ArrayList<String> fields = new ArrayList<String>(Arrays.asList(union.getRowMeta().getFieldNames()));
        String currencyField = "" + settlecurrency + " as entrycurrency";
        fields.add(currencyField);
        DataSet select = union.select(fields.toArray(new String[fields.size()]));
        return select.orderBy(new String[]{"createtime"});
    }

    public DataSet getConmValidDataSet(String hbillno) {
        QFilter poFilter = new QFilter("mapping_entry.bizname", "in", (Object)new String[]{"totalamount", "totaltaxamount", "totalallamount", "biztime"});
        poFilter.and(new QFilter("bizmodel.number", "=", (Object)"conm_purcontract"));
        DataSet po_bea_mapping = QueryServiceHelper.queryDataSet((String)"aaa", (String)"bea_mapping", (String)"number,mapping_entry.bizname bizname,mapping_entry.datatype_name mname", (QFilter[])poFilter.toArray(), null);
        QFilter qFilter = new QFilter("bizobjno", "=", (Object)"conm_purcontract");
        qFilter.and(new QFilter("bizbillno", "=", (Object)hbillno));
        DataSet pobills_log = QueryServiceHelper.queryDataSet((String)"query-block-log", (String)"bea_stc_log", (String)"no,bizbillno,bizobjno,retrytimes,status,createtime,taskname,mappingno,entryentity.name as name,entryentity.type as type ,entryentity.value_tag as value", (QFilter[])qFilter.toArray(), null);
        DataSet dataSet = pobills_log.join(po_bea_mapping, JoinType.LEFT).on("mappingno", "number").on("name", "mname").select(pobills_log.getRowMeta().getFieldNames(), new String[]{"bizname"}).finish();
        if (dataSet.isEmpty()) {
            return UpChainDetailRptQuery.getEmptDataSet();
        }
        Field[] headFields = new Field[]{new Field("totalamount", "amount", (DataType)DataType.BigDecimalType, true), new Field("totaltaxamount", "taxamount", (DataType)DataType.BigDecimalType, true), new Field("totalallamount", "amountandtax", (DataType)DataType.BigDecimalType, true), new Field("biztime", "biztime", (DataType)DataType.TimestampType, true)};
        DataSet contract = BlockChainRptHelper.parseChainLog(dataSet, headFields, null);
        contract = contract.filter("status = 'A'").groupBy(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime"}).sum("amount").sum("taxamount").sum("amountandtax").finish();
        return contract;
    }

    private DataSet getOrderDataSet(String hbillno) {
        Field[] headFields = new Field[1];
        Field[] entryFields = new Field[]{new Field("billentry[ ].amount", "amount", (DataType)DataType.BigDecimalType, true), new Field("billentry[ ].taxamount", "taxamount", (DataType)DataType.BigDecimalType, true), new Field("billentry[ ].amountandtax", "amountandtax", (DataType)DataType.BigDecimalType, true), new Field("billentry[ ].conbillnumber", "conbillnumber", (DataType)DataType.StringType, true)};
        headFields[0] = new Field("biztime", "biztime", (DataType)DataType.TimestampType, true);
        DataSet orderBill = BlockChainRptHelper.queryLog("pm_purorderbill", hbillno, "billentry.conbillnumber", "billno", headFields, entryFields);
        if (orderBill.copy().isEmpty()) {
            return UpChainDetailRptQuery.getEmptDataSet();
        }
        return orderBill.filter("conbillnumber = '" + hbillno + "'").filter("status = 'A'").groupBy(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime"}).sum("amount").sum("taxamount").sum("amountandtax").finish();
    }

    private DataSet getApDataSet(String hbillno) {
        Field[] headFields = new Field[1];
        Field[] entryFields = new Field[]{new Field("detailentry[ ].e_amount", "amount", (DataType)DataType.BigDecimalType, true), new Field("detailentry[ ].e_tax", "taxamount", (DataType)DataType.BigDecimalType, true), new Field("detailentry[ ].e_pricetaxtotal", "amountandtax", (DataType)DataType.BigDecimalType, true), new Field("detailentry[ ].e_contract", "e_contract", (DataType)DataType.StringType, true)};
        headFields[0] = new Field("bizdate", "biztime", (DataType)DataType.TimestampType, true);
        DataSet apBill = BlockChainRptHelper.queryLog("ap_finapbill", hbillno, "detailentry.e_contract", "billno", headFields, entryFields);
        if (apBill.copy().isEmpty()) {
            return UpChainDetailRptQuery.getEmptDataSet();
        }
        return apBill.filter("e_contract = '" + hbillno + "'").filter("status = 'A'").groupBy(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime"}).sum("amount").sum("taxamount").sum("amountandtax").finish();
    }

    private DataSet getPayDataSet(String hbillno) {
        Field[] headFields = new Field[1];
        Field[] entryFields = new Field[]{new Field("entry[ ].e_actamt", "amount", (DataType)DataType.BigDecimalType, true), new Field("entry[ ].contractnumber", "contractnumber", (DataType)DataType.StringType, true)};
        headFields[0] = new Field("bizdate", "biztime", (DataType)DataType.TimestampType, true);
        DataSet payBill = BlockChainRptHelper.queryLog("cas_paybill", hbillno, "entry.contractnumber", "billno", headFields, entryFields);
        if (payBill.copy().isEmpty()) {
            return UpChainDetailRptQuery.getEmptDataSet();
        }
        return payBill.filter("contractnumber = '" + hbillno + "'").filter("status = 'A'").select(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime", "0 as taxamount", "amount", "amount as amountandtax"}).groupBy(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime"}).sum("amount").sum("taxamount").sum("amountandtax").finish();
    }

    private DataSet getAgrtDataSet(String hbillno, String entity) {
        Field[] fields = new Field[]{new Field("biztime", (DataType)DataType.TimestampType)};
        DataSet agrtBill = BlockChainRptHelper.queryLog(entity, hbillno, "srccontractnum", "billno", fields, null);
        agrtBill = agrtBill.filter("status = 'A'").select(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime", "0 as amount", "0 as taxamount", "0 as amountandtax"}).groupBy(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime"}).sum("amount").sum("taxamount").sum("amountandtax").finish();
        return agrtBill;
    }

    public static DataSet getEmptDataSet() {
        RowMeta rowMeta = new RowMeta(new String[]{"no", "bizbillno", "createtime", "taskname", "biztime", "amount", "taxamount", "amountandtax"}, new DataType[]{DataType.StringType, DataType.StringType, DataType.TimestampType, DataType.StringType, DataType.TimestampType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType});
        return Algo.create((String)"emptDataSet").createDataSet(new ArrayList().iterator(), rowMeta);
    }
}

