/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.blockchain;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.chart.GaugeChart;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.conm.business.pojo.SmartContractStatisticsInfo;
import kd.scmc.conm.report.blockchain.helper.UpChainOverViewHelper;

public class UpChainOverViewRptPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbar");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setDefaultValue();
        SmartContractStatisticsInfo statinfo = this.dataStatistics();
        this.setStatisticsValue(statinfo);
        this.generateStatiGauge(statinfo);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if ("refresh".equals(operationKey)) {
            Object org = this.getModel().getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"UpChainOverViewRptPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            Object startdate = this.getModel().getValue("startdate");
            Object enddate = this.getModel().getValue("enddate");
            if (startdate == null && enddate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b7e\u8ba2\u65e5\u671f\u8303\u56f4\u3002", (String)"UpChainOverViewRptPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String fieldKey = e.getItemKey();
        if ("refresh".equals(fieldKey)) {
            SmartContractStatisticsInfo statinfo = this.dataStatistics();
            this.setStatisticsValue(statinfo);
            this.generateStatiGauge(statinfo);
        }
    }

    private void setDefaultValue() {
        String formId = this.getView().getFormShowParameter().getFormId();
        Long org = UpChainOverViewHelper.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_PURCHASE.getViewType());
        this.getModel().setValue("org", (Object)org);
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            this.setdefaultDate();
        }
    }

    private void generateStatiGauge(SmartContractStatisticsInfo statinfo) {
        String unit = ResManager.loadKDString((String)"\u5355", (String)"UpChainOverViewRptPlugin_2", (String)"scmc-conm-report", (Object[])new Object[0]);
        GaugeChart changegauge = (GaugeChart)this.getControl("changegauge");
        UpChainOverViewHelper.createGaugeChart(changegauge, statinfo.getConmChangeCoChainCount() + unit, statinfo.getChangeRate());
        GaugeChart terminategauge = (GaugeChart)this.getControl("terminategauge");
        UpChainOverViewHelper.createGaugeChart(terminategauge, statinfo.getConmTerminateCoChainCount() + unit, statinfo.getTerminateRate());
        GaugeChart exceedgauge = (GaugeChart)this.getControl("exceedgauge");
        UpChainOverViewHelper.createGaugeChart(exceedgauge, statinfo.getConmExceedCCoChainCount() + unit, statinfo.getExceedRate());
    }

    private void setStatisticsValue(SmartContractStatisticsInfo statinfo) {
        this.setLabelApText("conmcochaincount", statinfo.getConmTotalCoChainCount());
        if (statinfo.getLastConmCoChainDate() == null) {
            this.setLabelApText("lastconmcochaindate", "-");
        } else {
            this.setLabelApText("lastconmcochaindate", statinfo.getLastConmCoChainDate());
        }
        this.setLabelApText("ordercochaincount", statinfo.getOrderCoChainCount());
        if (statinfo.getLastOrderCoChainDate() == null) {
            this.setLabelApText("lastordercochaindate", "-");
        } else {
            this.setLabelApText("lastordercochaindate", statinfo.getLastOrderCoChainDate());
        }
        this.setLabelApText("apcochaincount", statinfo.getApCoChainCount());
        if (statinfo.getLastApCoChainDate() == null) {
            this.setLabelApText("lastapcochaindate", "-");
        } else {
            this.setLabelApText("lastapcochaindate", statinfo.getLastApCoChainDate());
        }
        this.setLabelApText("paycochaincount", statinfo.getPayCoChainCount());
        if (statinfo.getLastPayCoChainDate() == null) {
            this.setLabelApText("lastpaycochaindate", "-");
        } else {
            this.setLabelApText("lastpaycochaindate", statinfo.getLastPayCoChainDate());
        }
        this.setLabelApText("cochaintotalcount", statinfo.getCoChainTotalCount());
        this.setLabelApText("ochaindays", statinfo.getCoChainDays());
        if (statinfo.getFirstCoChainDate() == null) {
            this.setLabelApText("firstcochaindate", "-");
        } else {
            this.setLabelApText("firstcochaindate", statinfo.getFirstCoChainDate());
        }
    }

    private void setLabelApText(String field, Object fieldValue) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Label labelAp = (Label)this.getView().getControl(field);
        if (fieldValue != null) {
            if (fieldValue instanceof Integer) {
                labelAp.setText(fieldValue.toString());
            }
            if (fieldValue instanceof Date) {
                labelAp.setText(sdf.format(fieldValue));
            }
            if (fieldValue instanceof String) {
                labelAp.setText(fieldValue.toString());
            }
        } else {
            labelAp.setText("");
        }
    }

    private SmartContractStatisticsInfo dataStatistics() {
        SmartContractStatisticsInfo statinfo = new SmartContractStatisticsInfo();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter startdateFilter = new QFilter("biztime", ">=", (Object)startdate);
        QFilter enddateFilter = new QFilter("biztime", "<=", (Object)enddate);
        DataSet purConmtract = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"billno", (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter}, null);
        DataSet endagrt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purendagrt", (String)"billno", (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter}, null);
        DataSet supagrt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_pursupagrt", (String)"billno", (QFilter[])new QFilter[]{orgFilter, startdateFilter, enddateFilter}, null);
        purConmtract = purConmtract.union(endagrt).union(supagrt);
        DataSet purConmtractOrg = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"billno", (QFilter[])new QFilter[]{orgFilter}, null);
        DataSet endagrtOrg = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purendagrt", (String)"billno", (QFilter[])new QFilter[]{orgFilter}, null);
        DataSet supagrtOrg = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"conm_pursupagrt", (String)"billno", (QFilter[])new QFilter[]{orgFilter}, null);
        purConmtractOrg = purConmtractOrg.union(endagrtOrg).union(supagrtOrg);
        DataSet purConmCochainLog = UpChainOverViewHelper.getBeaLogDataSet("conm_purcontract");
        DataSet conmTotalCochainLog = UpChainOverViewHelper.getBeaLogDataSetByList(Arrays.asList("conm_purcontract", "conm_purendagrt", "conm_pursupagrt"));
        DataSet purOrderCochainLog = UpChainOverViewHelper.getBeaLogDataSet("pm_purorderbill");
        DataSet apCochainLog = UpChainOverViewHelper.getBeaLogDataSet("ap_finapbill");
        DataSet payCochainLog = UpChainOverViewHelper.getBeaLogDataSet("cas_paybill");
        HashMap countMap = UpChainOverViewHelper.getFirstDateAndTotalCount(purConmtractOrg, conmTotalCochainLog.copy(), purOrderCochainLog.copy(), apCochainLog.copy(), payCochainLog.copy());
        if (countMap.get("fisrtCoChainDate") != null) {
            statinfo.setFirstCoChainDate((Date)countMap.get("fisrtCoChainDate"));
        }
        statinfo.setCoChainTotalCount((Integer)countMap.get("totalCochainCount"));
        DataSet purConm = purConmCochainLog.join(purConmtract.copy(), JoinType.INNER).on("bizbillno", "billno").select(new String[]{"billno", "createtime", "bizbillno", "name", "value_tag", "status", "mappingno", "bizobjno"}).finish().filter("status='A'");
        DataSet purConmBill = purConm.copy().select("billno").distinct();
        DataSet purConmCount = purConmBill.copy().groupBy().count().finish();
        DataSet toTalConm = conmTotalCochainLog.join(purConmtract.copy(), JoinType.INNER).on("bizbillno", "billno").select(new String[]{"billno", "status"}).finish().filter("status='A'").select("billno").distinct().groupBy().count().finish();
        DataSet maxDate = purConm.copy().groupBy().max("createtime", "maxDate").finish();
        if (!toTalConm.hasNext()) {
            return statinfo;
        }
        if (maxDate.hasNext()) {
            statinfo.setLastConmCoChainDate(maxDate.next().getDate("maxDate"));
        }
        if (purConmCount.hasNext()) {
            statinfo.setConmCoChainCount(purConmCount.next().getInteger("count"));
        }
        statinfo.setConmTotalCoChainCount(toTalConm.next().getInteger("count"));
        statinfo.setConmTerminateCoChainCount(UpChainOverViewHelper.getMappingCount(purConm.copy(), "terminatestatus", "value_tag='B'"));
        statinfo.setConmChangeCoChainCount(UpChainOverViewHelper.getMappingCount(purConm.copy(), "changestatus", "value_tag='C'"));
        statinfo.setConmExceedCCoChainCount(UpChainOverViewHelper.get2MappingCount(purConm.copy(), "terminatestatus", Boolean.FALSE, "biztimeend", Boolean.TRUE, "value_tag='A'", "value_tag < TO_DATE('" + UpChainOverViewHelper.getNow() + "','yyyy-MM-dd HH:mm:ss')"));
        countMap = UpChainOverViewHelper.getLastDateAndCount(purOrderCochainLog, purConmBill.copy(), "pm_purorderbill", "billentry[ ].conbillnumber");
        statinfo.setLastOrderCoChainDate((Date)countMap.get("lastCoChainDate"));
        statinfo.setOrderCoChainCount((Integer)countMap.get("cochainCount"));
        countMap = UpChainOverViewHelper.getLastDateAndCount(apCochainLog, purConmBill.copy(), "ap_finapbill", "detailentry[ ].e_contract");
        statinfo.setLastApCoChainDate((Date)countMap.get("lastCoChainDate"));
        statinfo.setApCoChainCount((Integer)countMap.get("cochainCount"));
        countMap = UpChainOverViewHelper.getLastDateAndCount(payCochainLog, purConmBill, "cas_paybill", "entry[ ].contractnumber");
        statinfo.setLastPayCoChainDate((Date)countMap.get("lastCoChainDate"));
        statinfo.setPayCoChainCount((Integer)countMap.get("cochainCount"));
        return statinfo;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("enddate", (Object)cal.getTime());
        cal.set(2, 0);
        cal.set(5, 1);
        model.setValue("startdate", (Object)cal.getTime());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getView().getFormShowParameter().getFormId();
        switch (name) {
            case "org": {
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", UpChainOverViewHelper.getHasPermissionOrgs(formId, OrgViewTypeEnum.IS_PURCHASE.getViewType())));
                break;
            }
        }
    }
}

