/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.functions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;

public class ConmExecuteCalcFunction
extends MapFunction {
    private RowMeta currentRowMeta;
    private String[] calcQtyFields;
    private String[] calcAmountFields;
    private String[] calcQtyNewFields;
    private String[] calcAmountNewFields;
    private Map<Object, DynamicObject> currencyMap;

    public ConmExecuteCalcFunction(RowMeta rowMeta, String[] calcQtyFields, String[] calcAmountFields, String[] calcQtyNewFields, String[] calcAmountNewFields, Map<Object, DynamicObject> currencyMap) {
        super.setSourceRowMeta(rowMeta);
        this.calcQtyFields = calcQtyFields;
        this.calcAmountFields = calcAmountFields;
        this.calcQtyNewFields = calcQtyNewFields;
        this.calcAmountNewFields = calcAmountNewFields;
        this.currencyMap = currencyMap;
    }

    public Object[] map(Row row) {
        int settlePrecision;
        int[] qtyIndexs = new int[this.calcQtyFields.length];
        BigDecimal[] qtyCalcs = new BigDecimal[this.calcQtyFields.length];
        int[] amountIndexs = new int[this.calcAmountFields.length];
        BigDecimal[] amountCalcs = new BigDecimal[this.calcAmountFields.length];
        boolean isReQtyCalc = false;
        boolean isReAmountCalc = false;
        boolean isNewQtyField = false;
        if (this.calcQtyNewFields != null && this.calcQtyNewFields.length > 0) {
            isNewQtyField = true;
        }
        boolean isNewAmountField = false;
        if (this.calcAmountNewFields != null && this.calcAmountNewFields.length > 0) {
            isNewAmountField = true;
        }
        Object[] qtyResult = RowUtil.toArray((Row)row);
        Object[] qtyResultTo = new Object[this.getResultRowMeta().getFieldCount()];
        System.arraycopy(qtyResult, 0, qtyResultTo, 0, qtyResult.length);
        BigDecimal baseQty = row.getBigDecimal("baseqty");
        if (baseQty == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            Integer numerator = row.getInteger("numerator");
            Integer denominator = row.getInteger("denominator");
            if (numerator != null && denominator != null && numerator > 0 && denominator > 0) {
                for (int i = 0; i < this.calcQtyFields.length; ++i) {
                    int index = this.getResultRowMeta().getFieldIndex(this.calcQtyFields[i]);
                    BigDecimal originQty = row.getBigDecimal(index);
                    if (isNewQtyField) {
                        index = qtyResult.length + i;
                    }
                    qtyIndexs[i] = index;
                    if (originQty != null) {
                        qtyCalcs[i] = originQty.multiply(BigDecimal.valueOf(numerator.intValue())).divide(BigDecimal.valueOf(denominator.intValue()), 10, 4);
                        isReQtyCalc = true;
                        continue;
                    }
                    qtyCalcs[i] = originQty;
                }
            }
        } else {
            BigDecimal qty = row.getBigDecimal("qty");
            for (int i = 0; i < this.calcQtyFields.length; ++i) {
                int index = this.getResultRowMeta().getFieldIndex(this.calcQtyFields[i]);
                BigDecimal originQty = row.getBigDecimal(index);
                if (isNewQtyField) {
                    index = qtyResult.length + i;
                }
                qtyIndexs[i] = index;
                if (originQty != null) {
                    qtyCalcs[i] = originQty.multiply(qty).divide(baseQty, 10, 4);
                    isReQtyCalc = true;
                    continue;
                }
                qtyCalcs[i] = originQty;
            }
        }
        String exchangetype = row.getString("exchangetype");
        BigDecimal exchangerate = row.getBigDecimal("exchangerate");
        Long settlecurrency = row.getLong("settlecurrency");
        int n = settlePrecision = settlecurrency != null && !settlecurrency.equals(Long.valueOf("0")) && this.currencyMap.get(settlecurrency) != null ? this.currencyMap.get(settlecurrency).getInt("amtprecision") : 10;
        if (exchangerate != null && StringUtils.isNotEmpty((String)exchangetype) && BigDecimal.ZERO.compareTo(exchangerate) != 0) {
            for (int i = 0; i < this.calcAmountFields.length; ++i) {
                int index = this.getResultRowMeta().getFieldIndex(this.calcAmountFields[i]);
                BigDecimal originAmount = row.getBigDecimal(index);
                if (isNewAmountField && isNewQtyField) {
                    index = qtyResult.length + this.calcQtyNewFields.length + i;
                } else if (isNewAmountField && !isNewQtyField) {
                    index = qtyResult.length + i;
                }
                amountIndexs[i] = index;
                if (originAmount != null) {
                    amountCalcs[i] = "1".equals(exchangetype) ? originAmount.multiply(exchangerate).setScale(settlePrecision, 4) : originAmount.divide(exchangerate, settlePrecision, 4);
                    isReAmountCalc = true;
                    continue;
                }
                amountCalcs[i] = originAmount;
            }
        }
        if (isReQtyCalc) {
            for (int j = 0; j < qtyIndexs.length; ++j) {
                qtyResultTo[qtyIndexs[j]] = qtyCalcs[j];
            }
        }
        if (isReAmountCalc) {
            for (int j = 0; j < amountIndexs.length; ++j) {
                qtyResultTo[amountIndexs[j]] = amountCalcs[j];
            }
        }
        return qtyResultTo;
    }

    public RowMeta getResultRowMeta() {
        if (this.currentRowMeta == null) {
            if (this.calcQtyNewFields != null || this.calcAmountNewFields != null) {
                RowMeta sourceRowMeta = this.getSourceRowMeta();
                ArrayList<Field> fields = new ArrayList<Field>(sourceRowMeta.getFieldCount());
                for (Field field : sourceRowMeta.getFields()) {
                    fields.add(field);
                }
                if (this.calcQtyNewFields != null) {
                    for (String string : this.calcQtyNewFields) {
                        fields.add(new Field(string, (DataType)DataType.BigDecimalType, false));
                    }
                }
                if (this.calcAmountNewFields != null) {
                    for (String string : this.calcAmountNewFields) {
                        fields.add(new Field(string, (DataType)DataType.BigDecimalType, false));
                    }
                }
                this.currentRowMeta = new RowMeta(fields.toArray(new Field[0]));
            } else {
                this.currentRowMeta = this.getSourceRowMeta();
            }
        }
        return this.currentRowMeta;
    }
}

