/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.conm.utils.CommonUtils;

public class PurContractRptHelper {
    private static final String IMPARTNER = "impartner";
    private static final String VIRIMPARTNER = "virimpartner";
    private static final String RETURNPARTNER = "returnpartner";
    private static final String VIRRETURNPARTNER = "virreturnpartner";
    private static final Log log = LogFactory.getLog(PurContractRptHelper.class);
    private static final String PURCONTRACT_ORG = "org";
    private static final String PURCONTRACT_BIZTIME = "biztime";
    private static final String PURCONTRACT_SUPPLIER = "supplier";
    private static final String PURCONTRACT_TYPE = "type";
    private static final String BILLNO = "billno";
    private static final String BILLENTRY = "billentry";

    public static String getMUConvField() {
        ArrayList<String> selectorSet = new ArrayList<String>(10);
        selectorSet.add("id");
        selectorSet.add("billentry.id as entryId");
        selectorSet.add("billentry.unit");
        selectorSet.add("billentry.baseunit");
        selectorSet.add("billentry.material.masterid.id as material");
        return String.join((CharSequence)",", selectorSet);
    }

    public static DataSet getMUConv(DataSet dataSet) {
        ArrayList<Object[]> MUConvs = new ArrayList<Object[]>();
        long startTime = System.currentTimeMillis();
        try (DataSet dataSetUnit = dataSet;){
            for (Row row : dataSetUnit) {
                DynamicObject muConv;
                int numerator = 1;
                int denominator = 1;
                Long material = row.getLong("material");
                Long unit = row.getLong("unit");
                Long baseunit = row.getLong("baseunit");
                if (!(CommonUtils.isNull((Object)material) || CommonUtils.isNull((Object)unit) || CommonUtils.isNull((Object)baseunit) || (muConv = BaseDataServiceHelper.getMUConv((Long)material, (Long)baseunit, (Long)unit)) == null)) {
                    numerator = muConv.getInt("numerator");
                    denominator = muConv.getInt("denominator");
                }
                Long id = row.getLong("id");
                Long entryId = row.getLong("entryId");
                MUConvs.add(new Object[]{id, entryId, numerator, denominator});
            }
        }
        Algo muConv = Algo.create((String)"MUConv");
        DataSetBuilder dataSetBuilder = muConv.createDataSetBuilder(PurContractRptHelper.getRowMeta());
        for (Object[] conv : MUConvs) {
            dataSetBuilder.append(conv);
        }
        long endTime = System.currentTimeMillis();
        log.info("getMUConvSize Time-consuming\uff1a" + MUConvs.size());
        log.info("getMUConv Time-consuming\uff1a" + (endTime - startTime) + "ms");
        return dataSetBuilder.build();
    }

    private static RowMeta getRowMeta() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("id", (DataType)DataType.LongType));
        fields.add(new Field("entryId", (DataType)DataType.LongType));
        fields.add(new Field("numerator", (DataType)DataType.IntegerType));
        fields.add(new Field("denominator", (DataType)DataType.IntegerType));
        return new RowMeta(fields.toArray(new Field[fields.size()]));
    }

    public static String getSelectFieldWriteBackFileds() {
        ArrayList<String> selectorSet = new ArrayList<String>(3);
        selectorSet.add("billentry.payablepriceqty as finapqty");
        selectorSet.add("billentry.payablebaseqty as finapbaseqty");
        selectorSet.add("billentry.payableamount as finapamount");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("id");
        selectorSet.add("tochar(id) as id_char");
        selectorSet.add(BILLNO);
        selectorSet.add("billname");
        selectorSet.add(PURCONTRACT_ORG);
        selectorSet.add(PURCONTRACT_SUPPLIER);
        selectorSet.add(PURCONTRACT_TYPE);
        selectorSet.add("billstatus");
        selectorSet.add(PURCONTRACT_BIZTIME);
        selectorSet.add("Month(biztime) groupkey");
        selectorSet.add("operator");
        selectorSet.add("changestatus");
        selectorSet.add("freezestatus");
        selectorSet.add("cancelstatus");
        selectorSet.add("settlecurrency");
        selectorSet.add("totalamount");
        selectorSet.add("totaltaxamount");
        selectorSet.add("totalallamount");
        selectorSet.add("exchangetype");
        selectorSet.add("exchangerate");
        selectorSet.add("billentry.id as entryId");
        selectorSet.add("tochar(billentry.id) as entryid_char");
        selectorSet.add("billentry.material.masterid.id as material");
        selectorSet.add("billentry.materialname as materialname");
        selectorSet.add("billentry.material.masterid.modelnum as model");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.baseunit as baseunit");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("billentry.baseqty as baseqty");
        selectorSet.add("billentry.price as price");
        selectorSet.add("billentry.priceandtax as priceandtax");
        selectorSet.add("billentry.amountandtax as amount");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as conmjoinorder");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as conmjoinarap");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as conmjoinbus");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as conmkey");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2orderbill(boolean isDetailReport) {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("id as orderid");
        selectorSet.add("billno as orderbillno");
        selectorSet.add("billentry.id as orderentryid");
        selectorSet.add("billentry.priceandtax as orderpriceandtax");
        selectorSet.add("billentry.baseqty as orderbaseqty");
        selectorSet.add("exchangetype as orderexchangetype");
        selectorSet.add("exchangerate as orderexchangerate");
        if (isDetailReport) {
            selectorSet.add("billentry.curamountandtax as orderamount");
        } else {
            selectorSet.add("istax as orderistax");
            selectorSet.add("currency as ordercurrency");
            selectorSet.add("settlecurrency as ordersettlecurrency");
            selectorSet.add("billentry.price as orderprice");
            selectorSet.add("billentry.qty as orderqty");
            selectorSet.add("billentry.taxrate as ordertaxrate");
            selectorSet.add("billentry.discounttype as orderdiscountType");
            selectorSet.add("billentry.discountrate as orderdiscountrate");
        }
        selectorSet.add("concat(tochar(billentry.conbillid),tochar(billentry.conbillentryid)) as orderjoinconm");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as orderjoinim");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as orderjoinreturn");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as orderjoinbus");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as orderjoinap");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as orderkey");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectFieldOrderbillWbFields4ContactRpt() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billentry.invbaseqty as invbaseqty");
        selectorSet.add("billentry.returnbaseqty as returnbaseqty");
        selectorSet.add("billentry.payablebaseqty as payablebaseqty");
        selectorSet.add("billentry.invqty as invqty");
        selectorSet.add("billentry.returnqty as returnqty");
        selectorSet.add("billentry.payablepriceqty as payableqty");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2inorderbill(boolean isVirtual) {
        ArrayList<String> selectorSet = new ArrayList<String>();
        if (!isVirtual) {
            selectorSet.add("billno as in_billno");
            selectorSet.add("supplier as " + IMPARTNER);
            selectorSet.add("billentry.baseqty as invbaseqty");
            selectorSet.add("billentry.curamountandtax as invamount");
            selectorSet.add("concat(tochar(id),tochar(billentry.id)) as imkey");
            selectorSet.add("concat(tochar(billentry.mainbillid),tochar(billentry.mainbillentryid)) as imjoinorder");
        } else {
            selectorSet.add("supplier as " + VIRIMPARTNER);
            selectorSet.add("concat(tochar(billentry.srcbillid),tochar(billentry.srcbillentryid)) as virjoinim");
        }
        selectorSet.add("id as imid");
        selectorSet.add("billentry.id as imentryid");
        selectorSet.add("billentry.logisticsbill as logisticsbill");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as imjoinarap");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as imjoinbus");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as imjoinreturn");
        selectorSet.add("tochar(id) as imid_char");
        selectorSet.add("tochar(billentry.id) as imentryid_char");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2returnorderbill(boolean isVirtual) {
        ArrayList<String> selectorSet = new ArrayList<String>();
        if (!isVirtual) {
            selectorSet.add("billno as return_billno");
            selectorSet.add("supplier as " + RETURNPARTNER);
            selectorSet.add("-1*billentry.baseqty as returnbaseqty");
            selectorSet.add("-1*billentry.curamountandtax as returnamount");
            selectorSet.add("concat(tochar(id),tochar(billentry.id)) as returnkey");
            selectorSet.add("concat(tochar(billentry.mainbillid),tochar(billentry.mainbillentryid)) as returnjoinorder");
            selectorSet.add("concat(tochar(billentry.srcbillid),tochar(billentry.srcbillentryid)) as returnjoinim");
        } else {
            selectorSet.add("supplier as " + VIRRETURNPARTNER);
            selectorSet.add("concat(tochar(billentry.srcbillid),tochar(billentry.srcbillentryid)) as returnvirjoinim");
        }
        selectorSet.add("id as returnid");
        selectorSet.add("billentry.id as returnentryid");
        selectorSet.add("billentry.logisticsbill as returnlogisticsbill");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as returnjoinarap");
        selectorSet.add("concat(tochar(id),tochar(billentry.id)) as returnjoinbus");
        selectorSet.add("tochar(billentry.id) as returnentryid_char");
        selectorSet.add("tochar(id) as returnid_char");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2Ap_Busbill() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("concat(tochar(entry.e_srcbillid),tochar(entry.e_srcentryid)) as busjoinsrc");
        selectorSet.add("concat(tochar(id),tochar(entry.id)) as busjoinarap");
        selectorSet.add("id as busid");
        selectorSet.add("entry.id as busentryid");
        selectorSet.add("concat(tochar(entry.corebillid),tochar(entry.corebillentryid)) as buscorejoinorder");
        selectorSet.add("tochar(id) as busid_char");
        selectorSet.add("tochar(entry.id) as busentryid_char");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2Ap_Finap() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("billno as finap_billno");
        selectorSet.add("detailentry.e_baseunitqty as finapbaseqty");
        selectorSet.add("detailentry.e_pricetaxtotalbase as finapamount");
        selectorSet.add("concat(tochar(id),tochar(detailentry.id)) as arapkey");
        selectorSet.add("concat(tochar(detailentry.e_sourcebillid),tochar(detailentry.e_sourcebillentryid)) as arapjoinsrc");
        selectorSet.add("concat(tochar(detailentry.corebillid),tochar(detailentry.corebillentryid)) as arapcorejoinorder");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObject contract;
        DynamicObject type;
        DynamicObjectCollection suppliers;
        Date endDate;
        Date startDate;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        if (org != null) {
            filters.add(new QFilter(PURCONTRACT_ORG, "=", org.getPkValue()));
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filters.add(new QFilter(PURCONTRACT_BIZTIME, ">=", (Object)PurContractRptHelper.getStartOrEndDate(startDate, false)));
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filters.add(new QFilter(PURCONTRACT_BIZTIME, "<=", (Object)PurContractRptHelper.getStartOrEndDate(endDate, true)));
        }
        if ((suppliers = filterInfo.getDynamicObjectCollection("supplierfield")) != null) {
            Object[] ids = suppliers.stream().map(DataEntityBase::getPkValue).toArray();
            filters.add(new QFilter(PURCONTRACT_SUPPLIER, "in", (Object)ids));
        }
        if ((type = filterInfo.getDynamicObject("typeid")) != null) {
            filters.add(new QFilter(PURCONTRACT_TYPE, "=", type.getPkValue()));
        }
        if ((contract = filterInfo.getDynamicObject("billnoid")) != null) {
            filters.add(new QFilter("id", "=", contract.getPkValue()));
        }
        return filters;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static List<QFilter> getUnitFilters(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.addAll(PurContractRptHelper.getFilters(filterInfo));
        filters.add(new QFilter("billentry.baseqty", "=", (Object)BigDecimal.ZERO));
        return filters;
    }
}

