/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.salsynthesis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.util.StringUtils;

public class ModifySumFieldFunction
extends GroupReduceFunction {
    public Map<String, Integer> indexMap;

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta rowMeta = this.getSourceRowMeta();
        Field[] fields = rowMeta.getFields();
        if (this.indexMap == null) {
            this.indexMap = new HashMap<String, Integer>(fields.length);
        }
        for (int i = 0; i < fields.length; ++i) {
            this.indexMap.put(fields[i].getName(), i);
        }
        boolean flag = this.hasField(new String[]{"linetype", "billno_c", "lineno_c", "totalamount_c", "totaltaxamount_c", "totalallamount_c", "prereceiptallamount_c", "receiptallamount_c", "qty_o", "deliqty_o", "invqty_o", "backqty_o", "joinpriceqty_c"});
        Integer linTypeIndex = this.indexMap.get("linetype");
        Iterator<RowX> iterator = iterable.iterator();
        if (flag) {
            ArrayList<Object[]> allData = new ArrayList<Object[]>();
            ArrayList<Object[]> noSumRowData = new ArrayList<Object[]>();
            while (iterator.hasNext()) {
                RowX next = iterator.next();
                Object[] objs = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object value;
                    objs[i] = value = next.get(i);
                }
                String lineType = (String)objs[linTypeIndex];
                if ("0".equals(lineType)) {
                    noSumRowData.add(objs);
                }
                allData.add(objs);
            }
            DataSet dataSet = Algo.create((String)"modifySumRow").createDataSet(noSumRowData.iterator(), this.getResultRowMeta());
            DataSet distinct = dataSet.copy().select(new String[]{"billno_c", "totalamount_c", "totaltaxamount_c", "totalallamount_c", "prereceiptallamount_c", "receiptallamount_c"}).distinct();
            DataSet headAmount = distinct.groupBy(new String[]{"billno_c"}).sum("totalamount_c").sum("totaltaxamount_c").sum("totalallamount_c").sum("prereceiptallamount_c").sum("receiptallamount_c").finish();
            HashMap headAmountMap = new HashMap(16);
            while (headAmount.hasNext()) {
                Row row = headAmount.next();
                HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
                map.put("totalamount_c", row.getBigDecimal("totalamount_c"));
                map.put("totaltaxamount_c", row.getBigDecimal("totaltaxamount_c"));
                map.put("totalallamount_c", row.getBigDecimal("totalallamount_c"));
                map.put("prereceiptallamount_c", row.getBigDecimal("prereceiptallamount_c"));
                map.put("receiptallamount_c", row.getBigDecimal("receiptallamount_c"));
                headAmountMap.put(row.getString("billno_c"), map);
            }
            HashMap<String, Map> entryAmountMap = new HashMap<String, Map>(16);
            DataSet entryApAmount = dataSet.groupBy(new String[]{"billno_c", "lineno_c"}).sum("aramount_c").finish();
            while (entryApAmount.hasNext()) {
                Row row = entryApAmount.next();
                Map map = entryAmountMap.getOrDefault(row.getString("billno_c"), new HashMap(16));
                map.put(row.getString("lineno_c"), row.getBigDecimal("aramount_c"));
                entryAmountMap.put(row.getString("billno_c"), map);
            }
            BigDecimal arAmount = BigDecimal.ZERO;
            Integer billNoIndex = this.indexMap.get("billno_c");
            Integer lineNoIndex = this.indexMap.get("lineno_c");
            Integer totalAmountIndex = this.indexMap.get("totalamount_c");
            Integer totalTaxAmountIndex = this.indexMap.get("totaltaxamount_c");
            Integer totalAllAmountIndex = this.indexMap.get("totalallamount_c");
            Integer preReceiptAllAmountIndex = this.indexMap.get("prereceiptallamount_c");
            Integer receiptAllAmountIndex = this.indexMap.get("receiptallamount_c");
            Integer arAmountIndex = this.indexMap.get("aramount_c");
            Integer qtyCIndex = this.indexMap.get("qty_o");
            Integer deliQtyIndex = this.indexMap.get("deliqty_o");
            Integer invQtyIndex = this.indexMap.get("invqty_o");
            Integer backQtyIndex = this.indexMap.get("backqty_o");
            Integer joinPriceQtyIndex = this.indexMap.get("joinpriceqty_c");
            for (Object[] row : allData) {
                Map amountMap;
                String lineType = (String)row[linTypeIndex];
                String billNo = (String)row[billNoIndex];
                Integer lineNo = (Integer)row[lineNoIndex];
                if (lineNo != null && "0".equals(lineType) && StringUtils.isNotEmpty((String)billNo)) {
                    amountMap = (Map)entryAmountMap.get(billNo);
                    BigDecimal aramount_c = (BigDecimal)amountMap.get(lineNo.toString());
                    row[arAmountIndex.intValue()] = aramount_c;
                    if (aramount_c != null) {
                        arAmount = arAmount.add(aramount_c);
                    }
                } else if ("1".equals(lineType)) {
                    amountMap = (Map)headAmountMap.get(billNo);
                    row[totalAmountIndex.intValue()] = amountMap.get("totalamount_c");
                    row[totalTaxAmountIndex.intValue()] = amountMap.get("totaltaxamount_c");
                    row[totalAllAmountIndex.intValue()] = amountMap.get("totalallamount_c");
                    row[preReceiptAllAmountIndex.intValue()] = amountMap.get("prereceiptallamount_c");
                    row[receiptAllAmountIndex.intValue()] = amountMap.get("receiptallamount_c");
                    Collection arAmounts = ((Map)entryAmountMap.get(billNo)).values();
                    BigDecimal payAmount = BigDecimal.ZERO;
                    for (BigDecimal amount : arAmounts) {
                        payAmount = payAmount.add(amount);
                    }
                    row[arAmountIndex.intValue()] = payAmount;
                    row[qtyCIndex.intValue()] = null;
                    row[deliQtyIndex.intValue()] = null;
                    row[invQtyIndex.intValue()] = null;
                    row[backQtyIndex.intValue()] = null;
                    row[joinPriceQtyIndex.intValue()] = null;
                } else if ("2".equals(lineType)) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    BigDecimal totalTaxAmount = BigDecimal.ZERO;
                    BigDecimal totalAllAmount = BigDecimal.ZERO;
                    BigDecimal preReceiptAllAmount = BigDecimal.ZERO;
                    BigDecimal receiptAllAmount = BigDecimal.ZERO;
                    for (Map amountMap2 : headAmountMap.values()) {
                        BigDecimal receiptallamount_c;
                        BigDecimal prereceiptallamount_c;
                        BigDecimal totalallamount_c;
                        BigDecimal totaltaxamount_c;
                        BigDecimal totalamount_c = (BigDecimal)amountMap2.get("totalamount_c");
                        if (totalamount_c != null) {
                            totalAmount = totalAmount.add(totalamount_c);
                        }
                        if ((totaltaxamount_c = (BigDecimal)amountMap2.get("totaltaxamount_c")) != null) {
                            totalTaxAmount = totalTaxAmount.add(totaltaxamount_c);
                        }
                        if ((totalallamount_c = (BigDecimal)amountMap2.get("totalallamount_c")) != null) {
                            totalAllAmount = totalAllAmount.add(totalallamount_c);
                        }
                        if ((prereceiptallamount_c = (BigDecimal)amountMap2.get("prereceiptallamount_c")) != null) {
                            preReceiptAllAmount = preReceiptAllAmount.add(prereceiptallamount_c);
                        }
                        if ((receiptallamount_c = (BigDecimal)amountMap2.get("receiptallamount_c")) == null) continue;
                        receiptAllAmount = receiptAllAmount.add(receiptallamount_c);
                    }
                    row[totalAmountIndex.intValue()] = totalAmount;
                    row[totalTaxAmountIndex.intValue()] = totalTaxAmount;
                    row[totalAllAmountIndex.intValue()] = totalAllAmount;
                    row[preReceiptAllAmountIndex.intValue()] = preReceiptAllAmount;
                    row[receiptAllAmountIndex.intValue()] = receiptAllAmount;
                    row[arAmountIndex.intValue()] = arAmount;
                    row[qtyCIndex.intValue()] = null;
                    row[deliQtyIndex.intValue()] = null;
                    row[invQtyIndex.intValue()] = null;
                    row[backQtyIndex.intValue()] = null;
                    row[joinPriceQtyIndex.intValue()] = null;
                }
                collector.collect(new RowX(row));
            }
            headAmountMap = null;
            entryAmountMap = null;
        } else {
            while (iterator.hasNext()) {
                RowX next = iterator.next();
                collector.collect(next);
            }
        }
    }

    private boolean hasField(String[] fields) {
        boolean flag = true;
        for (String field : fields) {
            if (this.indexMap.containsKey(field)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

