/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.report.salsynthesis;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.scmc.conm.report.helper.MultiOrganHelper;
import kd.scmc.conm.report.helper.SalContractRptHelper;
import kd.scmc.conm.utils.CommonUtils;

public class SalSynthesisReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final String HEAD_ORG = "head_org";
    private static final String SALCONTRACT_BIZTIME = "biztime";
    private static final String SALCONTRACT_CUSTOMER = "customer";
    private static final String SALCONTRACT_TYPE = "type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addRowClickListener((RowClickEventListener)this);
        EntryGrid endagrtentity = (EntryGrid)this.getControl("endagrtentry");
        endagrtentity.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid supagrtentry = (EntryGrid)this.getControl("supagrtentry");
        supagrtentry.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit customer = (MulBasedataEdit)this.getView().getControl("hcustomer");
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hbillno = (MulBasedataEdit)this.getView().getControl("hbillno");
        hbillno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit htype = (MulBasedataEdit)this.getView().getControl("htype");
        htype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hdept = (MulBasedataEdit)this.getView().getControl("hdept");
        hdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hoperatorgroup = (MulBasedataEdit)this.getView().getControl("hoperatorgroup");
        hoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hoperator = (MulBasedataEdit)this.getView().getControl("hoperator");
        hoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hmaterial = (MulBasedataEdit)this.getView().getControl("hmaterial");
        hmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit hproject = (MulBasedataEdit)this.getView().getControl("hproject");
        hproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hOrg = (BasedataEdit)this.getView().getControl(HEAD_ORG);
        hOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        Long org = SalSynthesisReportPlugin.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_SALE.getViewType());
        if (org == null) {
            Long orgId = RequestContext.get().getOrgId();
            long userID = RequestContext.get().getCurrUserId();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)this.getView().getFormShowParameter().getAppId(), (String)formId, (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                List orgList = hasPermOrgResult.getHasPermOrgs();
                if (orgList != null && orgList.size() > 0) {
                    if (orgList.contains(orgId)) {
                        this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgId});
                    } else {
                        this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgList.get(0)});
                    }
                }
            } else {
                this.getModel().setValue(HEAD_ORG, (Object)new Object[]{orgId});
            }
        } else {
            this.getModel().setValue(HEAD_ORG, (Object)new Object[]{org});
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null && enddate == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.getModel().setValue("startdate", (Object)cal.getTime());
            this.getModel().setValue("enddate", (Object)cal.getTime());
        }
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"conm_salcontract");
        this.setDisplayName(fieldNameMap, "billtype_c.number", "billtype", entityType);
        this.setDisplayName(fieldNameMap, "contparties_c.number", "contparties", entityType);
        this.setDisplayName(fieldNameMap, "conmprop_c.number", "conmprop", entityType);
        this.setDisplayName(fieldNameMap, "settlecurrency_c.number", "settlecurrency", entityType);
        this.setDisplayName(fieldNameMap, "billstatus_c", "billstatus", entityType);
        this.setDisplayName(fieldNameMap, "reviewstatus_c", "reviewstatus", entityType);
        this.setDisplayName(fieldNameMap, "signstatus_c", "signstatus", entityType);
        this.setDisplayName(fieldNameMap, "filingstatus_c", "filingstatus", entityType);
        this.setDisplayName(fieldNameMap, "changestatus_c", "changestatus", entityType);
        this.setDisplayName(fieldNameMap, "freezestatus_c", "freezestatus", entityType);
        this.setDisplayName(fieldNameMap, "cancelstatus_c", "cancelstatus", entityType);
        this.setDisplayName(fieldNameMap, "closestatus_c", "closestatus", entityType);
        this.setDisplayName(fieldNameMap, "terminatestatus_c", "terminatestatus", entityType);
        this.setDisplayName(fieldNameMap, "entryinvorg_c.number", "entryinvorg", entityType);
        this.setDisplayName(fieldNameMap, "entrysettleorg_c.number", "entrysettleorg", entityType);
        this.setDisplayName(fieldNameMap, "rowclosestatus_c", "rowclosestatus", entityType);
        this.setDisplayName(fieldNameMap, "rowterminatestatus_c", "rowterminatestatus", entityType);
        HashSet<String> removedPros = new HashSet<String>(16);
        removedPros.add("totalamount_c");
        removedPros.add("totalallamount_c");
        removedPros.add("totaltaxamount_c");
        removedPros.add("prereceiptallamount_c");
        removedPros.add("receiptallamount_c");
        removedPros.add("unit_c.name");
        removedPros.add("unit_c.number");
        removedPros.add("priceandtax_c");
        removedPros.add("qty_c");
        removedPros.add("amountandtax_c");
        removedPros.add("lineno_c");
        removedPros.add("org_c.name");
        removedPros.add("org_c.number");
        removedPros.add("biztime_c");
        removedPros.add("type_c.name");
        removedPros.add("type_c.number");
        removedPros.add("customer_c.name");
        removedPros.add("customer_c.number");
        removedPros.add("dept_c.name");
        removedPros.add("dept_c.number");
        removedPros.add("operatorgroup_c.name");
        removedPros.add("operatorgroup_c.number");
        removedPros.add("operator_c.operatorname");
        removedPros.add("operator_c.operatornumber");
        removedPros.add("billno_c");
        removedPros.add("billname_c");
        removedPros.add("material_c.name");
        removedPros.add("material_c.number");
        removedPros.add("materialname_c");
        removedPros.add("model_c");
        removedPros.add("project_c");
        removedPros.add("validstatus_c");
        removedPros.add("settlecurrency_c.amtprecision");
        removedPros.add("settlecurrency_c.priceprecision");
        removedPros.add("settlecurrency_c.sign");
        removedPros.add("settlecurrency_c.name");
        removedPros.add("settlecurrency_c.isshowsign");
        removedPros.add("entryinvorg_c.name");
        removedPros.add("entrysettleorg_c.name");
        removedPros.add("billtype_c.name");
        removedPros.add("contparties_c.name");
        removedPros.add("conmprop_c.name");
        removedPros.add("joinpriceqty_c");
        removedPros.add("aramount_c");
        this.addFilterGridCols(fieldNameMap, removedPros);
        ComboEdit item = (ComboEdit)this.getView().getControl("sumkeycols");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        this.addSumKeyComboItem(items, "org_c", "org", entityType);
        this.addSumKeyComboItem(items, "type_c", SALCONTRACT_TYPE, entityType);
        this.addSumKeyComboItem(items, "billno_c", "billno", entityType);
        this.addSumKeyComboItem(items, "billname_c", "billname", entityType);
        this.addSumKeyComboItem(items, "contparties_c", "contparties", entityType);
        this.addSumKeyComboItem(items, "customer_c", SALCONTRACT_CUSTOMER, entityType);
        this.addSumKeyComboItem(items, "biztime_c", SALCONTRACT_BIZTIME, entityType);
        this.addSumKeyComboItem(items, "billstatus_c", "billstatus", entityType);
        this.addSumKeyComboItem(items, "validstatus_c", "validstatus", entityType);
        this.addSumKeyComboItem(items, "changestatus_c", "changestatus", entityType);
        this.addSumKeyComboItem(items, "freezestatus_c", "freezestatus", entityType);
        this.addSumKeyComboItem(items, "cancelstatus_c", "cancelstatus", entityType);
        this.addSumKeyComboItem(items, "closestatus_c", "closestatus", entityType);
        this.addSumKeyComboItem(items, "terminatestatus_c", "terminatestatus", entityType);
        this.addSumKeyComboItem(items, "filingstatus_c", "filingstatus", entityType);
        this.addSumKeyComboItem(items, "dept_c", "dept", entityType);
        this.addSumKeyComboItem(items, "operatorgroup_c", "operatorgroup", entityType);
        this.addSumKeyComboItem(items, "operator_c", "operator", entityType);
        this.addSumKeyComboItem(items, "settlecurrency_c", "settlecurrency", entityType);
        this.addSumKeyComboItem(items, "totalamount_c", "totalamount", entityType);
        this.addSumKeyComboItem(items, "totaltaxamount_c", "totaltaxamount", entityType);
        this.addSumKeyComboItem(items, "totalallamount_c", "totalallamount", entityType);
        this.addSumKeyComboItem(items, "prereceiptallamount_c", "prereceiptallamount", entityType);
        this.addSumKeyComboItem(items, "receiptallamount_c", "receiptallamount", entityType);
        item.setComboItems(items);
    }

    private void addSumKeyComboItem(List<ComboItem> items, String key, String field, MainEntityType entityType) {
        IDataEntityProperty typeProperty = entityType.findProperty(field);
        if (typeProperty != null) {
            ComboItem billnoItem = new ComboItem(typeProperty.getDisplayName(), key);
            items.add(billnoItem);
        }
    }

    private void setDisplayName(Map<String, String> fieldNameMap, String key, String field, MainEntityType entityType) {
        IDataEntityProperty typeProperty = entityType.findProperty(field);
        if (typeProperty != null) {
            fieldNameMap.put(key, typeProperty.getDisplayName().getLocaleValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        DynamicObjectCollection horg = (DynamicObjectCollection)this.getModel().getValue(HEAD_ORG);
        if (!HEAD_ORG.equals(name) && (horg == null || horg.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalSynthesisReportPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        formShowParameter.setShowApproved(false);
        List<Long> listOrgId = null;
        switch (name) {
            case "head_org": {
                String formId = this.getView().getFormShowParameter().getFormId();
                QFilter orgQFilter = SalSynthesisReportPlugin.getHasPermissionOrgQFilter(formId, OrgViewTypeEnum.IS_SALE.getViewType());
                formShowParameter.getListFilterParameter().getQFilters().add(orgQFilter);
                break;
            }
            case "hbillno": {
                if (horg == null || horg.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalSynthesisReportPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                ArrayList qFilters = new ArrayList(10);
                Optional.ofNullable(this.getBaseDataIds(HEAD_ORG)).ifPresent(orgIds -> {
                    if (orgIds.size() > 0) {
                        qFilters.add(new QFilter("org", "in", orgIds));
                    }
                });
                Optional.ofNullable(this.getModel().getValue("startdate")).ifPresent(startDate -> qFilters.add(new QFilter(SALCONTRACT_BIZTIME, ">=", (Object)SalContractRptHelper.getStartOrEndDate((Date)startDate, false))));
                Optional.ofNullable(this.getModel().getValue("enddate")).ifPresent(endDate -> qFilters.add(new QFilter(SALCONTRACT_BIZTIME, "<=", (Object)SalContractRptHelper.getStartOrEndDate((Date)endDate, true))));
                Optional.ofNullable(this.getBaseDataIds("htype")).ifPresent(typeIds -> {
                    if (typeIds.size() > 0) {
                        qFilters.add(new QFilter(SALCONTRACT_TYPE, "in", typeIds));
                    }
                });
                Optional.ofNullable(this.getBaseDataIds("hcustomer")).ifPresent(customerIds -> {
                    if (customerIds.size() > 0) {
                        qFilters.add(new QFilter(SALCONTRACT_CUSTOMER, "in", customerIds));
                    }
                });
                IDataModel model = this.getModel();
                DynamicObject data = model.getDataEntity();
                Optional.ofNullable(data.getString("hvalidstatus")).ifPresent(validstatus -> qFilters.add(new QFilter("validstatus", "in", (Object)validstatus.replaceFirst(",", "").split(","))));
                if (qFilters.isEmpty()) break;
                formShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
                break;
            }
            case "hcustomer": {
                if (horg == null || horg.isEmpty()) {
                    formShowParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalSynthesisReportPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                listOrgId = MultiOrganHelper.getBaseDataLongIds(this.getView(), HEAD_ORG);
                QFilter bd_customer = MultiOrganHelper.getBaseDataFilter("bd_customer", listOrgId);
                if (bd_customer == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_customer);
                break;
            }
            case "hoperator": {
                MulBasedataDynamicObjectCollection hoperatorgroup = (MulBasedataDynamicObjectCollection)this.getModel().getValue("hoperatorgroup");
                if (hoperatorgroup == null || hoperatorgroup.size() <= 0) {
                    formShowParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalSynthesisReportPlugin_1", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                ArrayList qFilter = new ArrayList(10);
                Optional.ofNullable(this.getBaseDataIds("hoperatorgroup")).ifPresent(operatorGroupIds -> {
                    if (operatorGroupIds.size() > 0) {
                        qFilter.add(new QFilter("operatorgrpid", "in", operatorGroupIds));
                    }
                });
                if (qFilter.isEmpty()) break;
                formShowParameter.getListFilterParameter().getQFilters().addAll(qFilter);
                break;
            }
            case "hoperatorgroup": {
                DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue(HEAD_ORG);
                if (org == null) {
                    formShowParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalSynthesisReportPlugin_0", (String)"scmc-conm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                listOrgId = MultiOrganHelper.getBaseDataIds(org);
                QFilter q = MultiOrganHelper.getOrgGrpQfilter(listOrgId, "XSZ");
                formShowParameter.getListFilterParameter().setFilter(q);
                QFilter bd_operatorgroup = MultiOrganHelper.getBaseDataFilter("bd_operatorgroup", listOrgId);
                if (bd_operatorgroup == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_operatorgroup);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "hmaterial": {
                listOrgId = MultiOrganHelper.getAllOrg(this.getModel().getValue(HEAD_ORG), false);
                QFilter bd_material = MultiOrganHelper.getBaseDataFilter("bd_materialsalinfo", listOrgId);
                if (bd_material == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_material);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "hproject": {
                listOrgId = MultiOrganHelper.getAllOrg(this.getModel().getValue(HEAD_ORG), false);
                QFilter bd_project = MultiOrganHelper.getBaseDataFilter("bd_project", listOrgId);
                if (bd_project == null) break;
                formShowParameter.getListFilterParameter().setFilter(bd_project);
                formShowParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName = e.getProperty().getName()) {
            case "head_org": {
                this.getModel().setValue("hcustomer", null);
                this.getModel().setValue("hbillno", null);
                this.getModel().setValue("hdept", null);
                this.getModel().setValue("hoperatorgroup", null);
                this.getModel().setValue("hoperator", null);
                this.getModel().setValue("hmaterial", null);
                this.getModel().setValue("hproject", null);
                break;
            }
            case "hoperatorgroup": {
                this.getModel().setValue("hoperator", null);
                break;
            }
            case "showsumrow": {
                if (((Boolean)newValue).booleanValue()) {
                    this.getModel().setValue("sumkeycols", (Object)"biztime_c,billno_c,settlecurrency_c,totalamount_c,totaltaxamount_c,totalallamount_c,prereceiptallamount_c,receiptallamount_c");
                    break;
                }
                this.getModel().setValue("sumkeycols", null);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"supagrtentry", "endagrtentry"});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObjectCollection horg = data.getDynamicObjectCollection(HEAD_ORG);
        Date startdate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        if (horg == null || horg.isEmpty() || startdate == null || enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"PurSynthesisReportPlugin_2", (String)"scmc-conm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObjectCollection orgfield = data.getDynamicObjectCollection(HEAD_ORG);
        Date startdate = data.getDate("startdate");
        Date enddate = data.getDate("enddate");
        String hvalidstatus = data.getString("hvalidstatus");
        Map customParam = queryParam.getCustomParam();
        customParam.put("billno", this.getBaseDataIds("hbillno"));
        customParam.put("org", orgfield);
        customParam.put("startdate", SalContractRptHelper.getStartOrEndDate(startdate, false));
        customParam.put("enddate", SalContractRptHelper.getStartOrEndDate(enddate, true));
        customParam.put(SALCONTRACT_CUSTOMER, this.getMasterIDs("hcustomer"));
        customParam.put("dept", this.getBaseDataIds("hdept"));
        customParam.put(SALCONTRACT_TYPE, this.getBaseDataIds("htype"));
        customParam.put("operatorgroup", this.getBaseDataIds("hoperatorgroup"));
        customParam.put("operator", this.getBaseDataIds("hoperator"));
        customParam.put("material", this.getMaterialMasterIds("hmaterial"));
        customParam.put("project", this.getBaseDataIds("hproject"));
        if (StringUtils.isNotEmpty((String)hvalidstatus)) {
            String[] hvalidstatuses = data.getString("hvalidstatus").replaceFirst(",", "").split(",");
            customParam.put("validstatus", hvalidstatuses);
        } else {
            customParam.put("validstatus", null);
        }
        customParam.put("showsumrow", this.getModel().getValue("showsumrow"));
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getModel().deleteEntryData("supagrtentry");
        this.getModel().deleteEntryData("endagrtentry");
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        if (fieldName.equals("supagrtbillno")) {
            Long supagrtid = (Long)this.getModel().getValue("supagrtid", rowIndex);
            BillShowParameter param = new BillShowParameter();
            param.setPkId((Object)supagrtid);
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("conm_salsupagrt");
            this.getView().showForm((FormShowParameter)param);
        } else if (fieldName.equals("endagrtbillno")) {
            Long endagrtid = (Long)this.getModel().getValue("endagrtid", rowIndex);
            BillShowParameter param = new BillShowParameter();
            param.setPkId((Object)endagrtid);
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("conm_salendagrt");
            this.getView().showForm((FormShowParameter)param);
        } else if (fieldName.equals("billno_c")) {
            BillShowParameter param = new BillShowParameter();
            ReportList list = (ReportList)this.getControl("reportlistap");
            String billno = (String)list.getReportModel().getValue(rowIndex, "billno_c");
            DynamicObjectCollection contract = QueryServiceHelper.query((String)"conm_salcontract", (String)"id", (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
            if (contract == null || contract.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"SalSynthesisReportPlugin_3", (String)"scmc-conm-report", (Object[])new Object[0]));
            } else {
                param.setPkId((Object)((DynamicObject)contract.get(0)).getLong("id"));
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId("conm_salcontract");
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int clickRowIndex = evt.getRow();
        if (clickRowIndex < 0) {
            this.getModel().deleteEntryData("supagrtentry");
            this.getModel().deleteEntryData("endagrtentry");
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
        } else {
            this.getModel().deleteEntryData("supagrtentry");
            this.getModel().deleteEntryData("endagrtentry");
            ReportList list = (ReportList)this.getControl("reportlistap");
            String billno = (String)list.getReportModel().getValue(clickRowIndex, "billno_c");
            this.loadSupAgrtEntry(billno);
            this.loadEndAgrtEntry(billno);
            this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        }
    }

    public static Long getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        for (Map tempOrg : hasPermissionOrgs) {
            Long id = Long.valueOf((String)tempOrg.get("id"));
            if (!id.equals(orgId)) continue;
            return id;
        }
        return Long.valueOf((String)((Map)hasPermissionOrgs.get(0)).get("id"));
    }

    public static QFilter getHasPermissionOrgQFilter(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        HashSet<Long> orgIds = new HashSet<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long id = Long.valueOf((String)tempOrg.get("id"));
            orgIds.add(id);
        }
        return new QFilter("id", "in", orgIds);
    }

    private void loadEndAgrtEntry(String billno) {
        String fields = "billno,billname,org,type,contparties,customer,biztime,biztimeend,billstatus,validstatus,reviewstatus,signstatus,filingstatus,creator,srccontractnum,createtime,srccontractname";
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"conm_salendagrt", (String)fields, (QFilter[])new QFilter("srccontractnum", "=", (Object)billno).toArray());
        if (loadFromCache.size() > 0) {
            DynamicObjectCollection endagrtentity = this.getModel().getEntryEntity("endagrtentry");
            for (DynamicObject agrt : loadFromCache.values()) {
                DynamicObject addNew = endagrtentity.addNew();
                addNew.set("endagrtid", agrt.getPkValue());
                addNew.set("endagrtbillno", (Object)agrt.getString("billno"));
                addNew.set("endagrtbillname", (Object)agrt.getString("billname"));
                addNew.set("endagrtorg", (Object)agrt.getDynamicObject("org"));
                addNew.set("endagrttype", (Object)agrt.getDynamicObject(SALCONTRACT_TYPE));
                addNew.set("endagrtcontparties", (Object)agrt.getDynamicObject("contparties"));
                addNew.set("endagrtcustomer", (Object)agrt.getDynamicObject(SALCONTRACT_CUSTOMER));
                addNew.set("endagrtbiztime", (Object)agrt.getDate(SALCONTRACT_BIZTIME));
                addNew.set("endagrtbiztimeend", (Object)agrt.getDate("biztimeend"));
                addNew.set("endagrtvalidstatus", (Object)agrt.getString("validstatus"));
                addNew.set("endagrtconbillno", (Object)agrt.getString("srccontractnum"));
                addNew.set("endagrtconbillname", (Object)agrt.getString("srccontractname"));
                addNew.set("endagrtbillstatus", (Object)agrt.getString("billstatus"));
                addNew.set("endagrtvalidstatus", (Object)agrt.getString("validstatus"));
                addNew.set("endagrtreviewstatus", (Object)agrt.getString("reviewstatus"));
                addNew.set("endagrtsignstatus", (Object)agrt.getString("signstatus"));
                addNew.set("endagrtfilingstatus", (Object)agrt.getString("filingstatus"));
                addNew.set("endagrtcreator", (Object)agrt.getDynamicObject("creator"));
                addNew.set("endagrtcreatetime", (Object)agrt.getDate("createtime"));
            }
            Comparator comparator = (o1, o2) -> {
                Date endagrtbiztime2;
                Date endagrtbiztime1 = o1.getDate("endagrtbiztime");
                int dataResult = endagrtbiztime1.compareTo(endagrtbiztime2 = o2.getDate("endagrtbiztime"));
                if (dataResult > 0) {
                    return 1;
                }
                if (dataResult == 0) {
                    String endagrtbillno1 = o1.getString("endagrtbillno");
                    String endagrtbillno2 = o2.getString("endagrtbillno");
                    return endagrtbillno1.compareTo(endagrtbillno2);
                }
                return 0;
            };
            endagrtentity.sort(comparator);
            this.getModel().updateEntryCache(endagrtentity);
        }
        this.getView().updateView("endagrtentry");
    }

    private void loadSupAgrtEntry(String billno) {
        String fields = "billno,billname,org,type,contparties,customer,biztime,biztimeend,billstatus,validstatus,reviewstatus,signstatus,filingstatus,creator,createtime,srccontractnum,srccontractname";
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"conm_salsupagrt", (String)fields, (QFilter[])new QFilter("srccontractnum", "=", (Object)billno).toArray());
        if (loadFromCache.size() > 0) {
            DynamicObjectCollection supagrtentry = this.getModel().getEntryEntity("supagrtentry");
            for (DynamicObject agrt : loadFromCache.values()) {
                DynamicObject addNew = supagrtentry.addNew();
                addNew.set("supagrtid", agrt.getPkValue());
                addNew.set("supagrtbillno", (Object)agrt.getString("billno"));
                addNew.set("supagrtbillname", (Object)agrt.getString("billname"));
                addNew.set("supagrtorg", (Object)agrt.getDynamicObject("org"));
                addNew.set("supagrttype", (Object)agrt.getDynamicObject(SALCONTRACT_TYPE));
                addNew.set("supagrtcontparties", (Object)agrt.getDynamicObject("contparties"));
                addNew.set("supagrtcustomer", (Object)agrt.getDynamicObject(SALCONTRACT_CUSTOMER));
                addNew.set("supagrtbiztime", (Object)agrt.getDate(SALCONTRACT_BIZTIME));
                addNew.set("supagrtvalidstatus", (Object)agrt.getString("validstatus"));
                addNew.set("supagrtconbillno", (Object)agrt.getString("srccontractnum"));
                addNew.set("supagrtconbillname", (Object)agrt.getString("srccontractname"));
                addNew.set("supagrtbillstatus", (Object)agrt.getString("billstatus"));
                addNew.set("supagrtvalidstatus", (Object)agrt.getString("validstatus"));
                addNew.set("supagrtreviewstatus", (Object)agrt.getString("reviewstatus"));
                addNew.set("supagrtsignstatus", (Object)agrt.getString("signstatus"));
                addNew.set("supagrtfilingstatus", (Object)agrt.getString("filingstatus"));
                addNew.set("supagrtcreator", (Object)agrt.getDynamicObject("creator"));
                addNew.set("supagrtcreatetime", (Object)agrt.getDate("createtime"));
            }
            Comparator comparator = (o1, o2) -> {
                Date endagrtbiztime2;
                Date endagrtbiztime1 = o1.getDate("supagrtbiztime");
                int dataResult = endagrtbiztime1.compareTo(endagrtbiztime2 = o2.getDate("supagrtbiztime"));
                if (dataResult > 0) {
                    return 1;
                }
                if (dataResult == 0) {
                    String endagrtbillno1 = o1.getString("supagrtbillno");
                    String endagrtbillno2 = o2.getString("supagrtbillno");
                    return -endagrtbillno1.compareTo(endagrtbillno2);
                }
                return 0;
            };
            supagrtentry.sort(comparator);
            this.getModel().updateEntryCache(supagrtentry);
        }
        this.getView().updateView("supagrtentry");
    }

    private void addFilterGridCols(Map<String, String> fieldNameMap, Set<String> removeFields) {
        ReportConf reportConf = ReportDataHandle.loadReportConf((String)this.getView().getEntityId());
        List srcBlockConf = reportConf.getSrcBlockConf();
        ArrayList conFields = new ArrayList();
        for (SrcBlockConf conf : srcBlockConf) {
            String srcEntity = conf.getSrcEntity();
            if (!"conm_salcontract".equals(srcEntity)) continue;
            Set values = conf.getRepoColSrcColMap().keySet();
            conFields.addAll(values);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        for (Map filterColumn : filterColumns) {
            String fieldName = (String)filterColumn.get("fieldName");
            String fieldPrefix = fieldName.split("\\.")[0];
            if (!conFields.contains(fieldPrefix) || removeFields.contains(fieldName)) continue;
            String value = fieldNameMap.get(fieldName);
            if (StringUtils.isNotEmpty((String)value)) {
                filterColumn.put("fieldCaption", value);
            }
            cols.add(filterColumn);
        }
        filterGrid.setFilterColumns(cols);
    }

    private Set<Object> getBaseDataIds(String field) {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObjectCollection supplier = data.getDynamicObjectCollection(field);
        return supplier.stream().map(a -> a.getLong("fbasedataid.id")).collect(Collectors.toSet());
    }

    private Set<Object> getMasterIDs(String field) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection fields = dataEntity.getDynamicObjectCollection(field);
        return fields.stream().map(a -> a.getLong("fbasedataid.masterid")).collect(Collectors.toSet());
    }

    private Set<Long> getMaterialMasterIds(String field) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection(field);
        if (col == null || col.size() < 1) {
            return null;
        }
        HashSet<Long> pkIds = new HashSet<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject material;
            DynamicObject baseData;
            DynamicObject entry = (DynamicObject)col.get(i);
            if (entry == null || (baseData = entry.getDynamicObject("fbasedataid")) == null || (material = baseData.getDynamicObject("masterid")) == null) continue;
            pkIds.add((Long)material.get("masterid"));
        }
        return pkIds;
    }
}

