/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.webapi;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InvReserveCreateApiService
implements IBillWebApiPlugin {
    private static final Set<String> MUST_INPUT_STRINGS = new HashSet<String>(Arrays.asList("demandformid", "demandnumber", "demandid", "demandentryid", "demandseq", "demanddate", "demandorg", "materiel", "demandunit", "demandqty", "reserveqty", "reservebaseqty", "reservetype", "reveredept", "reservecust", "reserveoperate", "reserveenddate", "reserveprctype", "supplyformid", "supplybillid", "supplyentryid", "supplyorgid", "supplystockid"));
    private Map<String, String> BASEDATA_MAP_FIELDS = new HashMap<String, String>(16);
    private Set<String> DATE_FIELDS = new HashSet<String>(4);
    private Set<String> allReservationFiledsInfo = new HashSet<String>(30);
    private static final String FORMID = "sbs_reservation";
    private Map<String, Object> SAVE_MAP = new HashMap<String, Object>(32);

    public ApiResult doCustomService(Map<String, Object> params) {
        LinkedHashMap param = (LinkedHashMap)params.get("data");
        this.initFieldsInfo();
        ApiResult checkInputParamApiResult = this.checkInputParam(param);
        if (!checkInputParamApiResult.getSuccess()) {
            return checkInputParamApiResult;
        }
        DynamicObject reservationDys = BusinessDataServiceHelper.newDynamicObject((String)FORMID);
        for (Map.Entry<String, Object> entry : this.SAVE_MAP.entrySet()) {
            reservationDys.set(entry.getKey(), entry.getValue());
        }
        DynamicObject reserveRecord = this.createReserveRecord(reservationDys);
        HashMap returnDate = new HashMap();
        HashSet<DynamicObject> setPkIds = new HashSet<DynamicObject>(2);
        setPkIds.add(reserveRecord);
        returnDate.put("successPkIds", setPkIds);
        return ApiResult.success(returnDate);
    }

    private ApiResult checkInputParam(LinkedHashMap<String, Object> param) {
        Set<String> paramKeys = param.keySet();
        HashSet<String> notAllReservationFiledsInfo = new HashSet<String>(paramKeys);
        HashSet<String> notMustInputParams = new HashSet<String>(MUST_INPUT_STRINGS);
        notAllReservationFiledsInfo.removeAll(this.allReservationFiledsInfo);
        notMustInputParams.removeAll(paramKeys);
        if (notAllReservationFiledsInfo.size() != 0) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u672a\u50a8\u5b58\u8f93\u5165\u53c2\u6570\u201c%s\u201d\u7684\u76f8\u5173\u4fe1\u606f,\u8bf7\u66f4\u6362\u67e5\u8be2\u6761\u4ef6\u3002", (String)"InvAccQueryApiService_1", (String)"scmc-im-webapi", (Object[])new Object[0]), notAllReservationFiledsInfo), (String)"020");
        }
        if (notMustInputParams.size() != 0) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570\u201c%s\u201d\u3002", (String)"InvAccQueryApiService_0", (String)"scmc-im-webapi", (Object[])new Object[0]), notMustInputParams), (String)"001");
        }
        Set<String> reservationBaseDataFields = this.BASEDATA_MAP_FIELDS.keySet();
        for (String inputKey : paramKeys) {
            Object inputKey_Value = param.get(inputKey);
            if (reservationBaseDataFields.contains(inputKey)) {
                ApiResult resultInputParamFormat = this.checkInputBaseDataValid((LinkedHashMap)inputKey_Value, inputKey);
                if (resultInputParamFormat.getSuccess()) continue;
                return resultInputParamFormat;
            }
            if (this.DATE_FIELDS.contains(inputKey)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    this.SAVE_MAP.put(inputKey, sdf.parse((String)inputKey_Value));
                }
                catch (ParseException e) {
                    ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u201c%s\u201d\u53c2\u6570\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"InvReserveCreateApiService_0", (String)"scmc-im-webapi", (Object[])new Object[0]), inputKey), (String)"098");
                }
                continue;
            }
            this.SAVE_MAP.put(inputKey, inputKey_Value);
        }
        return new ApiResult();
    }

    private ApiResult checkInputBaseDataValid(LinkedHashMap<String, Object> param1, String key) {
        String value = (String)param1.get("number");
        if (value == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u7684\u201c%s\u201d\u884c\u683c\u5f0f\u6709\u8bef\u3002", (String)"InvAccQueryApiService_2", (String)"scmc-im-webapi", (Object[])new Object[0]), key), (String)"099");
        }
        DynamicObject dys = null;
        dys = key.equals("reserveoperate") ? BusinessDataServiceHelper.loadSingleFromCache((String)this.BASEDATA_MAP_FIELDS.get(key), (String)"id,operatornumber", (QFilter[])new QFilter("operatornumber", "=", (Object)value).toArray()) : BusinessDataServiceHelper.loadSingleFromCache((String)this.BASEDATA_MAP_FIELDS.get(key), (String)"id,number", (QFilter[])new QFilter("number", "=", (Object)value).toArray());
        if (dys == null) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"InvReserveCreateApiService_1", (String)"scmc-im-webapi", (Object[])new Object[0]), key, value), (String)"010");
        }
        this.SAVE_MAP.put(key, dys.getPkValue());
        return new ApiResult();
    }

    private void initFieldsInfo() {
        Map sbsReservationMapFieldInfo = EntityMetadataCache.getDataEntityType((String)FORMID).getAllFields();
        this.allReservationFiledsInfo = sbsReservationMapFieldInfo.keySet();
        for (Map.Entry entry : sbsReservationMapFieldInfo.entrySet()) {
            if (entry.getValue() instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)entry.getValue();
                String entityId = basedataProp.getBaseEntityId();
                this.BASEDATA_MAP_FIELDS.put((String)entry.getKey(), entityId);
                continue;
            }
            if (!(entry.getValue() instanceof DateProp)) continue;
            this.DATE_FIELDS.add((String)entry.getKey());
        }
    }

    private DynamicObject createReserveRecord(DynamicObject reserveLinkData) {
        DynamicObject reserveRecord = BusinessDataServiceHelper.newDynamicObject((String)"msmod_reserve_record");
        Object balId = reserveLinkData.get("supplybillid");
        BigDecimal reservebaseqty = reserveLinkData.getBigDecimal("reservebaseqty");
        BigDecimal reserveqty = reserveLinkData.getBigDecimal("reserveqty");
        BigDecimal reserveunit2ndqty = reserveLinkData.getBigDecimal("reserveunit2ndqty");
        DynamicObject bal = BusinessDataServiceHelper.loadSingle((String)"im_inv_realbalance", (String)"id,lockbaseqty,lockqty,lockqty2nd,avbbaseqty,avbqty,avbqty2nd,baseqty,qty,qty2nd", (QFilter[])new QFilter("id", "=", balId).toArray());
        reserveRecord.set("bill_obj", reserveLinkData.get("demandformid"));
        reserveRecord.set("bill_no", reserveLinkData.get("demandnumber"));
        reserveRecord.set("bill_id", reserveLinkData.get("demandid"));
        reserveRecord.set("billentry_id", reserveLinkData.get("demandentryid"));
        reserveRecord.set("bill_source", (Object)"1");
        reserveRecord.set("entry_name", reserveLinkData.get("billentry"));
        reserveRecord.set("billentry_seq", reserveLinkData.get("demandseq"));
        reserveRecord.set("bal_id", balId);
        reserveRecord.set("base_qty", (Object)reservebaseqty);
        reserveRecord.set("qty", (Object)reserveqty);
        reserveRecord.set("qty2nd", (Object)reserveunit2ndqty);
        reserveRecord.set("bal_source", (Object)"1");
        BigDecimal lockbaseqty = bal.getBigDecimal("lockbaseqty").add(reservebaseqty);
        BigDecimal lockqty = bal.getBigDecimal("lockqty").add(reserveqty);
        BigDecimal lockqty2nd = bal.getBigDecimal("lockqty2nd").add(reserveunit2ndqty);
        bal.set("lockbaseqty", (Object)lockbaseqty);
        bal.set("lockqty", (Object)lockqty);
        bal.set("lockqty2nd", (Object)lockqty2nd);
        bal.set("avbbaseqty", (Object)bal.getBigDecimal("baseqty").subtract(lockbaseqty));
        bal.set("avbqty", (Object)bal.getBigDecimal("qty").subtract(lockqty));
        bal.set("avbqty2nd", (Object)bal.getBigDecimal("qty2nd").subtract(lockqty2nd));
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"createReserveRecord");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reserveRecord});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bal});
            DynamicObject dynamicObject = reserveRecord;
            return dynamicObject;
        }
        catch (Exception e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

