/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.cal.common.helper.BillTreeBuildParameter;

public class EntityParseHelper {
    private static HashSet<Class<?>> invalidFldTypes = new HashSet();
    private static HashSet<Class<?>> invalidAutoBatchFldTypes = new HashSet();

    public static Map<String, IDataEntityProperty> findPropertys(EntityType mainType, String fullPropName) {
        LinkedHashMap<String, IDataEntityProperty> props = new LinkedHashMap<String, IDataEntityProperty>();
        if (mainType.getName().equalsIgnoreCase(fullPropName) || "billhead".equalsIgnoreCase(fullPropName)) {
            props.put(fullPropName, (IDataEntityProperty)mainType.getPrimaryKey());
            return props;
        }
        Object prop = null;
        String[] keys = fullPropName.split("\\.");
        ArrayList<String> unknowKeys = new ArrayList<String>(Arrays.asList(keys));
        String key1 = keys[0];
        int nextKeyIndex = 1;
        if (keys.length == 1) {
            prop = mainType.findProperty(key1);
            if (prop != null) {
                props.put(key1, (IDataEntityProperty)prop);
            } else {
                props.put(key1, null);
            }
            unknowKeys.clear();
        } else {
            prop = mainType.findProperty(key1);
            if (prop == null) {
                props.put(fullPropName, null);
                unknowKeys.clear();
            } else {
                props.put(key1, (IDataEntityProperty)prop);
                unknowKeys.remove(0);
                String key2 = keys[nextKeyIndex];
                if (prop instanceof EntryProp) {
                    prop = mainType.findProperty(key2);
                    if (prop == null) {
                        prop = mainType.findProperty(key1 + "." + key2);
                    }
                    ++nextKeyIndex;
                    if (prop != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                }
                if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                    key2 = keys[nextKeyIndex];
                    ++nextKeyIndex;
                    BasedataProp bdProp1 = (BasedataProp)prop;
                    MainEntityType baseEntityType1 = (MainEntityType)bdProp1.getComplexType();
                    if ((prop = baseEntityType1.getPrimaryKey().getName().equals(key2) ? baseEntityType1.getPrimaryKey() : baseEntityType1.findProperty(key2)) != null) {
                        props.put(key2, (IDataEntityProperty)prop);
                        unknowKeys.remove(0);
                    }
                    if (prop instanceof BasedataProp && keys.length > nextKeyIndex) {
                        String key3 = keys[nextKeyIndex];
                        ++nextKeyIndex;
                        BasedataProp bdProp2 = (BasedataProp)prop;
                        MainEntityType baseEntityType2 = (MainEntityType)bdProp2.getComplexType();
                        if ((prop = baseEntityType2.getPrimaryKey().getName().equals(key3) ? baseEntityType2.getPrimaryKey() : baseEntityType2.findProperty(key3)) != null) {
                            props.put(key3, (IDataEntityProperty)prop);
                            unknowKeys.remove(0);
                        }
                    }
                }
            }
        }
        if (unknowKeys.size() > 0) {
            props.put(StringUtils.join(unknowKeys, (String)"."), null);
        }
        return props;
    }

    public static String buildPropFullCaption(EntityType mainType, String fullPropName) {
        return EntityParseHelper.buildPropFullCaption(mainType, fullPropName, true);
    }

    public static String buildPropFullCaption(EntityType mainType, String fullPropName, boolean isShowBillName) {
        IDataEntityProperty firstProp;
        ArrayList<String> captions = new ArrayList<String>();
        Map<String, IDataEntityProperty> props = EntityParseHelper.findPropertys(mainType, fullPropName);
        if (isShowBillName && (firstProp = props.entrySet().iterator().next().getValue()) != null) {
            IDataEntityType parentType = null;
            parentType = firstProp instanceof EntryProp ? ((EntryProp)firstProp).getItemType() : firstProp.getParent();
            if (parentType instanceof MainEntityType) {
                captions.add(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityParseHelper_0", (String)"scmc-im-cal", (Object[])new Object[0]));
            } else if (parentType instanceof EntityType) {
                LocaleString displayCaption = ((EntityType)parentType).getDisplayName();
                captions.add(displayCaption == null ? "" : displayCaption.toString());
            }
        }
        for (Map.Entry<String, IDataEntityProperty> item : props.entrySet()) {
            if (item.getValue() == null) {
                captions.add(item.getKey());
                continue;
            }
            IDataEntityProperty property = item.getValue();
            if (property instanceof EntryProp) continue;
            if (property instanceof DynamicProperty) {
                LocaleString displayCaption = ((DynamicProperty)property).getDisplayName();
                captions.add(displayCaption == null ? item.getKey() : displayCaption.toString());
                continue;
            }
            captions.add(item.getKey());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public static String buildPropFullCaption(IDataEntityProperty property) {
        LocaleString displayCaption;
        ArrayList<String> captions = new ArrayList<String>();
        IDataEntityType parentType = property.getParent();
        if (parentType instanceof MainEntityType) {
            captions.add(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityParseHelper_0", (String)"scmc-im-cal", (Object[])new Object[0]));
        } else if (parentType instanceof EntityType) {
            displayCaption = ((EntityType)parentType).getDisplayName();
            captions.add(displayCaption == null ? "" : displayCaption.toString());
        }
        if (property instanceof DynamicProperty) {
            displayCaption = ((DynamicProperty)property).getDisplayName();
            captions.add(displayCaption == null ? property.getName() : displayCaption.toString());
        } else {
            captions.add(property.getName());
        }
        return StringUtils.join((Object[])captions.toArray(), (String)".");
    }

    public static String getPropAlias(EntityType mainType, String fullPropName) {
        Map<String, IDataEntityProperty> props = EntityParseHelper.findPropertys(mainType, fullPropName);
        if (props.size() > 0) {
            Map.Entry<String, IDataEntityProperty> item = props.entrySet().iterator().next();
            IDataEntityProperty property = item.getValue();
            return property.getAlias();
        }
        return null;
    }

    public static TreeNode buildBillTreeNodes(BillTreeBuildParameter ... parameters) {
        MainEntityType mainType = parameters[0].getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        ArrayList<TreeNode> fldNodes = new ArrayList<TreeNode>();
        for (BillTreeBuildParameter billTreeBuildParameter : parameters) {
            fldNodes.addAll(EntityParseHelper.buildFldTreeNodes(billTreeBuildParameter));
        }
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        TreeNode tempNode = null;
        for (int i = fldNodes.size() - 1; i >= 0; --i) {
            tempNode = (TreeNode)fldNodes.get(i);
            if (nodeMap.containsKey(tempNode.getId())) {
                fldNodes.remove(i);
                continue;
            }
            nodeMap.put(tempNode.getId(), tempNode);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        HashSet<String> selectedEntity = new HashSet<String>();
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.size() == 0) {
            selectedEntity = new HashSet();
            for (String entityKey : mainType.getAllEntities().keySet()) {
                selectedEntity.add(entityKey);
            }
        }
        List onlyShowFields = parameter.getShowFields();
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityParseHelper_0", (String)"scmc-im-cal", (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                EntityParseHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            if (onlyShowFields == null || onlyShowFields.size() == 0) {
                for (IDataEntityProperty property : entityType.getFields().values()) {
                    BasedataProp bdProp;
                    MainEntityType bdType;
                    List<TreeNode> refNodes;
                    boolean matched = false;
                    if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName()) || !parameter.isIncludeDecimalAndDate() && (property instanceof DecimalProp || property instanceof DateProp)) continue;
                    TreeNode fldNode = EntityParseHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
                    if (fldNode != null) {
                        entityFldNodes.add(fldNode);
                        matched = true;
                    }
                    if (!(property instanceof BasedataProp) || parameter.isBaseDataOnlyShowRootNode()) continue;
                    if (fldNode == null) {
                        fldNode = EntityParseHelper.BuildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                    }
                    if ((refNodes = EntityParseHelper.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, property.getName(), parameter.isDynamicText())).size() <= 0) continue;
                    entityFldNodes.addAll(refNodes);
                    if (matched) continue;
                    entityFldNodes.add(fldNode);
                }
            } else {
                for (Object o : onlyShowFields) {
                    BasedataProp bdProp;
                    MainEntityType bdType;
                    List<TreeNode> refNodes;
                    IDataEntityProperty property = mainType.findProperty(o.toString());
                    if (property == null) continue;
                    boolean matched = false;
                    TreeNode fldNode = EntityParseHelper.BuildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
                    if (fldNode != null) {
                        entityFldNodes.add(fldNode);
                        matched = true;
                    }
                    if (!(property instanceof BasedataProp) || parameter.isBaseDataOnlyShowRootNode()) continue;
                    if (fldNode == null) {
                        fldNode = EntityParseHelper.BuildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                    }
                    if ((refNodes = EntityParseHelper.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, property.getName(), parameter.isDynamicText())).size() <= 0) continue;
                    entityFldNodes.addAll(refNodes);
                    if (matched) continue;
                    entityFldNodes.add(fldNode);
                }
            }
            if (entityFldNodes.size() <= 0) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    public static boolean isSupportConvField(MainEntityType mainType, IDataEntityProperty property) {
        if (invalidFldTypes.contains(property.getClass())) {
            return false;
        }
        return !(property.getParent() instanceof LinkEntryType);
    }

    public static boolean isSupportAutoBatch(MainEntityType mainType, IDataEntityProperty property) {
        if (invalidFldTypes.contains(property.getClass())) {
            return false;
        }
        if (invalidAutoBatchFldTypes.contains(property.getClass())) {
            return false;
        }
        if (mainType instanceof BillEntityType) {
            String billNo = ((BillEntityType)mainType).getBillNo();
            if (property.getName().equalsIgnoreCase(billNo)) {
                return false;
            }
        }
        return true;
    }

    private static List<TreeNode> BuildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = EntityParseHelper.BuildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = EntityParseHelper.BuildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodes2 = EntityParseHelper.BuildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText)).size() <= 0) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static TreeNode BuildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = EntityParseHelper.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = EntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                String content = String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"scmc-im-cal", (Object[])new Object[0]), entityType.getDisplayName().toString());
                idNode.setText(content);
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = EntityParseHelper.BuildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                String content = String.format(ResManager.loadKDString((String)"%1$s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"scmc-im-cal", (Object[])new Object[0]), entityType.getDisplayName().toString());
                idNode.setText(content);
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = EntityParseHelper.BuildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                String content = String.format(ResManager.loadKDString((String)"%1$s.\u5e8f\u53f7", (String)"EntityParseHelper_2", (String)"scmc-im-cal", (Object[])new Object[0]), entityType.getDisplayName().toString());
                seqNode.setText(content);
                entityFldNodes.add(seqNode);
            }
        }
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp) {
                if (!((BasedataProp)matchedProperty).isFromSampleMaster(fldProperty)) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (matchedProperty instanceof BigIntProp && fldProperty instanceof LongProp) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    public static void bindColNames(IDataModel model, String entryKey, String entity, String fieldKey, String fieldnameKey) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        int count = model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            String fullCaption;
            String field = (String)model.getValue(fieldKey, i);
            if (!StringUtils.isNotEmpty((CharSequence)field) || !StringUtils.isNotEmpty((CharSequence)(fullCaption = EntityParseHelper.buildPropFullCaption((EntityType)entityType, field)))) continue;
            model.setValue(fieldnameKey, (Object)fullCaption, i);
        }
        model.setDataChanged(false);
    }

    static {
        invalidFldTypes.add(BillStatusProp.class);
        invalidFldTypes.add(CreateDateProp.class);
        invalidFldTypes.add(CreaterProp.class);
        invalidFldTypes.add(ModifierProp.class);
        invalidFldTypes.add(ModifyDateProp.class);
        invalidFldTypes.add(MulBasedataProp.class);
        invalidAutoBatchFldTypes.add(DateTimeProp.class);
        invalidAutoBatchFldTypes.add(DateProp.class);
        invalidAutoBatchFldTypes.add(UserProp.class);
    }
}

