/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.cal.common.helper.FilterResult;
import kd.scmc.im.cal.common.helper.SyncConditionCompiler;

public class FilterInfoChecker {
    private String entity = "";
    private String filterStr = "";
    private FilterCondition filterCondition;
    private MainEntityType bizbillentitytype;
    private DynamicObject[] invBills;
    private HashSet<Long> deletedBillIds = new HashSet(16);
    private Set<Long> bizBillIds;
    private String bizSelector;

    public FilterInfoChecker(String entity, Set<Long> bizBillIds) {
        this.bizBillIds = bizBillIds;
        this.entity = entity;
        this.bizbillentitytype = EntityMetadataCache.getDataEntityType((String)this.entity);
    }

    public FilterInfoChecker(String entity, Set<Long> bizBillIds, String filterStr) {
        this.entity = entity;
        this.bizbillentitytype = EntityMetadataCache.getDataEntityType((String)this.entity);
        this.filterStr = filterStr;
        this.bizBillIds = bizBillIds;
        this.filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)this.filterStr, FilterCondition.class);
    }

    public List<FilterResult> doCheckFilterResult() {
        String entryName = this.getMaxEntryPrefix();
        List<FilterResult> checkRs = this.checkBizBillsByRule(entryName, this.invBills);
        return checkRs;
    }

    public Map<Long, String> doCheckErrorInfo() {
        HashMap<Long, String> unValidIdMap = new HashMap<Long, String>(16);
        if (this.filterCondition.getFilterRow().isEmpty()) {
            return unValidIdMap;
        }
        List<FilterResult> filterResults = this.doCheckFilterResult();
        for (FilterResult filterResult : filterResults) {
            if (filterResult.hasValidEntry()) continue;
            unValidIdMap.put(filterResult.getBillHead().getLong("id"), filterResult.getErrorInfo());
        }
        HashSet<Long> existBillIds = new HashSet<Long>(16);
        for (DynamicObject invBillDyc : this.invBills) {
            existBillIds.add((Long)invBillDyc.getPkValue());
        }
        HashSet<Long> hashSet = new HashSet<Long>(this.bizBillIds);
        hashSet.removeAll(existBillIds);
        hashSet.removeAll(this.deletedBillIds);
        this.deletedBillIds.addAll(hashSet);
        String notExistLog = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\u3002", (String)"FilterInfoChecker_0", (String)"scmc-im-cal", (Object[])new Object[0]);
        for (Long item : hashSet) {
            unValidIdMap.put(item, notExistLog);
        }
        return unValidIdMap;
    }

    private List<FilterResult> checkBizBillsByRule(String entryPrefix, DynamicObject[] billDycs) {
        if (billDycs.length < 1) {
            return new ArrayList<FilterResult>(0);
        }
        MainEntityType mainType = (MainEntityType)billDycs[0].getDataEntityType();
        ArrayList<String> entryKeyList = new ArrayList<String>(3);
        entryKeyList.add(this.entity);
        if (!StringUtils.isEmpty((String)entryPrefix)) {
            String[] entryArr;
            for (String entryKey : entryArr = entryPrefix.split("\\.")) {
                entryKeyList.add(entryKey);
            }
        }
        FilterBuilder builder = new FilterBuilder(this.bizbillentitytype, this.filterCondition);
        String[] script = builder.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        RowDataModel rowModel = new RowDataModel((String)entryKeyList.get(entryKeyList.size() - 1), mainType);
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        ArrayList<FilterResult> resultList = new ArrayList<FilterResult>(billDycs.length);
        for (DynamicObject bill : billDycs) {
            FilterResult result = new FilterResult(bill);
            resultList.add(result);
            this.recursionCheck(entryKeyList, bill, this.filterCondition, expr, expContext, result);
        }
        return resultList;
    }

    public DynamicObject[] loadSyncBillsByID() {
        this.invBills = BusinessDataServiceHelper.load((Object[])this.bizBillIds.toArray(), (DynamicObjectType)this.bizbillentitytype);
        return this.invBills;
    }

    private String getMaxEntryPrefix() {
        String maxEntryPrefix = "";
        for (SimpleFilterRow row : this.filterCondition.getFilterRow()) {
            String fieldName = row.getFieldName();
            String firstKey = fieldName.contains(".") ? fieldName.split("\\.")[0] : fieldName;
            String entryPrefix = this.getParentEntryName(firstKey);
            if (entryPrefix.length() <= maxEntryPrefix.length()) continue;
            maxEntryPrefix = entryPrefix;
        }
        return maxEntryPrefix;
    }

    private String getParentEntryName(String fieldKey) {
        IDataEntityType parentProperty = this.bizbillentitytype.findProperty(fieldKey).getParent();
        if (parentProperty instanceof SubEntryType) {
            return parentProperty.getParent().getName() + "." + parentProperty.getName() + ".";
        }
        if (parentProperty instanceof EntryType) {
            return parentProperty.getName() + ".";
        }
        return "";
    }

    private void recursionCheck(List<String> entryKeyList, DynamicObject bill, FilterCondition filterCondition, BOSExpression expr, BOSExpressionContext expContext, FilterResult result) {
        String lastEntryKey = entryKeyList.get(entryKeyList.size() - 1);
        String currentEntry = bill.getDataEntityType().getName();
        if (currentEntry.equals(lastEntryKey)) {
            this.checkValid(filterCondition, expr, expContext, result, bill);
        } else {
            String nextEntry = entryKeyList.get(entryKeyList.indexOf(currentEntry) + 1);
            for (DynamicObject entry : bill.getDynamicObjectCollection(nextEntry)) {
                this.recursionCheck(entryKeyList, entry, filterCondition, expr, expContext, result);
            }
        }
    }

    private void checkValid(FilterCondition filterCondition, BOSExpression expr, BOSExpressionContext expContext, FilterResult result, DynamicObject entry) {
        expContext.getRowDataModel().setRowContext((Object)entry, 0);
        Boolean exprValue = (Boolean)CalcExprParser.getExpressionValue((BOSExpression)expr, (ExpressionContext)expContext, (FunctionManage)FunctionManage.get());
        if (!exprValue.booleanValue()) {
            SyncConditionCompiler compiler = new SyncConditionCompiler();
            compiler.compileSubCondition(filterCondition, this.bizbillentitytype);
            List<SyncConditionCompiler> rs = compiler.getSubCondCompilers();
            for (SyncConditionCompiler syncConditionCompiler : rs) {
                Boolean rowCheckRs = (Boolean)CalcExprParser.getExpressionValue((String)syncConditionCompiler.getFullExpression(), (ExpressionContext)expContext, (FunctionManage)FunctionManage.get());
                if (rowCheckRs.booleanValue()) continue;
                String errorMsg = syncConditionCompiler.getDescription();
                result.appendErrorInfo(errorMsg);
                break;
            }
        } else {
            result.addValidEntry(entry);
        }
    }

    public DynamicObject[] getInvBills() {
        return this.invBills;
    }

    public void setInvBills(DynamicObject[] invBills) {
        this.invBills = invBills;
    }

    public Set<Long> getBizBillIds() {
        return this.bizBillIds;
    }

    public void setBizBillIds(Set<Long> bizBillIds) {
        this.bizBillIds = bizBillIds;
    }

    public void setBizSelector(String bizSelector) {
        this.bizSelector = bizSelector;
    }

    public String getFilterStr() {
        return this.filterStr;
    }

    public String getBizSelector() {
        return this.bizSelector;
    }

    public void setFilterStr(String filterStr) {
        this.filterStr = filterStr;
        this.filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)this.filterStr, FilterCondition.class);
    }
}

