/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.common.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.servicehelper.user.UserService;

public class SyncConditionCompiler {
    private CRCondition crCondition;
    private List<QFilter> gridQFilters = new ArrayList<QFilter>();
    private IGetValueMode gridFilterExecuter;
    private IGetValueMode expressionExecuter;
    private List<QFilter> custQFilters = new ArrayList<QFilter>();
    private String custFilterExpression;
    private IGetValueMode custExpressionExecuter;
    private String custFilterDesc;
    private List<SyncConditionCompiler> subCondCompilers = new ArrayList<SyncConditionCompiler>();
    private String description;
    private String fullExpression;
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();

    public SyncConditionCompiler() {
    }

    public SyncConditionCompiler(CRCondition crCondition) {
        this.crCondition = crCondition;
    }

    public SyncConditionCompiler(List<QFilter> custQFilters, String custFilterExpression, String custFilterDesc) {
        if (custQFilters != null) {
            this.custQFilters.addAll(custQFilters);
        }
        this.custFilterExpression = custFilterExpression;
        this.custFilterDesc = custFilterDesc;
    }

    public SyncConditionCompiler(CRCondition crCondition, List<QFilter> custQFilters, String custFilterExpression, String custFilterDesc) {
        this.crCondition = crCondition;
        if (custQFilters != null) {
            this.custQFilters.addAll(custQFilters);
        }
        this.custFilterExpression = custFilterExpression;
        this.custFilterDesc = custFilterDesc;
    }

    public void compile(FilterCondition filterStr, MainEntityType mainEntityType) {
        String gridFilterDesc = null;
        ArrayList<String> exps = new ArrayList<String>();
        FilterCondition filterCondition = filterStr;
        if (filterCondition == null) {
            this.gridFilterExecuter = new GetConstValue((Object)Boolean.TRUE);
        } else {
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
            TimeService timeService = new TimeService();
            filterBuilder.setTimeService((ITimeService)timeService);
            UserService userService = new UserService();
            filterBuilder.setUserService((IUserService)userService);
            filterBuilder.buildFilter(false);
            this.gridQFilters.clear();
            this.gridQFilters.add(filterBuilder.getQFilter());
            String[] filterScripts = filterBuilder.buildFilterScript();
            String gridFilterString = filterScripts[0];
            if (StringUtils.isNotBlank((CharSequence)gridFilterString)) {
                exps.add(gridFilterString);
            } else {
                this.gridFilterExecuter = new GetConstValue((Object)Boolean.TRUE);
            }
            gridFilterDesc = filterScripts[1];
        }
        if (this.crCondition != null && StringUtils.isBlank((CharSequence)this.crCondition.getExpression())) {
            this.expressionExecuter = new GetConstValue((Object)Boolean.TRUE);
        }
        if (StringUtils.isNotBlank((CharSequence)this.custFilterExpression)) {
            exps.add(this.custFilterExpression);
        } else {
            this.custExpressionExecuter = new GetConstValue((Object)Boolean.TRUE);
        }
        this.description = this.crCondition != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? this.crCondition.getDescription().toString() : gridFilterDesc;
        this.fullExpression = StringUtils.join((Object[])exps.toArray(), (String)" and ");
        if (this.gridFilterExecuter != null) {
            this.vars.addAll(this.gridFilterExecuter.getVars());
        }
        if (this.expressionExecuter != null) {
            this.vars.addAll(this.expressionExecuter.getVars());
        }
        if (this.custExpressionExecuter != null) {
            this.vars.addAll(this.custExpressionExecuter.getVars());
        }
    }

    public void compileSubCondition(FilterCondition filterStr, MainEntityType mainEntityType) {
        if (filterStr != null && !filterStr.getFilterRow().isEmpty()) {
            String str = SerializationUtils.toJsonString((Object)filterStr);
            FilterCondition copyFilter = (FilterCondition)SerializationUtils.fromJsonString((String)str, FilterCondition.class);
            List<List<SimpleFilterRow>> rowGroups = this.splitFilterRows(copyFilter.getFilterRow());
            for (List<SimpleFilterRow> rows : rowGroups) {
                FilterCondition filterCondition = new FilterCondition();
                filterCondition.setFilterRow(rows);
                CRCondition subCondition = new CRCondition();
                subCondition.setFilterCondition(filterCondition);
                SyncConditionCompiler subCondCompiler = new SyncConditionCompiler(subCondition);
                subCondCompiler.compile(filterCondition, mainEntityType);
                this.subCondCompilers.add(subCondCompiler);
            }
        }
        if (this.crCondition != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getExpression())) {
            CRCondition subCondition = new CRCondition();
            subCondition.setExpression(this.crCondition.getExpression());
            subCondition.setDescription(this.crCondition.getDescription());
            SyncConditionCompiler subCondCompiler = new SyncConditionCompiler(subCondition);
            subCondCompiler.compile(subCondition.getFilterCondition(), mainEntityType);
            this.subCondCompilers.add(subCondCompiler);
        }
        if (this.custQFilters != null && !this.custQFilters.isEmpty() || StringUtils.isNotBlank((CharSequence)this.custFilterExpression)) {
            SyncConditionCompiler subCondCompiler = new SyncConditionCompiler(this.custQFilters, this.custFilterExpression, this.custFilterDesc);
            subCondCompiler.compile(filterStr, mainEntityType);
            this.subCondCompilers.add(subCondCompiler);
        }
    }

    private List<List<SimpleFilterRow>> splitFilterRows(List<SimpleFilterRow> rows) {
        List<List<SimpleFilterRow>> lstGroup = new ArrayList<List<SimpleFilterRow>>();
        if (rows == null || rows.isEmpty()) {
            return lstGroup;
        }
        if (rows.size() == 1) {
            lstGroup.add(rows);
            return lstGroup;
        }
        lstGroup = this.splitByBracket(rows);
        if (lstGroup.isEmpty()) {
            return lstGroup;
        }
        if (lstGroup.size() == 1) {
            String leftBracket = rows.get(0).getLeftBracket().replace(" ", "");
            String rightBracket = rows.get(rows.size() - 1).getRightBracket().replace(" ", "");
            rows.get(0).setLeftBracket(leftBracket.substring(1));
            rows.get(rows.size() - 1).setRightBracket(rightBracket.substring(1));
            lstGroup = this.splitFilterRows(rows);
        }
        if (lstGroup.size() > 1) {
            boolean hadOr = this.isJoinByOr(lstGroup);
            if (hadOr) {
                lstGroup = new ArrayList();
                lstGroup.add(rows);
            } else {
                ArrayList<List<SimpleFilterRow>> tmpGroup = new ArrayList<List<SimpleFilterRow>>();
                tmpGroup.addAll(lstGroup);
                lstGroup.clear();
                for (List list : tmpGroup) {
                    List<List<SimpleFilterRow>> subListGroup = this.splitFilterRows(list);
                    lstGroup.addAll(subListGroup);
                }
            }
        }
        return lstGroup;
    }

    private boolean isJoinByOr(List<List<SimpleFilterRow>> lstGroup) {
        boolean hadOr = false;
        for (int i = 0; i < lstGroup.size() - 1; ++i) {
            List<SimpleFilterRow> group = lstGroup.get(i);
            String logic = group.get(group.size() - 1).getLogic();
            if (!StringUtils.equals((CharSequence)logic, (CharSequence)String.valueOf(LogicOperate.OR.getValue())) && !StringUtils.equalsIgnoreCase((CharSequence)logic, (CharSequence)LogicOperate.OR.toString())) continue;
            hadOr = true;
            break;
        }
        return hadOr;
    }

    private List<List<SimpleFilterRow>> splitByBracket(List<SimpleFilterRow> rows) {
        ArrayList<List<SimpleFilterRow>> lstGroup = new ArrayList<List<SimpleFilterRow>>();
        int totalLeftBracket = 0;
        ArrayList<SimpleFilterRow> groupDetail = new ArrayList<SimpleFilterRow>();
        for (SimpleFilterRow row : rows) {
            int currRightBracket;
            int currLeftBracket = row.getLeftBracket().replace(" ", "").length();
            if ((totalLeftBracket = totalLeftBracket + currLeftBracket - (currRightBracket = row.getRightBracket().replace(" ", "").length())) > 0) {
                groupDetail.add(row);
                continue;
            }
            groupDetail.add(row);
            lstGroup.add(groupDetail);
            groupDetail = new ArrayList();
        }
        if (!groupDetail.isEmpty()) {
            lstGroup.add(groupDetail);
        }
        return lstGroup;
    }

    public List<SyncConditionCompiler> getSubCondCompilers() {
        return this.subCondCompilers;
    }

    public CRCondition getCrCondition() {
        return this.crCondition;
    }

    public void setCrCondition(CRCondition crCondition) {
        this.crCondition = crCondition;
    }

    public List<QFilter> getGridQFilters() {
        return this.gridQFilters;
    }

    public void setGridQFilters(List<QFilter> gridQFilters) {
        this.gridQFilters = gridQFilters;
    }

    public IGetValueMode getGridFilterExecuter() {
        return this.gridFilterExecuter;
    }

    public void setGridFilterExecuter(IGetValueMode gridFilterExecuter) {
        this.gridFilterExecuter = gridFilterExecuter;
    }

    public IGetValueMode getExpressionExecuter() {
        return this.expressionExecuter;
    }

    public void setExpressionExecuter(IGetValueMode expressionExecuter) {
        this.expressionExecuter = expressionExecuter;
    }

    public List<QFilter> getCustQFilters() {
        return this.custQFilters;
    }

    public void setCustQFilters(List<QFilter> custQFilters) {
        this.custQFilters = custQFilters;
    }

    public String getCustFilterExpression() {
        return this.custFilterExpression;
    }

    public void setCustFilterExpression(String custFilterExpression) {
        this.custFilterExpression = custFilterExpression;
    }

    public IGetValueMode getCustExpressionExecuter() {
        return this.custExpressionExecuter;
    }

    public void setCustExpressionExecuter(IGetValueMode custExpressionExecuter) {
        this.custExpressionExecuter = custExpressionExecuter;
    }

    public String getCustFilterDesc() {
        return this.custFilterDesc;
    }

    public void setCustFilterDesc(String custFilterDesc) {
        this.custFilterDesc = custFilterDesc;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFullExpression() {
        return this.fullExpression;
    }

    public void setFullExpression(String fullExpression) {
        this.fullExpression = fullExpression;
    }

    public List<IVariableMode> getVars() {
        return this.vars;
    }

    public void setVars(List<IVariableMode> vars) {
        this.vars = vars;
    }

    public void setSubCondCompilers(List<SyncConditionCompiler> subCondCompilers) {
        this.subCondCompilers = subCondCompilers;
    }
}

