/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.cal.opplugin.bizgroup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BizGroupSettingSaveOp
extends AbstractOperationServicePlugIn {
    public static final String MULBILL_TYPE = "A";
    public static final String KEY_GROUPBILLENTRY = "groupbillentry";
    public static final String KEY_RELATIONENTRY = "relationentry";
    public static final String[] CALFIELDS = new String[]{"billno", "bookdate", "bizdate", "material", "owner", "baseqty"};
    private static final String TEXT_CASEWHEN = " case when %s is not null and %s <> '' and %s <> ' ' then %s else %s end ";
    private static final String BASEDATA_CASEWHEN = " case when %s is not null and %s <> 0L then %s else %s end ";
    private static final String OTHER_CASEWHEN = " case when %s is not null then %s else %s end ";
    private static final String TO_CHAR_FMT = "TOCHAR(%s) as %s";
    public static final String SRC_TYPE = "0";
    public static final String DEST_TYPE = "1";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("grouptype");
        e.getFieldKeys().add("formid");
        e.getFieldKeys().add("fieldkey0");
        e.getFieldKeys().add("fieldkey1");
        e.getFieldKeys().add("fieldkey2");
        e.getFieldKeys().add("fieldkey3");
        e.getFieldKeys().add("fieldkey4");
        e.getFieldKeys().add("relfield");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("selfield");
        e.getFieldKeys().add("text2long");
        e.getFieldKeys().add("filterjson_tag");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection groupbillEntry = dataEntity.getDynamicObjectCollection(KEY_GROUPBILLENTRY);
            if (groupbillEntry == null || groupbillEntry.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6210\u7ec4\u5355\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BizGroupSettingSaveOp_0", (String)"scmc-im-cal", (Object[])new Object[0]));
            }
            String grouptype = dataEntity.getString("grouptype");
            if (MULBILL_TYPE.equals(grouptype)) {
                Set<String> formids = this.getAllFormid(dataEntities);
                Map<String, MainEntityType> entityTypeMap = this.getMainEntityTypeMap(formids);
                Map<String, String> formid2EntryKeyMap = this.getFormid2EntryKeyMap(entityTypeMap);
                Map<String, String> selectMap = this.getSelectMap(formids, entityTypeMap, formid2EntryKeyMap);
                this.setRelField(dataEntity, entityTypeMap, formid2EntryKeyMap, selectMap);
                continue;
            }
            this.setSrcTarType(dataEntity);
        }
    }

    private Map<String, MainEntityType> getMainEntityTypeMap(Set<String> formids) {
        HashMap<String, MainEntityType> map = new HashMap<String, MainEntityType>(4);
        for (String formid : formids) {
            map.put(formid, EntityMetadataCache.getDataEntityType((String)formid));
        }
        return map;
    }

    private Map<String, String> getFormid2EntryKeyMap(Map<String, MainEntityType> entityTypeMap) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        block0: for (Map.Entry<String, MainEntityType> mapEntry : entityTypeMap.entrySet()) {
            String formid = mapEntry.getKey();
            MainEntityType bizEntityType = mapEntry.getValue();
            IDataEntityProperty materialPro = bizEntityType.findProperty("material");
            if (materialPro != null && materialPro.getParent() instanceof EntryType && !(materialPro.getParent() instanceof LinkEntryType) && !(materialPro.getParent() instanceof SubEntryType)) {
                IDataEntityType parent = materialPro.getParent();
                map.put(formid, parent.getName());
                continue;
            }
            for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
                EntityType entityType = (EntityType)entryItem.getValue();
                if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
                map.put(formid, entityType.getName());
                continue block0;
            }
        }
        return map;
    }

    private Map<String, String> getSelectMap(Set<String> formids, Map<String, MainEntityType> entityTypeMap, Map<String, String> formid2EntryKeyMap) {
        QFilter filter = new QFilter("sourcebill", "in", formids);
        filter.and("enable", "=", (Object)DEST_TYPE);
        filter.and("fieldmap.calfield", "in", (Object)CALFIELDS);
        HashMap<String, Set> sourceFieldMap = new HashMap<String, Set>(16);
        HashMap<String, IDataEntityProperty> sourceFieldTypeMap = new HashMap<String, IDataEntityProperty>(16);
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cal_calbillrule", (String)"sourcebill,fieldmap.calfield,fieldmap.sourcefield", (QFilter[])filter.toArray(), (String)"calbill");
        Object object = null;
        try {
            for (Row row : ds) {
                String sourcebill = row.getString("sourcebill");
                if (StringUtils.isEmpty((String)sourcebill)) continue;
                String calfield = row.getString("fieldmap.calfield");
                String sourcefield = row.getString("fieldmap.sourcefield");
                MainEntityType mainEntityType = entityTypeMap.get(sourcebill);
                if ("material1.masterid".equals(sourcefield) && mainEntityType.findProperty("materialmasterid1") != null) {
                    sourcefield = "materialmasterid1";
                } else if ("material.masterid".equals(sourcefield) && mainEntityType.findProperty("materialmasterid") != null) {
                    sourcefield = "materialmasterid";
                }
                IDataEntityProperty property = mainEntityType.findProperty(sourcefield.split("\\.")[0]);
                if (property == null) continue;
                IDataEntityType parentType = property.getParent();
                String entryKey = formid2EntryKeyMap.get(sourcebill);
                if (parentType instanceof SubEntryType) continue;
                if (parentType instanceof EntryType) {
                    sourcefield = entryKey + "." + sourcefield;
                }
                String key = sourcebill + "#" + calfield;
                Set sourceFullFields = sourceFieldMap.computeIfAbsent(key, k -> new LinkedHashSet(16));
                sourceFullFields.add(sourcefield);
                sourceFieldTypeMap.put(key, property);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        for (Map.Entry entry : sourceFieldMap.entrySet()) {
            String select;
            String key = (String)entry.getKey();
            Set sourceFullFields = (Set)entry.getValue();
            String[] sourceFullFieldArr = sourceFullFields.toArray(new String[0]);
            if (sourceFullFields.size() == 1) {
                resultMap.put(key, sourceFullFieldArr[0]);
                continue;
            }
            IDataEntityProperty type = (IDataEntityProperty)sourceFieldTypeMap.get(key);
            if (type instanceof TextProp) {
                select = String.format(TEXT_CASEWHEN, sourceFullFieldArr[0], sourceFullFieldArr[0], sourceFullFieldArr[0], sourceFullFieldArr[0], sourceFullFieldArr[1]);
                resultMap.put(key, select);
                continue;
            }
            if (type instanceof BasedataProp) {
                select = String.format(BASEDATA_CASEWHEN, sourceFullFieldArr[0], sourceFullFieldArr[0], sourceFullFieldArr[0], sourceFullFieldArr[1]);
                resultMap.put(key, select);
                continue;
            }
            select = String.format(OTHER_CASEWHEN, sourceFullFieldArr[0], sourceFullFieldArr[0], sourceFullFieldArr[1]);
            resultMap.put(key, select);
        }
        return resultMap;
    }

    private Set<String> getAllFormid(DynamicObject[] dataEntities) {
        HashSet<String> formids = new HashSet<String>(16);
        int srcSize = 0;
        int destSiz = 0;
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection groupbillEntry = dataEntity.getDynamicObjectCollection(KEY_GROUPBILLENTRY);
            for (int i = 0; i < groupbillEntry.size(); ++i) {
                DynamicObject groupbill = (DynamicObject)groupbillEntry.get(i);
                DynamicObject formid = groupbill.getDynamicObject("formid");
                if (formid == null) continue;
                formids.add(formid.getString("id"));
                String type = groupbill.getString("type");
                if (SRC_TYPE.equals(type)) {
                    ++srcSize;
                } else if (DEST_TYPE.equals(type)) {
                    ++destSiz;
                }
                String filterjson_tag = groupbill.getString("filterjson_tag");
                this.isEmptyValidate(formid, filterjson_tag);
            }
        }
        if (srcSize > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u4e0d\u5141\u8bb8\u6709\u591a\u884c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizGroupSettingSaveOp_1", (String)"scmc-im-cal", (Object[])new Object[0]));
        }
        if (srcSize == 0 || destSiz == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u6e90\u5355\u548c\u76ee\u6807\u5355\u3002", (String)"BizGroupSettingSaveOp_2", (String)"scmc-im-cal", (Object[])new Object[0]));
        }
        return formids;
    }

    private void isEmptyValidate(DynamicObject formid, String filterjson_tag) {
        if (!StringUtils.isEmpty((String)filterjson_tag)) {
            String entity = (String)formid.getPkValue();
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterjson_tag, FilterCondition.class);
            MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            if (qFilter != null) {
                return;
            }
        }
        String msg = ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizGroupSettingSaveOp_6", (String)"scmc-im-cal", (Object[])new Object[0]);
        throw new KDBizException(msg);
    }

    private void setSrcTarType(DynamicObject dataEntity) {
        DynamicObjectCollection groupBillEntrys = dataEntity.getDynamicObjectCollection(KEY_GROUPBILLENTRY);
        HashSet<String> formids = new HashSet<String>(16);
        for (DynamicObject groupBillEntry : groupBillEntrys) {
            groupBillEntry.set("type", (Object)"2");
            if (formids.add(groupBillEntry.getString("formid.id"))) continue;
            String msg = ResManager.loadKDString((String)"\u201c%s\u201d\u4e1a\u52a1\u5bf9\u8c61\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizGroupSettingSaveOp_5", (String)"scmc-im-cal", (Object[])new Object[0]);
            msg = String.format(msg, groupBillEntry.getString("formid.name"));
            throw new KDBizException(msg);
        }
    }

    private void setRelField(DynamicObject dataEntity, Map<String, MainEntityType> entityTypeMap, Map<String, String> formid2EntryKeyMap, Map<String, String> selectMap) {
        String formid;
        DynamicObject groupbill;
        int i;
        DynamicObjectCollection groupbillEntry = dataEntity.getDynamicObjectCollection(KEY_GROUPBILLENTRY);
        DynamicObjectCollection relationEntry = dataEntity.getDynamicObjectCollection(KEY_RELATIONENTRY);
        int size = relationEntry.size();
        if (size == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5173\u8054\u5173\u7cfb\u3002", (String)"BizGroupSettingSaveOp_3", (String)"scmc-im-cal", (Object[])new Object[0]));
        }
        ArrayList<Boolean> containTextList = new ArrayList<Boolean>(8);
        for (i = 0; i < size; ++i) {
            containTextList.add(Boolean.FALSE);
        }
        for (i = 0; i < groupbillEntry.size(); ++i) {
            groupbill = (DynamicObject)groupbillEntry.get(i);
            formid = groupbill.getString("formid.id");
            if (StringUtils.isEmpty((String)formid)) continue;
            MainEntityType entityType = entityTypeMap.get(formid);
            for (int j = 0; j < size; ++j) {
                String fieldkey = ((DynamicObject)relationEntry.get(j)).getString("fieldkey" + i);
                if (StringUtils.isEmpty((String)fieldkey)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5173\u8054\u5173\u7cfb\u5b57\u6bb5\uff0c\u6216\u8005\u5220\u6389\u7a7a\u767d\u7684\u5173\u8054\u5173\u7cfb\u884c\u3002", (String)"BizGroupSettingSaveOp_4", (String)"scmc-im-cal", (Object[])new Object[0]));
                }
                boolean isStrType = entityType.findProperty(fieldkey) instanceof TextProp;
                containTextList.set(j, (Boolean)containTextList.get(j) != false || isStrType);
            }
        }
        for (i = 0; i < groupbillEntry.size(); ++i) {
            groupbill = (DynamicObject)groupbillEntry.get(i);
            formid = groupbill.getString("formid.id");
            if (StringUtils.isEmpty((String)formid)) continue;
            String selectField = this.getSelectFields(groupbill, formid2EntryKeyMap, selectMap);
            MainEntityType entityType = entityTypeMap.get(formid);
            String entryKey = formid2EntryKeyMap.get(formid);
            ArrayList<String> relfields = new ArrayList<String>(16);
            ArrayList<String> selectFields = new ArrayList<String>(8);
            ArrayList<String> text2LongFields = new ArrayList<String>(8);
            selectFields.add(selectField);
            for (int j = 0; j < size; ++j) {
                String fieldkey = ((DynamicObject)relationEntry.get(j)).getString("fieldkey" + i);
                if (!StringUtils.isNotEmpty((String)fieldkey)) continue;
                String fullFieldKey = this.getFullField(entryKey, fieldkey, entityType);
                relfields.add(fullFieldKey);
                if (((Boolean)containTextList.get(j)).booleanValue() && (entityType.findProperty(fieldkey) instanceof BigIntProp || entityType.findProperty(fieldkey) instanceof LongProp)) {
                    selectFields.add(String.format(TO_CHAR_FMT, fullFieldKey, fullFieldKey));
                    text2LongFields.add(fullFieldKey);
                    continue;
                }
                selectFields.add(fullFieldKey);
            }
            groupbill.set("relfield", (Object)String.join((CharSequence)",", relfields));
            groupbill.set("selfield", (Object)String.join((CharSequence)",", selectFields));
            groupbill.set("text2long", (Object)String.join((CharSequence)",", text2LongFields));
        }
    }

    private String getSelectFields(DynamicObject groupbill, Map<String, String> formid2EntryKeyMap, Map<String, String> selectMap) {
        String formid = groupbill.getString("formid.id");
        String entryKey = formid2EntryKeyMap.get(formid);
        String type = groupbill.getString("type");
        String prefix = "src_";
        if (DEST_TYPE.equals(type)) {
            prefix = "dest_";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("id as ");
        builder.append(prefix);
        builder.append("bizbillid,");
        builder.append(entryKey);
        builder.append(".id as ");
        builder.append(prefix);
        builder.append("bizentryid,");
        builder.append(selectMap.get(formid + "#billno"));
        builder.append(" as ");
        builder.append(prefix);
        builder.append("billno,");
        builder.append(selectMap.get(formid + "#bookdate"));
        builder.append(" as ");
        builder.append(prefix);
        builder.append("bookdate,");
        builder.append(selectMap.get(formid + "#bizdate"));
        builder.append(" as ");
        builder.append(prefix);
        builder.append("bizdate,");
        builder.append(selectMap.get(formid + "#material"));
        builder.append(" as ");
        builder.append(prefix);
        builder.append("material,");
        builder.append(selectMap.get(formid + "#owner"));
        builder.append(" as ");
        builder.append(prefix);
        builder.append("owner,");
        builder.append(selectMap.get(formid + "#baseqty"));
        builder.append(" as ");
        builder.append(prefix);
        builder.append("baseqty,");
        builder.append("'");
        builder.append(formid);
        builder.append("'");
        builder.append(" as ");
        builder.append(prefix);
        builder.append("formid,");
        builder.append("ischargeoffed as ");
        builder.append(prefix);
        builder.append("ischargeoffed,");
        if ("im_transinbill".equals(formid)) {
            builder.append("billentry.isovertrans");
            builder.append(" as ");
            builder.append(prefix);
            builder.append("islastentry");
        } else {
            builder.append("'0' as ");
            builder.append(prefix);
            builder.append("islastentry");
        }
        return builder.toString();
    }

    private String getFullField(String entryKey, String fieldkey, MainEntityType mainEntityType) {
        IDataEntityProperty bizEntity = mainEntityType.findProperty(fieldkey.split("\\.")[0]);
        IDataEntityType parentyCalEntity = bizEntity.getParent();
        StringBuilder fullField = new StringBuilder();
        if (parentyCalEntity instanceof SubEntryType) {
            fullField.append(entryKey);
            fullField.append(".");
            fullField.append(parentyCalEntity.getName());
            fullField.append(".");
            fullField.append(fieldkey);
        } else if (parentyCalEntity instanceof EntryType) {
            fullField.append(parentyCalEntity.getName());
            fullField.append(".");
            fullField.append(fieldkey);
        } else {
            fullField.append(fieldkey);
        }
        return fullField.toString();
    }
}

