/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.botp.mdc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.common.mdc.consts.PrecisionAccountEnum;

public class MdcReApplyToOrderConvertPlugin
extends AbstractConvertPlugIn {
    private Map<Long, Integer> unitPrecisionCache = new HashMap<Long, Integer>();

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        HashMap<String, DynamicObject> outInvStatusEntryMap = new HashMap<String, DynamicObject>(16);
        ArrayList<DynamicObject> defaultStatus = new ArrayList<DynamicObject>(16);
        this.setOutOwnerType(billDataEntitys);
        if ("im_mdc_omreturnbill".equals(tgtMainType)) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            DynamicObjectCollection rows = extendedDataEntity.getDataEntity().getDynamicObjectCollection("billentry");
            ArrayList<DynamicObject> tgtList = new ArrayList<DynamicObject>(rows.getRowCount());
            for (DynamicObject row : rows) {
                this.oneToMany(row, tgtList);
            }
            if (tgtList.size() <= 0) continue;
            rows.clear();
            this.setOutInvStatus(outInvStatusEntryMap, defaultStatus, extendedDataEntity, tgtList);
            tgtList.forEach(tgt -> rows.add(tgt));
        }
    }

    private void setOutOwnerType(ExtendedDataEntity[] billDataEntitys) {
        ArrayList<Long> stockEntryIds = new ArrayList<Long>(16);
        HashMap<Long, String> stockEntryIdAndSupplyMode = new HashMap<Long, String>(16);
        HashMap invSchemeIdAndOutOwnerType = new HashMap(16);
        List<Object> invSchemeIds = this.assSupplyMode(stockEntryIds, stockEntryIdAndSupplyMode, billDataEntitys);
        DynamicObjectCollection invSchemeDynColl = QueryServiceHelper.query((String)"im_invscheme", (String)"id,outinvtypeentry.outinvtype,outinvtypeentry.outownertype1,outinvtypeentry.outkeepertype1", (QFilter[])new QFilter[]{new QFilter("id", "in", invSchemeIds)});
        for (DynamicObject invSchemeDyn : invSchemeDynColl) {
            Object invSchemeId = invSchemeDyn.get("id");
            HashMap<String, String> tmpMap = new HashMap<String, String>(16);
            Object outinvtype = invSchemeDyn.get("outinvtypeentry.outinvtype");
            tmpMap.put("outownertype1", invSchemeDyn.getString("outinvtypeentry.outownertype1"));
            tmpMap.put("outkeepertype1", invSchemeDyn.getString("outinvtypeentry.outkeepertype1"));
            invSchemeIdAndOutOwnerType.put(invSchemeId + "_" + MdcReApplyToOrderConvertPlugin.getDyObjId(outinvtype), tmpMap);
        }
        for (ExtendedDataEntity mftProOrder : billDataEntitys) {
            DynamicObject mftProOrderDyn = mftProOrder.getDataEntity();
            DynamicObject invScheme = mftProOrderDyn.getDynamicObject("invscheme");
            Object invSchemeId = invScheme.get("id");
            DynamicObjectCollection billEntry = mftProOrderDyn.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billEntry) {
                Object outinvType = entry.get("outinvtype");
                Long outinvTypeId = MdcReApplyToOrderConvertPlugin.getDyObjId(outinvType);
                DynamicObjectCollection outInvTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
                for (DynamicObject dyn : outInvTypeEntry) {
                    Object outinvtype = dyn.get("outinvtype");
                    Long dyObjId = MdcReApplyToOrderConvertPlugin.getDyObjId(outinvtype);
                    Map outInvTypeMap = (Map)invSchemeIdAndOutOwnerType.get(invSchemeId + "_" + dyObjId);
                    String outOwnerType = (String)outInvTypeMap.get("outownertype1");
                    String outKeeperType = (String)outInvTypeMap.get("outkeepertype1");
                    if (dyObjId == null || !dyObjId.equals(outinvTypeId) || "".equals(outOwnerType) || "".equals(outKeeperType)) continue;
                    entry.set("outownertype", (Object)outOwnerType);
                    entry.set("outkeepertype", (Object)outKeeperType);
                }
            }
        }
    }

    private List<Object> assSupplyMode(List<Long> stockEntryIds, Map<Long, String> stockEntryIdAndSupplyMode, ExtendedDataEntity[] mftProOrders) {
        ArrayList<Object> invSchemeIds = new ArrayList<Object>(16);
        for (ExtendedDataEntity mftStockOrder : mftProOrders) {
            DynamicObject mftStockOrderDyn = mftStockOrder.getDataEntity();
            Object invScheme = mftStockOrderDyn.get("invscheme");
            invSchemeIds.add(MdcReApplyToOrderConvertPlugin.getDyObjId(invScheme));
            DynamicObjectCollection billentry = mftStockOrderDyn.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                Long srcBillEntryid = entry.getLong("srcbillentryid");
                stockEntryIds.add(srcBillEntryid);
            }
        }
        QFilter qFilter = new QFilter("billentry.id", "in", stockEntryIds);
        DynamicObjectCollection mftStockDynColl = QueryServiceHelper.query((String)"im_mdc_mftreturnapplybill", (String)"billentry,billentry.id, billentry.supplymode", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject mftStockDyn : mftStockDynColl) {
            Long stockEntryId = mftStockDyn.getLong("billentry.id");
            String supplyMode = mftStockDyn.getString("billentry.supplymode");
            stockEntryIdAndSupplyMode.put(stockEntryId, supplyMode);
        }
        return invSchemeIds;
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }

    private void setOutInvStatus(Map<String, DynamicObject> outInvStatusEntryMap, List<DynamicObject> defaultStatus, ExtendedDataEntity extendedDataEntity, List<DynamicObject> tgtList) {
        DynamicObject invscheme = (DynamicObject)extendedDataEntity.getValue("invscheme");
        DynamicObjectCollection outInvStatusEntry = invscheme.getDynamicObjectCollection("outinvstatusentry");
        for (DynamicObject dyn : outInvStatusEntry) {
            DynamicObject outinvstatus = dyn.getDynamicObject("outinvstatus");
            Boolean outinvstatusisdefault = dyn.getBoolean("outinvstatusisdefault");
            if (outinvstatusisdefault.booleanValue()) {
                defaultStatus.add(outinvstatus);
            }
            outInvStatusEntryMap.put(outinvstatus.getString("number"), outinvstatus);
        }
        for (DynamicObject tgt : tgtList) {
            DynamicObject outStatus;
            String returnmaterialtype = tgt.getString("returnmaterialtype");
            if ("A".equals(returnmaterialtype)) {
                outStatus = outInvStatusEntryMap.get("110");
                if (outStatus != null) {
                    tgt.set("outinvstatus", (Object)outStatus);
                    continue;
                }
                tgt.set("outinvstatus", (Object)defaultStatus.get(0));
                continue;
            }
            outStatus = outInvStatusEntryMap.get("115");
            if (outStatus != null) {
                tgt.set("outinvstatus", (Object)outStatus);
                continue;
            }
            tgt.set("outinvstatus", (Object)defaultStatus.get(0));
        }
    }

    private void oneToMany(DynamicObject inWareRow, List<DynamicObject> tgtList) {
        Long srcbillentryid = inWareRow.getLong("srcbillentryid");
        String srcBillEntry = inWareRow.getString("srcbillentity");
        DynamicObject material = inWareRow.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterId = material.getDynamicObject("masterid");
        inWareRow.set("unit", (Object)material.getDynamicObject("inventoryunit"));
        if (masterId.getDynamicObject("auxptyunit") != null) {
            inWareRow.set("unit2nd", (Object)masterId.getDynamicObject("auxptyunit"));
        }
        DynamicObject unit = inWareRow.getDynamicObject("unit");
        DynamicObject baseunit = inWareRow.getDynamicObject("baseunit");
        DynamicObject unit2nd = inWareRow.getDynamicObject("unit2nd");
        if (baseunit == null) {
            baseunit = masterId.getDynamicObject("baseunit");
            inWareRow.set("baseunit", (Object)baseunit);
        }
        if (0L == srcbillentryid) {
            return;
        }
        QFilter qFilter = new QFilter("billentry.id", "=", (Object)srcbillentryid);
        DynamicObject srcbillentry = BusinessDataServiceHelper.loadSingle((String)"im_mdc_mftreturnapplybill", (String)this.getReApplySelectFields(), (QFilter[])new QFilter[]{qFilter});
        if (srcbillentry != null) {
            DynamicObjectCollection reportBillEntrys = srcbillentry.getDynamicObjectCollection("billentry");
            for (DynamicObject reportEntry : reportBillEntrys) {
                BigDecimal poworkbaseqty;
                BigDecimal poincbaseqty;
                BigDecimal unit2ndQty;
                BigDecimal qty;
                BigDecimal baseQty;
                Long sumentryId = reportEntry.getLong("id");
                if (sumentryId == 0L || !srcbillentryid.equals(sumentryId)) continue;
                boolean checkback = reportEntry.getBoolean("checkback");
                BigDecimal auditbaseqty = reportEntry.getBigDecimal("auditbaseqty");
                BigDecimal outbaseqty = reportEntry.getBigDecimal("outbaseqty");
                if (!checkback) {
                    DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                    tempRow.set("returnmaterialtype", (Object)"A");
                    BigDecimal bsqty = auditbaseqty.subtract(outbaseqty);
                    BigDecimal baseQty2 = this.processPrecision(bsqty, baseunit);
                    tempRow.set("baseqty", (Object)baseQty2);
                    BigDecimal qty2 = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty2, masterId.getLong("id"), unit.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                    tempRow.set("qty", (Object)qty2);
                    if (unit2nd != null) {
                        BigDecimal unit2ndQty2 = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty2, masterId.getLong("id"), unit2nd.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                        tempRow.set("qtyunit2nd", (Object)unit2ndQty2);
                    }
                    tgtList.add(tempRow);
                    continue;
                }
                BigDecimal gdbaseqty = reportEntry.getBigDecimal("gdbaseqty");
                BigDecimal coaccpbaseqty = reportEntry.getBigDecimal("coaccpbaseqty");
                if (gdbaseqty.compareTo(BigDecimal.ZERO) > 0 || coaccpbaseqty.compareTo(BigDecimal.ZERO) > 0) {
                    DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                    BigDecimal bsqty = gdbaseqty.add(coaccpbaseqty);
                    baseQty = this.processPrecision(bsqty, baseunit);
                    tempRow.set("baseqty", (Object)baseQty);
                    qty = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty, masterId.getLong("id"), unit.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                    tempRow.set("qty", (Object)qty);
                    if (unit2nd != null) {
                        unit2ndQty = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty, masterId.getLong("id"), unit2nd.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                        tempRow.set("qtyunit2nd", (Object)unit2ndQty);
                    }
                    tempRow.set("returnmaterialtype", (Object)"A");
                    tgtList.add(tempRow);
                }
                if ((poincbaseqty = reportEntry.getBigDecimal("poincbaseqty")).compareTo(BigDecimal.ZERO) > 0) {
                    DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                    baseQty = this.processPrecision(poincbaseqty, baseunit);
                    tempRow.set("baseqty", (Object)baseQty);
                    qty = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty, masterId.getLong("id"), unit.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                    tempRow.set("qty", (Object)qty);
                    if (unit2nd != null) {
                        unit2ndQty = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty, masterId.getLong("id"), unit2nd.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                        tempRow.set("qtyunit2nd", (Object)unit2ndQty);
                    }
                    tempRow.set("returnmaterialtype", (Object)"B");
                    tgtList.add(tempRow);
                }
                if ((poworkbaseqty = reportEntry.getBigDecimal("poworkbaseqty")).compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject tempRow = (DynamicObject)OrmUtils.clone((IDataEntityBase)inWareRow, (boolean)false, (boolean)true);
                BigDecimal baseQty3 = this.processPrecision(poworkbaseqty, baseunit);
                tempRow.set("baseqty", (Object)this.processPrecision(poworkbaseqty, baseunit));
                BigDecimal qty3 = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty3, masterId.getLong("id"), unit.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                tempRow.set("qty", (Object)qty3);
                if (unit2nd != null) {
                    BigDecimal unit2ndQty3 = MdcReApplyToOrderConvertPlugin.calculateQtyByBaseQty(baseQty3, masterId.getLong("id"), unit2nd.getLong("id"), baseunit.getLong("id"), this.unitPrecisionCache);
                    tempRow.set("qtyunit2nd", (Object)unit2ndQty3);
                }
                tempRow.set("returnmaterialtype", (Object)"C");
                tgtList.add(tempRow);
            }
        }
    }

    public static BigDecimal calculateQtyByBaseQty(BigDecimal matchBaseQty, long materialId, long unitId, long baseUnitId, Map<Long, Integer> unitPrecisionCache) {
        int unitPrecision = MdcReApplyToOrderConvertPlugin.getUnitPrecision(unitId, unitPrecisionCache);
        BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)materialId, (Long)unitId, (Long)baseUnitId);
        if (unitRate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return matchBaseQty.divide(unitRate, unitPrecision, RoundingMode.HALF_UP);
    }

    public static int getUnitPrecision(Long unitId, Map<Long, Integer> unitPrecisionCache) {
        if (unitId == null) {
            return 10;
        }
        if (!unitPrecisionCache.containsKey(unitId)) {
            DynamicObject unit = BusinessDataServiceHelper.loadSingleFromCache((Object)unitId, (String)"bd_measureunits", (String)"precision");
            if (unit != null) {
                unitPrecisionCache.put(unitId, unit.getInt("precision"));
            } else {
                unitPrecisionCache.put(unitId, 10);
            }
        }
        return unitPrecisionCache.get(unitId);
    }

    private String getReApplySelectFields() {
        StringBuilder sql = new StringBuilder();
        sql.append("billentry").append(',');
        sql.append("billentry.id").append(',');
        sql.append("billentry.checkback").append(',');
        sql.append("billentry.auditbaseqty").append(',');
        sql.append("billentry.outbaseqty").append(',');
        sql.append("billentry.gdbaseqty").append(',');
        sql.append("billentry.coaccpbaseqty").append(',');
        sql.append("billentry.poincbaseqty").append(',');
        sql.append("billentry.poworkbaseqty");
        return sql.toString();
    }

    private BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null || baseunit == null || masterid == null) {
            return BigDecimal.ZERO;
        }
        return UnitConvertHelper.calculateNewQty((BigDecimal)baseqty, (Long)((Long)unit.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)masterid.getPkValue()), (StringBuilder)new StringBuilder());
    }

    private BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        String precisionAccount = unit.getString("precisionaccount");
        return qty.setScale(precision, PrecisionAccountEnum.getEnumByVal(Integer.parseInt(precisionAccount)));
    }
}

