/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.business.mdc.backflush;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.model.MftStockEntryBFModel;
import kd.scmc.im.common.mdc.utils.AppParameterUtils;

public class TailDiffBackFlush {
    private static final Log logger = LogFactory.getLog(TailDiffBackFlush.class);
    private Map<Long, BigDecimal> mSrcBillBaseQtyMap = new HashMap<Long, BigDecimal>(16);
    private Map<Long, Map<String, Object>> mAppParam = new HashMap<Long, Map<String, Object>>(16);
    private Map<String, String> mReflectInfoMap = new HashMap<String, String>(16);
    private String mStockName = "";

    public TailDiffBackFlush(String stockName, Map<String, String> reflectInfoMap) {
        this.mStockName = stockName;
        this.mReflectInfoMap = reflectInfoMap;
    }

    public void caleAutoNowbfqtyTailDiff(ThreadLocal<Map<Long, List<Map<String, Object>>>> srcBillRowMap, Map<String, Object> judgeResult, HashMap<String, Object> judgeParam) {
        logger.info("caleAutoNowbfqtyTailDiff begin");
        logger.info(String.format("judgeResult=%s;judgeParam=%s;mStockName=%s", judgeResult, judgeParam, this.mStockName));
        DynamicObject mftstockEntryObj = (DynamicObject)judgeParam.get("mftstockEntryObj");
        Long mftentryid = 0L;
        DynamicObject orgscObj = null;
        if (mftstockEntryObj != null) {
            DynamicObject mftStock = (DynamicObject)mftstockEntryObj.getParent();
            mftentryid = (Long)mftStock.get("orderentryid.id");
            orgscObj = mftStock.getDynamicObject("org");
        }
        boolean isPass = (Boolean)judgeResult.get("isPass");
        if (orgscObj == null || !isPass) {
            return;
        }
        Map<String, Object> appParams = this.getAppParameterByOrg((Long)orgscObj.getPkValue(), this.mStockName);
        Boolean isadjustbf = appParams.get("isadjustbf") == null ? Boolean.FALSE : (Boolean)appParams.get("isadjustbf");
        Integer adjustbfcoeInt = appParams.get("adjustbfcoe") == null ? Integer.valueOf(1) : (Integer)appParams.get("adjustbfcoe");
        logger.info(String.format("isadjustbf=%s;adjustbfcoeInt=%s", isadjustbf, adjustbfcoeInt));
        if (!isadjustbf.booleanValue()) {
            return;
        }
        Map<String, String> reflectInfoMap = this.mReflectInfoMap;
        if (reflectInfoMap.size() <= 0) {
            return;
        }
        BigDecimal srcBillBaseQtyTotal = this.mSrcBillBaseQtyMap.get(mftentryid);
        if (srcBillBaseQtyTotal == null) {
            HashSet<Long> orderentryidSet = new HashSet<Long>(1);
            orderentryidSet.add(mftentryid);
            Map<Long, BigDecimal> srcBillBaseQtyTotalMap = this.getSrcBFBillBaseQty(orderentryidSet, reflectInfoMap, srcBillRowMap.get());
            srcBillBaseQtyTotal = srcBillBaseQtyTotalMap.get(mftentryid);
            this.mSrcBillBaseQtyMap.put(mftentryid, srcBillBaseQtyTotal);
        }
        if (srcBillBaseQtyTotal == null) {
            srcBillBaseQtyTotal = BigDecimal.ZERO;
        }
        BigDecimal unclaimedQty = mftstockEntryObj.getBigDecimal("cansendqty");
        BigDecimal productQty = (BigDecimal)judgeParam.get("baseQty");
        BigDecimal canbfqty = (BigDecimal)judgeResult.get("qualitydefault");
        BigDecimal nowbfqty = null;
        DynamicObject materialunitidObj = mftstockEntryObj.getDynamicObject("materialunitid");
        logger.info(String.format("canbfqty=%s;unclaimedQty=%s;srcBillBaseQtyTotal=%s;productQty=%s", canbfqty, unclaimedQty, srcBillBaseQtyTotal, productQty));
        if (canbfqty.compareTo(unclaimedQty) > 0 && unclaimedQty.compareTo(BigDecimal.ZERO) > 0 && srcBillBaseQtyTotal.compareTo(productQty) <= 0) {
            nowbfqty = unclaimedQty;
        } else if (canbfqty.compareTo(unclaimedQty) < 0 && unclaimedQty.compareTo(BigDecimal.ZERO) > 0 && srcBillBaseQtyTotal.compareTo(productQty) >= 0) {
            Integer precisInt = materialunitidObj.getInt("precision");
            BigDecimal difValX = unclaimedQty.subtract(canbfqty);
            BigDecimal res = difValX.multiply(BigDecimal.valueOf(Math.pow(10.0, precisInt.intValue()))).subtract(new BigDecimal(adjustbfcoeInt));
            if (res.compareTo(BigDecimal.ZERO) <= 0) {
                nowbfqty = unclaimedQty;
            }
        }
        if (nowbfqty != null) {
            judgeResult.put("qualitydefault", nowbfqty);
            logger.info(String.format("qualitydefault:%s", nowbfqty));
        }
        logger.info("caleAutoNowbfqtyTailDiff end");
    }

    private Set<Long> getOrderEntryIDTailDiffDF(List<DynamicObject> billEntryList) {
        Set<Long> orderentryids = billEntryList.stream().map(p -> p.getDynamicObject("orderentryid").getLong("id")).collect(Collectors.toSet());
        List orgIdLst = billEntryList.stream().filter(p -> p.getDynamicObject("orgsc") != null).map(p -> p.getDynamicObject("orgsc").getLong("id")).collect(Collectors.toList());
        int orgMeetCount = 0;
        for (Long orgId : orgIdLst) {
            Map<String, Object> appParams = this.getAppParameterByOrg(orgId, this.mStockName);
            Boolean isadjustbf = appParams.get("isadjustbf") == null ? Boolean.FALSE : (Boolean)appParams.get("isadjustbf");
            if (!isadjustbf.booleanValue()) continue;
            ++orgMeetCount;
        }
        if (orgMeetCount <= 0) {
            orderentryids.clear();
        }
        return orderentryids;
    }

    public void caleNowbfqtyTailDiff(List<DynamicObject> billEntryList) {
        HashMap<Long, MftStockEntryBFModel> mftstockMap = new HashMap<Long, MftStockEntryBFModel>(16);
        Map<String, String> reflectInfoMap = this.mReflectInfoMap;
        logger.info("caleNowbfqtyTailDiff begin");
        Set<Long> orderentryids = this.getOrderEntryIDTailDiffDF(billEntryList);
        if (orderentryids.size() <= 0) {
            return;
        }
        Map<Long, BigDecimal> srcBillBaseQtyMap = this.getSrcBFBillBaseQty(orderentryids, reflectInfoMap);
        Map<Long, List<DynamicObject>> mftStockMap = this.getMftstocks(this.mStockName, orderentryids);
        for (DynamicObject billEntry : billEntryList) {
            Integer adjustbfcoeInt;
            DynamicObject orgscObj = billEntry.getDynamicObject("orgsc");
            if (orgscObj == null) continue;
            Map<String, Object> appParams = this.getAppParameterByOrg((Long)orgscObj.getPkValue(), this.mStockName);
            Boolean isadjustbf = appParams.get("isadjustbf") == null ? Boolean.FALSE : (Boolean)appParams.get("isadjustbf");
            Integer n = adjustbfcoeInt = appParams.get("adjustbfcoe") == null ? Integer.valueOf(1) : (Integer)appParams.get("adjustbfcoe");
            if (!isadjustbf.booleanValue()) continue;
            Long mftEntryID = billEntry.getLong("orderentryid.id");
            Long stockentryID = billEntry.getLong("stockentryid");
            BigDecimal nowbfqty = billEntry.getBigDecimal("nowbfqty");
            DynamicObject materialunitidObj = billEntry.getDynamicObject("materialunitid");
            MftStockEntryBFModel mftStockModel = (MftStockEntryBFModel)mftstockMap.get(stockentryID);
            List<DynamicObject> mftStockLst = mftStockMap.get(stockentryID);
            if (mftStockModel == null) {
                mftStockModel = new MftStockEntryBFModel();
                mftStockModel.setEntryId(stockentryID);
                BigDecimal unissueqty = billEntry.getBigDecimal("unissueqty");
                mftStockModel.setUnclaimedQty(unissueqty);
                mftstockMap.put(stockentryID, mftStockModel);
            }
            if (mftStockModel == null) continue;
            BigDecimal unclaimedQty = mftStockModel.getUnclaimedQty();
            BigDecimal canbfqty = billEntry.getBigDecimal("canbfqty");
            BigDecimal srcBillBaseQtyTotal = srcBillBaseQtyMap.get(mftEntryID);
            BigDecimal productQty = null;
            if (mftStockLst != null && mftStockLst.size() > 0) {
                productQty = mftStockLst.get(0).getBigDecimal("baseqty");
            }
            if (canbfqty.compareTo(unclaimedQty) > 0 && unclaimedQty.compareTo(BigDecimal.ZERO) > 0 && srcBillBaseQtyTotal.compareTo(productQty) <= 0) {
                billEntry.set("nowbfqty", (Object)unclaimedQty);
                nowbfqty = unclaimedQty;
                logger.info(String.format("upper nowbfqty:%s", nowbfqty));
            } else if (canbfqty.compareTo(unclaimedQty) < 0 && unclaimedQty.compareTo(BigDecimal.ZERO) > 0 && srcBillBaseQtyTotal.compareTo(productQty) >= 0) {
                Integer precisInt = materialunitidObj.getInt("precision");
                BigDecimal difValX = unclaimedQty.subtract(canbfqty);
                BigDecimal res = difValX.multiply(BigDecimal.valueOf(Math.pow(10.0, precisInt.intValue()))).subtract(new BigDecimal(adjustbfcoeInt));
                if (res.compareTo(BigDecimal.ZERO) <= 0) {
                    billEntry.set("nowbfqty", (Object)unclaimedQty);
                    nowbfqty = unclaimedQty;
                    logger.info(String.format("lower nowbfqty:%s", nowbfqty));
                }
            }
            unclaimedQty = unclaimedQty.subtract(nowbfqty);
            mftStockModel.setUnclaimedQty(unclaimedQty);
        }
        logger.info("caleNowbfqtyTailDiff end");
    }

    private Map<Long, List<DynamicObject>> getMftstocks(String stockName, Set<Long> orderentryids) {
        QFilter qfilters = new QFilter("orderentryid.id", "in", orderentryids);
        DynamicObjectCollection curMftStockRows = QueryServiceHelper.query((String)stockName, (String)"orderentryid,stockentry.id,baseqty", (QFilter[])qfilters.toArray());
        Map<Long, List<DynamicObject>> curMftStockMap = curMftStockRows.stream().collect(Collectors.groupingBy(p -> p.getLong("stockentry.id")));
        return curMftStockMap;
    }

    private Map<Long, BigDecimal> getSrcBFBillBaseQty(Set<Long> orderentryids, Map<String, String> reflectInfoMap) {
        return this.getSrcBFBillBaseQty(orderentryids, reflectInfoMap, new HashMap<Long, List<Map<String, Object>>>(16));
    }

    private Map<Long, BigDecimal> getSrcBFBillBaseQty(Set<Long> orderentryids, Map<String, String> reflectInfoMap, Map<Long, List<Map<String, Object>>> srcBillRowMap) {
        logger.info("getSrcBFBillBaseQty begin");
        HashMap<Long, BigDecimal> srcMap = new HashMap<Long, BigDecimal>(16);
        if (orderentryids.size() <= 0) {
            return srcMap;
        }
        if (srcBillRowMap == null) {
            srcBillRowMap = new HashMap<Long, List<Map<String, Object>>>(16);
        }
        String sourcebillNumber = reflectInfoMap.get("sourcebillNumber");
        String mftentryidName = this.getEntryFieldFix("mftentryidName", reflectInfoMap);
        String entryIdName = this.getEntryFieldFix("entryIdName", reflectInfoMap);
        String baseqtyName = this.getEntryFieldFix("baseqtyName", reflectInfoMap);
        QFilter qFilters = new QFilter(mftentryidName, "in", orderentryids);
        String mftentryidType = reflectInfoMap.get("mftentryidType");
        if (StringUtils.equalsIgnoreCase((CharSequence)mftentryidType, (CharSequence)"String")) {
            Set orderentryidStrs = orderentryids.stream().map(Object::toString).collect(Collectors.toSet());
            qFilters = new QFilter(mftentryidName, "in", orderentryidStrs);
        }
        QFilter qfStatus = new QFilter("billstatus", "=", (Object)"C");
        if (srcBillRowMap.size() > 0) {
            qfStatus = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        }
        qFilters.and(qfStatus);
        StringBuilder sbStr = new StringBuilder();
        sbStr.append(mftentryidName);
        sbStr.append(",");
        sbStr.append(entryIdName);
        sbStr.append(",");
        sbStr.append(baseqtyName);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)sourcebillNumber, (String)sbStr.toString(), (QFilter[])new QFilter[]{qFilters});
        Map<Long, List<DynamicObject>> mftRowsGrp = rows.stream().collect(Collectors.groupingBy(p -> p.getLong(mftentryidName)));
        for (Map.Entry<Long, List<DynamicObject>> mftRowsE : mftRowsGrp.entrySet()) {
            List<DynamicObject> mftRows = mftRowsE.getValue();
            Long mftentryid = mftRowsE.getKey();
            BigDecimal baseQtyTotoal = BigDecimal.ZERO;
            HashSet<Long> calmftIDs = new HashSet<Long>(16);
            for (DynamicObject mftRow : mftRows) {
                Long entryId = mftRow.getLong(entryIdName);
                BigDecimal baseqty = mftRow.getBigDecimal(baseqtyName);
                baseQtyTotoal = baseQtyTotoal.add(baseqty);
                calmftIDs.add(entryId);
            }
            List<Map<String, Object>> srcBillRows = srcBillRowMap.get(mftentryid);
            if (srcBillRows != null) {
                for (Map<String, Object> srcBillRow : srcBillRows) {
                    Long entryId = (Long)srcBillRow.get("entryid");
                    if (calmftIDs.contains(entryId)) continue;
                    BigDecimal baseqty = (BigDecimal)srcBillRow.get("baseqty");
                    baseQtyTotoal = baseQtyTotoal.add(baseqty);
                }
            }
            srcMap.put(mftentryid, baseQtyTotoal);
        }
        logger.info(String.format("getSrcBFBillBaseQty orderentryids=%s;srcMap=%s;srcBillRowMap=%s", orderentryids, srcMap, srcBillRowMap));
        logger.info("getSrcBFBillBaseQty begin");
        return srcMap;
    }

    private String getEntryFieldFix(String fieldName, Map<String, String> srcReflectInfoMap) {
        String entryVal = srcReflectInfoMap.get("entryName");
        String fieldeVal = srcReflectInfoMap.get(fieldName);
        return entryVal + "." + fieldeVal;
    }

    private Map<String, Object> getAppParameterByOrg(Long orgId, String stockName) {
        Map<String, Object> curAppParam = this.mAppParam.get(orgId);
        String appId = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)stockName, (CharSequence)"om_mftstock") || StringUtils.equalsIgnoreCase((CharSequence)stockName, (CharSequence)"om_componentlist")) {
            appId = "1/OY+A2+47UY";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)stockName, (CharSequence)"pom_mftstock")) {
            appId = "064+TL0DU6T9";
        }
        if (curAppParam == null) {
            logger.info(String.format("stockName=%s;appId=%s;orgId=%s", stockName, appId, orgId));
            curAppParam = AppParameterUtils.getAppParameterMap(appId, orgId);
            if (curAppParam == null) {
                curAppParam = new HashMap<String, Object>(16);
            }
            this.mAppParam.put(orgId, curAppParam);
        }
        logger.info("getAppParameterByOrg:" + this.mAppParam);
        return curAppParam;
    }
}

