/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dlock.DLock;

public class ImLockHelper {
    public static Map<String, DLock> createDLocks(Set<String> keys, boolean isReentrant) {
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        int size = keys.size();
        HashMap<String, DLock> dLocks = new HashMap<String, DLock>(size);
        for (String key : keys) {
            DLock dLock = isReentrant ? DLock.createReentrant((String)key) : DLock.create((String)key);
            dLocks.put(key, dLock);
        }
        return dLocks;
    }

    public static Map<String, DLock> tryDLocks(Map<String, DLock> dLocks, Long timeoutMillis) {
        HashMap<String, DLock> successdLocks = new HashMap<String, DLock>(10);
        if (dLocks == null || dLocks.isEmpty()) {
            return successdLocks;
        }
        long time = timeoutMillis == null ? 30000L : timeoutMillis;
        for (Map.Entry<String, DLock> stringDLockEntry : dLocks.entrySet()) {
            DLock lock = stringDLockEntry.getValue();
            if (!lock.tryLock(time)) continue;
            successdLocks.put(stringDLockEntry.getKey(), lock);
        }
        return successdLocks;
    }

    public static void unDLocks(List<DLock> dLocks) {
        if (dLocks == null || dLocks.isEmpty()) {
            return;
        }
        for (DLock dLock : dLocks) {
            dLock.unlock();
        }
    }
}

