/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutNewHelper;
import kd.scmc.im.common.mdc.utils.StockBackFlushUtils;

public class InvMatchingRuleOutHelperNew {
    private static final Log logger = LogFactory.getLog(InvMatchingRuleOutHelperNew.class);
    private static Map<Long, Map<String, Object>> materialMap = new HashMap<Long, Map<String, Object>>();
    private static Map<String, String> cacheMap = new HashMap<String, String>();

    public static Map<String, Object> invAccQueryForMatchingRule(DynamicObject targetBillObj, String pagecachebfinvqty, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
        Map<String, DynamicObject> entryMap = InvMatchingRuleOutHelperNew.getEntryMap(tbillEntrys);
        Map<Long, List<Long>> masterIdMap = InvMatchingRuleOutHelperNew.getEntryMasterIDMap(tbillEntrys);
        String billname = targetBillObj.getDataEntityType().getName();
        List entryInfoList = MatchingRuleOutNewHelper.getMatchingResultFromDynobj((String)billname, (String)"billentry", (String)"matchingruleout", (DynamicObject)targetBillObj, (DynamicObjectCollection)tbillEntrys);
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---" + entryInfoList);
        StringBuilder sb = new StringBuilder();
        HashSet<Object> deleteSet = new HashSet<Object>(entryInfoList.size());
        for (Map entryInfo : entryInfoList) {
            List<Long> set;
            String format;
            if (entryInfo.isEmpty()) continue;
            String errMsg = (String)entryInfo.get("errMsg");
            BigDecimal qty = (BigDecimal)entryInfo.get("qty");
            BigDecimal plusQty = (BigDecimal)entryInfo.get("plusQty");
            String materialname = (String)entryInfo.get("materialname");
            Long materialmasterid = (Long)entryInfo.get("materialmasterid");
            List entryInfoMapList = (List)entryInfo.get("entryInfo");
            if (entryInfo.get("errMsg") != null && !"".equals(errMsg)) {
                sb.append(errMsg);
                continue;
            }
            if ("true".equals(pagecachebfinvqty)) {
                if (qty.compareTo(plusQty) == 0) {
                    format = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u5012\u51b2\u7269\u6599\u201c%1$s\u201d\uff0c\u5e93\u5b58\u6570\u91cf\u22640\u3002", (String)"InvMatchingRuleOutHelperNew_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialname);
                    if (masterIdMap.containsKey(materialmasterid)) {
                        set = masterIdMap.get(materialmasterid);
                        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--set--" + set);
                        for (Long rowId : set) {
                            deleteSet.add(rowId);
                            StockBackFlushUtils.setErr(entryMap.get(rowId.toString()), res, stockBFMap, format);
                        }
                    }
                    logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--pagecachebfinvqty--" + pagecachebfinvqty + "----" + format);
                    continue;
                }
                if (plusQty.compareTo(BigDecimal.ZERO) <= 0 || res == null) continue;
                Map map = (Map)entryInfoMapList.get(0);
                Object entryId = map.get("entryId");
                deleteSet.add(entryId);
                StockBackFlushUtils.setErr(entryMap.get(entryId.toString()), res, stockBFMap, "E");
                logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--entryId--" + entryId + "----E--");
                continue;
            }
            if (plusQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            format = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u5012\u51b2\u7269\u6599%1$s\uff0c\u9700\u6c42\u6570\u91cf%2$s\uff0c\u5e93\u5b58\u6570\u91cf\u77ed\u7f3a%3$s\u3002", (String)"InvMatchingRuleOutHelperNew_11", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialname, qty, plusQty);
            if (masterIdMap.containsKey(materialmasterid)) {
                set = masterIdMap.get(materialmasterid);
                logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--set222--" + set);
                for (Long rowId : set) {
                    deleteSet.add(rowId);
                    StockBackFlushUtils.setErr(entryMap.get(rowId.toString()), res, stockBFMap, format);
                }
                if (entryInfoMapList != null && entryInfoMapList.size() > 0) {
                    for (Map tmap : entryInfoMapList) {
                        Object entryId = tmap.get("entryId");
                        deleteSet.add(entryId);
                    }
                }
            }
            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--------plusQty--" + plusQty + "---" + format);
        }
        if (!"".equals(sb.toString())) {
            result.put("success", false);
            result.put("message", sb.toString());
            return result;
        }
        DynamicObject materialReqOutBill = BusinessDataServiceHelper.newDynamicObject((String)billname);
        DynamicObjectCollection billEntry = (DynamicObjectCollection)materialReqOutBill.get("billentry");
        result.put("success", true);
        result.put("message", ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u51fa\u5e93\u6210\u529f\u3002", (String)"InvMatchingRuleOutHelperNew_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        Object parent = tbillEntrys.getParent();
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--------deleteSet--" + deleteSet);
        for (int i = 0; i < entryInfoList.size(); ++i) {
            Map entryInfo = (Map)entryInfoList.get(i);
            if (!entryInfo.isEmpty()) {
                InvMatchingRuleOutHelperNew.buildEntrys(billEntry, (DynamicObject)tbillEntrys.get(i), entryInfo, pagecachebfinvqty, deleteSet);
                continue;
            }
            DynamicObject dynamicObject = (DynamicObject)tbillEntrys.get(i);
            int seq = billEntry.size() + 1;
            dynamicObject.set("seq", (Object)seq);
            billEntry.add(tbillEntrys.get(i));
        }
        InvMatchingRuleOutHelperNew.getWarehouse(billEntry);
        for (DynamicObject entry : billEntry) {
            entry.setParent(parent);
        }
        result.put("result", billEntry);
        return result;
    }

    public static String invAccQueryForMatchingRuleNew(DynamicObject targetBillObj, String pagecachebfinvqty, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res, Map<Long, Long> entryAndPkidMap, Map<Long, DynamicObject> tarDyMap) {
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---entryAndPkidMap--" + entryAndPkidMap);
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---tarDyMap--" + tarDyMap.keySet());
        materialMap.clear();
        DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
        Map<String, DynamicObject> entryMap = InvMatchingRuleOutHelperNew.getEntryMap(tbillEntrys);
        Map<Long, List<Long>> masterIdMap = InvMatchingRuleOutHelperNew.getEntryMasterIDMap(tbillEntrys);
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---masterIdMap--" + masterIdMap);
        String billname = targetBillObj.getDataEntityType().getName();
        DynamicObjectCollection clone = (DynamicObjectCollection)tbillEntrys.clone();
        List entryInfoList = MatchingRuleOutNewHelper.getMatchingResultFromDynobj((String)billname, (String)"billentry", (String)"matchingruleout", (DynamicObject)targetBillObj, (DynamicObjectCollection)tbillEntrys);
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---" + entryInfoList);
        StringBuilder sb = new StringBuilder();
        HashSet<Object> deleteSet = new HashSet<Object>(entryInfoList.size());
        HashSet successSet = new HashSet(entryInfoList.size());
        for (Object entryInfo : entryInfoList) {
            if (entryInfo.isEmpty()) continue;
            BigDecimal qty = (BigDecimal)entryInfo.get("qty");
            BigDecimal plusQty = (BigDecimal)entryInfo.get("plusQty");
            if (!Objects.nonNull(entryInfo.get("entryInfo"))) continue;
            List entryInfoMapList = (List)entryInfo.get("entryInfo");
            if (plusQty.compareTo(BigDecimal.ZERO) != 0 || entryInfoMapList == null || entryInfoMapList.size() <= 0) continue;
            for (Map tmap : entryInfoMapList) {
                Object entryId = tmap.get("entryId");
                successSet.add(entryId);
            }
        }
        int deleteindex = 0;
        for (Map entryInfo : entryInfoList) {
            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---entryInfo--" + entryInfo);
            if (!entryInfo.isEmpty()) {
                String errMsg = (String)entryInfo.get("errMsg");
                if (entryInfo.get("errMsg") != null && !"".equals(errMsg)) {
                    sb.append(errMsg);
                    DynamicObject rowdata = (DynamicObject)clone.get(deleteindex);
                    Long delentryid = (Long)rowdata.getPkValue();
                    deleteSet.add(delentryid);
                    if (res == null) continue;
                    logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---errMsg--" + errMsg);
                    StockBackFlushUtils.setErr(entryMap.get(delentryid.toString()), res, stockBFMap, errMsg);
                    continue;
                }
                BigDecimal qty = (BigDecimal)entryInfo.get("qty");
                BigDecimal plusQty = (BigDecimal)entryInfo.get("plusQty");
                String materialname = (String)entryInfo.get("materialname");
                Long materialmasterid = (Long)entryInfo.get("materialmasterid");
                Map<String, Object> catchMaterialMap = InvMatchingRuleOutHelperNew.getMaterialDataMap(materialmasterid);
                String materialmodelnum = (String)catchMaterialMap.get("modelnum");
                String materialnumber = (String)catchMaterialMap.get("number");
                if (Objects.nonNull(entryInfo.get("entryInfo"))) {
                    List<Long> set;
                    String format;
                    List entryInfoMapList = (List)entryInfo.get("entryInfo");
                    if ("true".equals(pagecachebfinvqty)) {
                        if (qty.compareTo(plusQty) == 0) {
                            format = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u5012\u51b2\u7269\u6599%1$s\uff08\u540d\u79f0\uff1a%2$s\uff1b\u89c4\u683c\u578b\u53f7\uff1a%3$s\uff09\uff0c\u5e93\u5b58\u6570\u91cf\u22640\u3002", (String)"InvMatchingRuleOutHelperNew_12", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialnumber, materialname, materialmodelnum);
                            if (masterIdMap.containsKey(materialmasterid)) {
                                set = masterIdMap.get(materialmasterid);
                                logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--set--" + set);
                                for (Long rowId : set) {
                                    deleteSet.add(rowId);
                                    if (res == null) {
                                        sb.append(format);
                                        continue;
                                    }
                                    StockBackFlushUtils.setErr(entryMap.get(rowId.toString()), res, stockBFMap, format);
                                }
                            }
                            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--pagecachebfinvqty--" + pagecachebfinvqty + "----" + format);
                        } else if (plusQty.compareTo(BigDecimal.ZERO) > 0 && res != null) {
                            Map map = (Map)entryInfoMapList.get(0);
                            Object entryId = map.get("entryId");
                            deleteSet.add(entryId);
                            StockBackFlushUtils.setErr(entryMap.get(entryId.toString()), res, stockBFMap, "E");
                            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--entryId--" + entryId + "----E--");
                        }
                    } else if (plusQty.compareTo(BigDecimal.ZERO) > 0) {
                        format = String.format(ResManager.loadKDString((String)"\u6279\u6b21\u5012\u51b2\u7269\u6599%1$s\uff08\u540d\u79f0\uff1a%2$s\uff1b\u89c4\u683c\u578b\u53f7\uff1a%3$s\uff09\uff0c\u9700\u6c42\u6570\u91cf%4$s\uff0c\u5e93\u5b58\u6570\u91cf\u77ed\u7f3a%5$s\u3002", (String)"InvMatchingRuleOutHelperNew_13", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialnumber, materialname, materialmodelnum, qty, plusQty);
                        if (masterIdMap.containsKey(materialmasterid)) {
                            set = masterIdMap.get(materialmasterid);
                            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--set222--" + set);
                            if (entryInfoMapList != null && entryInfoMapList.size() > 0) {
                                for (Map tmap : entryInfoMapList) {
                                    Object entryId = tmap.get("entryId");
                                    deleteSet.add(entryId);
                                    if (res == null) {
                                        sb.append(format);
                                        continue;
                                    }
                                    if (entryMap.get(entryId.toString()) == null) continue;
                                    StockBackFlushUtils.setErr(entryMap.get(entryId.toString()), res, stockBFMap, format);
                                }
                            } else {
                                for (Long rowId : set) {
                                    DynamicObject entrydata = entryMap.get(rowId.toString());
                                    BigDecimal qty2 = entrydata.getBigDecimal("qty");
                                    if (qty.compareTo(qty2) != 0 || successSet.contains(rowId)) continue;
                                    deleteSet.add(rowId);
                                    if (res == null) {
                                        sb.append(format);
                                        continue;
                                    }
                                    StockBackFlushUtils.setErr(entryMap.get(rowId.toString()), res, stockBFMap, format);
                                }
                            }
                        }
                        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--------plusQty--" + plusQty + "---" + format);
                    }
                }
            }
            ++deleteindex;
        }
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--------deleteSet--" + deleteSet + "----successSet--" + successSet);
        deleteSet.removeAll(successSet);
        for (int i = 0; i < entryInfoList.size(); ++i) {
            Map entryInfo;
            entryInfo = (Map)entryInfoList.get(i);
            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--------entryInfo-2222---" + entryInfo);
            if (entryInfo.isEmpty() || entryInfo.get("errMsg") != null) continue;
            DynamicObject rowdata = (DynamicObject)clone.get(i);
            Long entryid = (Long)rowdata.getPkValue();
            Long pkId = entryAndPkidMap.get(entryid);
            logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93--------entryid-2222---" + entryid + "--pkId--" + pkId);
            DynamicObject resultData = tarDyMap.get(pkId);
            if (resultData == null) continue;
            DynamicObjectCollection resultEntry = (DynamicObjectCollection)resultData.get("billentry");
            InvMatchingRuleOutHelperNew.buildEntrysNew(rowdata, entryInfo, pagecachebfinvqty, deleteSet, resultEntry);
            if (resultEntry == null || resultEntry.isEmpty()) {
                tarDyMap.remove(pkId);
                continue;
            }
            InvMatchingRuleOutHelperNew.getWarehouse(resultEntry);
            tarDyMap.put(pkId, resultData);
        }
        HashSet<Long> deleteIdSet = new HashSet<Long>(tarDyMap.size());
        for (Map.Entry<Long, DynamicObject> tempMap : tarDyMap.entrySet()) {
            Long key = tempMap.getKey();
            DynamicObject todata = tempMap.getValue();
            DynamicObjectCollection resultEntry = todata.getDynamicObjectCollection("billentry");
            resultEntry.removeIf(x -> deleteSet.contains(x.getPkValue()));
            if (resultEntry != null && resultEntry.size() > 0) continue;
            deleteIdSet.add(key);
        }
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---start-----tarDyMap--" + tarDyMap.keySet());
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93---start-----deleteIdSet--" + deleteIdSet);
        if (!deleteIdSet.isEmpty()) {
            for (Long delid : deleteIdSet) {
                tarDyMap.remove(delid);
            }
        }
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93-----end---tarDyMap--" + tarDyMap.keySet());
        return sb.toString();
    }

    private static Map<String, DynamicObject> getEntryMap(DynamicObjectCollection tbillEntrys) {
        HashMap<String, DynamicObject> entryMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject entry : tbillEntrys) {
            entryMap.put(entry.getPkValue().toString(), entry);
        }
        return entryMap;
    }

    private static Map<Long, List<Long>> getEntryMasterIDMap(DynamicObjectCollection tbillEntrys) {
        HashMap<Long, List<Long>> maseterIdMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject entry : tbillEntrys) {
            List<Long> entryIdList = new ArrayList<Long>(8);
            Long entryId = entry.getLong("id");
            DynamicObject masterid = entry.getDynamicObject("material.masterid");
            Long mId = masterid.getLong("id");
            if (maseterIdMap.containsKey(mId)) {
                entryIdList = (List)maseterIdMap.get(mId);
            }
            entryIdList.add(entryId);
            maseterIdMap.put(mId, entryIdList);
        }
        return maseterIdMap;
    }

    private static void getWarehouse(DynamicObjectCollection billEntry) {
        InvMatchingRuleOutHelperNew.setDynamicObject(billEntry, "warehouse", "bd_warehouse", "status,enable,name,number,isopenlocation,entryentity,entryentity.location");
        InvMatchingRuleOutHelperNew.setDynamicObject(billEntry, "location", "bd_location", "name,number");
        InvMatchingRuleOutHelperNew.setDynamicObject(billEntry, "lot", "bd_lot", "number");
    }

    private static void setDynamicObject(DynamicObjectCollection billEntry, String name, String number, String query) {
        HashMap wareHouse = new HashMap(billEntry.size());
        for (DynamicObject billEntryDym : billEntry) {
            wareHouse.put(billEntryDym.get(name) instanceof DynamicObject ? ((Long)((DynamicObject)billEntryDym.get(name)).getPkValue()).longValue() : billEntryDym.getLong(name), null);
        }
        QFilter filter = new QFilter("id", "in", wareHouse.keySet());
        Map loads = BusinessDataServiceHelper.loadFromCache((String)number, (String)query, (QFilter[])new QFilter[]{filter});
        Iterator iterator = billEntry.iterator();
        while (iterator.hasNext()) {
            DynamicObject billEntryDym;
            billEntryDym.set(name, loads.get((billEntryDym = (DynamicObject)iterator.next()).get(name) instanceof DynamicObject ? ((Long)((DynamicObject)billEntryDym.get(name)).getPkValue()).longValue() : billEntryDym.getLong(name)));
        }
    }

    private static void buildEntrys(DynamicObjectCollection billEntry, DynamicObject srcEntry, Map<String, Object> insertEntryInfo, String pagecachebfinvqty, Set<Object> deleteSet) {
        int seq = billEntry.size() + 1;
        List entryInfoList = (List)insertEntryInfo.get("entryInfo");
        logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:" + entryInfoList);
        int size = entryInfoList.size();
        for (int i = 0; i < size; ++i) {
            Map entryInfo = (Map)entryInfoList.get(i);
            Long entryId = (Long)entryInfo.get("entryId");
            if (deleteSet.contains(entryId) && !"true".equals(pagecachebfinvqty)) continue;
            DynamicObject newEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)srcEntry, (boolean)false, (boolean)true);
            newEntry.setParent(srcEntry.getParent());
            InvMatchingRuleOutHelperNew.clearInvField(newEntry);
            newEntry.set("seq", (Object)seq);
            for (Map.Entry m : entryInfo.entrySet()) {
                String strs = "entryId,invaccId,material,unit,baseunit";
                if (Arrays.asList(strs.split(",")).contains(m.getKey())) continue;
                newEntry.set((String)m.getKey(), m.getValue());
                if (!newEntry.containsProperty((String)m.getKey() + "_id")) continue;
                newEntry.set((String)m.getKey() + "_id", m.getValue());
            }
            InvMatchingRuleOutHelperNew.setBaseAuxQty(newEntry);
            billEntry.add((Object)newEntry);
            ++seq;
        }
    }

    private static void buildEntrysNew(DynamicObject srcEntry, Map<String, Object> insertEntryInfo, String pagecachebfinvqty, Set<Object> deleteSet, DynamicObjectCollection resultEntry) {
        int seq = resultEntry.size() + 1;
        List entryInfoList = (List)insertEntryInfo.get("entryInfo");
        logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:" + entryInfoList);
        int size = entryInfoList.size();
        HashSet<Long> deleteRow = new HashSet<Long>(8);
        for (int i = 0; i < size; ++i) {
            Map entryInfo = (Map)entryInfoList.get(i);
            Long entryId = (Long)entryInfo.get("entryId");
            logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:entryId" + entryId);
            if (deleteSet.contains(entryId) && !"true".equals(pagecachebfinvqty)) {
                deleteRow.add(entryId);
                continue;
            }
            Boolean isadd = Boolean.TRUE;
            for (DynamicObject row : resultEntry) {
                Long rowId = (Long)row.getPkValue();
                Object lotnumber = row.get("lotnumber");
                logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:entryId" + entryId + "---rowId---" + rowId + "--lotnumber" + lotnumber);
                if (entryId.equals(rowId)) {
                    InvMatchingRuleOutHelperNew.clearInvField(row);
                    for (Map.Entry m : entryInfo.entrySet()) {
                        String strs = "entryId,invaccId,material,unit,baseunit";
                        if (Arrays.asList(strs.split(",")).contains(m.getKey())) continue;
                        row.set((String)m.getKey(), m.getValue());
                        if (!row.containsProperty((String)m.getKey() + "_id")) continue;
                        row.set((String)m.getKey() + "_id", m.getValue());
                    }
                    InvMatchingRuleOutHelperNew.setBaseAuxQty(row);
                    isadd = Boolean.FALSE;
                    break;
                }
                Object lotnumber2 = row.get("lotnumber");
                logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:entryId" + entryId + "---rowId---" + rowId + "--lotnumber2" + lotnumber2);
            }
            logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:isadd" + isadd + "---entryId---" + entryId);
            if (!isadd.booleanValue()) continue;
            DynamicObject newEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)srcEntry, (boolean)false, (boolean)true);
            newEntry.setParent(srcEntry.getParent());
            InvMatchingRuleOutHelperNew.clearInvField(newEntry);
            newEntry.set("seq", (Object)seq);
            newEntry.set("id", (Object)entryId);
            for (Map.Entry m : entryInfo.entrySet()) {
                String strs = "entryId,invaccId,material,unit,baseunit";
                if (Arrays.asList(strs.split(",")).contains(m.getKey())) continue;
                newEntry.set((String)m.getKey(), m.getValue());
                if (!newEntry.containsProperty((String)m.getKey() + "_id")) continue;
                newEntry.set((String)m.getKey() + "_id", m.getValue());
            }
            newEntry.setParent(srcEntry.getParent());
            InvMatchingRuleOutHelperNew.setBaseAuxQty(newEntry);
            resultEntry.add((Object)newEntry);
            ++seq;
        }
        logger.info("\u5012\u51b2\u81ea\u52a8\u5339\u914d\u89c4\u5219\u51fa\u5e93\u7ed3\u679c:\u5220\u9664\u884c\uff1a" + deleteRow + "---seq--" + seq);
        if (!deleteRow.isEmpty()) {
            resultEntry.removeIf(x -> deleteRow.contains(x.getPkValue()));
        }
    }

    private static void clearInvField(DynamicObject newEntry) {
        newEntry.set("baseqty", (Object)BigDecimal.ZERO);
        newEntry.set("qtyunit2nd", (Object)BigDecimal.ZERO);
    }

    private static void setBaseAuxQty(DynamicObject newEntry) {
        int seq = newEntry.getInt("seq");
        DynamicObject materialInfo = newEntry.getDynamicObject("material");
        if (materialInfo == null) {
            logger.info(String.format("\u7b2c%s\u884c\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a,\u65e0\u6cd5\u8ba1\u7b97\u57fa\u672c\u6570\u91cf\u548c\u6570\u91cf", seq));
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        if (material == null) {
            logger.info(String.format("\u7b2c%s\u884c\u7269\u6599\u4e3a\u7a7a,\u65e0\u6cd5\u8ba1\u7b97\u57fa\u672c\u6570\u91cf\u548c\u6570\u91cf", seq));
            return;
        }
        BigDecimal qty = newEntry.getBigDecimal("qty");
        DynamicObject unit = newEntry.getDynamicObject("unit");
        DynamicObject baseUnit = newEntry.getDynamicObject("baseunit");
        if (unit == null || baseUnit == null) {
            logger.info(String.format("\u7b2c%s\u884c\u8ba1\u91cf\u5355\u4f4d\u6216\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a,\u65e0\u6cd5\u8ba1\u7b97\u57fa\u672c\u6570\u91cf\u548c\u6570\u91cf", seq));
            return;
        }
        BigDecimal baseUnitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()), cacheMap);
        if (baseUnitRate == null || BigDecimal.ZERO.compareTo(baseUnitRate) == 0) {
            logger.info(String.format("\u7b2c%s\u884c\u8ba1\u91cf\u5355\u4f4d-\u57fa\u672c\u5355\u4f4d\u6362\u7b97\u7387\u4e3a\u7a7a\u6216\u8005\u4e3a0", seq));
            return;
        }
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
        newEntry.set("baseqty", (Object)baseQty);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            logger.info(String.format("\u7b2c%s\u884c\u8f85\u52a9\u5355\u4f4d\u4e3a\u7a7a\u6216\u8005\u57fa\u672c\u6570\u91cf\u4e3a0", seq));
            return;
        }
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()), cacheMap);
        if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
            logger.info(String.format("\u7b2c%s\u884c\u57fa\u672c\u5355\u4f4d-\u8f85\u52a9\u5355\u4f4d\u6362\u7b97\u7387\u4e3a\u7a7a\u6216\u8005\u4e3a0", seq));
            return;
        }
        BigDecimal qtyUnit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxptyUnit);
        newEntry.set("qtyunit2nd", (Object)qtyUnit2nd);
    }

    public static Map<String, Object> getMaterialDataMap(Long materialmasterid) {
        if (!materialMap.containsKey(materialmasterid) && materialmasterid > 0L) {
            QFilter mqf = new QFilter("id", "=", (Object)materialmasterid);
            DynamicObject bdmaterial = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"id,number,modelnum", (QFilter[])mqf.toArray());
            String modelnum = bdmaterial.getString("modelnum");
            String number = bdmaterial.getString("number");
            HashMap<String, String> tempMap = new HashMap<String, String>(8);
            tempMap.put("modelnum", modelnum);
            tempMap.put("number", number);
            materialMap.put(materialmasterid, tempMap);
        }
        Map<String, Object> catchmaterialMap = materialMap.get(materialmasterid);
        logger.info("\u5339\u914d\u89c4\u5219\u51fa\u5e93\u83b7\u53d6\u7269\u6599--materialMap---" + materialMap + "----catchmaterialMap---" + catchmaterialMap);
        return catchmaterialMap;
    }
}

