/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BackFlushCatchUtils {
    private static DistributeSessionlessCache backflushcache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("backflush");
    private static final int CACHE_TIMELONG = 7200;
    private static Log logger = LogFactory.getLog(BackFlushCatchUtils.class);

    public static Map<String, DynamicObject> addBatchCache(List<DynamicObject> selectDym) {
        HashMap<String, DynamicObject> catchKeyMap = new HashMap<String, DynamicObject>(selectDym.size());
        for (DynamicObject sdym : selectDym) {
            Object sourcebillid = sdym.get("sourcebillid");
            Object sourcebillentryid = sdym.get("sourcebillentryid");
            Object stockentryid = sdym.get("stockentryid");
            String key = "backflush_" + sourcebillid + "_" + sourcebillentryid + "_" + stockentryid;
            catchKeyMap.put(key, sdym);
        }
        return catchKeyMap;
    }

    public static Boolean checkBatchCacheExit(Map<String, DynamicObject> catchKeyMap, StringBuilder sb) {
        Boolean isexit = Boolean.FALSE;
        if (backflushcache != null) {
            logger.info("checkBatchCacheExit--catchKeyMap---" + catchKeyMap);
            logger.info("checkBatchCacheExit---backflushcache--" + backflushcache);
            for (Map.Entry<String, DynamicObject> catchKey : catchKeyMap.entrySet()) {
                String key = catchKey.getKey();
                if (!backflushcache.contains(key)) continue;
                DynamicObject value = catchKey.getValue();
                DynamicObject materielmasterid = value.getDynamicObject("materielmasterid");
                String materialName = materielmasterid == null ? "" : materielmasterid.getString("number");
                String sourcebillno = value.getString("sourcebillno");
                String orderno = value.getString("orderno");
                String format = String.format(ResManager.loadKDString((String)"\u5de5\u5355\u7f16\u53f7\uff1a%1$s\uff0c\u6e90\u5355\uff1a%2$s\uff0c\u7269\u6599\u7f16\u7801\uff1a%3$s\u6b63\u5728\u6267\u884c\u751f\u6210\u3002\n", (String)"BackFlushCatchUtils_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), orderno, sourcebillno, materialName);
                sb.append(format);
                isexit = Boolean.TRUE;
            }
        }
        return isexit;
    }

    public static Boolean catchBackFlush(Map<String, DynamicObject> catchKeyMap) {
        Boolean isexit = Boolean.FALSE;
        if (backflushcache != null) {
            for (Map.Entry<String, DynamicObject> catchKey : catchKeyMap.entrySet()) {
                String key = catchKey.getKey();
                backflushcache.put(key, (Object)key, 7200);
            }
        }
        return isexit;
    }
}

