/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CompletePickValidator {
    public static Collection<String> completePickValid(DynamicObject entryObj, DynamicObject manuBill, DynamicObject transactiontype, String entity) {
        if (manuBill == null || !CompletePickValidator.needValid(entryObj, manuBill)) {
            return null;
        }
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        BigDecimal curQTY = entryObj.getBigDecimal("baseqty");
        String materialNumber = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("number");
        String materialName = entryObj.getDynamicObject("material").getDynamicObject("masterid").getString("name");
        ArrayList<String> errMsgColls = new ArrayList<String>();
        if (null != manuBill.getDynamicObjectCollection("treeentryentity")) {
            for (int k = 0; k < manuBill.getDynamicObjectCollection("treeentryentity").size(); ++k) {
                QFilter qfilter;
                boolean isExists;
                DynamicObject manuEntryObj = (DynamicObject)manuBill.getDynamicObjectCollection("treeentryentity").get(k);
                Long manuEntryId = entryObj.getLong("manuentryid");
                if (!manuEntryId.equals(manuEntryObj.getPkValue()) || !(isExists = QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qfilter = new QFilter("orderentryid", "=", manuEntryObj.getPkValue())}))) continue;
                BigDecimal accQty = BigDecimal.ZERO;
                accQty = accQty.add(manuEntryObj.getBigDecimal("quainwaqty")).add(manuEntryObj.getBigDecimal("unquainwaqty")).add(manuEntryObj.getBigDecimal("scrinwaqty"));
                DynamicObject mftStock = BusinessDataServiceHelper.loadSingle((String)entity, (String)"orderentryid,baseqty,unitid,stockentry,stockentry.materialid,stockentry.materialid.number,stockentry.materialid.name,stockentry.feedingqty,stockentry.qtytype,stockentry.overissuecontrl,stockentry.demandqty,stockentry.fixscrap,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.lackraitioqty,stockentry.rejectedqty,stockentry.actissueqty,stockentry.issuemode,stockentry.isbackflush,stockentry.iskeypart,stockentry.isbulkmaterial,stockentry.materialunitid ", (QFilter[])new QFilter[]{qfilter});
                BigDecimal baseQty = mftStock.getBigDecimal("baseqty");
                for (int j = 0; j < mftStock.getDynamicObjectCollection("stockentry").size(); ++j) {
                    DynamicObject mftstockEntryObj = (DynamicObject)mftStock.getDynamicObjectCollection("stockentry").get(j);
                    DynamicObject unitid = mftstockEntryObj.getDynamicObject("materialunitid");
                    int precision = unitid.getInt("precision");
                    String precisionaccount = unitid.getString("precisionaccount");
                    int deal = 4;
                    switch (precisionaccount) {
                        case "2": {
                            deal = 1;
                            break;
                        }
                        case "3": {
                            deal = 0;
                            break;
                        }
                        default: {
                            deal = 4;
                        }
                    }
                    if (!CompletePickValidator.isInRange(mftstockEntryObj, transactiontype)) continue;
                    HashMap<String, Object> judgeParam = new HashMap<String, Object>();
                    judgeParam.put("mftstockEntryObj", mftstockEntryObj);
                    judgeParam.put("isconsiderloss", isconsiderloss);
                    judgeParam.put("curQTY", curQTY);
                    judgeParam.put("accQty", accQty);
                    judgeParam.put("baseQty", baseQty);
                    HashMap<String, Object> judgeResult = CompletePickValidator.qualityJudge(judgeParam, precision, deal);
                    boolean isPass = (Boolean)judgeResult.get("isPass");
                    if (isPass) continue;
                    String pNumber = mftstockEntryObj.getDynamicObject("materialid").getString("number");
                    String pName = mftstockEntryObj.getDynamicObject("materialid").getString("name");
                    BigDecimal qtyA = (BigDecimal)judgeResult.get("qualityA");
                    BigDecimal qtyB = (BigDecimal)judgeResult.get("qualityB");
                    BigDecimal qtyT = accQty.add(curQTY);
                    String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u5168\u9886\u6599\u7684\u7269\u6599\uff1a\u5165\u5e93\u4ea7\u54c1\u7f16\u7801\u201c%1$s\u201d \u4ea7\u54c1\u540d\u79f0\u201c%2$s\u201d \u7d2f\u8ba1\u5165\u5e93\u57fa\u672c\u6570\u91cf\u201c%3$s\u201d\uff0c\u7269\u6599\u7f16\u7801\u201c%4$s\u201d \u7269\u6599\u540d\u79f0\u201c%5$s\u201d\u5e94\u9886\u7528\u201c%6$s\u201d\uff0c\u5b9e\u9645\u9886\u7528\u201c%7$s\u201d\u3002", (String)"CompletePickValidator_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialNumber, materialName, qtyT.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyT.intValue()) : qtyT.setScale(precision, deal), pNumber, pName, qtyB.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyB.intValue()) : qtyB.setScale(precision, deal), qtyA.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(qtyA.intValue()) : qtyA.setScale(precision, deal));
                    errMsgColls.add(message);
                }
            }
        }
        return errMsgColls;
    }

    private static boolean isInRange(DynamicObject mftstockEntryObj, DynamicObject transactiontype) {
        String warehousrang = transactiontype.getString("warehousrang");
        String issuemode = mftstockEntryObj.getString("issuemode");
        String isbackflush = mftstockEntryObj.getString("isbackflush");
        boolean isbulkmaterial = mftstockEntryObj.getBoolean("isbulkmaterial");
        boolean iskeypart = mftstockEntryObj.getBoolean("iskeypart");
        boolean inRangeFlag = false;
        switch (warehousrang) {
            case "A": {
                if (isbulkmaterial || !"A".equals(isbackflush) || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "B": {
                if (!iskeypart || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
            case "C": {
                if (isbulkmaterial || "C".equals(issuemode)) break;
                inRangeFlag = true;
                break;
            }
        }
        return inRangeFlag;
    }

    private static boolean needValid(DynamicObject entryObj, DynamicObject manuBill) {
        DynamicObject transactiontype = manuBill.getDynamicObject("transactiontype");
        if (!transactiontype.getBoolean("iswarehousingpick")) {
            return false;
        }
        return "C".equals(entryObj.getString("producttype"));
    }

    private static HashMap<String, Object> qualityJudge(HashMap<String, Object> judgeParam, int precision, int deal) {
        boolean isPass;
        BigDecimal qualityA = BigDecimal.ZERO;
        BigDecimal qualityB = BigDecimal.ZERO;
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject mftstockEntryObj = (DynamicObject)judgeParam.get("mftstockEntryObj");
        boolean isconsiderloss = (Boolean)judgeParam.get("isconsiderloss");
        BigDecimal curQTY = (BigDecimal)judgeParam.get("curQTY");
        BigDecimal accQty = (BigDecimal)judgeParam.get("accQty");
        BigDecimal baseQty = (BigDecimal)judgeParam.get("baseQty");
        qualityA = qualityA.add(mftstockEntryObj.getBigDecimal("actissueqty")).subtract(mftstockEntryObj.getBigDecimal("rejectedqty")).add(mftstockEntryObj.getBigDecimal("feedingqty"));
        String qtytype = mftstockEntryObj.getString("qtytype");
        if ("A".equals(qtytype) || "C".equals(qtytype)) {
            String overissuecontrl = mftstockEntryObj.getString("overissuecontrl");
            qualityB = qualityB.add(accQty).add(curQTY);
            BigDecimal fixscrap = mftstockEntryObj.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)mftstockEntryObj.get("fixscrap");
            qualityB = qualityB.multiply(mftstockEntryObj.getBigDecimal("demandqty").subtract(fixscrap)).divide(baseQty, precision, deal);
            if ("B".equals(overissuecontrl) && qualityB.compareTo(mftstockEntryObj.getBigDecimal("lackraitioqty")) > 0) {
                qualityB = mftstockEntryObj.getBigDecimal("lackraitioqty");
            }
        } else {
            qualityB = mftstockEntryObj.getBigDecimal("demandqty");
        }
        if (qualityA.compareTo(qualityB) >= 0) {
            isPass = true;
        } else {
            isPass = false;
            result.put("qualityA", qualityA);
            result.put("qualityB", qualityB);
        }
        result.put("isPass", isPass);
        return result;
    }
}

