/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MftReqOutBillUtil {
    private static final ThreadLocal<Map<String, Map<Long, Map<String, Object>>>> orderEntryThreadLocal = new ThreadLocal();

    public static Map<String, Map<String, Object>> getMftStockByMainBillEntryIds(Set<Long> mainBillEntryId, String entity) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(256);
        if (CollectionUtils.isEmpty(mainBillEntryId)) {
            return map;
        }
        String algoKey = "queryPomMftStock";
        String selectFields = "id,billno,billstatus,transactiontypeid,transactiontypeid.isreturn,transactiontypeid.returncontrol,stockentry.id,stockentry.seq,stockentry.overissuecontrl,stockentry.extraratioqty,stockentry.actissueqty,stockentry.rejectedqty,stockentry.feedingqty,stockentry.scrapqty,stockentry.iscannegative,stockentry.useqty";
        QFilter filter = new QFilter("stockentry.id", "in", mainBillEntryId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(32);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                BigDecimal actQty = row.getBigDecimal("stockentry.actissueqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("stockentry.actissueqty");
                BigDecimal rejQty = row.getBigDecimal("stockentry.rejectedqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("stockentry.rejectedqty");
                BigDecimal feedQty = row.getBigDecimal("stockentry.feedingqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("stockentry.feedingqty");
                BigDecimal scrQty = row.getBigDecimal("stockentry.scrapqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("stockentry.scrapqty");
                BigDecimal extraratioQty = row.getBigDecimal("stockentry.extraratioqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("stockentry.extraratioqty");
                BigDecimal useQty = row.getBigDecimal("stockentry.useqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : row.getBigDecimal("stockentry.useqty");
                map1.put("stockentry.actissueqty", actQty);
                map1.put("stockentry.rejectedqty", rejQty);
                map1.put("stockentry.feedingqty", feedQty);
                map1.put("stockentry.scrapqty", scrQty);
                map1.put("stockentry.extraratioQty", extraratioQty);
                map1.put("stockentry.overissuecontrl", row.getString("stockentry.overissuecontrl"));
                map1.put("stockentry.iscannegative", row.getString("stockentry.iscannegative"));
                map1.put("stockentry.useqty", useQty);
                map1.put("transactiontypeid", row.getLong("transactiontypeid"));
                map1.put("transactiontypeid.isreturn", row.getBoolean("transactiontypeid.isreturn"));
                map1.put("transactiontypeid.returncontrol", row.getString("transactiontypeid.returncontrol"));
                map1.put("stockentry.seq", row.getLong("stockentry.seq"));
                map.put(row.getString("stockentry.id"), map1);
            }
        }
        return map;
    }

    public static Map<String, Map<String, String>> getMftStockByIds(Set<Long> mainBillIds, String entity) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(mainBillIds.size());
        if (CollectionUtils.isEmpty(mainBillIds)) {
            return map;
        }
        String algoKey = "queryPomMftStock";
        QFilter filter = new QFilter("id", "in", mainBillIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"id,billno,billstatus,transactiontypeid.producttype,transactiontypeid.isoffrequpdatestock", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("transactiontypeproducttype", row.getString("transactiontypeid.producttype"));
                map1.put("transactiontypeisupdatestock", row.getString("transactiontypeid.isoffrequpdatestock"));
                map.put(row.getString("id"), map1);
            }
        }
        return map;
    }

    public static Map<String, Map<String, String>> getXmftStockByStockId(Set<Long> mainBillIds, String entity) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(256);
        if (CollectionUtils.isEmpty(mainBillIds)) {
            return map;
        }
        String algoKey = "queryXmftStock";
        QFilter qFilter = new QFilter("stockentry.stockid", "in", mainBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"id,billno,billstatus,stockentry.stockid", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (StringUtils.equals((CharSequence)"C", (CharSequence)row.getString("billstatus"))) continue;
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("stockentry.stockid", row.getString("stockentry.stockid"));
                map.put(row.getString("stockentry.stockid"), map1);
            }
        }
        return map;
    }

    public static Map<String, Map<String, String>> getXmftOrderByManuEntryId(Set<String> manuEntryIds, String entity) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(128);
        if (CollectionUtils.isEmpty(manuEntryIds)) {
            return map;
        }
        String algoKey = "queryXmftorder";
        QFilter qFilter = new QFilter("treeentryentity.srcbillentryid", "in", manuEntryIds);
        qFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"id,billno,billstatus,treeentryentity.srcbillentryid", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> map1 = new HashMap<String, String>(16);
                map1.put("id", row.getString("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("treeentryentity.srcbillentryid", row.getString("treeentryentity.srcbillentryid"));
                map.put(row.getString("treeentryentity.srcbillentryid"), map1);
            }
        }
        return map;
    }

    public static Map<Long, Map<String, Object>> getOrderById(Set<Long> ids, String entityName) {
        Map<Long, Map<String, Object>> dataMap;
        String algoKey = "queryOrderById";
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>(ids.size());
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        StringBuilder orderKeys = new StringBuilder();
        for (Long id : ids) {
            orderKeys.append(id);
        }
        Map<String, Map<Long, Map<String, Object>>> orderDataMap = orderEntryThreadLocal.get();
        if (orderDataMap == null) {
            orderDataMap = new HashMap<String, Map<Long, Map<String, Object>>>();
            orderEntryThreadLocal.set(orderDataMap);
        }
        if ((dataMap = orderDataMap.get(orderKeys.toString())) != null && !dataMap.isEmpty()) {
            return dataMap;
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        String selectFields = "id,billno,billstatus,treeentryentity.id,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.bizstatus,treeentryentity.planstatus,treeentryentity.iscontrolqty,treeentryentity.inwarmax,treeentryentity.inwarmin,treeentryentity.quainwaqty,treeentryentity.waitcheckqty,treeentryentity.unquainwaqty,treeentryentity.scrinwaqty,treeentryentity.stockqty,treeentryentity.transmittime,treeentryentity.materielmasterid,transactiontype,transactiontype.warehouscontrol,transactiontype.iswarehousingpick,transactiontype.warehousrang,transactiontype.isprocedure,transactiontype.isconsiderloss";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map1 = new HashMap<String, Object>(64);
                map1.put("id", row.getLong("id"));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("treeentryentity.id", row.getLong("treeentryentity.id"));
                map1.put("treeentryentity.seq", row.getString("treeentryentity.seq"));
                map1.put("treeentryentity.producttype", row.getString("treeentryentity.producttype"));
                map1.put("treeentryentity.material", row.getLong("treeentryentity.material"));
                map1.put("treeentryentity.materielmasterid", row.getLong("treeentryentity.materielmasterid"));
                map1.put("treeentryentity.bizstatus", row.getString("treeentryentity.bizstatus"));
                map1.put("treeentryentity.planstatus", row.getString("treeentryentity.planstatus"));
                map1.put("treeentryentity.inwarmax", row.getBigDecimal("treeentryentity.inwarmax"));
                map1.put("treeentryentity.inwarmin", row.getBigDecimal("treeentryentity.inwarmin"));
                map1.put("treeentryentity.stockqty", row.getBigDecimal("treeentryentity.stockqty"));
                map1.put("treeentryentity.quainwaqty", row.getBigDecimal("treeentryentity.quainwaqty"));
                map1.put("treeentryentity.waitcheckqty", row.getBigDecimal("treeentryentity.waitcheckqty"));
                map1.put("treeentryentity.unquainwaqty", row.getBigDecimal("treeentryentity.unquainwaqty"));
                map1.put("treeentryentity.scrinwaqty", row.getBigDecimal("treeentryentity.scrinwaqty"));
                map1.put("treeentryentity.iscontrolqty", row.getBoolean("treeentryentity.iscontrolqty"));
                map1.put("treeentryentity.transmittime", row.getDate("treeentryentity.transmittime"));
                map1.put("transactiontype.warehouscontrol", row.getString("transactiontype.warehouscontrol"));
                map1.put("transactiontype.iswarehousingpick", row.getBoolean("transactiontype.iswarehousingpick"));
                map1.put("transactiontype.isconsiderloss", row.getBoolean("transactiontype.isconsiderloss"));
                map1.put("transactiontype.warehousrang", row.getString("transactiontype.warehousrang"));
                map1.put("transactiontype.isprocedure", row.getString("transactiontype.isprocedure"));
                map.put(row.getLong("treeentryentity.id"), map1);
            }
        }
        orderDataMap.put(orderKeys.toString(), map);
        return map;
    }

    public static List<Map<String, Object>> getStockByOrderEntryIdV1(Set<Long> ids, String entityName) {
        Map<String, String> map1;
        String algoKey = "getStockByOrderEntryId";
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(128);
        if (CollectionUtils.isEmpty(ids)) {
            return list;
        }
        HashSet<Long> materialMftIDSet = new HashSet<Long>(16);
        HashSet<Long> unitIDSet = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("orderentryid", "in", ids);
        String selectFields = "id,billno,billstatus,transactiontypeid,transactiontypeid.warehousrang,transactiontypeid.isconsiderloss,orderentryid,baseqty,stockentry.id,stockentry.materialid,stockentry.feedingqty,stockentry.overissuecontrl,stockentry.demandqty,stockentry.fixscrap,stockentry.qtynumerator,stockentry.qtydenominator,stockentry.lackraitioqty,stockentry.rejectedqty,stockentry.qtytype,stockentry.actissueqty,stockentry.issuemode,stockentry.isbackflush,stockentry.iskeypart,stockentry.isbulkmaterial,stockentry.materialunitid";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map1 = new HashMap<String, Object>(64);
                map1.put("id", (String)((Object)row.getLong("id")));
                map1.put("billno", row.getString("billno"));
                map1.put("billstatus", row.getString("billstatus"));
                map1.put("transactiontypeid", (String)((Object)row.getLong("transactiontypeid")));
                map1.put("transactiontypeid.warehousrang", row.getString("transactiontypeid.warehousrang"));
                map1.put("transactiontypeid.isconsiderloss", (String)((Object)row.getBoolean("transactiontypeid.isconsiderloss")));
                map1.put("orderentryid", (String)((Object)row.getLong("orderentryid")));
                map1.put("baseqty", (String)((Object)row.getBigDecimal("baseqty")));
                map1.put("stockentry.id", (String)((Object)row.getLong("stockentry.id")));
                map1.put("stockentry.materialid", (String)((Object)row.getLong("stockentry.materialid")));
                map1.put("stockentry.materialid.number", "");
                map1.put("stockentry.materialid.name", "");
                map1.put("stockentry.materialid.masterid.number", "");
                map1.put("stockentry.materialid.masterid.name", "");
                materialMftIDSet.add(row.getLong("stockentry.materialid"));
                map1.put("stockentry.feedingqty", (String)((Object)row.getBigDecimal("stockentry.feedingqty")));
                map1.put("stockentry.qtytype", row.getString("stockentry.qtytype"));
                map1.put("stockentry.overissuecontrl", row.getString("stockentry.overissuecontrl"));
                map1.put("stockentry.demandqty", (String)((Object)row.getBigDecimal("stockentry.demandqty")));
                map1.put("stockentry.fixscrap", (String)((Object)row.getBigDecimal("stockentry.fixscrap")));
                map1.put("stockentry.qtynumerator", (String)((Object)row.getBigDecimal("stockentry.qtynumerator")));
                map1.put("stockentry.qtydenominator", (String)((Object)row.getBigDecimal("stockentry.qtydenominator")));
                map1.put("stockentry.rejectedqty", (String)((Object)row.getBigDecimal("stockentry.rejectedqty")));
                map1.put("stockentry.actissueqty", (String)((Object)row.getBigDecimal("stockentry.actissueqty")));
                map1.put("stockentry.lackraitioqty", (String)((Object)row.getBigDecimal("stockentry.lackraitioqty")));
                map1.put("stockentry.issuemode", row.getString("stockentry.issuemode"));
                map1.put("stockentry.isbackflush", row.getString("stockentry.isbackflush"));
                map1.put("stockentry.iskeypart", (String)((Object)row.getBoolean("stockentry.iskeypart")));
                map1.put("stockentry.isbulkmaterial", (String)((Object)row.getBoolean("stockentry.isbulkmaterial")));
                map1.put("stockentry.materialunitid", (String)((Object)row.getLong("stockentry.materialunitid")));
                map1.put("stockentry.materialunitid.precision", (String)((Object)Integer.valueOf(0)));
                map1.put("stockentry.materialunitid.precisionaccount", "");
                unitIDSet.add(row.getLong("stockentry.materialunitid"));
                list.add(map1);
            }
        }
        Map mftMap = new HashMap(16);
        if (!materialMftIDSet.isEmpty()) {
            String selectProperties = "id,number,name,masterid,masterid.number,masterid.name";
            QFilter qFilter1 = new QFilter("id", "in", materialMftIDSet);
            mftMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)selectProperties, (QFilter[])new QFilter[]{qFilter1});
        }
        Map unitMap = new HashMap(16);
        if (!unitIDSet.isEmpty()) {
            String selectProperties = "id,number,name,precisionaccount,precision";
            QFilter qFilter1 = new QFilter("id", "in", unitIDSet);
            unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)selectProperties, (QFilter[])new QFilter[]{qFilter1});
        }
        for (int i = 0; i < list.size(); ++i) {
            Long materialmftID;
            DynamicObject mftInfo;
            map1 = (Map)list.get(i);
            Long unitID = map1.get("stockentry.materialunitid") == null ? 0L : Long.parseLong(map1.get("stockentry.materialunitid").toString());
            DynamicObject unit = (DynamicObject)unitMap.get(unitID);
            if (unit != null) {
                map1.put("stockentry.materialunitid.precision", (String)((Object)Integer.valueOf(unit.getInt("precision"))));
                map1.put("stockentry.materialunitid.precisionaccount", unit.getString("precisionaccount"));
            }
            if ((mftInfo = (DynamicObject)mftMap.get(materialmftID = Long.valueOf(map1.get("stockentry.materialid") == null ? 0L : Long.parseLong(map1.get("stockentry.materialid").toString())))) == null) continue;
            map1.put("stockentry.materialid.number", mftInfo.getString("number"));
            map1.put("stockentry.materialid.name", mftInfo.getString("name"));
            map1.put("stockentry.materialid.masterid.number", mftInfo.getDynamicObject("masterid").getString("number"));
            map1.put("stockentry.materialid.masterid.name", mftInfo.getDynamicObject("masterid").getString("name"));
        }
        return list;
    }

    public static int getPrecisionaccount(String precisionaccount) {
        int deal = 4;
        switch (precisionaccount) {
            case "2": {
                deal = 1;
                break;
            }
            case "3": {
                deal = 0;
                break;
            }
        }
        return deal;
    }

    public static Map<Long, Long> querySfcReportByEntryId(Set<Long> entryIds, String entity) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(256);
        if (CollectionUtils.isEmpty(entryIds)) {
            return map;
        }
        QFilter qFilter = new QFilter("sumentry.manuinbillentryid", "in", entryIds);
        String algoKey = "querySfcReportByEntryId";
        if ("sfc_processreportbill".equals(entity)) {
            qFilter = new QFilter("sumentry.manuinbillentryid", "in", entryIds.stream().map(String::valueOf).collect(Collectors.toSet()));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"id,billno,billstatus,sumentry.id,sumentry.manuinbillentryid", (QFilter[])new QFilter[]{qFilter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.put(row.getLong("sumentry.id"), row.getLong("sumentry.manuinbillentryid"));
            }
        }
        return map;
    }
}

