/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MftRowLinkUtils {
    public static void fixRowLink(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryFld, String srcRowSeqFld, Object targetBillId, String srcBillNo) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryFld) && StringUtils.isNotBlank((CharSequence)srcRowSeqFld) && StringUtils.isNotBlank((CharSequence)srcBillNo) && null != targetBillId) {
            DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryFld);
            DynamicObject[] sourceBillObjs = MftRowLinkUtils.loadSourceBill(srcTableDefine, srcBillNo);
            MftRowLinkUtils.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObjs, srcRowSeqFld);
            DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
            DynamicObjectCollection linkRows = ((DynamicObject)targetRows.get(0)).getDynamicObjectCollection("billentry_lk");
            OperateOption create = OperateOption.create();
            create.setVariableValue("ignoreValidation", String.valueOf(true));
            create.setVariableValue("breakLastEdit", String.valueOf(true));
            OperationResult saveOperate = SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)create);
            if (!saveOperate.isSuccess()) {
                List allErrorOrValidateInfo = saveOperate.getAllErrorOrValidateInfo();
                StringBuilder builder = new StringBuilder();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    builder.append(iOperateInfo.getMessage());
                }
                throw new KDBizException(builder.toString());
            }
        }
    }

    private static DynamicObject[] loadSourceBill(TableDefine srcTableDefine, String srcBillNo) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter(sourceMainType.getBillNo(), "=", (Object)srcBillNo);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }

    private static void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject[] sourceBillObjs, String srcRowSeqFld) {
        HashMap<Integer, Object[]> srcRowIds = new HashMap<Integer, Object[]>();
        for (DynamicObject srcObj : sourceBillObjs) {
            DynamicObjectCollection srcRows = srcObj.getDynamicObjectCollection(srcTableDefine.getEntityKey());
            for (DynamicObject srcRow : srcRows) {
                Integer srcRowSeq = srcRow.getInt("seq");
                Object[] srcRowId = new Object[]{srcObj.getPkValue(), srcRow.getPkValue()};
                srcRowIds.put(srcRowSeq, srcRowId);
            }
        }
        Long srcTableId = srcTableDefine.getTableId();
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty()) continue;
            Integer srcRowSeq = targetRow.getInt(srcRowSeqFld);
            Long manuentryid = targetRow.getLong("manuentryid");
            if (!srcRowIds.containsKey(srcRowSeq)) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            Object[] srcRowId = (Object[])srcRowIds.get(srcRowSeq);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
            if (srcRowId.length < 2 || !Objects.equal((Object)manuentryid, (Object)srcRowId[1])) continue;
            linkRow.set(lkEntryKey + "_sbillid", srcRowId[0]);
            linkRow.set(lkEntryKey + "_sid", srcRowId[1]);
            linkRows.add((Object)linkRow);
            break;
        }
    }
}

