/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class OMStockBackFlushUtils {
    private static final Log logger = LogFactory.getLog(OMStockBackFlushUtils.class);

    public static String delResLog(Map<DynamicObject, String> res, String string) {
        OMStockBackFlushUtils.updateBFStatus(res, string);
        ORM orm = ORM.create();
        DynamicObject backFlushLog = orm.newDynamicObject("im_mdc_backflushlog");
        IDataEntityType type = backFlushLog.getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey((Object[])new DynamicObject[]{backFlushLog}, type);
        backFlushLog.set("billstatus", (Object)"C");
        backFlushLog.set("billno", (Object)("mo" + backFlushLog.getPkValue()));
        backFlushLog.set("createtime", (Object)TimeServiceHelper.now());
        backFlushLog.set("modifytime", (Object)TimeServiceHelper.now());
        backFlushLog.set("creator", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        backFlushLog.set("modifier", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        ArrayList<String> unExistEntryIds = new ArrayList<String>();
        for (Map.Entry<DynamicObject, String> result : res.entrySet()) {
            OMStockBackFlushUtils.setLogBillEntry(result, backFlushLog, unExistEntryIds, string);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{backFlushLog});
        return backFlushLog.getPkValue().toString();
    }

    private static void updateBFStatus(Map<DynamicObject, String> res, String string) {
        ArrayList<Object> entryIdList = new ArrayList<Object>(10);
        String entityName = "";
        for (Map.Entry<DynamicObject, String> result : res.entrySet()) {
            DynamicObject key = result.getKey();
            String sourcebillentry = key.getString("sourcebillentry");
            String sourcebillentryid = key.getString("sourcebillentryid");
            if (!"A".equals(sourcebillentry)) continue;
            entryIdList.add(NumberUtils.toLong((String)sourcebillentryid));
            entityName = "im_mdc_omcmplinbill";
        }
        OMStockBackFlushUtils.updateBFStatusByEntryId(entryIdList, entityName);
    }

    private static void setLogBillEntry(Map.Entry<DynamicObject, String> result, DynamicObject backFlushLog, List<String> unExistEntryIds, String string) {
        DynamicObject key = result.getKey();
        String value = result.getValue();
        String bfstatus = "";
        if ("unbackflush".equals(string)) {
            bfstatus = "".equals(value) ? "C" : "D";
        } else if ("backflush".equals(string)) {
            bfstatus = "success".equals(value) ? "A" : "B";
            if ("E".equals(value)) {
                bfstatus = "E";
            }
            if ("".equals(value)) {
                value = ResManager.loadKDString((String)"\u624b\u5de5\u7ec8\u6b62\u4efb\u52a1\u3002", (String)"OMStockBackFlushUtils_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            } else if ("success".equals(value)) {
                value = ResManager.loadKDString((String)" ", (String)"OMStockBackFlushUtils_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            } else if ("E".equals(value)) {
                value = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3\uff0c\u90e8\u5206\u5012\u51b2\u3002", (String)"OMStockBackFlushUtils_2", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
        }
        String sourcebillentry = key.getString("sourcebillentry");
        String sourcebillentryid = key.getString("sourcebillentryid");
        String stockentryid = key.getString("stockentryid");
        unExistEntryIds.add(sourcebillentry + "," + sourcebillentryid + "," + stockentryid);
        DynamicObjectCollection billEntrys = backFlushLog.getDynamicObjectCollection("billentry");
        DynamicObject billEntry = ORM.create().newDynamicObject("im_mdc_backflushlog.billentry");
        billEntry.set("bfstatus", (Object)bfstatus);
        billEntry.set("sourcebillentry", key.get("sourcebillentry"));
        billEntry.set("sourcebillno", key.get("sourcebillno"));
        billEntry.set("billseq", key.get("billseq"));
        billEntry.set("biztime", key.get("biztime"));
        billEntry.set("materialid", key.get("materialid"));
        billEntry.set("productid", key.get("productid"));
        billEntry.set("materielmasterid", key.get("materielmasterid"));
        if (value.length() > 1000) {
            logger.info("\u5012\u51b2\u4fe1\u606f\u8d85\u957f\u8bb0\u5f55\uff1a" + value);
            billEntry.set("bfres", (Object)(value.substring(0, 999) + "....."));
        } else {
            billEntry.set("bfres", (Object)value);
        }
        billEntry.set("sourcebillentryid", key.get("sourcebillentryid"));
        billEntry.set("stockid", key.get("stockid"));
        billEntry.set("sourcebillid", key.get("sourcebillid"));
        billEntry.set("stockentryid", key.get("stockentryid"));
        billEntrys.add((Object)billEntry);
    }

    public static Map<String, List<Object>> updateStockBFInfo(List<String> unExistEntryIds, String bfclose) {
        DynamicObject[] bills;
        HashMap<String, List<Object>> unExistRes = new HashMap<String, List<Object>>(16);
        HashSet<String> sourceBillEntrySet = new HashSet<String>(16);
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < unExistEntryIds.size(); ++i) {
            String[] split = unExistEntryIds.get(i).split(",");
            sourceBillEntrySet.add(split[0]);
            sourceBillEntryidSet.add(Long.parseLong(split[1]));
            stockEntryIdSet.add(Long.parseLong(split[2]));
        }
        QFilter filter = new QFilter("sourcebillentry", "in", sourceBillEntrySet);
        filter.and(new QFilter("sourcebillentryid", "in", sourceBillEntryidSet));
        filter.and(new QFilter("stockentryid", "in", stockEntryIdSet));
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"im_mdc_backflushstock", (String)"sourcebillentry,sourcebillentryid,stockentryid,actissuebfqty,bfclose", (QFilter[])new QFilter[]{filter})) {
            String sourcebillentry = bill.getString("sourcebillentry");
            String sourcebillentryid = bill.getString("sourcebillentryid");
            String stockentryid = bill.getString("stockentryid");
            String idStr = sourcebillentry + "," + sourcebillentryid + "," + stockentryid;
            List list = (List)unExistRes.get(idStr);
            if (list != null) {
                bill.set("actissuebfqty", list.get(0));
            }
            if ("A".equals(bfclose)) {
                bill.set("bfclose", (Object)true);
                continue;
            }
            if (!"B".equals(bfclose)) continue;
            bill.set("bfclose", (Object)false);
        }
        SaveServiceHelper.update((DynamicObject[])bills);
        return unExistRes;
    }

    public static Map<String, List<Object>> getUnExistBFInfo(List<String> unExistEntryIds) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)unExistEntryIds.size());
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < unExistEntryIds.size(); ++i) {
            String unExistEntryId = unExistEntryIds.get(i);
            String[] split = unExistEntryId.split(",");
            sourceBillEntryidSet.add(Long.parseLong(split[1]));
            stockEntryIdSet.add(Long.parseLong(split[2]));
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            info.add(BigDecimal.ZERO);
            info.add(Boolean.valueOf(false));
            res.put(unExistEntryId, info);
        }
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", sourceBillEntryidSet);
        filter.and(new QFilter("billentry.mainbillentryid", "in", stockEntryIdSet));
        filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"im_mdc_omoutbill", (String)"billentry.srcbillentity,billentry.srcbillentryid,billentry.mainbillentryid,billentry.remainreturnbaseqty", (QFilter[])new QFilter[]{filter});
        OMStockBackFlushUtils.fillInfo(bills, res);
        return res;
    }

    private static void fillInfo(DynamicObjectCollection bills, Map<String, List<Object>> res) {
        HashMap qtyRes = new HashMap();
        for (DynamicObject bill : bills) {
            String sourcebillentry = "A";
            String sourcebillentryid = bill.getString("billentry.srcbillentryid");
            String stockentryid = bill.getString("billentry.mainbillentryid");
            BigDecimal baseqty = bill.getBigDecimal("billentry.remainreturnbaseqty").abs();
            String idStr = sourcebillentry + "," + sourcebillentryid + "," + stockentryid;
            List info = qtyRes.get(idStr) == null ? new ArrayList() : (List)qtyRes.get(idStr);
            info.add(baseqty);
            qtyRes.put(idStr, info);
        }
        for (Map.Entry result : qtyRes.entrySet()) {
            String key = (String)result.getKey();
            List value = (List)result.getValue();
            BigDecimal qty = BigDecimal.ZERO;
            for (int i = 0; i < value.size(); ++i) {
                qty = qty.add((BigDecimal)value.get(i));
            }
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            Boolean bfclose = false;
            info.add(qty);
            info.add(bfclose);
            res.put(key, info);
        }
    }

    public static void updateBFStatusByEntryId(List<Object> entryIdList, String entityName) {
        if (!entityName.equals("im_mdc_omcmplinbill")) {
            return;
        }
        String selectString = "id,billno";
        String sourcebill = "A";
        String baseqtyName = "billentry.baseqty";
        String entryIdName = "billentry.id";
        if (entityName.equals("im_mdc_omcmplinbill")) {
            selectString = OMStockBackFlushUtils.getMftInBillSelects();
        } else if (entityName.equals("pom_mftorderreport")) {
            selectString = OMStockBackFlushUtils.getMftOrderReportSelects();
            entryIdName = "sumentry.id";
            sourcebill = "B";
            baseqtyName = "sumentry.completbsqty";
        }
        List<Long> entryIds = entryIdList.stream().map(e -> Long.parseLong(e.toString())).collect(Collectors.toList());
        QFilter q = new QFilter(entryIdName, "in", entryIds);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)selectString, (QFilter[])new QFilter[]{q});
        HashMap<Object, Set<String>> billInfo = new HashMap<Object, Set<String>>(16);
        HashMap<String, BigDecimal> bfQty = new HashMap<String, BigDecimal>(16);
        HashMap<String, DynamicObject> bfStockEntry = new HashMap<String, DynamicObject>(16);
        ArrayList<String> existEntryIds = new ArrayList<String>(10);
        OMStockBackFlushUtils.getBFQty(billInfo, bfQty, bfStockEntry, existEntryIds, bills, sourcebill, baseqtyName, entryIdName);
        Map<String, List<Object>> unExistRes = OMStockBackFlushUtils.getUnExistBFInfo(existEntryIds);
        HashMap<String, String> bfStatus = new HashMap<String, String>(16);
        OMStockBackFlushUtils.updateStockBFStatus(unExistRes, bfQty, bfStockEntry, bfStatus);
        HashMap<Object, String> sourceBFStatus = new HashMap<Object, String>(16);
        OMStockBackFlushUtils.updateSourceBFStatus(sourceBFStatus, billInfo, bfStatus);
        OMStockBackFlushUtils.updateSourceBFStatusById(entryIds, sourceBFStatus, entityName, entryIdName);
    }

    public static void getBFQty(Map<Object, Set<String>> billInfo, Map<String, BigDecimal> bfQty, Map<String, DynamicObject> bfStockEntry, List<String> existEntryIds, DynamicObjectCollection bills, String sourcebill, String baseqtyName, String entryIdName) {
        List<List<Object>> bfBillInfo = OMStockBackFlushUtils.getBFBillInfo(bills, sourcebill, null);
        logger.info("------OMStockBackFlushUtils.getBFQty------bfBillInfo\u5927\u5c0f\u4e3a\uff1a" + bfBillInfo.size());
        for (List<Object> grid : bfBillInfo) {
            Object entryId;
            Set<String> set;
            DynamicObject stockDym;
            DynamicObject bill = (DynamicObject)grid.get(0);
            DynamicObject stockEntry = (DynamicObject)grid.get(1);
            BigDecimal canbfqty = OMStockBackFlushUtils.getCanBFQty(stockEntry, stockDym = (DynamicObject)grid.get(2), bill, baseqtyName, sourcebill);
            if (canbfqty.compareTo(BigDecimal.ZERO) <= 0) {
                canbfqty = BigDecimal.ZERO;
            }
            if ((set = billInfo.get(entryId = bill.get(entryIdName))) == null) {
                set = new HashSet<String>(10);
            }
            Object stockentryid = stockEntry.getPkValue();
            String idStr = sourcebill + "," + entryId.toString() + "," + stockentryid.toString();
            set.add(idStr);
            existEntryIds.add(idStr);
            bfQty.put(idStr, canbfqty);
            logger.info("------OMStockBackFlushUtils------\u5e94\u5012\u51b2\u6570\u91cf\u4e3a\uff1a" + sourcebill + "+" + idStr + "+" + canbfqty);
            billInfo.put(entryId, set);
            bfStockEntry.put(idStr, stockEntry);
        }
    }

    public static void updateStockBFStatus(Map<String, List<Object>> unExistRes, Map<String, BigDecimal> bfQty, Map<String, DynamicObject> bfStockEntry, Map<String, String> bfStatus) {
        for (Map.Entry<String, List<Object>> resInfo : unExistRes.entrySet()) {
            BigDecimal canbfqty;
            String key = resInfo.getKey();
            List<Object> list = resInfo.getValue();
            BigDecimal actissuebfqty = (BigDecimal)list.get(0);
            DynamicObject stockEntry = bfStockEntry.get(key);
            if ("B".equals(stockEntry.getString("qtytype"))) {
                actissuebfqty = stockEntry.getBigDecimal("actissueqty");
            }
            if ((canbfqty = bfQty.get(key)).compareTo(BigDecimal.ZERO) == 0 && actissuebfqty.compareTo(BigDecimal.ZERO) == 0) {
                bfStatus.put(key, "D");
                continue;
            }
            if (actissuebfqty.compareTo(BigDecimal.ZERO) == 0) {
                bfStatus.put(key, "A");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) < 0) {
                bfStatus.put(key, "B");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) == 0) {
                bfStatus.put(key, "C");
                continue;
            }
            if (actissuebfqty.compareTo(canbfqty) <= 0) continue;
            bfStatus.put(key, "E");
        }
    }

    public static void updateSourceBFStatusById(List<Long> entryIds, Map<Object, String> sourceBFStatus, String entityName, String entryIdName) {
        DynamicObject[] loads;
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)entityName, (String)"billno,billentry,billentry.backflushstatus", (QFilter[])new QFilter[]{new QFilter(entryIdName, "in", entryIds)})) {
            DynamicObjectCollection billentrys = load.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                String bfstatus = sourceBFStatus.get(billentry.getPkValue());
                if (bfstatus != null) {
                    billentry.set("backflushstatus", (Object)bfstatus);
                } else if (entryIds.contains((Long)billentry.getPkValue())) {
                    billentry.set("backflushstatus", (Object)"F");
                }
                logger.info("------OMStockBackFlushUtils------\u5355\u636e[" + load.getString("billno") + "]\u6700\u7ec8\u8bbe\u7f6e\u5012\u51b2\u6807\u8bc6\u4e3a\uff1a" + billentry.getString("backflushstatus"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])loads);
    }

    public static void updateSourceBFStatus(Map<Object, String> sourceBFStatus, Map<Object, Set<String>> billInfo, Map<String, String> bfStatus) {
        for (Map.Entry<Object, Set<String>> bill : billInfo.entrySet()) {
            Object key = bill.getKey();
            Set<String> values = bill.getValue();
            String sourceStatus = "B";
            int a = 0;
            int c = 0;
            int f = 0;
            int e = 0;
            for (String value : values) {
                String bfstatus = bfStatus.get(value);
                if ("A".equals(bfstatus)) {
                    ++a;
                    continue;
                }
                if ("C".equals(bfstatus)) {
                    ++c;
                    continue;
                }
                if ("F".equals(bfstatus)) {
                    ++f;
                    continue;
                }
                if (!"E".equals(bfstatus)) continue;
                ++e;
            }
            if (values.size() - f == 0) {
                sourceStatus = "F";
            } else if (values.size() - f == a) {
                sourceStatus = "A";
            } else if (values.size() - f == c) {
                sourceStatus = "C";
            } else if (values.size() - f == c + e) {
                sourceStatus = "E";
            }
            sourceBFStatus.put(key, sourceStatus);
            logger.info("------OMStockBackFlushUtils------\u5012\u51b2\u6807\u8bc6\u7edf\u8ba1\uff1a\u672a\u5012\u51b2A." + a + " \u5168\u90e8\u5012\u51b2C." + c + " \u4e0d\u5012\u51b2F." + f + " \u8d85\u989d\u5012\u51b2E." + e);
        }
    }

    public static String getMftInBillSelects() {
        return "id,billno,invscheme.bizdirection,billentry.id,billentry.manubill billentry.mainbillnumber,billentry.manubillid billentry.mainbillid,billentry.manuentry billentry.mainbillentryseq,billentry.manuentryid billentry.mainbillentryid,billentry.baseqty,billentry.manuentryid,billentry.remainreturnbaseqty,billentry.materialmasterid,billentry.backflushstatus,billentry.seq,biztime,billentry.baseunit";
    }

    public static String getMftOrderReportSelects() {
        return "id,billno,sumentry.id,sumentry.manufacturenun,sumentry.manufacturerow,sumentry.mftentryid,sumentry.completbsqty,sumentry.seq,reportdate,sumentry.baseunit";
    }

    public static List<List<Object>> getBFBillInfo(DynamicObjectCollection bills, String sourcebill, IDataModel model) {
        ArrayList<List<Object>> gridList = new ArrayList<List<Object>>(16);
        String orderEntryIdName = "billentry.mainbillentryid";
        String backFlushTimeName = "A";
        if ("A".equals(sourcebill)) {
            orderEntryIdName = "billentry.manuentryid";
            backFlushTimeName = "A";
        } else if ("B".equals(sourcebill)) {
            orderEntryIdName = "sumentry.mftentryid";
            backFlushTimeName = "B";
        }
        HashSet<Object> orderEntryId = new HashSet<Object>(bills.size());
        for (int i = 0; i < bills.size(); ++i) {
            orderEntryId.add(((DynamicObject)bills.get(i)).getLong(orderEntryIdName));
        }
        Map<Object, DynamicObject> stocks = OMStockBackFlushUtils.getStockDym(orderEntryId);
        for (int i = 0; i < bills.size(); ++i) {
            DynamicObject stockDym = stocks.get(((DynamicObject)bills.get(i)).getLong(orderEntryIdName));
            if (stockDym == null || !OMStockBackFlushUtils.getStockDymFilterRes(stockDym, model)) continue;
            DynamicObjectCollection stockEntry = stockDym.getDynamicObjectCollection("stockentry");
            boolean transactiontype = stockDym.getBoolean("transactiontypeid.returnbackflush");
            for (int j = 0; j < stockEntry.size(); ++j) {
                String backflushtime = ((DynamicObject)stockEntry.get(j)).getString("backflushtime");
                String isbackflush = ((DynamicObject)stockEntry.get(j)).getString("isbackflush");
                String issuemode = ((DynamicObject)stockEntry.get(j)).getString("issuemode");
                String qtytype = ((DynamicObject)stockEntry.get(j)).getString("qtytype");
                if (!backFlushTimeName.equals(backflushtime) || !"B".equals(isbackflush) || "C".equals(issuemode) || !OMStockBackFlushUtils.getFilterRes((DynamicObject)stockEntry.get(j), model) || (!"A".equals(sourcebill) || !"0".equals(((DynamicObject)bills.get(i)).getString("invscheme.bizdirection"))) && (!"A".equals(qtytype) || !transactiontype)) continue;
                ArrayList<Object> obj = new ArrayList<Object>(3);
                obj.add(bills.get(i));
                obj.add(stockEntry.get(j));
                obj.add(stockDym);
                gridList.add(obj);
                if (gridList.size() <= 200000) continue;
                gridList.clear();
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8fc7\u591a\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"OMStockBackFlushUtils_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        }
        return gridList;
    }

    private static boolean getStockDymFilterRes(DynamicObject stockDym, IDataModel model) {
        if (model != null) {
            DynamicObject bdproject;
            DynamicObject object;
            DynamicObject orderEntryDym;
            DynamicObject mftdeptorgid;
            DynamicObject producedept = (DynamicObject)model.getValue("producedept");
            boolean closeOrder = (Boolean)model.getValue("closeorder");
            if (!(producedept == null || (mftdeptorgid = stockDym.getDynamicObject("mftdeptorgid")) != null && mftdeptorgid.getPkValue().equals(producedept.getPkValue()))) {
                return false;
            }
            if (!closeOrder && "C".equals(stockDym.getString("orderentryid.bizstatus"))) {
                return false;
            }
            DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber");
            if (!(tracknumber == null || (orderEntryDym = stockDym.getDynamicObject("orderentryid")) == null || (object = orderEntryDym.getDynamicObject("tracknumber")) != null && object.getPkValue().equals(tracknumber.getPkValue()))) {
                return false;
            }
            DynamicObject projectmain = (DynamicObject)model.getValue("projectmain");
            if (!(projectmain == null || (bdproject = stockDym.getDynamicObject("bdproject")) != null && bdproject.getPkValue().equals(projectmain.getPkValue()))) {
                return false;
            }
        }
        return true;
    }

    private static boolean getFilterRes(DynamicObject stockEntryDym, IDataModel model) {
        DynamicObjectCollection materials;
        if (model != null && (materials = (DynamicObjectCollection)model.getValue("materialidmain")) != null && materials.size() > 0) {
            DynamicObject materialId = stockEntryDym.getDynamicObject("materielmasterid");
            for (DynamicObject material : materials) {
                if (materialId == null || !materialId.getPkValue().equals(material.getDynamicObject("fbasedataid").getPkValue())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static BigDecimal getCanBFQty(DynamicObject stockEntry, DynamicObject stockDym, DynamicObject bill, String baseqtyName, String sourcebill) {
        BigDecimal baseQty;
        BigDecimal qualityA = new BigDecimal(bill.getString(baseqtyName)).abs();
        DynamicObject mftstockEntryObj = stockEntry;
        boolean isReturnBackFlush = stockDym.getBoolean("transactiontypeid.returnbackflush");
        if (!isReturnBackFlush && StringUtils.equals((String)"A", (String)sourcebill) && "0".equals(bill.getString("invscheme.bizdirection"))) {
            qualityA = new BigDecimal(bill.getString("billentry.remainreturnbaseqty")).abs();
        }
        if ((baseQty = (BigDecimal)stockDym.get("baseqty")).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        DynamicObject materialunitid = mftstockEntryObj.getDynamicObject("materialunitid");
        int precision = materialunitid.getInt("precision");
        String qtyType = mftstockEntryObj.getString("qtytype");
        if ("B".equals(qtyType)) {
            return mftstockEntryObj.getBigDecimal("demandqty");
        }
        return qualityA.multiply(mftstockEntryObj.getBigDecimal("demandqty")).divide(baseQty, precision, OMStockBackFlushUtils.getRoundType(materialunitid));
    }

    private static int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    public static Map<Object, DynamicObject> getStockDym(Set<Object> orderEntryId) {
        DynamicObject[] stockArray = BusinessDataServiceHelper.load((String)"om_mftstock", (String)OMStockBackFlushUtils.getStockSelects(), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", orderEntryId), new QFilter("stockentry.isbackflush", "in", (Object)new String[]{"B", "C"})});
        HashMap<Object, DynamicObject> stockMap = new HashMap<Object, DynamicObject>(stockArray.length);
        for (int i = 0; i < stockArray.length; ++i) {
            stockMap.put(stockArray[i].getDynamicObject("orderentryid").getPkValue(), stockArray[i]);
        }
        return stockMap;
    }

    private static String getStockSelects() {
        return "orderno,baseunitid,mftdeptorgid,orderentryid,orderentryid.bizstatus,baseqty,transactiontypeid,productid,productmasterid,stockentry,stockentry.backflushtime,stockentry.isbackflush,stockentry.issuemode,stockentry.materialid,stockentry.materialunitid,stockentry.supplyorgid,stockentry.warehouseid,stockentry.demandqty,stockentry.qtytype,stockentry.supplymode,stockentry.supplierid,stockentry.location,stockentry.childauxpropertyid,stockentry.unissueqty,stockentry.cansendqty,stockentry.materielmasterid,stockentry.actissueqty,stockentry.entryconfiguredcode,transactiontypeid.returnbackflush,bdproject,stockentry.batchno,org";
    }
}

