/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.mdc.backflush.TailDiffBackFlushHelper;
import kd.scmc.im.common.mdc.utils.AutoBackFlushUtils;
import org.apache.commons.lang.StringUtils;

public class OmAutoBackFlushUtils {
    private static final String KEY_BILLENTITY = "billentity";
    private static Log logger = LogFactory.getLog(OmAutoBackFlushUtils.class);

    private OmAutoBackFlushUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, String> omBackFlushbatch(List<Map<String, Object>> bfParam) {
        HashMap<Long, String> bfRes = new HashMap<Long, String>(16);
        try {
            TailDiffBackFlushHelper.setSrcBillAutoBFHolderData(bfParam);
            for (Map<String, Object> objInfo : bfParam) {
                String backFlushRes;
                try {
                    backFlushRes = OmAutoBackFlushUtils.omBackFlush(objInfo);
                }
                catch (KDBizException e1) {
                    logger.error((Throwable)e1);
                    backFlushRes = e1.getMessage();
                }
                bfRes.put((Long)objInfo.get("id"), backFlushRes);
            }
        }
        finally {
            TailDiffBackFlushHelper.clearSrcBillAutoBFHolderData();
        }
        return bfRes;
    }

    public static String omBackFlush(Map<String, Object> objInfo) {
        ArrayList<String> backFlushErrList = new ArrayList<String>();
        DynamicObject obj = (DynamicObject)objInfo.get("billdym");
        DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("billentry");
        HashMap<String, List<Integer>> backFlushParam = new HashMap<String, List<Integer>>();
        backFlushParam.put("backFlushErrList", new ArrayList());
        backFlushParam.put("backFlushSuccessList", new ArrayList());
        backFlushParam.put("successedList", new ArrayList());
        for (int i = 0; i < entryCol.size(); ++i) {
            String isSuccessToStock = "audit";
            DynamicObject entryObj = (DynamicObject)entryCol.get(i);
            Map<String, Object> entryBFInfo = AutoBackFlushUtils.getEntryBFInfo(objInfo, entryObj.getPkValue());
            if (!"C".equals(entryObj.getString("backflushstatus"))) {
                entryBFInfo.put(KEY_BILLENTITY, objInfo.get(KEY_BILLENTITY));
                entryBFInfo.put("ordername", objInfo.get("ordername"));
                entryBFInfo.put("orderentry", objInfo.get("orderentry"));
                Object targetname = entryBFInfo.get("targetname");
                if ("im_mdc_omreturnbill".equals(targetname)) {
                    entryBFInfo.put("baseqty", entryObj.getBigDecimal("baseqty").abs());
                } else {
                    entryBFInfo.put("baseqty", entryObj.getBigDecimal("baseqty"));
                }
                if ("im_mdc_omcmplinbill".equals(objInfo.get(KEY_BILLENTITY))) {
                    entryBFInfo.put("orderid", entryObj.get("manubillid"));
                    entryBFInfo.put("orderentryid", entryObj.getLong("manuentryid"));
                } else {
                    entryBFInfo.put("orderid", entryObj.get("mainbillid"));
                    entryBFInfo.put("orderentryid", entryObj.getLong("mainbillentryid"));
                }
                isSuccessToStock = AutoBackFlushUtils.autoBackFlushStock(entryBFInfo);
            } else {
                backFlushParam.get("successedList").add(i + 1);
            }
            AutoBackFlushUtils.dealInfo(isSuccessToStock, backFlushErrList, entryObj, objInfo.get("operationkey").toString(), i + 1, backFlushParam);
        }
        AutoBackFlushUtils.dealbackFlushErrList(backFlushParam, backFlushErrList);
        SaveServiceHelper.update((DynamicObject)obj);
        if (backFlushErrList.isEmpty()) {
            return "";
        }
        return obj.get("billno") + "\uff1a" + StringUtils.strip((String)((Object)backFlushErrList).toString(), (String)"[]");
    }
}

