/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.common.mdc.utils.ManuBillPickStatusEnum;

public class OmOrderCalMaterialUtils {
    private static final Log logger = LogFactory.getLog(OmOrderCalMaterialUtils.class);
    private static final String IM_MDC_MTF_PRO_ORDER = "im_mdc_omproorder";
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    public static final String KEY_PRODUCTTYPE = "producttype";
    public static final String KEY_ENTITYID_STOCK = "om_componentlist";
    public static final String KEY_TEXT_ORDERID = "orderid";
    public static final String KEY_PRMT_ORDERENTRYID = "orderentryid";
    public static final String KEY_PICKSTATUS = "pickstatus";
    public static final String KEY_PICKINGPAIRS = "pickingpairs";

    public static void calMaterial(Map<String, String> measureunitData, Map<String, DynamicObject> transactiontypeMap, Set<String> orderidList, Set<Object> orderEntryidList, Map<String, DynamicObject> srcMap, boolean isFromManuBill) {
        QFilter filter = new QFilter(KEY_TEXT_ORDERID, "in", orderidList);
        filter.and(new QFilter(KEY_PRMT_ORDERENTRYID, "in", orderEntryidList));
        Map<String, List<Map<String, Object>>> stockMap = OmOrderCalMaterialUtils.getStockMap(filter);
        HashMap<String, String> proorderMap = new HashMap<String, String>();
        QFilter qfilter0 = new QFilter("billentry.manuentryid", "in", orderEntryidList);
        qfilter0.and("billstatus", "=", (Object)"C");
        qfilter0.and("billtype.billformid", "=", (Object)IM_MDC_MTF_PRO_ORDER);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"queryDownBill", (String)IM_MDC_MTF_PRO_ORDER, (String)"id,billentry.manuentryid", (QFilter[])new QFilter[]{qfilter0}, (String)"billentry.manuentryid");
        Object object = null;
        try {
            for (Row row : queryDataSet) {
                String manuentryid = row.getString("billentry.manuentryid");
                proorderMap.put(manuentryid, manuentryid);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        ArrayList<DynamicObject> mftOrders = new ArrayList<DynamicObject>(srcMap.size());
        for (Map.Entry entry : srcMap.entrySet()) {
            String billnoKey = (String)entry.getKey();
            DynamicObject order = (DynamicObject)entry.getValue();
            DynamicObjectCollection col = order.getDynamicObjectCollection("billentry");
            if (!isFromManuBill && !OmOrderCalMaterialUtils.isAutoCal(order, transactiontypeMap)) {
                logger.info("mftoutbackwrite----------\u4e0d\u8ba1\u7b97---------billnoKey\uff1a" + billnoKey);
                continue;
            }
            for (DynamicObject entry2 : col) {
                Object pkValue = entry2.getPkValue();
                if (!orderEntryidList.contains(pkValue)) continue;
                String orderMapkey = billnoKey + "@" + entry2.getPkValue();
                List<Map<String, Object>> stockCol = stockMap.get(orderMapkey);
                if (stockCol != null) {
                    logger.info("mftoutbackwrite----------stockcol---------" + stockCol.toString());
                }
                BigDecimal qty = entry2.getBigDecimal("qty");
                DynamicObject baseunit = entry2.getDynamicObject("unit");
                String measureunit = measureunitData.get(baseunit.getPkValue().toString());
                BigDecimal pickQty = OmOrderCalMaterialUtils.calPickQtyByEntry(transactiontypeMap, order, stockCol, qty, measureunit);
                logger.info("mftoutbackwrite----------pickQty---------" + pickQty);
                Boolean isExistsMaterialReq = Boolean.FALSE;
                if (proorderMap.containsKey(entry2.getPkValue().toString())) {
                    isExistsMaterialReq = Boolean.TRUE;
                }
                if (pickQty.compareTo(BigDecimal.ZERO) == 0 && !isExistsMaterialReq.booleanValue()) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.NOPICK.getValue());
                    continue;
                }
                if (pickQty.compareTo(BigDecimal.ZERO) == 0 && isExistsMaterialReq.booleanValue()) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.SOMEPICK.getValue());
                    continue;
                }
                if (pickQty.compareTo(BigDecimal.ZERO) > 0 && pickQty.compareTo(qty) < 0) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.SOMEPICK.getValue());
                    continue;
                }
                if (pickQty.compareTo(qty) == 0) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.ALLPICK.getValue());
                    continue;
                }
                if (pickQty.compareTo(qty) <= 0) continue;
                entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.MOREPICK.getValue());
            }
            mftOrders.add(order);
        }
        if (mftOrders != null && mftOrders.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])mftOrders.toArray(new DynamicObject[0]));
        }
    }

    public static boolean isAutoCal(DynamicObject manuBill, Map<String, DynamicObject> transactiontypeMap) {
        String transactiontype = manuBill.getString(KEY_TRANSACTIONTYPE);
        DynamicObject transtype = transactiontypeMap.get(transactiontype);
        if (transtype != null) {
            return transtype.getBoolean("isvolcal");
        }
        return false;
    }

    public static boolean isExistsMaterialReq(Object pkValue) throws KDException {
        if (pkValue == null) {
            return false;
        }
        ORM orm = ORM.create();
        QFilter qfilter = new QFilter("billentry.manuentryid", "=", pkValue);
        boolean isExistsOutBill = orm.exists(IM_MDC_MTF_PRO_ORDER, new QFilter[]{qfilter});
        return isExistsOutBill;
    }

    public static BigDecimal calPickQtyByEntry(Map<String, DynamicObject> transactiontypeMap, DynamicObject manuBill, List<Map<String, Object>> stockentrys, BigDecimal qty, String measureunit) {
        BigDecimal pickQty = BigDecimal.ZERO;
        if (stockentrys == null || stockentrys.size() < 1) {
            return pickQty;
        }
        Boolean pickflag = false;
        String controlscope = OmOrderCalMaterialUtils.getControlScope(manuBill, transactiontypeMap);
        for (Map<String, Object> stockentry : stockentrys) {
            BigDecimal actissueqty = stockentry.get("actissueqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("actissueqty");
            BigDecimal rejectedqty = stockentry.get("rejectedqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("rejectedqty");
            BigDecimal feedingqty = stockentry.get("feedingqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("feedingqty");
            BigDecimal scrapqty = stockentry.get("scrapqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("scrapqty");
            BigDecimal demandqty = stockentry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("demandqty");
            BigDecimal fixscrap = stockentry.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("fixscrap");
            String qtytype = (String)stockentry.get("qtytype");
            String isbackflush = (String)stockentry.get("isbackflush");
            boolean iskeypart = (Boolean)stockentry.get("iskeypart");
            String issuemode = (String)stockentry.get("issuemode");
            if ("C".equals(issuemode) || "A".equals(controlscope) && "B".equals(isbackflush) || "B".equals(controlscope) && !iskeypart || demandqty.compareTo(BigDecimal.ZERO) == 0) continue;
            if ("B".equals(qtytype)) {
                BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
                BigDecimal newpickqty = BigDecimal.ZERO;
                if (helpqty.compareTo(demandqty) >= 0) {
                    newpickqty = qty;
                }
                if (newpickqty.compareTo(pickQty) < 0) {
                    pickQty = newpickqty;
                    pickflag = true;
                    continue;
                }
                if (pickflag.booleanValue() || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            String[] split = measureunit.split("@@");
            int precision = Integer.parseInt(split[0]);
            String precisionaccount = split[1];
            int deal = 4;
            switch (precisionaccount) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
            BigDecimal newpickqty = helpqty.multiply(qty).divide(demandqty.subtract(fixscrap), precision, deal);
            if (newpickqty.compareTo(pickQty) < 0) {
                pickQty = newpickqty;
                pickflag = true;
                continue;
            }
            if (pickflag.booleanValue() || pickQty.compareTo(BigDecimal.ZERO) != 0) continue;
            pickQty = newpickqty;
            pickflag = true;
        }
        return pickQty;
    }

    public static String getControlScope(DynamicObject manuBill, Map<String, DynamicObject> transactiontypeMap) {
        String transactiontype = manuBill.getString(KEY_TRANSACTIONTYPE);
        DynamicObject transtype = transactiontypeMap.get(transactiontype);
        if (transtype != null) {
            return transtype.getString("controlscope");
        }
        return null;
    }

    private static String selectStockProperties() {
        StringBuilder selector = new StringBuilder();
        selector.append("id,orderno,orderentryid,stockentry.qtytype,stockentry.wipqty,");
        selector.append("stockentry.id,stockentry.actissueqty,stockentry.feedingqty,stockentry.rejectedqty,");
        selector.append("stockentry.scrapqty,stockentry.demandqty,");
        selector.append("stockentry.fixscrap,");
        selector.append("stockentry.isbackflush,stockentry.iskeypart,stockentry.issuemode,");
        selector.append("transactiontypeid,transactiontypeid.isconsiderloss");
        return selector.toString();
    }

    private static Map<String, List<Map<String, Object>>> getStockMap(QFilter filter) {
        HashMap<String, List<Map<String, Object>>> stockMap = new HashMap<String, List<Map<String, Object>>>();
        try (DataSet stockData = QueryServiceHelper.queryDataSet((String)"query_stockdata", (String)KEY_ENTITYID_STOCK, (String)OmOrderCalMaterialUtils.selectStockProperties(), (QFilter[])new QFilter[]{filter}, (String)" orderno,orderentryid");){
            for (Row row : stockData) {
                Map<Object, Object> rowMap = new HashMap(16);
                List rowList = new ArrayList();
                String billnoKey = row.getString("orderno");
                String stockMapkey = billnoKey + "@" + row.get(KEY_PRMT_ORDERENTRYID);
                if (stockMap.containsKey(stockMapkey)) {
                    rowList = (List)stockMap.get(stockMapkey);
                    rowMap = OmOrderCalMaterialUtils.getrowMap(row);
                    rowList.add(rowMap);
                    continue;
                }
                rowList = new ArrayList();
                rowMap = OmOrderCalMaterialUtils.getrowMap(row);
                rowList.add(rowMap);
                stockMap.put(stockMapkey, rowList);
            }
        }
        return stockMap;
    }

    private static Map<String, Object> getrowMap(Row row) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        rowMap.put("actissueqty", row.getBigDecimal("stockentry.actissueqty"));
        rowMap.put("feedingqty", row.getBigDecimal("stockentry.feedingqty"));
        rowMap.put("rejectedqty", row.getBigDecimal("stockentry.rejectedqty"));
        rowMap.put("scrapqty", row.getBigDecimal("stockentry.scrapqty"));
        rowMap.put("demandqty", row.getBigDecimal("stockentry.demandqty"));
        rowMap.put("fixscrap", row.getBigDecimal("stockentry.fixscrap"));
        rowMap.put("qtytype", row.getString("stockentry.qtytype"));
        rowMap.put("isbackflush", row.getString("stockentry.isbackflush"));
        rowMap.put("issuemode", row.getString("stockentry.issuemode"));
        rowMap.put("iskeypart", row.getBoolean("stockentry.iskeypart"));
        return rowMap;
    }
}

