/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class OrderBookDateService {
    private static final Log logger = LogFactory.getLog(OrderBookDateService.class);
    private static final String KEY_BOOKDATE_EQUALS_BIZDATE = "INV0004";

    public static Date queryMaxBookDate(long productOrgId, long invOrgId, Map<Long, Date> productOrgAndBookDateMap, Map<Long, Date> invOrgAndBookDateMap) {
        Date tempDate;
        Date maxBookDate = null;
        for (Map.Entry<Long, Date> productBookDateEntry : productOrgAndBookDateMap.entrySet()) {
            long productOrgIdInEntry = productBookDateEntry.getKey();
            if (productOrgId != productOrgIdInEntry || null == (tempDate = productBookDateEntry.getValue())) continue;
            maxBookDate = maxBookDate == null ? tempDate : (maxBookDate.after(tempDate) ? maxBookDate : tempDate);
            logger.info("\u751f\u4ea7\u7ec4\u7ec7maxBookDate---" + maxBookDate);
        }
        for (Map.Entry<Long, Date> invBookDateEntry : invOrgAndBookDateMap.entrySet()) {
            long invOrgIdInEntry = invBookDateEntry.getKey();
            if (invOrgId != invOrgIdInEntry || null == (tempDate = invBookDateEntry.getValue())) continue;
            maxBookDate = maxBookDate == null ? tempDate : (maxBookDate.after(tempDate) ? maxBookDate : tempDate);
            logger.info("\u5e93\u5b58\u7ec4\u7ec7maxBookDate---" + maxBookDate);
        }
        return maxBookDate;
    }

    public static boolean bookDateEqualsBizDate() {
        return false;
    }

    public static boolean isIntertemporal(Date compareBookDate, Date bookDate) {
        boolean result = false;
        if (null != compareBookDate && null != bookDate && compareBookDate.before(OrderBookDateService.theDayAfterMaxBookDate(bookDate))) {
            result = true;
        }
        return result;
    }

    public static Date theDayAfterMaxBookDate(Date date) {
        Date theDayAfterMaxBookDate = null;
        if (null != date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            ((Calendar)calendar).add(5, 1);
            theDayAfterMaxBookDate = calendar.getTime();
            logger.info("theDayAfterMaxBookDate---" + theDayAfterMaxBookDate);
        }
        return theDayAfterMaxBookDate;
    }
}

