/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.common.mdc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalManager;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.api.InvRealAccQueryService;
import kd.scmc.im.business.helper.matchruleout.MatchingRuleOutHandler;
import kd.scmc.im.common.mdc.helper.InvMatchingRuleOutHelper;
import kd.scmc.im.common.mdc.helper.InvMatchingRuleOutHelperNew;
import kd.scmc.im.common.mdc.utils.AutoBackFlushUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class StockBackFlushUtils {
    private static final Log logger = LogFactory.getLog(StockBackFlushUtils.class);

    private StockBackFlushUtils() {
    }

    public static OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    public static Map<String, List<Object>> getUnExistBFInfo(List<String> unExistEntryIds) {
        HashMap res = Maps.newHashMapWithExpectedSize((int)unExistEntryIds.size());
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        String entityName = "im_mdc_mftproorder";
        for (int i = 0; i < unExistEntryIds.size(); ++i) {
            String unExistEntryId = unExistEntryIds.get(i);
            String[] split = unExistEntryId.split(",");
            sourceBillEntryidSet.add(Long.parseLong(split[1]));
            stockEntryIdSet.add(Long.parseLong(split[2]));
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            info.add(BigDecimal.ZERO);
            info.add(Boolean.valueOf(false));
            res.put(unExistEntryId, info);
            if (!StringUtils.equals((String)"G", (String)split[0])) continue;
            entityName = "im_mdc_mftreturnorder";
        }
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", sourceBillEntryidSet);
        filter.and(new QFilter("billentry.mainbillentryid", "in", stockEntryIdSet));
        filter.and(new QFilter("ischargeoff", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("ischargeoffed", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)"billentry.srcbillentity,billentry.srcbillentryid,billentry.mainbillentryid,billentry.remainreturnbaseqty", (QFilter[])new QFilter[]{filter});
        StockBackFlushUtils.fillInfo(bills, res);
        return res;
    }

    private static void fillInfo(DynamicObjectCollection bills, Map<String, List<Object>> res) {
        HashMap qtyRes = new HashMap();
        for (DynamicObject bill : bills) {
            String sourcebillentry = "A";
            if ("im_mdc_mftmanuinbill".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "A";
            } else if ("pom_mftorderreport".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "B";
            } else if ("sfc_processreportbill".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "C";
            } else if ("sfc_protransferbill".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "D";
            } else if ("sfc_manftech".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "F";
            } else if ("im_mdc_mftreturnbill".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "G";
            } else if ("prop_mftorderreport".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "H";
            } else if ("prop_processreportbill".equals(bill.getString("billentry.srcbillentity"))) {
                sourcebillentry = "I";
            }
            String sourcebillentryid = bill.getString("billentry.srcbillentryid");
            String stockentryid = bill.getString("billentry.mainbillentryid");
            BigDecimal baseqty = bill.getBigDecimal("billentry.remainreturnbaseqty").abs();
            String idStr = sourcebillentry + "," + sourcebillentryid + "," + stockentryid;
            List info = qtyRes.get(idStr) == null ? new ArrayList() : (List)qtyRes.get(idStr);
            info.add(baseqty);
            qtyRes.put(idStr, info);
        }
        for (Map.Entry result : qtyRes.entrySet()) {
            String key = (String)result.getKey();
            List value = (List)result.getValue();
            BigDecimal qty = BigDecimal.ZERO;
            for (int i = 0; i < value.size(); ++i) {
                qty = qty.add((BigDecimal)value.get(i));
            }
            ArrayList<Comparable<BigDecimal>> info = new ArrayList<Comparable<BigDecimal>>(2);
            Boolean bfclose = false;
            info.add(qty);
            info.add(bfclose);
            res.put(key, info);
        }
    }

    public static boolean getSelectEntry(int index, String[] split) {
        for (int i = 0; i < split.length; ++i) {
            if (Integer.parseInt(split[i]) != index) continue;
            return true;
        }
        return false;
    }

    public static String delResLog(Map<DynamicObject, String> res, String string, DynamicObject backFlushLog) {
        long start = System.currentTimeMillis();
        StockBackFlushUtils.updateBFStatus(res);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u66f4\u65b0\u5012\u51b2\u72b6\u6001\u7ed3\u675f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        ArrayList<String> unExistEntryIds = new ArrayList<String>();
        for (Map.Entry<DynamicObject, String> result : res.entrySet()) {
            StockBackFlushUtils.setLogBillEntry(result, backFlushLog, unExistEntryIds, string);
        }
        return backFlushLog.getPkValue().toString();
    }

    private static void updateBFStatus(Map<DynamicObject, String> res) {
        ArrayList<Object> entryIdList_a = new ArrayList<Object>(10);
        ArrayList<Object> entryIdList_b = new ArrayList<Object>(10);
        ArrayList<Object> entryIdList_c = new ArrayList<Object>(10);
        ArrayList<Object> entryIdList_g = new ArrayList<Object>(10);
        ArrayList<Object> entryIdList_h = new ArrayList<Object>(10);
        ArrayList<Object> entryIdList_i = new ArrayList<Object>(10);
        for (Map.Entry<DynamicObject, String> result : res.entrySet()) {
            DynamicObject key = result.getKey();
            String sourcebillentry = key.getString("sourcebillentry");
            String sourcebillentryid = key.getString("sourcebillentryid");
            if ("A".equals(sourcebillentry)) {
                entryIdList_a.add(NumberUtils.toLong((String)sourcebillentryid));
                continue;
            }
            if ("B".equals(sourcebillentry)) {
                entryIdList_b.add(NumberUtils.toLong((String)sourcebillentryid));
                continue;
            }
            if ("C".equals(sourcebillentry)) {
                entryIdList_c.add(NumberUtils.toLong((String)sourcebillentryid));
                continue;
            }
            if ("G".equals(sourcebillentry)) {
                entryIdList_g.add(NumberUtils.toLong((String)sourcebillentryid));
                continue;
            }
            if ("H".equals(sourcebillentry)) {
                entryIdList_h.add(NumberUtils.toLong((String)sourcebillentryid));
                continue;
            }
            if (!"I".equals(sourcebillentry)) continue;
            entryIdList_i.add(NumberUtils.toLong((String)sourcebillentryid));
        }
        if (!entryIdList_a.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList_a, "im_mdc_mftmanuinbill");
        }
        if (!entryIdList_b.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList_b, "pom_mftorderreport");
        }
        if (!entryIdList_c.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList_c, "sfc_processreportbill");
        }
        if (!entryIdList_g.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList_g, "im_mdc_mftreturnbill");
        }
        if (!entryIdList_h.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList_h, "prop_mftorderreport");
        }
        if (!entryIdList_i.isEmpty()) {
            AutoBackFlushUtils.updateBFStatusByEntryId(entryIdList_i, "prop_processreportbill");
        }
    }

    public static Map<String, List<Object>> updateStockBFInfo(List<String> unExistEntryIds, String bfclose) {
        DynamicObject[] bills;
        HashMap<String, List<Object>> unExistRes = new HashMap<String, List<Object>>(16);
        HashSet<String> sourceBillEntrySet = new HashSet<String>(16);
        HashSet<Long> sourceBillEntryidSet = new HashSet<Long>(16);
        HashSet<Long> stockEntryIdSet = new HashSet<Long>(16);
        for (int i = 0; i < unExistEntryIds.size(); ++i) {
            String[] split = unExistEntryIds.get(i).split(",");
            sourceBillEntrySet.add(split[0]);
            sourceBillEntryidSet.add(Long.parseLong(split[1]));
            stockEntryIdSet.add(Long.parseLong(split[2]));
        }
        QFilter filter = new QFilter("sourcebillentry", "in", sourceBillEntrySet);
        filter.and(new QFilter("sourcebillentryid", "in", sourceBillEntryidSet));
        filter.and(new QFilter("stockentryid", "in", stockEntryIdSet));
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"im_mdc_backflushstock", (String)"sourcebillentry,sourcebillentryid,stockentryid,actissuebfqty,bfclose", (QFilter[])new QFilter[]{filter})) {
            String sourcebillentry = bill.getString("sourcebillentry");
            String sourcebillentryid = bill.getString("sourcebillentryid");
            String stockentryid = bill.getString("stockentryid");
            String idStr = sourcebillentry + "," + sourcebillentryid + "," + stockentryid;
            List list = (List)unExistRes.get(idStr);
            if (list != null) {
                bill.set("actissuebfqty", list.get(0));
            }
            if ("A".equals(bfclose)) {
                bill.set("bfclose", (Object)true);
                continue;
            }
            if (!"B".equals(bfclose)) continue;
            bill.set("bfclose", (Object)false);
        }
        SaveServiceHelper.update((DynamicObject[])bills);
        return unExistRes;
    }

    public static void batchBackFlushClose(Map<Object, Object> info, String bill, String entityName) {
        ArrayList<String> existEntryIds = new ArrayList<String>(8);
        HashSet orderEntryId = Sets.newHashSetWithExpectedSize((int)info.size());
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            orderEntryId.add(entry.getValue());
        }
        Map<Object, DynamicObject> stocks = StockBackFlushUtils.getStockDym(orderEntryId, entityName);
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            DynamicObject stockDym = stocks.get(entry.getValue());
            if (stockDym == null) continue;
            DynamicObjectCollection stockEntry = stockDym.getDynamicObjectCollection("stockentry");
            for (int j = 0; j < stockEntry.size(); ++j) {
                existEntryIds.add(bill + "," + entry.getKey() + "," + ((DynamicObject)stockEntry.get(j)).getPkValue().toString());
            }
        }
        StockBackFlushUtils.updateStockBFInfo(existEntryIds, "B");
    }

    private static void setLogBillEntry(Map.Entry<DynamicObject, String> result, DynamicObject backFlushLog, List<String> unExistEntryIds, String string) {
        DynamicObject key = result.getKey();
        String value = result.getValue();
        String bfstatus = "success";
        if ("unbackflush".equals(string)) {
            bfstatus = "success".equals(value) ? "C" : "D";
            if ("success".equals(value)) {
                value = ResManager.loadKDString((String)" ", (String)"StockBackFlushUtils_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
        } else if ("backflush".equals(string)) {
            bfstatus = "success".equals(value) ? "A" : "B";
            if ("E".equals(value)) {
                bfstatus = "E";
            }
            if ("".equals(value)) {
                value = ResManager.loadKDString((String)"\u624b\u5de5\u7ec8\u6b62\u4efb\u52a1\u3002", (String)"StockBackFlushUtils_0", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            } else if ("success".equals(value)) {
                value = ResManager.loadKDString((String)" ", (String)"StockBackFlushUtils_1", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            } else if ("E".equals(value)) {
                value = ResManager.loadKDString((String)"\u5e93\u5b58\u4e0d\u8db3\uff0c\u90e8\u5206\u5012\u51b2\u3002", (String)"StockBackFlushUtils_2", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
        }
        String sourcebillentry = key.getString("sourcebillentry");
        String sourcebillentryid = key.getString("sourcebillentryid");
        String stockentryid = key.getString("stockentryid");
        unExistEntryIds.add(sourcebillentry + "," + sourcebillentryid + "," + stockentryid);
        DynamicObjectCollection billEntrys = backFlushLog.getDynamicObjectCollection("billentry");
        DynamicObject billEntry = ORM.create().newDynamicObject("im_mdc_backflushlog.billentry");
        billEntry.set("bfstatus", (Object)bfstatus);
        billEntry.set("sourcebillentry", key.get("sourcebillentry"));
        billEntry.set("sourcebillno", key.get("sourcebillno"));
        billEntry.set("billseq", key.get("billseq"));
        billEntry.set("biztime", key.get("biztime"));
        billEntry.set("materialid", key.get("materialid"));
        billEntry.set("productid", key.get("productid"));
        billEntry.set("materielmasterid", key.get("materielmasterid"));
        if (value.length() > 1000) {
            logger.info("\u5012\u51b2\u4fe1\u606f\u8d85\u957f\u8bb0\u5f55\uff1a" + value);
            billEntry.set("bfres", (Object)(value.substring(0, 990) + "..."));
        } else {
            billEntry.set("bfres", (Object)value);
        }
        billEntry.set("sourcebillentryid", key.get("sourcebillentryid"));
        billEntry.set("stockid", key.get("stockid"));
        billEntry.set("sourcebillid", key.get("sourcebillid"));
        billEntry.set("stockentryid", key.get("stockentryid"));
        billEntrys.add((Object)billEntry);
    }

    public Map<String, BigDecimal> getWareHouseQty() {
        HashSet wareHouseMater = new HashSet();
        HashSet<Long> materialSet = new HashSet<Long>();
        HashSet<Long> warehouseSet = new HashSet<Long>();
        HashSet<Long> locationSet = new HashSet<Long>();
        HashSet<Long> orgSet = new HashSet<Long>();
        for (String wareHouse : wareHouseMater) {
            String[] split = wareHouse.split(",");
            if (split.length != 4) continue;
            materialSet.add(Long.parseLong(split[0]));
            warehouseSet.add(Long.parseLong(split[1]));
            locationSet.add(Long.parseLong(split[2]));
            orgSet.add(Long.parseLong(split[3]));
        }
        QFilter filter = new QFilter("material", "in", materialSet);
        filter.and(new QFilter("warehouse", "in", warehouseSet));
        filter.and(new QFilter("location", "in", locationSet));
        filter.and(new QFilter("org", "in", orgSet));
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"im_inv_realbalance", (String)"org,material,warehouse,location,baseqty", (QFilter[])new QFilter[]{filter});
        HashMap wareHouseMap = Maps.newHashMapWithExpectedSize((int)bills.size());
        for (DynamicObject bill : bills) {
            wareHouseMap.put(bill.getString("material") + "," + bill.getString("warehouse") + "," + bill.getString("location") + "," + bill.getString("org"), bill.getBigDecimal("baseqty"));
        }
        return wareHouseMap;
    }

    public static Map<Object, DynamicObject> getStockDym(Set<Object> orderEntryId, String stockEntityName) {
        long start = System.currentTimeMillis();
        logger.info("getStockDym---stockEntityName---" + stockEntityName);
        DynamicObject[] stockArray = BusinessDataServiceHelper.load((String)stockEntityName, (String)StockBackFlushUtils.getStockSelects(), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", orderEntryId), new QFilter("stockentry.isbackflush", "in", (Object)new String[]{"B", "C"})});
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0load\u7ec4\u4ef6\u6e05\u5355\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        HashMap<Object, DynamicObject> stockMap = new HashMap<Object, DynamicObject>(stockArray.length);
        for (int i = 0; i < stockArray.length; ++i) {
            DynamicObject orderEntry = stockArray[i].getDynamicObject("orderentryid");
            if (orderEntry == null) continue;
            stockMap.put(orderEntry.getPkValue(), stockArray[i]);
        }
        return stockMap;
    }

    public static Map<Object, DynamicObject> getMftOrderDym(List<QFilter> mOrderQf) {
        DynamicObject[] stockArray = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)StockBackFlushUtils.getMftOrderSelects(), (QFilter[])mOrderQf.toArray(new QFilter[mOrderQf.size()]));
        HashMap<Object, DynamicObject> stockMap = new HashMap<Object, DynamicObject>(stockArray.length);
        for (int i = 0; i < stockArray.length; ++i) {
            stockMap.put(stockArray[i].getDynamicObject("treeentryentity.seq").getPkValue(), stockArray[i]);
        }
        return stockMap;
    }

    public static String getStockSelects() {
        return "orderno,baseunitid,mftdeptorgid,orderentryid,orderentryid.bizstatus,baseqty,transactiontypeid,transactiontypeid.returnbackflush,productid,productmasterid,stockentry,stockentry.backflushtime,stockentry.isbackflush,stockentry.issuemode,stockentry.materialid,stockentry.materialunitid,stockentry.supplyorgid,stockentry.warehouseid,stockentry.demandqty,stockentry.qtytype,stockentry.supplymode,stockentry.supplierid,stockentry.location,stockentry.childauxpropertyid,stockentry.unissueqty,stockentry.cansendqty,stockentry.materielmasterid,stockentry.actissueqty,stockentry.entryconfiguredcode,stockentry.processseq,stockentry.oprno,stockentry.beginworkbf,bdproject,stockentry.batchno,org";
    }

    private static String getMftOrderSelects() {
        return "billno,id,org,treeentryentity.seq,treeentryentity.producttype,treeentryentity.material,treeentryentity.unit,treeentryentity.producedept,treeentryentity.qty,treeentryentity.baseunit,treeentryentity.baseqty";
    }

    public static String handleMatchingRule(List<DynamicObject> targetBillObjs, String pagecachebfinvqty, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        DynamicObject targetBillObj;
        int j;
        ArrayList<DynamicObject> failed = new ArrayList<DynamicObject>(targetBillObjs.size());
        IDataEntityType type = targetBillObjs.get(0).getDataEntityType();
        String billname = targetBillObjs.get(0).getDataEntityType().getName();
        Map cfgs = MatchingRuleOutHandler.getInvQueryCfgs((String)billname, (String)"billentry", (String)"matchingruleout");
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey(targetBillObjs, type);
        StockBackFlushUtils.setNoUpdateFileds(targetBillObjs);
        DynamicObject materialReqOutBill = targetBillObjs.get(0);
        CloneUtils cloneUtils = new CloneUtils(false, false);
        DynamicObject dynamicObjectNew = (DynamicObject)cloneUtils.clone((IDataEntityBase)materialReqOutBill);
        DynamicObjectCollection tbillEntrys2 = (DynamicObjectCollection)dynamicObjectNew.get("billentry");
        HashMap<Long, Long> entryAndPkidMap = new HashMap<Long, Long>(targetBillObjs.size());
        HashMap<Long, DynamicObject> tarDyMap = new HashMap<Long, DynamicObject>(targetBillObjs.size());
        for (j = 0; j < targetBillObjs.size(); ++j) {
            targetBillObj = targetBillObjs.get(j);
            Long pkid = (Long)targetBillObj.getPkValue();
            tarDyMap.put(pkid, targetBillObj);
            DynamicObjectCollection tbillEntry = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject row : tbillEntry) {
                Long rowid = (Long)row.getPkValue();
                entryAndPkidMap.put(rowid, pkid);
            }
            if (j <= 0) continue;
            tbillEntrys2.addAll((Collection)tbillEntry);
        }
        if (cfgs == null || cfgs.isEmpty()) {
            logger.info("\u5012\u51b2\uff1a\u65e7\u5339\u914d\u89c4\u5219\u51fa\u5e93\u903b\u8f91\uff0c\u5148\u4e0d\u5904\u7406\u3002");
            for (j = 0; j < targetBillObjs.size(); ++j) {
                targetBillObj = targetBillObjs.get(j);
                DynamicObject org = targetBillObj.getDynamicObject("org");
                if (org == null) continue;
                DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
                Map<String, Object> matchingRule = InvMatchingRuleOutHelper.invAccQueryForMatchingRule(tbillEntrys, org.getPkValue(), pagecachebfinvqty, stockBFMap, res);
                if (((Boolean)matchingRule.get("success")).booleanValue()) {
                    DynamicObjectCollection entry = (DynamicObjectCollection)matchingRule.get("result");
                    if (entry == null || entry.size() <= 0) {
                        failed.add(targetBillObj);
                        continue;
                    }
                    targetBillObj.set("billentry", (Object)entry);
                    continue;
                }
                failed.add(targetBillObj);
                String mes = String.format(ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u51fa\u5e93\u5931\u8d25\uff1a%s", (String)"StockBackFlushUtils_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), matchingRule.get("message").toString());
                if (res != null) {
                    for (DynamicObject entry : tbillEntrys) {
                        StockBackFlushUtils.setErr(entry, res, stockBFMap, mes);
                    }
                    continue;
                }
                return mes;
            }
            targetBillObjs.removeAll(failed);
            return "";
        }
        logger.info("\u5012\u51b2\uff1a\u65b0\u5339\u914d\u89c4\u5219\u51fa\u5e93\u903b\u8f91");
        String invAccQueryForMatchingRuleNew = InvMatchingRuleOutHelperNew.invAccQueryForMatchingRuleNew(dynamicObjectNew, pagecachebfinvqty, stockBFMap, res, entryAndPkidMap, tarDyMap);
        targetBillObjs.clear();
        for (Map.Entry tMap : tarDyMap.entrySet()) {
            targetBillObjs.add((DynamicObject)tMap.getValue());
        }
        return invAccQueryForMatchingRuleNew;
    }

    private static void setNoUpdateFileds(List<DynamicObject> targetBillObjs) {
        String formId = "im_mdc_mftproorder";
        HashSet<Object> materialIdSet = new HashSet<Object>(16);
        for (DynamicObject targetBillObj : targetBillObjs) {
            formId = targetBillObj.getDataEntityType().getName();
            DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject tbillEntry : tbillEntrys) {
                DynamicObject material = tbillEntry.getDynamicObject("material");
                if (material == null) continue;
                materialIdSet.add(material.getPkValue());
            }
        }
        logger.info("----------NoUpdateFieldsAnalysisHelper,materialIdSet:" + materialIdSet);
        Map noUpdateFiledsMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"NoUpdateInvService", (String)"getNoUpdateFields", (Object[])new Object[]{formId, "billentry", materialIdSet});
        logger.info("---------------NoUpdateFieldsAnalysisHelper,noUpdateFiledsMap:" + noUpdateFiledsMap);
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
            for (DynamicObject tbillEntry : tbillEntrys) {
                DynamicObject material = tbillEntry.getDynamicObject("material");
                if (material == null) continue;
                String value = (String)noUpdateFiledsMap.get(material.getPkValue());
                tbillEntry.set("noupdateinvfields", (Object)value);
            }
        }
    }

    public static void setErr(DynamicObject entry, Map<DynamicObject, String> res, Map<Object, List<DynamicObject>> stockBFMap, String string) {
        Object stockEntryId = entry.get("mainbillentryid");
        Object srcEntryId = entry.get("srcbillentryid");
        List<DynamicObject> list = stockBFMap.get(stockEntryId);
        for (DynamicObject stockBFDym : list) {
            if (!stockBFDym.get("sourcebillentryid").equals(srcEntryId)) continue;
            res.put(stockBFDym, string);
        }
    }

    public static void handleInvQty(List<DynamicObject> targetBillObjs, String pagecachebfinvqty, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        if ("true".equals(pagecachebfinvqty)) {
            ArrayList<DynamicObject> failed = new ArrayList<DynamicObject>(targetBillObjs.size());
            for (DynamicObject targetBillObj : targetBillObjs) {
                StringBuilder alertMsg = new StringBuilder();
                DynamicObject org = targetBillObj.getDynamicObject("org");
                if (org == null) continue;
                DynamicObjectCollection billEntry = (DynamicObjectCollection)targetBillObj.get("billentry");
                for (int i = 0; i < billEntry.size(); ++i) {
                    DynamicObject entry = (DynamicObject)billEntry.get(i);
                    String confirmMsg = StockBackFlushUtils.invQtyValidateAlertMsg(entry);
                    if (!confirmMsg.isEmpty()) continue;
                    Map<String, Object> params = StockBackFlushUtils.getInvQtyParams(entry, org);
                    alertMsg.append(StockBackFlushUtils.setInvQty(params, entry, i + 1, stockBFMap, res));
                }
                if ("".equals(alertMsg.toString())) continue;
                failed.add(targetBillObj);
                for (DynamicObject entry : billEntry) {
                    StockBackFlushUtils.setErr(entry, res, stockBFMap, alertMsg.length() > 0 ? alertMsg.deleteCharAt(alertMsg.length() - 1).append("\u3002").toString() : alertMsg.toString());
                }
            }
            targetBillObjs.removeAll(failed);
        }
    }

    public static void dealInvRealbalance(List<DynamicObject> targetBillObjs, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res, String targetName, List<Object> saveSuccessList, Map<String, BigDecimal> billCanbfqty) {
        logger.info("autoReservePredictStr\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4fe1\u606f\uff1a" + targetBillObjs);
        Object invokeBizService = DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"MpsReserveService", (String)"autoReservePredictStr", (Object[])new Object[]{"im_mdc_mftproorder", targetBillObjs.toArray(new DynamicObject[0])});
        logger.info("autoReservePredictStr\u8c03\u7528\u5e93\u5b58\u63a5\u53e3\u4fe1\u606f\u8fd4\u56de\uff1a" + invokeBizService);
        HashMap failedMap = new HashMap(16);
        HashMap<Long, JSONObject> rowDataMap = new HashMap<Long, JSONObject>(16);
        if (invokeBizService != null) {
            JSONArray parseArray = JSON.parseArray((String)((String)invokeBizService));
            for (int i = 0; i < parseArray.size(); ++i) {
                JSONObject data = (JSONObject)parseArray.get(i);
                String reserveResultType = (String)data.get((Object)"reserveResultType");
                Long billId = (Long)data.get((Object)"billId");
                if (!"Failed".equals(reserveResultType) && !"PartSuccess".equals(reserveResultType)) continue;
                JSONArray entry = (JSONArray)data.get((Object)"entryResultList");
                HashSet<Long> entryFailedSet = new HashSet<Long>(16);
                for (int rowindex = 0; rowindex < entry.size(); ++rowindex) {
                    JSONObject rowdata = (JSONObject)entry.get(rowindex);
                    String rowReserveResultType = (String)rowdata.get((Object)"reserveResultType");
                    Long entryId = (Long)rowdata.get((Object)"entryId");
                    if (!"Failed".equals(rowReserveResultType)) continue;
                    entryFailedSet.add(entryId);
                    rowDataMap.put(entryId, rowdata);
                }
                if (entryFailedSet.isEmpty()) continue;
                failedMap.put(billId, entryFailedSet);
            }
        }
        logger.info("autoReservePredictStr---failedMap----" + failedMap);
        if (failedMap != null && !failedMap.isEmpty()) {
            Set eset;
            DynamicObjectCollection billEntry;
            Long id;
            ArrayList<DynamicObject> romoveList = new ArrayList<DynamicObject>(8);
            for (DynamicObject targetBillObj : targetBillObjs) {
                id = (Long)targetBillObj.getPkValue();
                billEntry = (DynamicObjectCollection)targetBillObj.get("billentry");
                if (!failedMap.containsKey(id) || (eset = (Set)failedMap.get(id)).size() != billEntry.size()) continue;
                romoveList.add(targetBillObj);
                for (DynamicObject entry : billEntry) {
                    String mpsReserveServiceError = StockBackFlushUtils.getMpsReserveServiceError(entry, rowDataMap);
                    logger.info("autoReservePredictStr---mpsReserveServiceError----" + mpsReserveServiceError);
                    StockBackFlushUtils.setErr(entry, res, stockBFMap, mpsReserveServiceError);
                }
            }
            if (!romoveList.isEmpty()) {
                targetBillObjs.removeAll(romoveList);
            }
            if (targetBillObjs != null && !targetBillObjs.isEmpty()) {
                for (DynamicObject targetBillObj : targetBillObjs) {
                    id = (Long)targetBillObj.getPkValue();
                    billEntry = (DynamicObjectCollection)targetBillObj.get("billentry");
                    if (!failedMap.containsKey(id)) continue;
                    eset = (Set)failedMap.get(id);
                    for (DynamicObject entry : billEntry) {
                        Long entryid = entry.getLong("id");
                        if (!eset.contains(entryid)) continue;
                        String mpsReserveServiceError = StockBackFlushUtils.getMpsReserveServiceError(entry, rowDataMap);
                        logger.info("autoReservePredictStr---mpsReserveServiceError222----" + mpsReserveServiceError);
                        StockBackFlushUtils.setErr(entry, res, stockBFMap, mpsReserveServiceError);
                    }
                    billEntry.removeIf(x -> eset.contains(x.getLong("id")));
                }
            }
        }
        if (targetBillObjs.isEmpty()) {
            return;
        }
        long start3 = System.currentTimeMillis();
        int size3 = targetBillObjs.size();
        String billCanbfqtyStr = JSON.toJSONString(billCanbfqty);
        OperateOption saveOption = StockBackFlushUtils.getOperateOption();
        saveOption.setVariableValue("billCanbfqtyStr", billCanbfqtyStr);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)targetName, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
        logger.info("\u751f\u4ea7\u5012\u51b2\u5e73\u53f0\u4fdd\u5b58\u9886\u6599\u5355,\u5171" + size3 + "\u6761\uff0c,\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start3));
        StockBackFlushUtils.setErrlog(saveResult, targetBillObjs, stockBFMap, res, "save");
        saveSuccessList.addAll(saveResult.getSuccessPkIds());
    }

    public static String getMpsReserveServiceError(DynamicObject entry, Map<Long, JSONObject> rowDataMap) {
        StringBuilder sb = new StringBuilder();
        Long entryid = entry.getLong("id");
        if (rowDataMap.containsKey(entryid)) {
            JSONObject jsonObject = rowDataMap.get(entryid);
            DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
            String materialName = material.getString("name");
            String materialNumber = material.getString("number");
            BigDecimal reservedQty = jsonObject.get((Object)"reservedQty") == null ? BigDecimal.ZERO : (BigDecimal)jsonObject.get((Object)"reservedQty");
            Integer reservedBaseQty = jsonObject.get((Object)"reservedBaseQty") == null ? Integer.valueOf(0) : (Integer)jsonObject.get((Object)"reservedBaseQty");
            BigDecimal reservedQty2nd = jsonObject.get((Object)"reservedQty2nd") == null ? BigDecimal.ZERO : (BigDecimal)jsonObject.get((Object)"reservedQty2nd");
            sb.append(String.format(ResManager.loadKDString((String)"\u5012\u51b2\u7269\u6599%1$s\uff08%2$s\uff09\uff0c\u9700\u6c42\u57fa\u672c\u6570\u91cf%3$s\uff0c\u9884\u7559\u57fa\u672c\u6570\u91cf%4$s\uff0c\u9884\u7559\u77ed\u7f3a\u57fa\u672c\u6570\u91cf%5$s\uff0c\u9884\u7559\u5931\u8d25\uff1b", (String)"StockBackFlushUtils_22", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialName, materialNumber, reservedQty, reservedBaseQty, reservedQty2nd));
        }
        String returnstr = sb.toString();
        logger.info("getMpsReserveServiceError:" + returnstr);
        return returnstr;
    }

    public static void dealInvRealbalance2(List<DynamicObject> targetBillObjs, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        List rules = BalManager.loadUpdateRule((String)"im_inv_realbalance");
        UpdateRule updateRule = rules.stream().filter(rule -> "im_mdc_mftproorder".equals(rule.getEntityNumber())).findFirst().get();
        Map targetSrcColMap = updateRule.getTargetSrcColMap();
        String fieldstr = String.join((CharSequence)",", targetSrcColMap.keySet());
        Map<String, BigDecimal> invRealAvbbaseqtyMap = StockBackFlushUtils.getInvRealAvbbaseqty(fieldstr, targetBillObjs);
        Map<Long, List<Map<String, Object>>> failedMap = StockBackFlushUtils.filterTarData(invRealAvbbaseqtyMap, fieldstr, targetBillObjs, targetSrcColMap);
        logger.info("dealInvRealbalance---failedMap--" + failedMap);
        if (failedMap != null && !failedMap.isEmpty()) {
            List<Map<String, Object>> eset;
            DynamicObjectCollection billEntry;
            Long id;
            ArrayList<DynamicObject> romoveList = new ArrayList<DynamicObject>(8);
            for (DynamicObject targetBillObj : targetBillObjs) {
                id = (Long)targetBillObj.getPkValue();
                billEntry = (DynamicObjectCollection)targetBillObj.get("billentry");
                if (!failedMap.containsKey(id) || (eset = failedMap.get(id)).size() != billEntry.size()) continue;
                romoveList.add(targetBillObj);
                for (DynamicObject entry : billEntry) {
                    DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
                    String materialName = material.getString("name");
                    String materialNumber = material.getString("number");
                    Map<String, Object> proOrderInfo = StockBackFlushUtils.getProOrderInfo(entry, eset);
                    String entryid = entry.getPkValue().toString();
                    BigDecimal baseqty = BigDecimal.ZERO;
                    BigDecimal avbbaseqty = BigDecimal.ZERO;
                    if (proOrderInfo.containsKey(entryid)) {
                        BigDecimal tempAvbqty = (BigDecimal)proOrderInfo.get("avbbaseqty");
                        if (avbbaseqty.compareTo(tempAvbqty) < 0) {
                            avbbaseqty = tempAvbqty;
                        }
                        baseqty = (BigDecimal)proOrderInfo.get("baseqty");
                    }
                    String manubill = entry.getString("manubill");
                    String format = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5012\u51b2\u7269\u6599%1$s\uff08%2$s\uff09\uff0c\u57fa\u672c\u6570\u91cf%3$s\uff0c\u53ef\u7528\u57fa\u672c\u6570\u91cf%4$s\uff0c\u5e93\u5b58\u4e0d\u8db3", (String)"StockBackFlushUtils_24", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialName, materialNumber, baseqty, avbbaseqty);
                    logger.info("dealInvRealbalance---\u6574\u5355\u5220\u9664--manubill--" + manubill + format);
                    StockBackFlushUtils.setErr(entry, res, stockBFMap, format);
                }
            }
            if (!romoveList.isEmpty()) {
                targetBillObjs.removeAll(romoveList);
            }
            if (targetBillObjs != null && !targetBillObjs.isEmpty()) {
                for (DynamicObject targetBillObj : targetBillObjs) {
                    id = (Long)targetBillObj.getPkValue();
                    billEntry = (DynamicObjectCollection)targetBillObj.get("billentry");
                    if (!failedMap.containsKey(id)) continue;
                    eset = failedMap.get(id);
                    HashSet<String> errorEntry = new HashSet<String>(billEntry.size());
                    for (DynamicObject entry : billEntry) {
                        String entryid = entry.getPkValue().toString();
                        Map<String, Object> proOrderInfo = StockBackFlushUtils.getProOrderInfo(entry, eset);
                        if (!proOrderInfo.containsKey(entryid)) continue;
                        DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
                        String materialName = material.getString("name");
                        String materialNumber = material.getString("number");
                        BigDecimal baseqty = BigDecimal.ZERO;
                        BigDecimal avbbaseqty = BigDecimal.ZERO;
                        if (proOrderInfo.containsKey(entryid)) {
                            BigDecimal tempAvbqty = (BigDecimal)proOrderInfo.get("avbbaseqty");
                            if (avbbaseqty.compareTo(tempAvbqty) < 0) {
                                avbbaseqty = tempAvbqty;
                            }
                            baseqty = (BigDecimal)proOrderInfo.get("baseqty");
                        }
                        String manubill = entry.getString("manubill");
                        String format = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5012\u51b2\u7269\u6599%1$s\uff08%2$s\uff09\uff0c\u57fa\u672c\u6570\u91cf%3$s\uff0c\u53ef\u7528\u57fa\u672c\u6570\u91cf%4$s\uff0c\u5e93\u5b58\u4e0d\u8db3", (String)"StockBackFlushUtils_24", (String)"scmc-mm-mdc", (Object[])new Object[0]), materialName, materialNumber, baseqty, avbbaseqty);
                        logger.info("dealInvRealbalance---\u5206\u5f55\u5220\u9664---manubill--" + manubill + format);
                        StockBackFlushUtils.setErr(entry, res, stockBFMap, format);
                        errorEntry.add(entryid);
                    }
                    billEntry.removeIf(x -> errorEntry.contains(x.getPkValue().toString()));
                }
            }
        }
    }

    public static Map<Long, List<Map<String, Object>>> filterTarData(Map<String, BigDecimal> invRealAvbbaseqtyMap, String fieldstr, List<DynamicObject> targetBillObjs, Map<String, String> targetSrcColMap) {
        HashMap<Long, List<Map<String, Object>>> failMap = new HashMap<Long, List<Map<String, Object>>>(targetBillObjs.size());
        String[] split = fieldstr.split(",");
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObject org = targetBillObj.getDynamicObject("org");
            Long orgid = 0L;
            if (org != null) {
                orgid = org.getLong("id");
            }
            Long pkValue = (Long)targetBillObj.getPkValue();
            DynamicObjectCollection billEntry = (DynamicObjectCollection)targetBillObj.get("billentry");
            ArrayList fialEntry = new ArrayList(billEntry.size());
            for (int i = 0; i < billEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)billEntry.get(i);
                StringBuilder key2 = new StringBuilder();
                for (String field : split) {
                    if (!targetSrcColMap.containsKey(field)) continue;
                    String tarfield = targetSrcColMap.get(field);
                    if ("org".equals(tarfield)) {
                        key2.append(orgid);
                        key2.append("@");
                        continue;
                    }
                    Object rdata = entry.get(tarfield);
                    if (field.indexOf("date") >= 0 || field.indexOf("qty") >= 0) {
                        logger.info("dealInvRealbalance--field--key---" + field);
                        continue;
                    }
                    if (rdata instanceof DynamicObject) {
                        DynamicObject dyData = (DynamicObject)rdata;
                        Long dataid = 0L;
                        if (dyData != null) {
                            dataid = dyData.getLong("id");
                        }
                        key2.append(dataid);
                    } else {
                        if (rdata instanceof Date) {
                            logger.info("dealInvRealbalance---Date--" + tarfield);
                            continue;
                        }
                        if (rdata instanceof String) {
                            String str = (String)rdata;
                            key2.append(str.trim());
                        } else if (rdata == null) {
                            key2.append("0");
                        } else {
                            key2.append(rdata);
                        }
                    }
                    key2.append("@");
                }
                String pickKey = key2.toString();
                BigDecimal baseqty = entry.getBigDecimal("baseqty");
                logger.info("dealInvRealbalance---pickKey--" + pickKey);
                if (invRealAvbbaseqtyMap.containsKey(pickKey)) {
                    BigDecimal avbbaseqty = invRealAvbbaseqtyMap.get(pickKey);
                    logger.info("dealInvRealbalance---pickKey--" + pickKey + "--baseqty--" + baseqty);
                    BigDecimal subtract = avbbaseqty.subtract(baseqty);
                    logger.info("dealInvRealbalance--pickKey--" + pickKey + "--avbbaseqty--" + avbbaseqty + "--subtract--" + subtract);
                    if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                        invRealAvbbaseqtyMap.put(pickKey, subtract);
                        continue;
                    }
                    String entryid = entry.getPkValue().toString();
                    HashMap<String, Object> fialMap = new HashMap<String, Object>(8);
                    fialMap.put("avbbaseqty", avbbaseqty);
                    fialMap.put("baseqty", baseqty);
                    fialMap.put(entryid, entryid);
                    fialEntry.add(fialMap);
                    continue;
                }
                logger.info("dealInvRealbalance---\u672a\u5339\u914d\u5230\u5e93\u5b58--pickKey--" + pickKey);
                String entryid = entry.getPkValue().toString();
                HashMap<String, Object> fialMap = new HashMap<String, Object>(8);
                fialMap.put("avbbaseqty", BigDecimal.ZERO);
                fialMap.put("baseqty", baseqty);
                fialMap.put(entryid, entryid);
                fialEntry.add(fialMap);
            }
            if (fialEntry.isEmpty()) continue;
            failMap.put(pkValue, fialEntry);
        }
        return failMap;
    }

    public static Map<String, BigDecimal> getInvRealAvbbaseqty(String fieldstr, List<DynamicObject> targetBillObjs) {
        logger.info("dealInvRealbalance--fieldstr---" + fieldstr);
        String[] split = fieldstr.split(",");
        Map<String, Object> invRealAccFilter = StockBackFlushUtils.getInvRealAccFilter(targetBillObjs);
        InvRealAccQueryService invReal = new InvRealAccQueryService();
        List invQtys = invReal.invAccQueryExtForInner(invRealAccFilter);
        HashMap<String, BigDecimal> invQtyMap = new HashMap<String, BigDecimal>(invQtys.size());
        if (invQtys != null && !invQtys.isEmpty()) {
            for (Map map : invQtys) {
                BigDecimal avbbaseqty = BigDecimal.ZERO;
                if (map.get("avbbaseqty") != null) {
                    avbbaseqty = new BigDecimal(map.get("avbbaseqty").toString());
                }
                StringBuilder key = new StringBuilder();
                for (String field : split) {
                    if (field.indexOf("date") >= 0 || field.indexOf("qty") >= 0) {
                        logger.info("dealInvRealbalance--field---" + field);
                        continue;
                    }
                    key.append(map.get(field));
                    key.append("@");
                }
                String invkey = key.toString();
                if (invQtyMap.containsKey(invkey)) {
                    BigDecimal avbbaseqty2 = (BigDecimal)invQtyMap.get(invkey);
                    logger.info("dealInvRealbalance---invkey--" + invkey + "--\u524davbbaseqty--" + avbbaseqty2 + "---\u540eavbbaseqty--" + avbbaseqty);
                    avbbaseqty = avbbaseqty.add(avbbaseqty2);
                }
                invQtyMap.put(invkey, avbbaseqty);
            }
        }
        logger.info("dealInvRealbalance--invQtyMap---" + invQtyMap);
        return invQtyMap;
    }

    public static Map<String, Object> getInvRealAccFilter(List<DynamicObject> targetBillObjs) {
        LinkedHashMap params = new LinkedHashMap(16);
        LinkedHashMap orgParams = new LinkedHashMap(1);
        HashSet<Long> orgidSet = new HashSet<Long>(16);
        HashSet<Long> materialSet = new HashSet<Long>(16);
        for (DynamicObject pickData : targetBillObjs) {
            DynamicObject org = pickData.getDynamicObject("org");
            if (org != null) {
                orgidSet.add(org.getLong("id"));
            }
            DynamicObjectCollection billentry = pickData.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billentry) {
                DynamicObject material = row.getDynamicObject("material");
                if (material == null) continue;
                DynamicObject masterid = material.getDynamicObject("masterid");
                materialSet.add(masterid.getLong("id"));
            }
        }
        orgParams.put("id", orgidSet);
        logger.info("getInvRealAccFilter--orgidSet---" + orgidSet);
        params.put("org", orgParams);
        LinkedHashMap<String, HashSet<Long>> materialParams = new LinkedHashMap<String, HashSet<Long>>(1);
        materialParams.put("id", materialSet);
        logger.info("getInvRealAccFilter--materialSet---" + materialSet);
        params.put("material", materialParams);
        HashMap<String, Object> newParams = new HashMap<String, Object>(16);
        newParams.put("data", params);
        return newParams;
    }

    private static String setInvQty(Map<String, Object> params, DynamicObject entry, int seq, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res) {
        InvRealAccQueryService invReal = new InvRealAccQueryService();
        List invQtys = invReal.invAccQueryExtForInner(params);
        String resStr = "";
        DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
        String materialName = material.getString("name");
        String materialNumber = material.getString("number");
        logger.info("\u67e5\u8be2\u5373\u65f6\u5e93\u5b58" + materialName + materialNumber + params.toString() + "\u7ed3\u679c\uff1a" + invQtys.toString());
        if (invQtys != null && !invQtys.isEmpty()) {
            BigDecimal baseqty;
            Map map = (Map)invQtys.get(0);
            BigDecimal avbbaseqty = BigDecimal.ZERO;
            if (map.get("avbbaseqty") != null) {
                avbbaseqty = new BigDecimal(map.get("avbbaseqty").toString());
            }
            if ((baseqty = entry.getBigDecimal("baseqty")).compareTo(avbbaseqty) > 0 && avbbaseqty.compareTo(BigDecimal.ZERO) > 0) {
                entry.set("baseqty", map.get("avbbaseqty"));
                entry.set("qtyunit2nd", map.get("avbbtndqty"));
                entry.set("qty", map.get("avbbqty"));
                if (res != null) {
                    StockBackFlushUtils.setErr(entry, res, stockBFMap, "E");
                }
            } else if (avbbaseqty.compareTo(BigDecimal.ZERO) <= 0) {
                resStr = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u5012\u51b2\u7269\u6599%2$s\uff08%3$s\uff09\uff0c\u5e93\u5b58\u6570\u91cf\u22640\uff1b", (String)"StockBackFlushUtils_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq, materialName, materialNumber);
            }
        } else {
            resStr = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u5012\u51b2\u7269\u6599%2$s\uff08%3$s\uff09\uff0c\u5e93\u5b58\u6570\u91cf\u22640\uff1b", (String)"StockBackFlushUtils_4", (String)"scmc-mm-mdc", (Object[])new Object[0]), seq, materialName, materialNumber);
        }
        return resStr;
    }

    private static String invQtyValidateAlertMsg(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (Objects.isNull(material)) {
            return ResManager.loadKDString((String)"\u7269\u6599\u4e3a\u7a7a", (String)"StockBackFlushUtils_5", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        Object unit = entry.get("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        Object outInvType = entry.get("outinvtype");
        Object outInvStatus = entry.get("outinvstatus");
        Object outOwnerType = entry.get("outownertype");
        Object outOwner = entry.get("outowner");
        Object outKeeperType = entry.get("outkeepertype");
        Object outKeeper = entry.get("outkeeper");
        StringBuilder alertMsg = new StringBuilder();
        if (null == unit || BigDecimal.ZERO.compareTo(qty) == 0 || null == outInvType || null == outInvStatus || null == outOwnerType || null == outOwner || null == outKeeperType || null == outKeeper) {
            if (null == unit) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"StockBackFlushUtils_6", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u6570\u91cf", (String)"StockBackFlushUtils_7", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outInvType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u7c7b\u578b", (String)"StockBackFlushUtils_8", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outInvStatus) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u5e93\u5b58\u72b6\u6001", (String)"StockBackFlushUtils_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outOwnerType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b\u7c7b\u578b", (String)"StockBackFlushUtils_10", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outOwner) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u8d27\u4e3b", (String)"StockBackFlushUtils_11", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outKeeperType) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005\u7c7b\u578b", (String)"StockBackFlushUtils_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            if (null == outKeeper) {
                if (alertMsg.length() > 0) {
                    alertMsg.append('\u3001');
                }
                alertMsg.append(ResManager.loadKDString((String)"\u51fa\u5e93\u4fdd\u7ba1\u8005", (String)"StockBackFlushUtils_13", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a", (String)"StockBackFlushUtils_14", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            alertMsg.insert(0, msg);
        }
        if (alertMsg.length() > 0) {
            return alertMsg.toString();
        }
        return alertMsg.toString();
    }

    public static Map<String, Object> getInvQtyParams(DynamicObject entry, DynamicObject org) {
        LinkedHashMap<String, Object> projectParams;
        Object project;
        Object unit2nd;
        DynamicObject baseunit;
        LinkedHashMap<String, Object> auxptyParams;
        Object auxpty;
        DynamicObject location;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(16);
        LinkedHashMap<String, Object> orgParams = new LinkedHashMap<String, Object>(1);
        orgParams.put("id", org.getPkValue());
        params.put("org", orgParams);
        DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
        LinkedHashMap<String, Object> materialParams = new LinkedHashMap<String, Object>(1);
        materialParams.put("id", material.getPkValue());
        params.put("material", materialParams);
        DynamicObject unit = entry.getDynamicObject("unit");
        Object outInvType = entry.get("outinvtype");
        Object outInvStatus = entry.get("outinvstatus");
        String outOwnerType = entry.getString("outownertype");
        Object outOwner = entry.get("outowner");
        String outKeeperType = entry.getString("outkeepertype");
        Object outKeeper = entry.get("outkeeper");
        LinkedHashMap<String, Object> unitParams = new LinkedHashMap<String, Object>(1);
        unitParams.put("id", unit.getPkValue());
        params.put("unit", unitParams);
        LinkedHashMap<String, Object> invtypeParams = new LinkedHashMap<String, Object>(1);
        invtypeParams.put("id", StockBackFlushUtils.getId(outInvType));
        params.put("invtype", invtypeParams);
        LinkedHashMap<String, Object> invstatusParams = new LinkedHashMap<String, Object>(1);
        invstatusParams.put("id", StockBackFlushUtils.getId(outInvStatus));
        params.put("invstatus", invstatusParams);
        params.put("ownertype", outOwnerType);
        LinkedHashMap<String, Object> outOwnerParams = new LinkedHashMap<String, Object>(1);
        outOwnerParams.put("id", StockBackFlushUtils.getId(outOwner));
        params.put("owner", outOwnerParams);
        params.put("keepertype", outKeeperType);
        LinkedHashMap<String, Object> outKeeperParams = new LinkedHashMap<String, Object>(1);
        outKeeperParams.put("id", StockBackFlushUtils.getId(outKeeper));
        params.put("keeper", outKeeperParams);
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        if (warehouse != null) {
            LinkedHashMap<String, Object> warehouseParams = new LinkedHashMap<String, Object>(1);
            warehouseParams.put("id", warehouse.getPkValue());
            params.put("warehouse", warehouseParams);
        }
        if ((location = entry.getDynamicObject("location")) != null) {
            LinkedHashMap<String, Object> locationParams = new LinkedHashMap<String, Object>(1);
            locationParams.put("id", location.getPkValue());
            params.put("location", locationParams);
        }
        if ((auxpty = entry.get("auxpty")) instanceof DynamicObject && !"0".equals(auxpty.toString())) {
            auxptyParams = new LinkedHashMap<String, Object>(1);
            auxptyParams.put("id", ((DynamicObject)auxpty).getPkValue());
            params.put("auxpty", auxptyParams);
        } else if (auxpty instanceof Long && !"0".equals(auxpty.toString())) {
            auxptyParams = new LinkedHashMap(1);
            auxptyParams.put("id", auxpty);
            params.put("auxpty", auxptyParams);
        }
        String lotnumber = entry.getString("lotnumber");
        if (!lotnumber.isEmpty()) {
            params.put("lotnum", lotnumber);
        }
        if ((baseunit = entry.getDynamicObject("baseunit")) != null) {
            LinkedHashMap<String, Object> baseunitParams = new LinkedHashMap<String, Object>(1);
            baseunitParams.put("id", baseunit.getPkValue());
            params.put("baseunit", baseunitParams);
        }
        if ((unit2nd = entry.get("unit2nd")) != null) {
            LinkedHashMap<String, Object> unit2ndParams = new LinkedHashMap<String, Object>(1);
            unit2ndParams.put("id", StockBackFlushUtils.getId(unit2nd));
            params.put("unit2nd", unit2ndParams);
        }
        if ((project = entry.get("project")) instanceof DynamicObject && !"0".equals(project.toString())) {
            projectParams = new LinkedHashMap<String, Object>(1);
            projectParams.put("id", ((DynamicObject)project).getPkValue());
            params.put("project", projectParams);
        } else if (project instanceof Long && !"0".equals(project.toString())) {
            projectParams = new LinkedHashMap(1);
            projectParams.put("id", project);
            params.put("project", projectParams);
        }
        HashMap<String, Object> newParams = new HashMap<String, Object>(16);
        newParams.put("data", params);
        return newParams;
    }

    private static Object getId(Object outKeeper) {
        if (outKeeper == null) {
            return 0L;
        }
        if (outKeeper instanceof DynamicObject) {
            return ((DynamicObject)outKeeper).getLong("id");
        }
        if (outKeeper instanceof Long) {
            return (Long)outKeeper;
        }
        return 0L;
    }

    public static Map<Long, DynamicObject> getTransMap(DynamicObject[] objs, String selectProperties) {
        HashSet<Long> orderIdSet = new HashSet<Long>(16);
        HashSet transIdSet = new HashSet(16);
        String orderEntity = "";
        String orderFiled = "";
        String tranEntity = "";
        HashMap<Long, DynamicObject> orderTransMap = new HashMap<Long, DynamicObject>(16);
        if (objs == null || objs.length == 0) {
            return orderTransMap;
        }
        String name = objs[0].getDataEntityType().getName();
        if ("im_mdc_omcmplinbill".equals(name)) {
            orderEntity = "om_mftorder";
            tranEntity = "mpdm_transactproduct";
            orderFiled = "manubillid";
            selectProperties = selectProperties + ",returnbackflush";
        } else if ("im_mdc_mftmanuinbill".equals(name) || "im_mdc_mftreturnbill".equals(name)) {
            orderEntity = "pom_mftorder";
            if ("E".equals(objs[0].getString("productiondomain"))) {
                orderEntity = "prop_mftorder";
            }
            tranEntity = "mpdm_transactproduct";
            orderFiled = "mainbillid";
        } else if ("im_mdc_ominbill".equals(name)) {
            orderEntity = "pm_om_purorderbill";
            tranEntity = "mpdm_transactout";
            orderFiled = "mainbillid";
        }
        for (DynamicObject obj : objs) {
            DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : dynamicObjectCollection) {
                Long mainbillid = entry.getLong(orderFiled);
                orderIdSet.add(mainbillid);
            }
        }
        HashMap<Long, DynamicObject> transMap = new HashMap<Long, DynamicObject>(16);
        if (orderIdSet.isEmpty()) {
            return orderTransMap;
        }
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        DataSet orderDataSet = QueryServiceHelper.queryDataSet((String)"queryTransactionType", (String)orderEntity, (String)"id,transactiontype", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIdSet)}, (String)"id");
        Object object = null;
        try {
            while (orderDataSet.hasNext()) {
                Row row = orderDataSet.next();
                map.put(row.getLong("id"), row.getLong("transactiontype"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (orderDataSet != null) {
                if (object != null) {
                    try {
                        orderDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    orderDataSet.close();
                }
            }
        }
        transIdSet.addAll(map.values());
        if (!transIdSet.isEmpty()) {
            Map tranLoads = BusinessDataServiceHelper.loadFromCache((String)tranEntity, (String)(selectProperties + ",returnbackflush"), (QFilter[])new QFilter[]{new QFilter("id", "in", transIdSet)});
            for (Map.Entry entry : tranLoads.entrySet()) {
                DynamicObject tranLoad = (DynamicObject)entry.getValue();
                transMap.put((Long)tranLoad.getPkValue(), tranLoad);
            }
            map.forEach((k, v) -> {
                if (transMap.containsKey(v)) {
                    orderTransMap.put((Long)k, (DynamicObject)transMap.get(v));
                }
            });
        }
        return orderTransMap;
    }

    public static String getEntity(String sourcebillentry) {
        if ("A".equals(sourcebillentry)) {
            return "im_mdc_mftmanuinbill";
        }
        if ("B".equals(sourcebillentry)) {
            return "pom_mftorderreport";
        }
        if ("C".equals(sourcebillentry)) {
            return "sfc_processreportbill";
        }
        if ("D".equals(sourcebillentry)) {
            return "sfc_protransferbill";
        }
        if ("F".equals(sourcebillentry)) {
            return "sfc_manftech";
        }
        if ("G".equals(sourcebillentry)) {
            return "im_mdc_mftreturnbill";
        }
        if ("H".equals(sourcebillentry)) {
            return "prop_mftorderreport";
        }
        if ("I".equals(sourcebillentry)) {
            return "prop_processreportbill";
        }
        return "";
    }

    public static List<List<Object>> getBFBillInfo(DynamicObjectCollection bills, String sourcebill, IDataModel model, String entityName) {
        ArrayList<List<Object>> gridList = new ArrayList<List<Object>>(16);
        String orderEntryIdName = "billentry.mainbillentryid";
        String stockEntityName = "pom_mftstock";
        String backFlushTimeName = "A";
        if ("A".equals(sourcebill) || "G".equals(sourcebill)) {
            orderEntryIdName = "billentry.mainbillentryid";
            backFlushTimeName = "A";
        } else if ("B".equals(sourcebill) || "C".equals(sourcebill) || "H".equals(sourcebill) || "I".equals(sourcebill)) {
            if ("prop_mftorderreport".equals(entityName) || "prop_processreportbill".equals(entityName)) {
                stockEntityName = "prop_mftstock";
            }
            orderEntryIdName = "sumentry.mftentryid";
            backFlushTimeName = "B";
        } else if ("D".equals(sourcebill)) {
            orderEntryIdName = "outentryentity.manufactureentryid.id";
            backFlushTimeName = "B";
        } else if ("F".equals(sourcebill)) {
            orderEntryIdName = "mftentryseq";
            backFlushTimeName = "A,B";
        }
        logger.info("getBFBillInfo---stockEntityName---" + stockEntityName + "---entityName--" + entityName);
        HashSet<Object> orderEntryId = new HashSet<Object>(bills.size());
        for (int i = 0; i < bills.size(); ++i) {
            String productiondomain;
            orderEntryId.add(((DynamicObject)bills.get(i)).getLong(orderEntryIdName));
            if (!"A".equals(sourcebill) && !"G".equals(sourcebill) || i != 0 || !"E".equals(productiondomain = ((DynamicObject)bills.get(i)).getString("productiondomain"))) continue;
            stockEntityName = "prop_mftstock";
        }
        Map<Object, DynamicObject> stocks = StockBackFlushUtils.getStockDym(orderEntryId, stockEntityName);
        for (int i = 0; i < bills.size(); ++i) {
            DynamicObject reportDym = (DynamicObject)bills.get(i);
            long orderEntryid = reportDym.getLong(orderEntryIdName);
            DynamicObject stockDym = stocks.get(orderEntryid);
            if (stockDym == null || !StockBackFlushUtils.getStockDymFilterRes(stockDym, model)) continue;
            DynamicObjectCollection stockEntry = stockDym.getDynamicObjectCollection("stockentry");
            boolean transactiontype = stockDym.getBoolean("transactiontypeid.returnbackflush");
            for (int j = 0; j < stockEntry.size(); ++j) {
                String backflushtime = ((DynamicObject)stockEntry.get(j)).getString("backflushtime");
                String isbackflush = ((DynamicObject)stockEntry.get(j)).getString("isbackflush");
                String issuemode = ((DynamicObject)stockEntry.get(j)).getString("issuemode");
                String qtytype = ((DynamicObject)stockEntry.get(j)).getString("qtytype");
                if (!Arrays.asList(backFlushTimeName.split(",")).contains(backflushtime) || !"B".equals(isbackflush) || "C".equals(issuemode) || !StockBackFlushUtils.getFilterRes((DynamicObject)stockEntry.get(j), model) || !StockBackFlushUtils.sfcFilter(reportDym, sourcebill, (DynamicObject)stockEntry.get(j)) || (!"A,B".equals(backFlushTimeName) || !((DynamicObject)stockEntry.get(j)).getBoolean("beginworkbf")) && ("A,B".equals(backFlushTimeName) || ((DynamicObject)stockEntry.get(j)).getBoolean("beginworkbf")) || "G".equals(sourcebill) && (!"A".equals(qtytype) || !transactiontype)) continue;
                ArrayList<Object> obj = new ArrayList<Object>(3);
                obj.add(bills.get(i));
                obj.add(stockEntry.get(j));
                obj.add(stockDym);
                gridList.add(obj);
                if (gridList.size() <= 200000) continue;
                gridList.clear();
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8fc7\u591a\uff0c\u8bf7\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"StockBackFlushUtils_21", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
        }
        return gridList;
    }

    private static boolean getFilterRes(DynamicObject stockEntryDym, IDataModel model) {
        DynamicObjectCollection materials;
        if (model != null && (materials = (DynamicObjectCollection)model.getValue("materialidmain")) != null && materials.size() > 0) {
            DynamicObject materialId = stockEntryDym.getDynamicObject("materielmasterid");
            for (DynamicObject material : materials) {
                if (materialId == null || !materialId.getPkValue().equals(material.getDynamicObject("fbasedataid").getPkValue())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean getStockDymFilterRes(DynamicObject stockDym, IDataModel model) {
        if (model != null) {
            DynamicObject bdproject;
            DynamicObject object;
            DynamicObject orderEntryDym;
            DynamicObject mftdeptorgid;
            DynamicObject producedept = (DynamicObject)model.getValue("producedept");
            boolean closeOrder = (Boolean)model.getValue("closeorder");
            if (!(producedept == null || (mftdeptorgid = stockDym.getDynamicObject("mftdeptorgid")) != null && mftdeptorgid.getPkValue().equals(producedept.getPkValue()))) {
                return false;
            }
            if (!closeOrder && "C".equals(stockDym.getString("orderentryid.bizstatus"))) {
                return false;
            }
            DynamicObject tracknumber = (DynamicObject)model.getValue("tracknumber");
            if (!(tracknumber == null || (orderEntryDym = stockDym.getDynamicObject("orderentryid")) == null || (object = orderEntryDym.getDynamicObject("tracknumber")) != null && object.getPkValue().equals(tracknumber.getPkValue()))) {
                return false;
            }
            DynamicObject projectmain = (DynamicObject)model.getValue("projectmain");
            if (!(projectmain == null || (bdproject = stockDym.getDynamicObject("bdproject")) != null && bdproject.getPkValue().equals(projectmain.getPkValue()))) {
                return false;
            }
        }
        return true;
    }

    public static String getMftInBillSelects() {
        return "id,billno,productiondomain,billentry.id,billentry.mainbillnumber,billentry.mainbillid,billentry.mainbillentity,billentry.mainbillentryseq,billentry.mainbillentryid,billentry.baseqty,billentry.remainreturnbaseqty,billentry.returnbaseqty,billentry.materialmasterid,billentry.backflushstatus,billentry.seq,biztime,billentry.baseunit";
    }

    public static String getMftOrderReportSelects() {
        return "id,billno,sumentry.id,sumentry.manufacturenun,sumentry.manufacturerow,sumentry.mftentryid,sumentry.completbsqty,sumentry.seq,reportdate,sumentry.baseunit";
    }

    public static String getSfcReportSelects() {
        return "id,billno,sumentry.id,sumentry.manufacturenun,sumentry.manufacturerow,sumentry.manufactureentryid sumentry.mftentryid,sumentry.completqty,sumentry.completbaseqty,sumentry.seq,reportdate,sumentry.oprunit,sumentry.baseunit,sumentry.processseq,sumentry.oprno";
    }

    public static String getSfcProtransSelects() {
        return "id,billno,outentryentity.id,outentryentity.seq,outentryentity.manufactureentryid.id,outentryentity.transferbaseqty,outentryentity.outprocessid,bizdate,outentryentity.outprocessid.oprparent,outentryentity.outprocessid.oprno";
    }

    public static String getSfcManftechSelects() {
        return "id,billno,mftentryseq,baseqty,createtime,oprentryentity.id,oprentryentity.seq,oprentryentity.oprparent,oprentryentity.oprno";
    }

    public static BigDecimal getCanBFQty(DynamicObject stockEntry, DynamicObject stockDym, DynamicObject bill, String baseqtyName, String sourcebill) {
        BigDecimal baseQty;
        BigDecimal qualityA = new BigDecimal(bill.getString(baseqtyName)).abs();
        DynamicObject mftstockEntryObj = stockEntry;
        boolean isReturnBackFlush = stockDym.getBoolean("transactiontypeid.returnbackflush");
        if (!isReturnBackFlush && StringUtils.equals((String)"A", (String)sourcebill)) {
            qualityA = new BigDecimal(bill.getString("billentry.remainreturnbaseqty")).abs();
        }
        if ((baseQty = (BigDecimal)stockDym.get("baseqty")).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        DynamicObject materialunitid = mftstockEntryObj.getDynamicObject("materialunitid");
        int precision = materialunitid.getInt("precision");
        String qtyType = mftstockEntryObj.getString("qtytype");
        if ("B".equals(qtyType)) {
            return mftstockEntryObj.getBigDecimal("demandqty");
        }
        return qualityA.multiply(mftstockEntryObj.getBigDecimal("demandqty")).divide(baseQty, precision, StockBackFlushUtils.getRoundType(materialunitid));
    }

    private static int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }

    public static <T> List<List<T>> subList(List<T> target, int num) {
        ArrayList<List<T>> listArr = new ArrayList<List<T>>(10);
        if (target.size() > num) {
            int number = target.size() / num;
            for (int i = 1; i <= number; ++i) {
                List<T> subList = target.subList(num * (i - 1), num * i);
                listArr.add(subList);
            }
            List<T> subList = target.subList(num * number, target.size());
            listArr.add(subList);
        } else {
            listArr.add(target);
        }
        return listArr;
    }

    public static void setErrlog(OperationResult saveResult, List<DynamicObject> targetBillObjs, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res, String opStr) {
        String info = "";
        if ("save".equals(opStr)) {
            info = ResManager.loadKDString((String)"\u4fdd\u5b58\u9886\u6599\u5355\u5931\u8d25\uff1a", (String)"StockBackFlushUtils_15", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        } else if ("submit".equals(opStr)) {
            info = ResManager.loadKDString((String)"\u63d0\u4ea4\u9886\u6599\u5355\u5931\u8d25\uff1a", (String)"StockBackFlushUtils_16", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        } else if ("audit".equals(opStr)) {
            info = ResManager.loadKDString((String)"\u5ba1\u6838\u9886\u6599\u5355\u5931\u8d25\uff1a", (String)"StockBackFlushUtils_17", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        List successPkIds = saveResult.getSuccessPkIds();
        ArrayList<DynamicObject> failed = new ArrayList<DynamicObject>(targetBillObjs.size());
        if (successPkIds.size() < targetBillObjs.size()) {
            Map<Object, String> mesMap = StockBackFlushUtils.getMesMap(saveResult);
            for (DynamicObject targetBillObj : targetBillObjs) {
                if (successPkIds.contains(targetBillObj.getPkValue())) continue;
                failed.add(targetBillObj);
                DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
                String mes = mesMap.get(targetBillObj.getPkValue());
                if (null == mes) {
                    mes = saveResult.getMessage();
                }
                for (DynamicObject entry : tbillEntrys) {
                    StockBackFlushUtils.setErr(entry, res, stockBFMap, info + mes);
                }
            }
        }
        targetBillObjs.removeAll(failed);
    }

    public static void setSaveErrlog(OperationResult saveResult, DynamicObject targetBillObj, Map<Object, List<DynamicObject>> stockBFMap, Map<DynamicObject, String> res, String opStr) {
        String info = "";
        if ("save".equals(opStr)) {
            info = ResManager.loadKDString((String)"\u4fdd\u5b58\u9886\u6599\u5355\u5931\u8d25\uff1a", (String)"StockBackFlushUtils_15", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        if (!saveResult.isSuccess()) {
            Map<Object, String> mesMap = StockBackFlushUtils.getMesMap(saveResult);
            DynamicObjectCollection tbillEntrys = targetBillObj.getDynamicObjectCollection("billentry");
            String mes = mesMap.get(targetBillObj.getPkValue());
            if (null == mes) {
                mes = saveResult.getMessage();
            }
            for (DynamicObject entry : tbillEntrys) {
                StockBackFlushUtils.setErr(entry, res, stockBFMap, info + mes);
            }
        }
    }

    public static void deleteRes(List<Object> saveSuccessPkIds, OperationResult submitResult, String targetName) {
        List submitSuccessPkIds = submitResult.getSuccessPkIds();
        saveSuccessPkIds.removeAll(submitSuccessPkIds);
        if (!saveSuccessPkIds.isEmpty()) {
            StockBackFlushUtils.delFaildResult(saveSuccessPkIds, targetName);
        }
    }

    public static void deleteRes(OperationResult saveResult, OperationResult submitResult, String targetName) {
        List saveSuccessPkIds = saveResult.getSuccessPkIds();
        List submitSuccessPkIds = submitResult.getSuccessPkIds();
        saveSuccessPkIds.removeAll(submitSuccessPkIds);
        if (!saveSuccessPkIds.isEmpty()) {
            StockBackFlushUtils.delFaildResult(saveSuccessPkIds, targetName);
        }
    }

    public static Map<Object, String> getMesMap(OperationResult optResult) {
        List allErrorOrValidateInfo = optResult.getAllErrorOrValidateInfo();
        String message = optResult.getMessage();
        HashMap<Object, String> mesMap = new HashMap<Object, String>(allErrorOrValidateInfo.size());
        for (IOperateInfo errInfo : allErrorOrValidateInfo) {
            mesMap.put(errInfo.getPkValue(), message + errInfo.getMessage());
        }
        return mesMap;
    }

    private static String delFaildResult(List<Object> successPkIds, String targetName) {
        DynamicObject[] loads;
        ArrayList<Object> auditPkIds = new ArrayList<Object>(successPkIds.size());
        ArrayList<DynamicObject> purinBillDymList = new ArrayList<DynamicObject>(successPkIds.size());
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)targetName, (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", successPkIds)})) {
            purinBillDymList.add(load);
            if ("C".equals(load.getString("billstatus"))) continue;
            auditPkIds.add(load.getPkValue());
        }
        if (auditPkIds.isEmpty()) {
            return "success";
        }
        return StockBackFlushUtils.delFaildResultDym(purinBillDymList, targetName);
    }

    private static String delFaildResultDym(List<DynamicObject> purinBillDymList, String targetName) {
        HashSet<Object> auditPkIds = new HashSet<Object>(purinBillDymList.size());
        HashSet<Object> submitPkIds = new HashSet<Object>(purinBillDymList.size());
        HashSet<Object> delPkIds = new HashSet<Object>(purinBillDymList.size());
        for (DynamicObject purinBillDym : purinBillDymList) {
            if ("C".equals(purinBillDym.getString("billstatus"))) {
                auditPkIds.add(purinBillDym.getPkValue());
                continue;
            }
            if ("B".equals(purinBillDym.getString("billstatus"))) {
                submitPkIds.add(purinBillDym.getPkValue());
                continue;
            }
            delPkIds.add(purinBillDym.getPkValue());
        }
        return StockBackFlushUtils.delFaildResultUnAudit(submitPkIds, auditPkIds, delPkIds, targetName);
    }

    private static String delFaildResultUnAudit(Set<Object> submitPkIds, Set<Object> auditPkIds, Set<Object> delPkIds, String targetName) {
        OperationResult delResult;
        OperateOption option = StockBackFlushUtils.getOperateOption();
        if (!auditPkIds.isEmpty()) {
            OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)targetName, (Object[])auditPkIds.toArray(), (OperateOption)option);
            if (!unAuditResult.isSuccess()) {
                logger.error("unaudit\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + auditPkIds.toArray() + StockBackFlushUtils.getErrDetail(unAuditResult));
                return ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\u3002", (String)"StockBackFlushUtils_18", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
            delPkIds.addAll(auditPkIds);
        }
        if (!submitPkIds.isEmpty()) {
            OperationResult unSubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)targetName, (Object[])submitPkIds.toArray(), (OperateOption)option);
            if (!unSubmitResult.isSuccess()) {
                logger.error("unsubmit\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + submitPkIds.toArray() + StockBackFlushUtils.getErrDetail(unSubmitResult));
                return ResManager.loadKDString((String)"\u64a4\u9500\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\u3002", (String)"StockBackFlushUtils_19", (String)"scmc-mm-mdc", (Object[])new Object[0]);
            }
            delPkIds.addAll(submitPkIds);
        }
        if (!(delResult = OperationServiceHelper.executeOperate((String)"delete", (String)targetName, (Object[])delPkIds.toArray(), (OperateOption)option)).isSuccess()) {
            logger.error("delete\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\uff1a" + delPkIds.toArray() + StockBackFlushUtils.getErrDetail(delResult));
            return ResManager.loadKDString((String)"\u5220\u9664\u5012\u51b2\u9886\u6599\u5355\u5931\u8d25\u3002", (String)"StockBackFlushUtils_20", (String)"scmc-mm-mdc", (Object[])new Object[0]);
        }
        return "";
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        String message = optResult.getMessage();
        if (message != null) {
            errDetail.append(message.replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            errDetail.append(errInfo.getMessage().replaceAll("\\(\\)", "").replaceAll("</br>", ""));
        }
        return errDetail.toString();
    }

    public static void initBookDate(List<DynamicObject> targetBillObjs) {
        for (DynamicObject targetBillObj : targetBillObjs) {
            targetBillObj.set("bookdate", null);
            CloseDateHelper.initBookDate((String)targetBillObj.getDataEntityType().getName(), (DynamicObject)targetBillObj);
        }
    }

    public static Object getBizDirection(DynamicObject invscheme) {
        DynamicObject transceiver = invscheme.getDynamicObject("transceivertype");
        DynamicObject transceivertype = BusinessDataServiceHelper.loadSingleFromCache((Object)transceiver.getPkValue(), (String)"bd_transceivertype", (String)"id,bizdirection");
        return transceivertype.getString("bizdirection");
    }

    public static boolean sfcFilter(DynamicObject reportDym, String sourcebill, DynamicObject stockDym) {
        boolean isreport = true;
        if ("C".equals(sourcebill)) {
            String processseq2 = reportDym.getString("sumentry.processseq");
            String oprno2 = reportDym.getString("sumentry.oprno");
            String reportKey = processseq2 + oprno2;
            String processseq = stockDym.getString("processseq");
            String oprno = stockDym.getString("oprno");
            String key = processseq + oprno;
            if (!key.equals(reportKey)) {
                isreport = false;
            }
        } else if ("D".equals(sourcebill)) {
            String processseq2 = reportDym.getString("outentryentity.outprocessid.oprparent");
            String oprno2 = reportDym.getString("outentryentity.outprocessid.oprno");
            String reportKey = processseq2 + oprno2;
            String processseq = stockDym.getString("processseq");
            String oprno = stockDym.getString("oprno");
            String key = processseq + oprno;
            if (!key.equals(reportKey)) {
                isreport = false;
            }
        } else if ("F".equals(sourcebill)) {
            String processseq2 = reportDym.getString("oprentryentity.oprparent");
            String oprno2 = reportDym.getString("oprentryentity.oprno");
            String reportKey = processseq2 + oprno2;
            String processseq = stockDym.getString("processseq");
            String oprno = stockDym.getString("oprno");
            String key = processseq + oprno;
            if (!key.equals(reportKey)) {
                isreport = false;
            }
        }
        return isreport;
    }

    private static String getInvrealbalanceSelects() {
        return "id,baseqty,qty,";
    }

    private static Map<String, String> getInvrealFieldMap() {
        HashMap<String, String> invMap = new HashMap<String, String>(16);
        invMap.put("", "");
        return invMap;
    }

    private static QFilter addInvAccNotZeroFilter() {
        QFilter qtyFilter = new QFilter("baseqty", "<>", (Object)0);
        qtyFilter.or(new QFilter("qty", "<>", (Object)0));
        qtyFilter.or(new QFilter("qty2nd", "<>", (Object)0));
        return qtyFilter;
    }

    private static Map<String, Object> getProOrderInfo(DynamicObject entry, List<Map<String, Object>> eset) {
        Map<String, Object> errorMap = new HashMap<String, Object>(8);
        String entryid = entry.getPkValue().toString();
        for (Map<String, Object> tmMap : eset) {
            if (!tmMap.containsKey(entryid)) continue;
            errorMap = tmMap;
            break;
        }
        return errorMap;
    }
}

