/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftintpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.common.mdc.helper.GetEntityNameHelper;
import kd.scmc.im.common.mdc.utils.MDCDyObjUtil;
import kd.scmc.im.common.mdc.utils.ManuFactureTraceUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ManuFactureorderInWarehsBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String KEY_WORKSHOP = "workshop";
    public static final String KEY_WORKSHOPID = "workshopid";
    public static final String KEY_MANUBILL = "manubill";
    public static final String KEY_MANUBILLID = "manubillid";
    public static final String KEY_MANUENTRY = "manuentry";
    public static final String KEY_MANUENTRYID = "manuentryid";
    public static final String KEY_WORKCENTER = "workcenter";
    public static final String KEY_WORKCENTERID = "workcenterid";
    public static final String ENTITYID_WORKSHOPSETUP = "mpdm_workshopsetup";
    public static final String ENTITYID_WORKPROCEDURE = "mpdm_workprocedure";
    public static final String ENTITYID_WORKCENTRE = "mpdm_workcentre";
    public static final String ENTITYID_PRODUCTTYPE = "producttype";
    public static final String HEADER_PRODUCTIONORG = "productionorg";
    public static final String KEY_PRODUCEDEPT = "producedept";
    private static String[] arr = new String[]{"B", "C", "D"};
    private static final String KEY_BOS_ORG = "bos_org";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit producedept = (BasedataEdit)this.getView().getControl(KEY_PRODUCEDEPT);
        if (producedept != null) {
            producedept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        TextEdit manuBill = (TextEdit)this.getView().getControl(KEY_MANUBILL);
        manuBill.addClickListener((ClickListener)this);
        TextEdit workcenter = (TextEdit)this.getView().getControl(KEY_WORKCENTER);
        workcenter.addClickListener((ClickListener)this);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(HEADER_PRODUCTIONORG);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel bill = this.getModel();
        this.setProduceOrg();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        BillModel source = (BillModel)e.getSource();
        String name = source.getDataEntityType().getName();
        if ("im_mdc_mftmanuinbill".equals(name)) {
            // empty if block
        }
        if (!this.isNull(org)) {
            long orgId = (Long)org.getPkValue();
            this.initCurrency(orgId);
            this.setShipper();
        }
        DynamicObjectCollection InvBillEntryList = (DynamicObjectCollection)bill.getValue("billentry");
        int entrySize = InvBillEntryList.size();
        for (int i = 0; i < entrySize; ++i) {
            if (bill.getValue("material", i) == null) continue;
        }
        DynamicObject obj = (DynamicObject)this.getModel().getValue(HEADER_PRODUCTIONORG);
        if (!this.isNull(obj)) {
            this.setEntrysettleOrg(obj.getLong("id"));
        }
    }

    private void setEntrysettleOrg(long mftOrg) {
        Long settleOrgId = this.getSettleOrgIdByMftOrg(mftOrg);
        int rowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue("entrysettleorg", (Object)settleOrgId, i);
        }
    }

    private Long getSettleOrgIdByMftOrg(long mftOrg) {
        DynamicObject dyOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)mftOrg, (String)KEY_BOS_ORG);
        Long settleOrgId = 0L;
        if (dyOrg.getBoolean("fisaccounting")) {
            settleOrgId = dyOrg.getLong("id");
        } else {
            List bizRelationOrgIds;
            OrgRelationParam orgParam = new OrgRelationParam();
            orgParam.setToViewType(OrgViewTypeEnum.IS_PRODUCE.getViewType());
            orgParam.setFromViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
            orgParam.setDirectViewType("fromorg");
            orgParam.setOrgId(mftOrg);
            long defaultOrgRelation = OrgUnitServiceHelper.getDefaultOrgRelation((OrgRelationParam)orgParam);
            if (defaultOrgRelation == 0L && (bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)orgParam)) != null && !bizRelationOrgIds.isEmpty()) {
                defaultOrgRelation = (Long)bizRelationOrgIds.get(0);
            }
            if (defaultOrgRelation == 0L) {
                Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
                settleOrgId = (Long)((Object)fromOrg);
            } else {
                settleOrgId = defaultOrgRelation;
            }
        }
        return settleOrgId;
    }

    private void setShipper() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject shipper = (DynamicObject)this.getModel().getValue("shipper");
        if (!this.isNull(org) && this.isNull(shipper)) {
            shipper = ManuFactureorderInWarehsBillEdit.getAccountByOrg(org.getLong("id"), "05");
            this.getModel().setValue("shipper", (Object)shipper);
        }
    }

    private void setProduceOrg() {
        DynamicObject obj;
        if (!this.isNull(this.getModel().getValue("org")) && (obj = (DynamicObject)this.getModel().getValue("org")).getBoolean("fisproduce")) {
            this.getModel().setValue(HEADER_PRODUCTIONORG, (Object)obj);
        }
    }

    public void setDefaultInvscheme() {
        FormShowParameter param = this.getView().getFormShowParameter();
        IPageCache pagecache = this.getPageCache();
        Object invschemeObj = param.getCustomParam("invscheme");
        if (invschemeObj != null) {
            pagecache.put("invscheme", (String)param.getCustomParam("invscheme"));
            String invscheme = this.getPageCache().get("invscheme");
            QFilter qFilternum = new QFilter("number", "=", (Object)invscheme);
            DynamicObject invschme = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invscheme", (String)"id,name,number,isoutupdate,outownertype", (QFilter[])new QFilter[]{qFilternum});
            DynamicObject biztype = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_biztype", (String)"id,name,number", (QFilter[])new QFilter[]{qFilternum});
            this.getModel().setValue("invscheme", (Object)invschme);
            this.getModel().setValue("biztype", (Object)biztype);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterLoadData(EventObject e) {
        this.setCellEnable();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("A".equals(this.getModel().getValue("billstatus"))) {
            this.lockBfRow();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCellEnable();
        this.setQualityStatusEnable();
    }

    private void setQualityStatusEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection billentry = model.getEntryEntity("billentry");
        IFormView view = this.getView();
        for (int i = 0; i < billentry.size(); ++i) {
            if (!"pom_mftorderreport".equals(((DynamicObject)billentry.get(i)).getString("srcbillentity")) && !"sfc_processreportbill".equals(((DynamicObject)billentry.get(i)).getString("srcbillentity"))) continue;
            view.setEnable(Boolean.FALSE, i, new String[]{"qualitystatus"});
        }
    }

    private void initCurrency(Long bizOrg) {
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)bizOrg);
        if (map == null) {
            return;
        }
        this.getModel().setValue("settlecurrency", map.get("baseCurrencyID"));
    }

    private static DynamicObject getAccountByOrg(Long orgId, String orgType) {
        if (orgId == null) {
            return null;
        }
        List idList = OrgUnitServiceHelper.getFromOrgs((String)orgType, (Long)orgId, (String)"10");
        Object settleOrgId = null;
        DynamicObject account = null;
        if (idList != null && idList.size() > 0) {
            settleOrgId = idList.get(0);
            account = BusinessDataServiceHelper.loadSingleFromCache(settleOrgId, (String)KEY_BOS_ORG);
        }
        return account;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int i;
        int rowIndex2;
        ChangeData changedata;
        EntryGrid entryGrid;
        ChangeData[] changeArr = e.getChangeSet();
        if ("1".equals(this.getPageCache().get("flag"))) {
            return;
        }
        String key = e.getProperty().getName();
        if (HEADER_PRODUCTIONORG.equals(key)) {
            this.getModel().deleteEntryData("billentry");
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("billentry")).getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        int rowCount = this.getModel().getEntryRowCount("billentry");
        if (KEY_MANUBILL.equals(key)) {
            this.getPageCache().put("flag", "1");
            changedata = changeArr[0];
            rowIndex2 = changedata.getRowIndex();
            String manubillno = (String)changedata.getNewValue();
            Long manuentryid = (Long)this.getModel().getValue(KEY_MANUENTRYID, rowIndex);
            if (manubillno.isEmpty()) {
                this.getModel().setValue(KEY_MANUBILLID, (Object)0, rowIndex2);
                this.getModel().setValue(KEY_MANUENTRY, null, rowIndex2);
                this.getModel().setValue(KEY_MANUENTRYID, (Object)0, rowIndex2);
                this.getModel().setValue(ENTITYID_PRODUCTTYPE, (Object)"", rowIndex2);
                this.getModel().setValue("mainbillentryseq", (Object)0, rowIndex2);
                this.getModel().setValue("mainbillentity", (Object)"", rowIndex2);
                this.getModel().setValue("mainbillid", (Object)0, rowIndex2);
                this.getModel().setValue("mainbillentryid", (Object)0, rowIndex2);
                this.getModel().setValue("mainbillnumber", (Object)"", rowIndex2);
                this.getModel().setValue("srcbillentity", (Object)"", rowIndex2);
                this.getModel().setValue("srcbillid", (Object)0, rowIndex2);
                this.getModel().setValue("srcbillnumber", (Object)"", rowIndex2);
                this.getView().setEnable(Boolean.valueOf(true), rowIndex2, new String[]{"productline"});
            } else if (manuentryid == 0L) {
                this.getModel().setValue(KEY_MANUBILL, null, rowIndex2);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\u8bf7\u4f7f\u7528f7\u9009\u62e9\u3002", (String)"ManuFactureorderInWarehsBillEdit_18", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            }
            this.getPageCache().put("flag", "0");
        }
        if (KEY_WORKCENTER.equals(key)) {
            for (i = 0; i < rowCount; ++i) {
                Object manuentryid = (Long)this.getModel().getValue(KEY_MANUENTRYID, rowIndex);
                if (!((Long)manuentryid).equals(this.getModel().getValue(KEY_MANUENTRYID, i))) continue;
                this.getModel().setValue(KEY_WORKCENTER, null, i);
                this.getModel().setValue(KEY_WORKCENTERID, (Object)0, i);
            }
        }
        if ("qualitystatus".equals(key)) {
            block13: for (i = 0; i < changeArr.length; ++i) {
                changedata = changeArr[i];
                if (changedata.getNewValue() == null) continue;
                switch (changedata.getNewValue().toString()) {
                    case "A": {
                        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"110")});
                        this.getModel().setValue("invstatus", (Object)obj, changedata.getRowIndex());
                        continue block13;
                    }
                    case "B": {
                        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"115")});
                        this.getModel().setValue("invstatus", (Object)obj, changedata.getRowIndex());
                        continue block13;
                    }
                    case "C": {
                        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"111")});
                        this.getModel().setValue("invstatus", (Object)obj, changedata.getRowIndex());
                        continue block13;
                    }
                    case "D": {
                        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"113")});
                        this.getModel().setValue("invstatus", (Object)obj, changedata.getRowIndex());
                        continue block13;
                    }
                }
            }
        }
        if ("qty".equals(key)) {
            changedata = changeArr[0];
            rowIndex2 = changedata.getRowIndex();
            DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex2);
            BigDecimal qty = (BigDecimal)changedata.getNewValue();
            DynamicObject baseunit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex2);
            DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex2);
            if (unit != null && baseunit != null && material != null) {
                DynamicObject masterid = material.getDynamicObject("masterid");
                StringBuilder errMsg = new StringBuilder();
                BigDecimal baseqty = UnitConvertHelper.calculateNewQty((BigDecimal)qty, (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)masterid.getPkValue()), (StringBuilder)errMsg);
                boolean isadd = (Boolean)this.getModel().getValue("isadd", rowIndex2);
                this.getModel().setValue("baseqty", (Object)baseqty, rowIndex2);
                if (isadd) {
                    this.getModel().setValue("receivalqty", (Object)baseqty, rowIndex2);
                }
            }
        }
        if ("material".equals(key)) {
            changedata = changeArr[0];
            rowIndex2 = changedata.getRowIndex();
            DynamicObject material = (DynamicObject)changedata.getNewValue();
            if (material == null) {
                return;
            }
            DynamicObject masterid = material.getDynamicObject("masterid");
            this.getModel().setValue("materialmasterid", masterid == null ? Long.valueOf(0L) : masterid.getPkValue(), rowIndex2);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        ListShowParameter showParameter;
        super.beforeClick(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (this.isNull(this.getModel().getValue("org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u3002", (String)"ManuFactureorderInWarehsBillEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (this.isNull(this.getModel().getValue(HEADER_PRODUCTIONORG))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"ManuFactureorderInWarehsBillEdit_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (key.equals(KEY_MANUBILL)) {
            if (this.isNull(this.getModel().getValue("invscheme"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u4e8b\u52a1\u3002", (String)"ManuFactureorderInWarehsBillEdit_14", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.isNull(this.getModel().getValue("material"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801\u3002", (String)"ManuFactureorderInWarehsBillEdit_15", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            showParameter = ShowFormHelper.createShowListForm((String)GetEntityNameHelper.getOrderEntityName(this.getModel().getValue("productiondomain") + ""), (boolean)false);
            List filters = showParameter.getListFilterParameter().getQFilters();
            DynamicObject orgInfo = (DynamicObject)this.getModel().getValue(HEADER_PRODUCTIONORG);
            filters.add(new QFilter("org.id", "=", orgInfo.get("id")));
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
            filters.add(new QFilter("treeentryentity.bizstatus", "not in", (Object)arr));
            filters.add(new QFilter("treeentryentity.planstatus", "=", (Object)"C"));
            HashSet<String> taskStatusSet = new HashSet<String>(16);
            taskStatusSet.add("B");
            taskStatusSet.add("C");
            taskStatusSet.add("D");
            filters.add(new QFilter("treeentryentity.taskstatus", "in", taskStatusSet));
            int count = this.getModel().getEntryCurrentRowIndex("billentry");
            DynamicObject billEntry = this.getModel().getEntryRowEntity("billentry", count);
            DynamicObject productLine = billEntry.getDynamicObject("productline");
            if ("E".equals(this.getModel().getValue("productiondomain")) && ObjectUtils.isNotEmpty((Object)productLine)) {
                filters.add(new QFilter("treeentryentity.productline", "=", productLine.getPkValue()));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_MANUBILL);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (key.equals(KEY_WORKCENTER)) {
            showParameter = ShowFormHelper.createShowListForm((String)ENTITYID_WORKCENTRE, (boolean)false);
            DynamicObject orgInfo = (DynamicObject)this.getModel().getValue(HEADER_PRODUCTIONORG);
            List filters = showParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("createorg.id", "=", orgInfo.get("id")));
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_WORKCENTER);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String selectProperties;
        Object pkValue;
        int rowIndex;
        EntryGrid entryGrid;
        ListSelectedRowCollection rows;
        super.closedCallBack(closedCallBackEvent);
        this.getPageCache().put("flag", "1");
        if (KEY_MANUBILL.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            DynamicObject obj;
            entryGrid = (EntryGrid)this.getView().getControl("billentry");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            rowIndex = entryGrid.getSelectRows()[0];
            pkValue = rows.get(0).getPrimaryKeyValue();
            selectProperties = "id,billno,treeentryentity,treeentryentity.productline,treeentryentity.material,treeentryentity.producedept,treeentryentity.warehouse,treeentryentity.location,treeentryentity.seq";
            String productiondomain = this.getModel().getValue("productiondomain") + "";
            if ("E".equalsIgnoreCase(productiondomain)) {
                selectProperties = selectProperties + ",treeentryentity.workcenter";
            }
            if ((obj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)GetEntityNameHelper.getOrderEntityName(productiondomain), (String)selectProperties)) == null) {
                return;
            }
            Long manuentryid = (Long)this.getModel().getValue(KEY_MANUENTRYID, rowIndex);
            Object entryPkValue = rows.get(0).getEntryPrimaryKeyValue();
            for (int i = 0; i < obj.getDynamicObjectCollection("treeentryentity").size(); ++i) {
                DynamicObject entry = (DynamicObject)obj.getDynamicObjectCollection("treeentryentity").get(i);
                if (!entry.getPkValue().equals(entryPkValue)) continue;
                DynamicObject mftmaterial = entry.getDynamicObject("material");
                DynamicObject invmaterial = (DynamicObject)this.getModel().getValue("material", rowIndex);
                DynamicObject material = invmaterial.getDynamicObject("masterid");
                this.getModel().setValue("materialattr", (Object)mftmaterial.getString("materialattr"), rowIndex);
                QFilter filter1 = new QFilter("masterid", "=", material.getPkValue());
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject masterId = invmaterial.getDynamicObject("masterid");
                DynamicObject invunit = invmaterial.getDynamicObject("inventoryunit");
                if (masterId.getDynamicObject("auxptyunit") != null) {
                    this.getModel().setValue("unit2nd", (Object)masterId.getDynamicObject("auxptyunit"), rowIndex);
                }
                if (entry.get(KEY_PRODUCEDEPT) == null) {
                    this.getModel().setValue(KEY_PRODUCEDEPT, (Object)0L, rowIndex);
                } else {
                    Object workshop = entry.getDynamicObject(KEY_PRODUCEDEPT).getPkValue();
                    this.getModel().setValue(KEY_PRODUCEDEPT, workshop, rowIndex);
                }
                if (entry.get("warehouse") != null) {
                    this.getModel().setValue("warehouse", entry.getDynamicObject("warehouse").getPkValue(), rowIndex);
                }
                this.getModel().setValue("location", entry.get("location") == null ? null : entry.getDynamicObject("location").getPkValue(), rowIndex);
                this.getModel().setValue("mainbillentryseq", entry.get("seq"), rowIndex);
                this.getModel().setValue("mainbillentity", (Object)obj.getDynamicObjectType().getName(), rowIndex);
                this.getModel().setValue("mainbillid", obj.getPkValue(), rowIndex);
                this.getModel().setValue("mainbillnumber", obj.get("billno"), rowIndex);
                this.getModel().setValue("srcbillentity", (Object)obj.getDynamicObjectType().getName(), rowIndex);
                this.getModel().setValue("srcbillid", obj.getPkValue(), rowIndex);
                this.getModel().setValue("srcbillnumber", obj.get("billno"), rowIndex);
                if (!"E".equalsIgnoreCase(productiondomain)) continue;
                this.getModel().setValue("productline", entry.get("productline"), rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"productline"});
            }
            this.getModel().setValue(KEY_MANUBILL, (Object)obj.getString("billno"), rowIndex);
            this.getModel().setValue(KEY_MANUBILLID, obj.getPkValue(), rowIndex);
            this.getModel().setValue(KEY_MANUENTRYID, entryPkValue, rowIndex);
            if (manuentryid != 0L && !manuentryid.equals(entryPkValue)) {
                this.setCellEnable();
            }
        }
        if (KEY_WORKCENTER.equals(closedCallBackEvent.getActionId()) && (rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !rows.isEmpty()) {
            entryGrid = (EntryGrid)this.getView().getControl("billentry");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            rowIndex = entryGrid.getSelectRows()[0];
            pkValue = rows.get(0).getPrimaryKeyValue();
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)ENTITYID_WORKCENTRE, (String)(selectProperties = "id,number,name"));
            if (obj == null) {
                return;
            }
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                Long manuentryid = (Long)this.getModel().getValue(KEY_MANUENTRYID, rowIndex);
                if (!manuentryid.equals(this.getModel().getValue(KEY_MANUENTRYID, i))) continue;
                this.getModel().setValue(KEY_WORKCENTER, (Object)obj.getString("name"), i);
                this.getModel().setValue(KEY_WORKCENTERID, obj.getPkValue(), i);
            }
        }
        this.getPageCache().put("flag", "0");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int rowCount;
        this.getPageCache().put("flag", "1");
        IDataModel model = this.getModel();
        int row = 0;
        int selectRow = 0;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        String operateKey = e.getOperateKey();
        if ("newentry".equals(operateKey)) {
            selectRow = entryGrid.getSelectRows()[0];
            this.setEntryRowData(selectRow);
            this.setCellEnable();
        } else if ("addproduct".equals(operateKey)) {
            selectRow = entryGrid.getSelectRows()[0];
            row = model.insertEntryRow("billentry", selectRow + 1);
            this.setCellEnable();
        } else if ("deleterow".equals(operateKey)) {
            Long manuentryid;
            selectRow = entryGrid.getSelectRows()[0];
            if (!((Boolean)model.getValue("iscopy", selectRow)).booleanValue() && !this.isNull(model.getValue("srcbillentryid", selectRow)) && "C".equals(model.getValue(ENTITYID_PRODUCTTYPE, selectRow))) {
                manuentryid = (Long)model.getValue(KEY_MANUENTRYID, selectRow);
                rowCount = model.getEntryRowCount("billentry");
                for (int i = rowCount - 1; i >= 0; --i) {
                    if (!manuentryid.equals(model.getValue(KEY_MANUENTRYID, i)) || !((Boolean)model.getValue("iscopy", i)).booleanValue()) continue;
                    model.deleteEntryRow("billentry", i);
                }
                model.deleteEntryRow("billentry", selectRow);
            } else if (((Boolean)model.getValue("iscopy", selectRow)).booleanValue()) {
                model.deleteEntryRow("billentry", selectRow);
            } else {
                manuentryid = (Long)model.getValue(KEY_MANUENTRYID, selectRow);
                if (0L == manuentryid) {
                    model.deleteEntryRow("billentry", selectRow);
                } else {
                    rowCount = model.getEntryRowCount("billentry");
                    for (int i = rowCount - 1; i >= 0; --i) {
                        if (!manuentryid.equals(model.getValue(KEY_MANUENTRYID, i))) continue;
                        model.deleteEntryRow("billentry", i);
                    }
                }
            }
            this.setCellEnable();
        } else if ("copyentryrow".equals(operateKey)) {
            int[] selectRows = entryGrid.getSelectRows();
            rowCount = model.getEntryRowCount("billentry");
            IFormView view = this.getView();
            for (int i = rowCount - selectRows.length; i < rowCount; ++i) {
                DynamicObject entryRowEntity = model.getEntryRowEntity("billentry", i);
                this.setEnableByMaterialMDC(entryRowEntity, i, view);
            }
            this.setCellEnable();
            this.setQualityStatusEnable();
        }
        this.getPageCache().put("flag", "0");
        if ("audit".equals(e.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            FormOperate formOperate = (FormOperate)e.getSource();
            String backflushInfo = formOperate.getOption().getVariableValue("backflushInfo", "");
            if (StringUtils.isNotEmpty((CharSequence)backflushInfo)) {
                this.getView().showTipNotification(backflushInfo);
            }
            this.getView().invokeOperation("refresh");
        } else if ("unaudit".equals(e.getOperateKey()) || "unbackflush".equals(e.getOperateKey()) || "updatebfstatus".equals(e.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        } else if ("save".equals(operateKey) || "unsubmit".equals(operateKey)) {
            this.lockBfRow();
        }
    }

    private void setCellEnable() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("billentry");
        IFormView view = this.getView();
        Boolean hasSrc = Boolean.FALSE;
        for (int i = 0; i < rowCount; ++i) {
            if (!"".equals(model.getValue("srcbillnumber"))) {
                hasSrc = Boolean.TRUE;
            }
            if (((Boolean)model.getValue("isadd", i)).booleanValue()) {
                DynamicObject materialInv = (DynamicObject)model.getValue("material", i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{KEY_PRODUCEDEPT});
                if (materialInv != null) {
                    Boolean enableshelflifemgr;
                    Boolean enablelot;
                    DynamicObject material = materialInv.getDynamicObject("masterid");
                    Boolean isuseauxpty = material.getBoolean("isuseauxpty");
                    if (!isuseauxpty.booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxpty"});
                    }
                    if (!(enablelot = Boolean.valueOf(materialInv.getBoolean("enablelot"))).booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"lotnumber"});
                    }
                    if (!(enableshelflifemgr = Boolean.valueOf(materialInv.getBoolean("enableshelflifemgr"))).booleanValue()) {
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"producedate"});
                        this.getView().setEnable(Boolean.FALSE, i, new String[]{"expirydate"});
                    }
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxpty"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"lotnumber"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"producedate"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"expirydate"});
                }
                DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", i);
                if (warehouse != null) {
                    Boolean isopenlocation = warehouse.getBoolean("isopenlocation");
                    if (isopenlocation.booleanValue()) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"location"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"location"});
                continue;
            }
            this.setControlState(Boolean.FALSE, i);
        }
        view.setEnable(Boolean.valueOf(hasSrc == false), new String[]{HEADER_PRODUCTIONORG});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if ("copy".equals(operateKey) && !this.allowCopy()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u751f\u6210\u7684\u201c\u5b8c\u5de5\u5165\u5e93\u5355\u201d\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"ManuFactureorderInWarehsBillEdit_11", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("deleterow".equals(operateKey)) {
            if (entryGrid.getSelectRows().length == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u9700\u8981\u5220\u9664\u7684\u5206\u5f55\u3002", (String)"ManuFactureorderInWarehsBillEdit_16", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        } else if ("newentry".equals(operateKey) && this.isNull(model.getValue(HEADER_PRODUCTIONORG))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u884c\u3002", (String)"ManuFactureorderInWarehsBillEdit_17", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("backflushout".equals(operateKey) || "rebackflushout".equals(operateKey)) {
            ArrayList<String> billnos = new ArrayList<String>(1);
            billnos.add(this.getModel().getValue("billno").toString());
            String name = this.getModel().getDataEntity().getDataEntityType().getName();
            String productiondomain = (String)this.getModel().getValue("productiondomain");
            String backFlushFormid = "im_mdc_backflushform";
            if ("E".equals(productiondomain)) {
                backFlushFormid = "im_mdc_propbackflushform";
            }
            BillShowParameter showParameter = ManuFactureTraceUtils.createAddNewBillShowParam(billnos, ((DynamicObject)this.getModel().getValue(HEADER_PRODUCTIONORG)).getPkValue(), backFlushFormid);
            showParameter.setCustomParam("billType", (Object)name);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean isNull(Object obj) {
        if (obj instanceof String) {
            return obj == null || obj.toString().trim().length() == 0;
        }
        return obj == null;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fileName = evt.getProperty().getName();
        if (HEADER_PRODUCTIONORG.equals(fileName)) {
            if (this.isNull(this.getModel().getValue("org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u3002", (String)"ManuFactureorderInWarehsBillEdit_9", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject obj = (DynamicObject)this.getModel().getValue("org");
            List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)((Long)obj.getPkValue()), (String)"10");
            long bizID = 15L;
            ORM orm = ORM.create();
            QFilter filter = new QFilter("parent.id", "in", (Object)idList);
            QFilter filter2 = null;
            filter2 = new QFilter("view", "=", (Object)bizID);
            QFilter filter3 = new QFilter("view.isdefault", "=", (Object)"1");
            QFilter[] filters = null;
            String selSql = "id,org.id";
            filters = new QFilter[]{filter, filter2, filter3};
            DynamicObjectCollection dcs = orm.query("bos_org_structure", selSql, filters);
            HashSet<Long> set = new HashSet<Long>();
            if (obj.getBoolean("fisproduce")) {
                set.add((Long)obj.getPkValue());
            }
            for (int i = 0; i < dcs.size(); ++i) {
                set.add((Long)((DynamicObject)dcs.get(i)).get("org.id"));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", set));
        }
        if ("material".equals(fileName)) {
            ORM orm = ORM.create();
            QFilter filter = new QFilter("isjointproduct", "=", (Object)Boolean.TRUE);
            QFilter filter2 = new QFilter("status", "=", (Object)"C");
            QFilter filter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter[] filters = null;
            String selSql = "id,masterid";
            filters = new QFilter[]{filter, filter2, filter3};
            DynamicObjectCollection dcs = orm.query("bd_materialmftinfo", selSql, filters);
            HashSet<Long> set = new HashSet<Long>();
            for (int i = 0; i < dcs.size(); ++i) {
                set.add((Long)((DynamicObject)dcs.get(i)).get("masterid"));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid", "in", set));
        }
        if (KEY_PRODUCEDEPT.equals(fileName)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(HEADER_PRODUCTIONORG);
            Long orgId = 0L;
            if (org != null) {
                orgId = (Long)org.getPkValue();
            }
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITYID_WORKSHOPSETUP, (Long)orgId);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection col = QueryServiceHelper.query((String)ENTITYID_WORKSHOPSETUP, (String)"workshoporg", (QFilter[])new QFilter[]{qFilter});
            if (!col.isEmpty()) {
                HashSet<Long> idSet = new HashSet<Long>(col.size());
                for (int i = 0; i < col.size(); ++i) {
                    DynamicObject obj = (DynamicObject)col.get(i);
                    idSet.add(Long.valueOf(obj.getString("workshoporg")));
                }
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", idSet));
            } else {
                List toOrg = OrgUnitServiceHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId);
                if (!toOrg.isEmpty()) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)toOrg));
                }
            }
            listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            listShowParameter.setMultiSelect(false);
        }
    }

    private void setEntryRowData(int row) {
        IDataModel model = this.getModel();
        model.setValue("qualitystatus", (Object)"A", row);
        model.setValue("receivalqty", (Object)0, row);
        model.setValue("receivedqty", (Object)0, row);
        model.setValue("isadd", (Object)Boolean.TRUE, row);
    }

    private boolean allowCopy() {
        int count = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < count; ++i) {
            String srcBillNumber = (String)this.getModel().getValue("srcbillnumber", i);
            if (srcBillNumber.isEmpty()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setEnableByMaterialMDC(DynamicObject entry, int index, IFormView view) {
        DynamicObject stockMaterial = entry.getDynamicObject("material");
        if (stockMaterial == null) {
            return;
        }
        DynamicObject material = null;
        if (!"bd_material".equals(stockMaterial.getDataEntityType().getName())) {
            material = stockMaterial.getDynamicObject("masterid");
        }
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5143\u6570\u636e\u914d\u7f6e\u6709\u8bef\uff1a\u7269\u6599\u7b56\u7565\u9700\u5f15\u7528\u7269\u6599\u201c\u542f\u7528\u8f85\u52a9\u5c5e\u6027 /isuseauxpty\u201d\u5c5e\u6027\u3002", (String)"ManuFactureorderInWarehsBillEdit_12", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
        boolean isUseAuxpty = material.getBoolean("isuseauxpty");
        view.setEnable(Boolean.valueOf(isUseAuxpty), index, new String[]{"auxpty"});
        DynamicObject unit2nd = material.getDynamicObject("auxptyunit");
        view.setEnable(Boolean.valueOf(unit2nd != null), index, new String[]{"qtyunit2nd"});
        boolean enableLot = stockMaterial.getBoolean("enablelot");
        view.setEnable(Boolean.valueOf(enableLot), index, new String[]{"lotnumber"});
        DynamicObject warehouse = entry.getDynamicObject("warehouse");
        boolean isopenlocation = warehouse != null && warehouse.getBoolean("isopenlocation");
        view.setEnable(Boolean.valueOf(isopenlocation), index, new String[]{"location"});
        boolean isEnableShelfLife = stockMaterial.getBoolean("enableshelflifemgr");
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"producedate"});
        view.setEnable(Boolean.valueOf(isEnableShelfLife), index, new String[]{"expirydate"});
    }

    private void setControlState(Boolean flag, int index) {
        this.getView().setEnable(flag, index, new String[]{"material", ENTITYID_PRODUCTTYPE, KEY_MANUBILL, "tracknumber", "configuredcode"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObject obj;
        super.afterAddRow(e);
        String entityName = e.getEntryProp().getName();
        if ("billentry".equals(entityName) && !this.isNull(obj = (DynamicObject)this.getModel().getValue(HEADER_PRODUCTIONORG))) {
            Long settleOrgId = this.getSettleOrgIdByMftOrg(obj.getLong("id"));
            for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.getModel().setValue("entrysettleorg", (Object)settleOrgId, rowIndex);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if (!"billentry".equals(entryProp.getName())) {
            return;
        }
        int[] rowIndexs = e.getRowIndexs();
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (int rowIndex : rowIndexs) {
            DynamicObject entry = this.getModel().getEntryRowEntity("billentry", rowIndex);
            Long entryId = entry.getLong("id");
            if (!MDCDyObjUtil.isNotEmptyId(entryId)) continue;
            entryIds.add(entryId);
        }
        if (!entryIds.isEmpty()) {
            Map<Long, Map<String, Object>> dataMap = this.getOutDataMap(entryIds);
            ArrayList<String> errMsgLs = new ArrayList<String>(16);
            for (int rowIndex : rowIndexs) {
                Map<String, Object> data;
                DynamicObject entry = this.getModel().getEntryRowEntity("billentry", rowIndex);
                Long entryId = entry.getLong("id");
                if (!MDCDyObjUtil.isNotEmptyId(entryId) || (data = dataMap.get(entryId)) == null) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5df2\u7ecf\u5012\u51b2\uff0c\u5012\u51b2\u9886\u6599\u5355\u7f16\u53f7\u201c%2$s\u201d\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ManuFactureorderInWarehsBillEdit_19", (String)"scmc-mm-mdc", (Object[])new Object[0]), rowIndex + 1, data.get("outBillNo"));
                errMsgLs.add(msg);
            }
            if (!errMsgLs.isEmpty()) {
                StringBuilder errSb = new StringBuilder();
                for (String errMsg : errMsgLs) {
                    errSb.append(errMsg).append("\n");
                }
                this.getView().showTipNotification(errSb.toString());
                e.setCancel(true);
            }
        }
    }

    private Map<Long, Map<String, Object>> getOutDataMap(Set<Long> entryIds) {
        HashMap<Long, Map<String, Object>> dataMap = new HashMap<Long, Map<String, Object>>(16);
        String algoKey = "query-im_mdc_mftproorder";
        QFilter filter = new QFilter("billentry.srcbillentryid", "in", entryIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"im_mdc_mftproorder", (String)"id,billno,billentry.srcbillentryid", (QFilter[])new QFilter[]{filter}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                Long outBillId = row.getLong("id");
                String billNo = row.getString("billno");
                Long srcbillentryid = row.getLong("billentry.srcbillentryid");
                data.put("outBillId", outBillId);
                data.put("outBillNo", billNo);
                dataMap.put(srcbillentryid, data);
            }
        }
        return dataMap;
    }

    private void lockBfRow() {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("billentry");
        for (DynamicObject entry : entryColl) {
            Long entryId = entry.getLong("id");
            if (!MDCDyObjUtil.isNotEmptyId(entryId)) continue;
            entryIds.add(entryId);
        }
        if (!entryIds.isEmpty()) {
            ArrayList<String> lockFields = new ArrayList<String>(16);
            lockFields.add("material");
            lockFields.add("auxpty");
            lockFields.add(ENTITYID_PRODUCTTYPE);
            lockFields.add("qualitystatus");
            lockFields.add(KEY_MANUBILL);
            lockFields.add(KEY_PRODUCEDEPT);
            lockFields.add("shift");
            lockFields.add("qty");
            lockFields.add("lotnumber");
            lockFields.add("producedate");
            lockFields.add("ecostcenter");
            lockFields.add("expirydate");
            lockFields.add("warehouse");
            lockFields.add("location");
            lockFields.add("outinvtype");
            lockFields.add("outinvstatus");
            lockFields.add("outowner");
            lockFields.add("outkeeper");
            lockFields.add("invtype");
            lockFields.add("invstatus");
            lockFields.add("owner");
            lockFields.add("keeper");
            lockFields.add("configuredcode");
            lockFields.add("tracknumber");
            lockFields.add("project");
            lockFields.add("price");
            lockFields.add("amount");
            lockFields.add(KEY_WORKCENTERID);
            lockFields.add(KEY_WORKCENTER);
            lockFields.add("downreturnqty");
            lockFields.add("entrycomment");
            Map<Long, Map<String, Object>> dataMap = this.getOutDataMap(entryIds);
            for (DynamicObject entry : entryColl) {
                Map<String, Object> data;
                Long entryId = entry.getLong("id");
                if (!MDCDyObjUtil.isNotEmptyId(entryId) || (data = dataMap.get(entryId)) == null) continue;
                int seq = entry.getInt("seq");
                this.getView().setEnable(Boolean.valueOf(false), seq - 1, lockFields.toArray(new String[0]));
            }
        }
    }
}

