/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftouttpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.utils.OrderBookDateService;

public class BackDiffShareUtil {
    private static final Log logger = LogFactory.getLog(BackDiffShareUtil.class);

    public static void updateDiffShareDetail(String errMessage, Map<Long, DynamicObject> subList, String dest, String status) {
        int i = 0;
        if (subList.size() > 0) {
            StringBuilder ssql = new StringBuilder();
            int batchsize = 10000;
            String resStr = errMessage;
            if (errMessage != null && errMessage.length() >= 255) {
                resStr = errMessage.substring(0, 200);
            } else if (errMessage == null) {
                errMessage = resStr = "error null";
            }
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
            int index = 0;
            updateList.add(new Object[]{status, resStr, errMessage});
            for (Map.Entry<Long, DynamicObject> sMap : subList.entrySet()) {
                Long key = sMap.getKey();
                if (i == subList.size() - 1 || i == batchsize) {
                    ++index;
                    ssql.append(key);
                    long startTimeMillis = System.currentTimeMillis();
                    BackDiffShareUtil.updateErrorShdifsharedetail(ssql.toString(), updateList, status);
                    long eTimeMillis = System.currentTimeMillis();
                    logger.info("unAduitOrderInfo--updateDetailMsg---update--index---" + index + "----" + (eTimeMillis - startTimeMillis));
                    ssql = new StringBuilder();
                } else {
                    ssql.append(key);
                    ssql.append(",");
                }
                ++i;
            }
        }
    }

    public static void updateDiffShareDetailError(String errMessage, List<Long> subList, String dest, String status) {
        if (!subList.isEmpty()) {
            StringBuilder ssql = new StringBuilder();
            int batchsize = 10000;
            String resStr = errMessage;
            if (errMessage != null && errMessage.length() >= 255) {
                resStr = errMessage.substring(0, 200);
            } else if (errMessage == null) {
                errMessage = resStr = "error null";
            }
            ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
            updateList.add(new Object[]{status, resStr, errMessage});
            int index = 0;
            for (int i = 0; i < subList.size(); ++i) {
                Long key = subList.get(i);
                if (i == subList.size() - 1 || i == batchsize) {
                    ++index;
                    ssql.append(key);
                    long startTimeMillis = System.currentTimeMillis();
                    BackDiffShareUtil.updateErrorShdifsharedetail(ssql.toString(), updateList, status);
                    long eTimeMillis = System.currentTimeMillis();
                    logger.info("unAduitOrderInfo--updateDetailMsg---update--index---" + index + "----" + (eTimeMillis - startTimeMillis));
                    ssql = new StringBuilder();
                    continue;
                }
                ssql.append(key);
                ssql.append(",");
            }
        }
    }

    public static void updateSuccessDiffShareDetail(Map<Object, String> billNos, List<Long> subList, String dest) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, String> sucmap : billNos.entrySet()) {
            sb.append(sucmap.getValue());
            sb.append(",");
        }
        String resStr = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u751f\u6210\u9886\u6599\u5355\uff1a%1$s\u6210\u529f\u3002", (String)"BackDiffShareUtil_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), sb.toString());
        if ("im_mdc_mftreturnorder".equals(dest)) {
            resStr = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u751f\u6210\u9000\u6599\u5355\uff1a%1$s\u6210\u529f\u3002", (String)"BackDiffShareUtil_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), sb.toString());
        }
        BackDiffShareUtil.updateDiffShareDetailError(resStr, subList, dest, "C");
    }

    public static void updateDetailMsg(String status, Map<Long, BigDecimal> updateMap, Set<Long> auditPkIds, String errorMsg) {
        logger.info("\u66f4\u65b0\u7ed3\u679c\u4fe1\u606f------" + status);
        logger.info("auditPkIds.size------" + auditPkIds.size());
        logger.info("auditPkIds------" + auditPkIds.toString());
        long startTimeMillis = System.currentTimeMillis();
        logger.info("unAduitOrderInfo--updateDetailMsg---start-----" + startTimeMillis);
        ArrayList<Object[]> updateParam = new ArrayList<Object[]>(16);
        String resStr = errorMsg;
        if (errorMsg != null && errorMsg.length() >= 255) {
            resStr = errorMsg.substring(0, 200);
        }
        int batchsize = 10000;
        if (!updateMap.isEmpty() && updateMap.size() > 0) {
            updateParam.add(new Object[]{status, resStr, errorMsg});
            StringBuilder sb2 = new StringBuilder();
            int i = 0;
            int index = 0;
            for (Map.Entry<Long, BigDecimal> smap : updateMap.entrySet()) {
                if (i == updateMap.size() - 1 || i == batchsize) {
                    ++index;
                    sb2.append(smap.getKey());
                    startTimeMillis = System.currentTimeMillis();
                    BackDiffShareUtil.updateShdifsharedetail(sb2.toString(), updateParam, status);
                    long eTimeMillis = System.currentTimeMillis();
                    logger.info("unAduitOrderInfo--updateDetailMsg---update--index---" + index + "----" + (eTimeMillis - startTimeMillis));
                    sb2 = new StringBuilder();
                } else {
                    sb2.append(smap.getKey());
                    sb2.append(",");
                }
                ++i;
            }
        }
        long endTimeMillis = System.currentTimeMillis();
        logger.info("unAduitOrderInfo--updateDetailMsg---endTime------" + endTimeMillis);
        logger.info("unAduitOrderInfo----updateDetailMsg----totaltime--" + (endTimeMillis - startTimeMillis));
    }

    public static void updateShdifsharedetail(String sb, List<Object[]> updateParam, String status) {
        StringBuilder sbsql = new StringBuilder();
        sbsql.append("update t_im_mdc_shdifsharedetail set fassignstauts=?,");
        if ("A".equals(status)) {
            sbsql.append("fassignnum=0,");
        }
        sbsql.append("fassignremark =?,fassignremark_tag =? where fentryid in (");
        sbsql.append(sb);
        sbsql.append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sbsql.toString(), updateParam);
    }

    public static void updateErrorShdifsharedetail(String sb, List<Object[]> updateParam, String status) {
        StringBuilder ssql = new StringBuilder();
        ssql.append("update t_im_mdc_shdifsharedetail set fassignstauts=?,");
        if ("C".equals(status)) {
            ssql.append("fassignnum=factsharenum,");
        }
        ssql.append("fassignremark =?,fassignremark_tag =? where fentryid in (");
        ssql.append(sb);
        ssql.append(")");
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)ssql.toString(), updateParam);
    }

    public static Map<Long, BigDecimal> getupdateDetailMap(Set<Long> auditPkIds) {
        HashMap<Long, BigDecimal> updateMap = new HashMap<Long, BigDecimal>(10);
        QFilter qf = new QFilter("id", "in", auditPkIds);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"queryMftreturnorder", (String)"im_mdc_mftreturnorder", (String)"billentry.srcbillid,billentry.srcbillentryid,billentry.qty", (QFilter[])new QFilter[]{qf}, (String)"");){
            for (Row row : queryDataSet) {
                updateMap.put(row.getLong("billentry.srcbillentryid"), row.getBigDecimal("billentry.qty"));
            }
        }
        return updateMap;
    }

    public static String getSqlId(Map<Long, BigDecimal> updateMap) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, BigDecimal> smap : updateMap.entrySet()) {
            if (i == updateMap.size() - 1) {
                sb.append(smap.getKey());
            } else {
                sb.append(smap.getKey());
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public static Boolean checkCloseOrderBookDate(DynamicObject morder, Map<Long, Date> acctOrgCloseDateMap) {
        Boolean flag = Boolean.TRUE;
        if (!StringUtils.equals((CharSequence)"A", (CharSequence)morder.getString("treeentryentity.bizstatus"))) {
            Object inwardept;
            long inwardeptid;
            Object org;
            long orgid;
            Date maxBookDate;
            Date closeDate;
            Date date = closeDate = morder.get("treeentryentity.closebookdate") == null ? morder.getDate("treeentryentity.closetime") : morder.getDate("treeentryentity.closebookdate");
            if (closeDate != null && OrderBookDateService.isIntertemporal(closeDate, maxBookDate = OrderBookDateService.queryMaxBookDate(orgid = (org = morder.get("org")) == null ? 0L : (Long)org, inwardeptid = (inwardept = morder.get("treeentryentity.inwardept")) == null ? 0L : (Long)inwardept, new HashMap<Long, Date>(), acctOrgCloseDateMap))) {
                flag = Boolean.FALSE;
            }
        }
        return flag;
    }
}

