/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftouttpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;
import kd.scmc.im.common.mdc.helper.CalMaterialExtHelper;
import kd.scmc.im.common.mdc.utils.ManuBillPickStatusEnum;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.formplugin.mdc.mftouttpl.ext.IMftCalMaterialExt;
import kd.scmc.im.mservice.mdc.event.CalMaterialServiceOp;
import org.apache.commons.lang3.math.NumberUtils;

public class MftOrderCalMaterialUtils {
    private static final Log logger = LogFactory.getLog(MftOrderCalMaterialUtils.class);
    public static final String KEY_TRANSACTIONTYPE = "transactiontype";
    public static final String KEY_PRODUCTTYPE = "producttype";
    public static final String KEY_TRANSACTPRODUCT = "mpdm_transactproduct";
    public static final String KEY_QTY = "qty";
    public static final String KEY_ENTITYID_STOCK = "pom_mftstock";
    public static final String KEY_TEXT_ORDER = "orderno";
    public static final String KEY_TEXT_ORDERID = "orderid";
    public static final String KEY_PRMT_ORDERENTRYID = "orderentryid";
    public static final String KEY_PICKSTATUS = "pickstatus";
    public static final String KEY_PICKINGPAIRS = "pickingpairs";
    private static final String ENTITY_ORDER = "orderEntity";
    private static final String ENTITY_STOCK = "stockEntity";
    private static final String ENTITY_OUTREQ = "reqoutEntity";

    public static void calMaterial(Map<String, String> measureunitData, Map<String, DynamicObject> transactiontypeMap, Set<String> orderidList, Set<String> orderEntryidList, Map<String, DynamicObject> srcMap, boolean isFromManuBill, String entityType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ENTITY_ORDER, "pom_mftorder");
        map.put(ENTITY_STOCK, KEY_ENTITYID_STOCK);
        map.put(ENTITY_OUTREQ, "im_mdc_mftproorder");
        MftOrderCalMaterialUtils.calMaterial(measureunitData, transactiontypeMap, orderidList, orderEntryidList, srcMap, isFromManuBill, entityType, map);
    }

    public static void calMaterial(Map<String, String> measureunitData, Map<String, DynamicObject> transactiontypeMap, Set<String> orderidList, Set<String> orderEntryidList, Map<String, DynamicObject> srcMap, Boolean isFromManuBill, String entityType, Map<String, String> entityMap) {
        QFilter filter = new QFilter(KEY_TEXT_ORDERID, "in", orderidList);
        filter.and(new QFilter(KEY_PRMT_ORDERENTRYID, "in", orderEntryidList.stream().map(NumberUtils::toLong).collect(Collectors.toList())));
        Map<String, List<Map<String, Object>>> stockMap = MftOrderCalMaterialUtils.getStockMap(filter, entityMap);
        Map<String, String> stockUnit = MftOrderCalMaterialUtils.getStockUnit(stockMap);
        HashMap<String, String> proorderMap = new HashMap<String, String>();
        QFilter qfilter0 = new QFilter("billentry.manuentryid", "in", orderEntryidList.stream().map(NumberUtils::toLong).collect(Collectors.toList()));
        qfilter0.and("billstatus", "=", (Object)"C");
        if (BillTypeEnum.PRO_ORDER.getName().equals(entityMap.get(ENTITY_OUTREQ))) {
            qfilter0.and("billtype.billformid", "in", (Object)new String[]{BillTypeEnum.PRO_ORDER.getName(), BillTypeEnum.FEED_ORDER.getName()});
        } else {
            qfilter0.and("billtype.billformid", "in", (Object)new String[]{"im_mdc_omoutbill", "im_mdc_omfeedbill"});
        }
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"queryDownBill", (String)entityMap.get(ENTITY_OUTREQ), (String)"id,billentry.manuentryid", (QFilter[])new QFilter[]{qfilter0}, (String)"billentry.manuentryid");
        Object object = null;
        try {
            for (Row row : queryDataSet) {
                String manuentryid = row.getString("billentry.manuentryid");
                proorderMap.put(manuentryid, manuentryid);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        ArrayList<DynamicObject> mftOrders = new ArrayList<DynamicObject>(srcMap.size());
        for (Map.Entry entry : srcMap.entrySet()) {
            String billnoKey = (String)entry.getKey();
            DynamicObject order = (DynamicObject)entry.getValue();
            DynamicObjectCollection col = order.getDynamicObjectCollection("treeentryentity");
            if (!isFromManuBill.booleanValue() && !MftOrderCalMaterialUtils.isAutoCal(order, transactiontypeMap)) {
                logger.info("calMaterial----------\u4e0d\u8ba1\u7b97---------isFromManuBill\uff1a" + isFromManuBill);
                logger.info("calMaterial----------\u4e0d\u8ba1\u7b97---------billnoKey\uff1a" + billnoKey);
                continue;
            }
            for (DynamicObject entry2 : col) {
                PluginProxy<IMftCalMaterialExt> newExtPlugin;
                String producttype;
                Object pkValue = entry2.getPkValue();
                if (!orderEntryidList.contains(pkValue.toString()) || !"C".equals(producttype = entry2.getString(KEY_PRODUCTTYPE))) continue;
                String orderMapkey = billnoKey + "@" + entry2.getPkValue();
                List<Map<String, Object>> stockCol = stockMap.get(orderMapkey);
                BigDecimal qty = entry2.getBigDecimal(KEY_QTY);
                DynamicObject baseunit = entry2.getDynamicObject("unit");
                String measureunit = measureunitData.get(baseunit.getPkValue().toString());
                BigDecimal pickQty = MftOrderCalMaterialUtils.calPickQty(transactiontypeMap, order, stockCol, qty, measureunit, stockUnit);
                logger.info("calMaterial----------pickQty---------=" + pickQty);
                Boolean isExistsMaterialReq = Boolean.FALSE;
                if (proorderMap.containsKey(entry2.getPkValue().toString())) {
                    isExistsMaterialReq = Boolean.TRUE;
                }
                if (pickQty.compareTo(BigDecimal.ZERO) <= 0) {
                    if (MftOrderCalMaterialUtils.isPartQtyByEntry(transactiontypeMap, order, stockCol, qty, measureunit)) {
                        entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                        entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.SOMEPICK.getValue());
                        MftOrderCalMaterialUtils.updateProPickStatus(col, entry2.getPkValue(), ManuBillPickStatusEnum.SOMEPICK.getValue());
                    } else {
                        entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                        entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.NOPICK.getValue());
                        MftOrderCalMaterialUtils.updateProPickStatus(col, entry2.getPkValue(), ManuBillPickStatusEnum.NOPICK.getValue());
                    }
                } else if (pickQty.compareTo(BigDecimal.ZERO) > 0 && pickQty.compareTo(qty) < 0) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.SOMEPICK.getValue());
                    MftOrderCalMaterialUtils.updateProPickStatus(col, entry2.getPkValue(), ManuBillPickStatusEnum.SOMEPICK.getValue());
                } else if (pickQty.compareTo(qty) == 0) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.ALLPICK.getValue());
                    MftOrderCalMaterialUtils.updateProPickStatus(col, entry2.getPkValue(), ManuBillPickStatusEnum.ALLPICK.getValue());
                } else if (pickQty.compareTo(qty) > 0) {
                    entry2.set(KEY_PICKINGPAIRS, (Object)pickQty);
                    entry2.set(KEY_PICKSTATUS, (Object)ManuBillPickStatusEnum.MOREPICK.getValue());
                    MftOrderCalMaterialUtils.updateProPickStatus(col, entry2.getPkValue(), ManuBillPickStatusEnum.MOREPICK.getValue());
                }
                if ((newExtPlugin = CalMaterialExtHelper.genExtPluginxy()) == null) continue;
                newExtPlugin.callReplace(p -> {
                    p.setMftOrderPickStatus(transactiontypeMap, order, stockCol, col, entry2);
                    return null;
                });
            }
            mftOrders.add(order);
        }
        if (mftOrders != null && mftOrders.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])mftOrders.toArray(new DynamicObject[0]));
            DynamicObjectCollection entryEntity = ((DynamicObject)mftOrders.get(0)).getDynamicObjectCollection("treeentryentity");
            if (!entryEntity.isEmpty()) {
                IDataEntityType iDataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
                DataEntityCacheManager cacheManager = new DataEntityCacheManager(iDataEntityType);
                cacheManager.removeByDt();
            }
        }
    }

    private static boolean isPartQtyByEntry(Map<String, DynamicObject> transactiontypeMap, DynamicObject order, List<Map<String, Object>> stockentrys, BigDecimal qty, String measureunit) {
        if (stockentrys == null || stockentrys.size() < 1) {
            return false;
        }
        String controlscope = MftOrderCalMaterialUtils.getControlScope(order, transactiontypeMap);
        for (Map<String, Object> stockentry : stockentrys) {
            BigDecimal standQty;
            BigDecimal demandqty;
            String issuemode = (String)stockentry.get("issuemode");
            if ("C".equals(issuemode) || (demandqty = stockentry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("demandqty")).compareTo(BigDecimal.ZERO) == 0 || (standQty = stockentry.get("standqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("standqty")).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal actissueqty = stockentry.get("actissueqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("actissueqty");
            BigDecimal rejectedqty = stockentry.get("rejectedqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("rejectedqty");
            BigDecimal feedingqty = stockentry.get("feedingqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("feedingqty");
            BigDecimal scrapqty = stockentry.get("scrapqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("scrapqty");
            BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
            BigDecimal unissueqty = demandqty.subtract(helpqty);
            String isbackflush = (String)stockentry.get("isbackflush");
            boolean iskeypart = (Boolean)stockentry.get("iskeypart");
            if (!("C".equals(controlscope) ? demandqty.compareTo(unissueqty) > 0 : ("A".equals(controlscope) ? !"B".equals(isbackflush) && demandqty.compareTo(unissueqty) > 0 : "B".equals(controlscope) && iskeypart && demandqty.compareTo(unissueqty) > 0))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAutoCal(DynamicObject manuBill, Map<String, DynamicObject> transactiontypeMap) {
        Boolean calflag = Boolean.FALSE;
        DynamicObject transactiontype = manuBill.getDynamicObject(KEY_TRANSACTIONTYPE);
        DynamicObject transtype = transactiontypeMap.get(transactiontype.getPkValue().toString());
        if (transtype != null) {
            boolean isvolcal = transtype.getBoolean("isvolcal");
            boolean isautoclose = transtype.getBoolean("isautoclose");
            if (isvolcal) {
                calflag = Boolean.TRUE;
            } else if (isautoclose) {
                calflag = Boolean.TRUE;
            }
        }
        return calflag;
    }

    public static boolean isExistsMaterialReq(Object pkValue) throws KDException {
        if (pkValue == null) {
            return false;
        }
        ORM orm = ORM.create();
        QFilter qfilter = new QFilter("billentry.manuentryid", "=", pkValue);
        boolean isExistsOutBill = orm.exists(BillTypeEnum.PRO_ORDER.getName(), new QFilter[]{qfilter});
        return isExistsOutBill;
    }

    public static BigDecimal calPickQty(Map<String, DynamicObject> transactiontypeMap, DynamicObject manuBill, List<Map<String, Object>> stockentrys, BigDecimal qty, String measureunit, Map<String, String> stockUnit) {
        BigDecimal pickQty = BigDecimal.ZERO;
        if (stockentrys == null || stockentrys.size() < 1) {
            return pickQty;
        }
        String controlscope = MftOrderCalMaterialUtils.getControlScope(manuBill, transactiontypeMap);
        Map<Long, List<Map>> groupedByGroupId = stockentrys.stream().filter(stockEntry -> MftOrderCalMaterialUtils.isValid(controlscope, stockEntry)).collect(Collectors.groupingBy(entry -> {
            long groupId = (Long)entry.get("replaceplanId") != 0L && (Long)entry.get("replacegroupid") == 0L ? (Long)entry.get("replaceplanId") : ((Long)entry.get("replacegroupid") != 0L ? ((Long)entry.get("replacegroupid")).longValue() : ((Long)entry.get("stockEntryId")).longValue());
            return groupId;
        }));
        HashMap minQuantityByPriorityInGroups = new HashMap(groupedByGroupId.size());
        for (Map.Entry<Long, List<Map>> groupEntry : groupedByGroupId.entrySet()) {
            Long groupId = groupEntry.getKey();
            List<Map> groupObjects = groupEntry.getValue();
            Map<Long, List<Map>> groupedByPriority = groupObjects.stream().collect(Collectors.groupingBy(map -> (Long)map.get("priority")));
            HashMap<Long, BigDecimal> minQuantityByPriority = new HashMap<Long, BigDecimal>(groupedByPriority.size());
            for (Map.Entry<Long, List<Map>> priorityEntry : groupedByPriority.entrySet()) {
                Long priority = priorityEntry.getKey();
                List<Map> priorityObjects = priorityEntry.getValue();
                Optional<BigDecimal> minQuantity = priorityObjects.stream().map(stockEntry -> MftOrderCalMaterialUtils.calPickQtyByEntry(stockEntry, qty, stockUnit)).min(BigDecimal::compareTo);
                minQuantityByPriority.put(priority, minQuantity.orElse(BigDecimal.ZERO));
            }
            minQuantityByPriorityInGroups.put(groupId, minQuantityByPriority);
        }
        HashMap<Long, BigDecimal> groupFinalQuantities = new HashMap<Long, BigDecimal>(minQuantityByPriorityInGroups.size());
        for (Map.Entry groupEntry : minQuantityByPriorityInGroups.entrySet()) {
            Long groupId = (Long)groupEntry.getKey();
            Map minQuantityByPriority = (Map)groupEntry.getValue();
            BigDecimal finalQuantity = minQuantityByPriority.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            groupFinalQuantities.put(groupId, finalQuantity);
        }
        pickQty = groupFinalQuantities.values().stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        return pickQty;
    }

    public static BigDecimal calPickQtyByEntry(Map<String, Object> stockentry, BigDecimal qty, Map<String, String> stockUnit) {
        BigDecimal pickQty = BigDecimal.ZERO;
        BigDecimal actissueqty = stockentry.get("actissueqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("actissueqty");
        BigDecimal rejectedqty = stockentry.get("rejectedqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("rejectedqty");
        BigDecimal feedingqty = stockentry.get("feedingqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("feedingqty");
        BigDecimal scrapqty = stockentry.get("scrapqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("scrapqty");
        BigDecimal demandqty = stockentry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("demandqty");
        BigDecimal fixscrap = stockentry.get("fixscrap") == null ? BigDecimal.ZERO : (BigDecimal)stockentry.get("fixscrap");
        BigDecimal useratio = stockentry.get("useratio") == null ? BigDecimal.ZERO : ((BigDecimal)stockentry.get("useratio")).divide(BigDecimalConstants.ONEHUNDRED, 4, 4);
        String unitId = (String)stockentry.get("materialunitid");
        logger.info("\u8ba1\u7b97\u9886\u6599\u5957\u6570\uff1a\u9700\u6c42\u6570\u91cf\uff1a" + demandqty);
        logger.info("\u8ba1\u7b97\u9886\u6599\u5957\u6570\uff1a\u56fa\u5b9a\u635f\u8017\uff1a" + fixscrap);
        String qtytype = (String)stockentry.get("qtytype");
        BigDecimal helpqty = actissueqty.add(feedingqty).subtract(rejectedqty).subtract(scrapqty);
        if ("B".equals(qtytype)) {
            if (helpqty.compareTo(demandqty) >= 0) {
                pickQty = qty.multiply(useratio);
            }
        } else {
            String precisionaccount;
            int precision;
            try {
                String[] split = stockUnit.get(unitId).split("@@");
                precision = Integer.parseInt(split[0]);
                precisionaccount = split[1];
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, new ErrorCode("unitcal", "stock materialunitid not exist"), new Object[0]);
            }
            int deal = 4;
            switch (precisionaccount) {
                case "2": {
                    deal = 1;
                    break;
                }
                case "3": {
                    deal = 0;
                    break;
                }
                default: {
                    deal = 4;
                }
            }
            if (demandqty.compareTo(fixscrap) != 0) {
                pickQty = helpqty.multiply(qty).multiply(useratio).divide(demandqty.subtract(fixscrap), precision, deal);
            }
        }
        return pickQty;
    }

    private static boolean isValid(String controlscope, Map<String, Object> stockEntry) {
        BigDecimal demandqty;
        boolean valid = true;
        String isbackflush = (String)stockEntry.get("isbackflush");
        boolean iskeypart = (Boolean)stockEntry.get("iskeypart");
        String issuemode = (String)stockEntry.get("issuemode");
        BigDecimal bigDecimal = demandqty = stockEntry.get("demandqty") == null ? BigDecimal.ZERO : (BigDecimal)stockEntry.get("demandqty");
        if ("C".equals(issuemode)) {
            valid = false;
        }
        if (demandqty.compareTo(BigDecimal.ZERO) == 0) {
            valid = false;
        }
        if ("A".equals(controlscope) && "B".equals(isbackflush)) {
            valid = false;
        }
        if ("B".equals(controlscope) && !iskeypart) {
            valid = false;
        }
        return valid;
    }

    public static String getControlScope(DynamicObject manuBill, Map<String, DynamicObject> transactiontypeMap) {
        DynamicObject transactiontype = manuBill.getDynamicObject(KEY_TRANSACTIONTYPE);
        DynamicObject transtype = transactiontypeMap.get(transactiontype.getPkValue().toString());
        if (transtype != null) {
            return transtype.getString("controlscope");
        }
        return null;
    }

    private static String selectStockProperties() {
        StringBuilder selector = new StringBuilder();
        selector.append("id");
        selector.append(",orderno");
        selector.append(",orderentryid");
        selector.append(",stockentry.qtytype");
        selector.append(",stockentry.wipqty");
        selector.append(",stockentry.id");
        selector.append(",stockentry.actissueqty");
        selector.append(",stockentry.feedingqty");
        selector.append(",stockentry.rejectedqty");
        selector.append(",stockentry.scrapqty");
        selector.append(",stockentry.demandqty");
        selector.append(",stockentry.standqty");
        selector.append(",stockentry.fixscrap");
        selector.append(",stockentry.unissueqty");
        selector.append(",stockentry.isbackflush");
        selector.append(",stockentry.iskeypart");
        selector.append(",stockentry.issuemode");
        selector.append(",stockentry.materialunitid");
        selector.append(",stockentry.useratio");
        selector.append(",stockentry.priority");
        selector.append(",stockentry.replacegroupid");
        selector.append(",stockentry.replaceplan");
        selector.append(",transactiontypeid");
        selector.append(",transactiontypeid.isconsiderloss");
        return selector.toString();
    }

    private static Map<String, List<Map<String, Object>>> getStockMap(QFilter filter, Map<String, String> entityMap) {
        HashMap<String, List<Map<String, Object>>> stockMap = new HashMap<String, List<Map<String, Object>>>();
        try (DataSet stockData = QueryServiceHelper.queryDataSet((String)"query_stockdata", (String)entityMap.get(ENTITY_STOCK), (String)MftOrderCalMaterialUtils.selectStockProperties(), (QFilter[])new QFilter[]{filter}, (String)" orderno,orderentryid");){
            for (Row row : stockData) {
                Map<Object, Object> rowMap = new HashMap();
                List rowList = new ArrayList();
                String billnoKey = row.getString(KEY_TEXT_ORDER);
                String stockMapkey = billnoKey + "@" + row.get(KEY_PRMT_ORDERENTRYID);
                if (stockMap.containsKey(stockMapkey)) {
                    rowList = (List)stockMap.get(stockMapkey);
                    rowMap = MftOrderCalMaterialUtils.getrowMap(row);
                    rowList.add(rowMap);
                    continue;
                }
                rowList = new ArrayList();
                rowMap = MftOrderCalMaterialUtils.getrowMap(row);
                rowList.add(rowMap);
                stockMap.put(stockMapkey, rowList);
            }
        }
        return stockMap;
    }

    private static Map<String, Object> getrowMap(Row row) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>(24);
        rowMap.put("actissueqty", row.getBigDecimal("stockentry.actissueqty"));
        rowMap.put("feedingqty", row.getBigDecimal("stockentry.feedingqty"));
        rowMap.put("rejectedqty", row.getBigDecimal("stockentry.rejectedqty"));
        rowMap.put("scrapqty", row.getBigDecimal("stockentry.scrapqty"));
        rowMap.put("demandqty", row.getBigDecimal("stockentry.demandqty"));
        rowMap.put("fixscrap", row.getBigDecimal("stockentry.fixscrap"));
        rowMap.put("qtytype", row.getString("stockentry.qtytype"));
        rowMap.put("isbackflush", row.getString("stockentry.isbackflush"));
        rowMap.put("issuemode", row.getString("stockentry.issuemode"));
        rowMap.put("iskeypart", row.getBoolean("stockentry.iskeypart"));
        rowMap.put("standqty", row.getBigDecimal("stockentry.standqty"));
        rowMap.put("materialunitid", row.getString("stockentry.materialunitid"));
        rowMap.put("useratio", row.getBigDecimal("stockentry.useratio"));
        rowMap.put("replacegroupid", row.getLong("stockentry.replacegroupid"));
        rowMap.put("priority", row.getLong("stockentry.priority"));
        rowMap.put("replaceplanId", row.getLong("stockentry.replaceplan"));
        rowMap.put("stockEntryId", row.getLong("stockentry.id"));
        return rowMap;
    }

    private static void updateProPickStatus(DynamicObjectCollection col, Object pkvalue, String status) {
        for (DynamicObject row : col) {
            String pid = row.getString("pid");
            if (!pid.equals(pkvalue.toString())) continue;
            row.set(KEY_PICKSTATUS, (Object)status);
        }
    }

    private static Map<String, String> getStockUnit(Map<String, List<Map<String, Object>>> stockMap) {
        HashSet<String> basunitList = new HashSet<String>(20);
        if (stockMap != null && CollectionUtils.isNotEmpty(stockMap.values())) {
            stockMap.values().forEach(stocks -> stocks.forEach(entry -> basunitList.add((String)entry.get("materialunitid"))));
        }
        return CalMaterialServiceOp.getMeasureunitData(basunitList);
    }
}

