/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.formplugin.mdc.applybill.MdcApplyBillEditTplPlugin;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;
import kd.scmc.im.utils.BigDecimalUtils;

public class MdcApplyBillEditPlugin
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static final String[] allkeys = new String[]{"billentry", "transtype", "biztime", "applyuser", "settlecurrency", "comment", "settleorg", "bizorg", "supplyownertype", "supplyowner", "applydept", "biztype", "invorg", "applyuser", "costcenterorg", "addrow", "deleterow", "fillbatch", "attachmentpanel"};
    private static final String[] f7Keys = new String[]{"supplierid", "outwarehouseid", "outlocation", "warehouse", "location"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"orderno"});
        for (String f7Key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7Key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"mpdm_manuperson", (String)"user,professiona", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)currentUserId)});
        if (loads != null && loads.length > 0) {
            this.getModel().setValue("professiona", loads[0].get("professiona"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "supplierid": {
                this.supplierFieldBeforeF7Select(e);
                break;
            }
            case "outwarehouseid": {
                this.outwareHouseFieldBeforeF7Select(e);
                break;
            }
            case "outlocation": {
                this.outlocationFieldBeforeF7Select(e);
                break;
            }
            case "warehouse": {
                this.warehouseFieldBeforeF7Select(e);
                break;
            }
            case "location": {
                this.locationFieldBeforeF7Select(e);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        String status = (String)this.getModel().getValue("billstatus");
        if ("D".equals(status)) {
            this.disableAll();
        } else if ("A".equals(status)) {
            this.enableAll();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        if ("entryclose".equals(op.getOperateKey()) || "entryunclose".equals(op.getOperateKey())) {
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u884c\u5206\u5f55\u3002", (String)"MdcApplyBillEditPlugin_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                StringBuilder sb = new StringBuilder();
                DynamicObjectCollection billentrys = this.getModel().getEntryEntity("billentry");
                for (int i = 0; i < selectRows.length; ++i) {
                    DynamicObject billentry = (DynamicObject)billentrys.get(selectRows[i]);
                    sb.append(billentry.getPkValue());
                    sb.append("@");
                }
                op.getOption().setVariableValue("entryids", sb.toString());
            }
        } else if ("materialsbind".equals(op.getOperateKey())) {
            if (selectRows.length <= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u591a\u884c\u5206\u5f55\u8fdb\u884c\u5957\u4ef6\u7ed1\u5b9a\u3002", (String)"MdcApplyBillEditPlugin_1", (String)"scmc-mm-mdc", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.openBindForm();
            }
        }
    }

    private void openBindForm() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "im_mdc_mftreqbind");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "mftreqbind");
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey()) || "entryclose".equals(e.getOperateKey()) || "entryunclose".equals(e.getOperateKey())) {
            if (e.getOperationResult().isSuccess()) {
                this.getView().invokeOperation("refresh");
            }
        } else if ("unsubmit".equals(e.getOperateKey()) || "unaudit".equals(e.getOperateKey())) {
            this.enableAll();
        }
    }

    private void enableAll() {
        this.getView().setEnable(Boolean.valueOf(true), allkeys);
    }

    private void disableAll() {
        this.getView().setEnable(Boolean.valueOf(false), allkeys);
    }

    public void click(EventObject evt) {
        if (MdcApplyBillUtils.valOrgIsNull(this.getModel(), this.getView())) {
            return;
        }
        Control sourceField = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)sourceField.getKey(), (CharSequence)"orderno")) {
            this.showBillList();
        }
    }

    private void showBillList() {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (boolean)false);
        List filters = showParameter.getListFilterParameter().getQFilters();
        filters.add(MdcApplyBillUtils.getOrderQFilter(this.getModel()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "orderno");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String group;
        super.closedCallBack(closedCallBackEvent);
        this.getPageCache().put("flag", "1");
        int currentRowIndex = this.getSelectEntryRowIndex();
        if ("orderno".equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (rows != null && !rows.isEmpty()) {
                this.getModel().beginInit();
                Long orderEntryId = (Long)rows.get(0).getEntryPrimaryKeyValue();
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 1), (String)"orderno,orderid,orderentryid,billno", (QFilter[])new QFilter[]{new QFilter("orderentryid", "=", (Object)orderEntryId)});
                MdcApplyBillUtils.setStockInfo(stock, currentRowIndex, this.getModel());
                this.getModel().endInit();
                this.getView().updateView();
            }
        } else if ("mftreqbind".equals(closedCallBackEvent.getActionId()) && !"0".equals(group = this.getPageCache().get("mftreqbindgroup"))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            for (int i = 0; i < selectRows.length; ++i) {
                this.getModel().setValue("materialgroup", (Object)group, selectRows[i]);
            }
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "orderno": {
                String stockno = (String)this.getModel().getValue("orderno", changeIndex);
                if (!StringUtils.isBlank((CharSequence)stockno)) {
                    QFilter filter = new QFilter("billno", "=", (Object)stockno);
                    filter.and(MdcApplyBillUtils.getOrderQFilter(this.getModel()));
                    DynamicObject order = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 0), (String)"treeentryentity", (QFilter[])new QFilter[]{filter});
                    if (order == null) {
                        MdcApplyBillUtils.setStockInfo(null, changeIndex, this.getModel());
                        break;
                    }
                    DynamicObjectCollection entrys = order.getDynamicObjectCollection("treeentryentity");
                    DynamicObject stockdym = BusinessDataServiceHelper.loadSingle((String)MdcApplyBillUtils.getEntityName(this.getModel(), 1), (String)"orderno,orderid,orderentryid,billno", (QFilter[])new QFilter[]{new QFilter("orderentryid", "=", ((DynamicObject)entrys.get(0)).getPkValue())});
                    MdcApplyBillUtils.setStockInfo(stockdym, changeIndex, this.getModel());
                    break;
                }
                MdcApplyBillUtils.setStockInfo(null, changeIndex, this.getModel());
                break;
            }
            case "material": {
                this.setSupplyDefalut(changeIndex);
                this.getModel().setValue("mversion", null, changeIndex);
                DynamicObject value = (DynamicObject)this.getModel().getValue("material", changeIndex);
                if (value != null) {
                    this.getModel().setValue("lengthunit", value.getDynamicObject("masterid").get("lengthunit"), changeIndex);
                    break;
                }
                this.getModel().setValue("lengthunit", null, changeIndex);
                break;
            }
            case "supplymode": {
                this.setSupplyDefalut(changeIndex);
                break;
            }
            case "warehouse": {
                DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", changeIndex);
                this.getModel().setValue("warehousechange", (Object)true, changeIndex);
                if (warehouse != null) {
                    boolean isOpenLocation = warehouse.getBoolean("isopenlocation");
                    this.getView().setEnable(Boolean.valueOf(isOpenLocation), changeIndex, new String[]{"location"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, changeIndex, new String[]{"location"});
                break;
            }
            case "unit": 
            case "qty": 
            case "auditqty": {
                this.setBizQtyAndUnit(changeIndex);
                break;
            }
            case "qtyunit2nd": {
                if (!this.getModel().getValue("auditqty", changeIndex).equals(this.getModel().getValue("qty", changeIndex))) break;
                this.getModel().setValue("auditbaseqty", this.getModel().getValue("baseqty", changeIndex), changeIndex);
                break;
            }
            case "project": {
                break;
            }
            case "headproject": {
                DynamicObject newObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
                DynamicObject oldObj = (DynamicObject)e.getChangeSet()[0].getOldValue();
                String newtran = "";
                String oldtran = "";
                if (newObj != null) {
                    newtran = newObj.getPkValue().toString();
                }
                if (oldObj != null) {
                    oldtran = oldObj.getPkValue().toString();
                }
                this.getPageCache().put("newheadproject", newtran);
                this.getPageCache().put("oldheadproject", oldtran);
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("billentry");
                if (oldObj == null || newtran.equals(this.getPageCache().get("oldheadproject")) || entryEntity == null || entryEntity.isEmpty()) break;
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("headprojectchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u9879\u76ee\u53f7\u5c06\u6e05\u9664\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"MdcApplyBillEditPlugin_6", (String)"scmc-mm-mdc", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"headprojectchange", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                this.setValueNoChange("headproject", this.getPageCache().get("newheadproject"));
            } else {
                this.setValueNoChange("headproject", this.getPageCache().get("oldheadproject"));
            }
        }
    }

    private void setValueNoChange(String keystr, Object oldObj) {
        this.getModel().beginInit();
        this.getModel().setValue("headproject", oldObj);
        this.getModel().endInit();
    }

    private void setBizQtyAndUnit(int changeIndex) {
        IDataModel bill = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", changeIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        BigDecimal auditqty = (BigDecimal)bill.getValue("auditqty", changeIndex);
        BigDecimal qty = (BigDecimal)bill.getValue("qty", changeIndex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", changeIndex);
        BigDecimal auditbaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)((DynamicObject)bill.getValue("unit", changeIndex)), (BigDecimal)auditqty, (DynamicObject)baseUnit);
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)((DynamicObject)bill.getValue("unit", changeIndex)), (BigDecimal)qty, (DynamicObject)baseUnit);
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)auditbaseQty, (String)"auditbaseqty");
        BigDecimalUtils.showBigDecimalErrorTip((IDataModel)bill, (BigDecimal)baseQty, (String)"auditbaseqty");
        bill.beginInit();
        bill.setValue("auditbaseqty", (Object)auditbaseQty, changeIndex);
        bill.setValue("baseqty", (Object)baseQty, changeIndex);
        bill.endInit();
        BillViewHelper.updateViewRow((IFormView)this.getView(), (int)changeIndex, (String)"billentry");
    }

    private void setSupplyDefalut(int changeIndex) {
        String supplymode = (String)this.getModel().getValue("supplymode", changeIndex);
        DynamicObject invorg = (DynamicObject)this.getModel().getValue("invorg");
        if ("bos_org".equals(supplymode) && invorg != null) {
            Long orgId = (Long)invorg.getPkValue();
            List<Object> ownerArray = MdcApplyBillUtils.getOwners(orgId);
            if (!ownerArray.isEmpty()) {
                this.getModel().setValue("supplierid", ownerArray.get(0), changeIndex);
            } else if (((Boolean)invorg.get("fisaccounting")).booleanValue()) {
                this.getModel().setValue("supplierid", (Object)invorg, changeIndex);
            }
        }
    }

    private void outlocationFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int seq = this.getSelectEntryRowIndex();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("outwarehouseid", seq);
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u51fa\u4ed3\u5e93\u3002", (String)"MdcApplyBillEditPlugin_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.locationFilter(warehouse, e);
    }

    private void locationFilter(DynamicObject warehouseold, BeforeF7SelectEvent e) {
        ArrayList<Object> locationList = new ArrayList<Object>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fentryid,flocationid from t_bd_warehouseentry where fid = ?", new Object[]{warehouseold.getPkValue()});
        try (DataSet ds = DB.queryDataSet((String)(MdcApplyBillEditTplPlugin.class.getName() + "locationFilter"), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sql);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Object flocationid = next.get("flocationid");
                if (flocationid == null || flocationid.equals(0L)) continue;
                locationList.add(flocationid);
            }
        }
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = new QFilter("id", "in", locationList);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void outwareHouseFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int seq = this.getSelectEntryRowIndex();
        DynamicObject org = (DynamicObject)this.getModel().getValue("outinvorg", seq);
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8c03\u51fa\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MdcApplyBillEditPlugin_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.warehouseFilter(org, e);
    }

    private void warehouseFilter(DynamicObject org, BeforeF7SelectEvent e) {
        ListShowParameter listShowParameter;
        Long[] warehouseids = MdcApplyBillUtils.getAllFinishInitWarehouseIDs(Long.parseLong(org.getPkValue().toString()));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Long warehouseid : warehouseids) {
            if (warehouseid == null) continue;
            ids.add(warehouseid);
        }
        if (!ids.isEmpty()) {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        } else {
            listShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter qfilter = new QFilter("id", "=", (Object)Long.valueOf("0"));
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void locationFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int seq = this.getSelectEntryRowIndex();
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", seq);
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4f9b\u8d27\u4ed3\u5e93\u3002", (String)"MdcApplyBillEditPlugin_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.locationFilter(warehouse, e);
    }

    private void warehouseFieldBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("invorg");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"MdcApplyBillEditPlugin_5", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.warehouseFilter(org, e);
    }

    private void supplierFieldBeforeF7Select(BeforeF7SelectEvent e) {
        int index = this.getSelectEntryRowIndex();
        String supplyfield = (String)this.getModel().getValue("supplymode", index);
        DynamicObject invorg = (DynamicObject)this.getModel().getValue("invorg");
        if ("bos_org".equals(supplyfield) && invorg != null) {
            ArrayList<Object> array = new ArrayList<Object>();
            Long orgId = (Long)invorg.getPkValue();
            List<Object> ownerArray = MdcApplyBillUtils.getOwners(orgId);
            array.addAll(ownerArray);
            if (((Boolean)invorg.get("fisaccounting")).booleanValue()) {
                array.add(invorg.get("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", array));
        }
    }
}

