/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang.StringUtils;

public class MdcApplyBillUtils {
    protected static final Map<String, String> entityNameMap = new HashMap<String, String>();
    public static final String[] orderRelationStr;
    protected static String[] replaceStr;

    private MdcApplyBillUtils() {
    }

    public static void setStockInfo(DynamicObject stock, int currentSelectIndex, IDataModel model) {
        if (stock == null) {
            for (String str : orderRelationStr) {
                if (!model.getDataEntity().containsProperty(str)) continue;
                model.setValue(str, null, currentSelectIndex);
            }
        } else {
            model.setValue("orderno", stock.get("orderno"), currentSelectIndex);
            model.setValue("orderid", stock.get("orderid"), currentSelectIndex);
            DynamicObject orderEntryf7 = stock.getDynamicObject("orderentryid");
            model.setValue("orderentryid", orderEntryf7.getPkValue(), currentSelectIndex);
            model.setValue("orderentryseq", orderEntryf7.get("entryseq"), currentSelectIndex);
            model.setValue("mainbillid", stock.getPkValue(), currentSelectIndex);
            model.setValue("mainbillentity", (Object)MdcApplyBillUtils.getEntityName(model, 1), currentSelectIndex);
            model.setValue("mainbillnumber", stock.get("billno"), currentSelectIndex);
            String entityName = MdcApplyBillUtils.getEntityName(model, 1);
            if ("pom_mrostock".equals(entityName)) {
                DynamicObject project = orderEntryf7.getDynamicObject("project");
                model.setValue("customer", orderEntryf7.get("customer"), currentSelectIndex);
                model.setValue("project", (Object)project, currentSelectIndex);
                model.setValue("headproject", (Object)project);
                model.setValue("workcard", orderEntryf7.get("workcard"), currentSelectIndex);
            } else {
                model.setValue("srcbilltype", stock.get("billtype"), currentSelectIndex);
                model.setValue("srcbillnumber", stock.get("billno"), currentSelectIndex);
                model.setValue("srcbillid", stock.get("id"), currentSelectIndex);
                model.setValue("tracknumber", stock.get("tracknumber"), currentSelectIndex);
                model.setValue("project", stock.get("bdproject"), currentSelectIndex);
            }
            if (model.getProperty("materialtype") != null && model.getProperty("productline") != null && stock.containsProperty("productline") && "E".equals(model.getValue("materialtype"))) {
                model.setValue("productline", stock.get("productline"), currentSelectIndex);
            }
        }
    }

    public static boolean valOrgIsNull(IDataModel model, IFormView iFormView) {
        DynamicObject orgInfo = (DynamicObject)model.getValue("org");
        if (orgInfo == null) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u8bf7\u7ec4\u7ec7\u3002", (String)"MdcApplyBillUtils_0", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static QFilter getOrderQFilter(IDataModel model) {
        DynamicObject headproject;
        DynamicObject orgInfo = (DynamicObject)model.getValue("org");
        QFilter q = new QFilter("org.id", "=", orgInfo.get("id"));
        q.and(new QFilter("billstatus", "=", (Object)"C"));
        q.and(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        q.and(new QFilter("treeentryentity.bizstatus", "=", (Object)"A"));
        if (model.getDataEntity().containsProperty("headproject") && (headproject = (DynamicObject)model.getValue("headproject")) != null) {
            q.and(new QFilter("treeentryentity.project", "=", headproject.getPkValue()));
        }
        return q;
    }

    public static String getEntityName(IDataModel model, int seq) {
        String type = (String)model.getValue("materialtype");
        return MdcApplyBillUtils.getEntityName(type, seq);
    }

    public static String getEntityName(String materialtype, IDataModel model, int seq) {
        String type = (String)model.getValue(materialtype);
        return MdcApplyBillUtils.getEntityName(type, seq);
    }

    public static String getEntityName(String type, int seq) {
        String[] split = entityNameMap.get(type).split(",");
        return split[seq];
    }

    public static QFilter getBaseSatusQFilter() {
        return new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
    }

    public static List<Object> getOwners(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>();
        if (orgId == null) {
            return array;
        }
        List ownerOrgs = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)orgId, (String)"10", (boolean)false);
        if (ownerOrgs != null && !ownerOrgs.isEmpty()) {
            for (int i = 0; i < ownerOrgs.size(); ++i) {
                Long ownerOrgId = (Long)ownerOrgs.get(i);
                if (array.contains(ownerOrgId)) continue;
                array.add(ownerOrgs.get(i));
            }
        }
        return array;
    }

    public static Long[] getAllFinishInitWarehouseIDs(Long orgId) {
        QFilter orgQf = new QFilter("org.id", "=", (Object)orgId);
        QFilter initstatusQf = new QFilter("initstatus", "=", (Object)"B");
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter startstatusQf = new QFilter("startstatus", "=", (Object)"B");
        QFilter[] qfs = new QFilter[]{orgQf, initstatusQf, enableQf, startstatusQf};
        String algokey = "query-im_warehousesetup";
        String sels = "warehouse";
        HashSet<Long> warehouseIds = new HashSet<Long>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algokey, (String)"im_warehousesetup", (String)sels, (QFilter[])qfs, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long warehouseId = next.getLong("warehouse");
                if (MdcApplyBillUtils.isEmptyId(warehouseId)) continue;
                warehouseIds.add(warehouseId);
            }
        }
        return warehouseIds.toArray(new Long[0]);
    }

    private static boolean isEmptyId(Long longID) {
        if (longID == null) {
            return true;
        }
        return longID == 0L;
    }

    public static String stripStr(String str) {
        return StringUtils.strip((String)str, (String)"[]");
    }

    public static String getRandomStr() {
        String str = "ABCDEFGHIJKLMNOBQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            char ch = str.charAt(new SecureRandom().nextInt(36));
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void setValueByStr(AbstractFormDataModel parentModel, int insertEntryRow, int mainSeq) {
        for (String str : orderRelationStr) {
            parentModel.setValue(str, parentModel.getValue(str, mainSeq), insertEntryRow);
        }
        for (String str : replaceStr) {
            parentModel.setValue(str, parentModel.getValue(str, mainSeq), insertEntryRow);
        }
    }

    public static DataSet queryStockDataset(Set<Long> stockIds, String reqType) {
        QFilter qf = new QFilter("id", "in", stockIds);
        qf.and("stockentry.wipqty", ">", (Object)BigDecimal.ZERO);
        DataSet allStocks = QueryServiceHelper.queryDataSet((String)(MdcApplyBillUtils.class.getName() + "queryStockDataset"), (String)MdcApplyBillUtils.getEntityName(reqType, 1), (String)"id,billno,stockentry.id,stockentry.seq,stockentry.materielmasterid,stockentry.rejectedqty,stockentry.wipqty,stockentry.oprworkcenter,stockentry.workstation", (QFilter[])qf.toArray(), null).distinct();
        return allStocks;
    }

    public static void createSubEntryFromStockEntry(DataSet allDataSets, DynamicObject billentry) {
        Object workstation;
        if (allDataSets == null || billentry == null) {
            return;
        }
        long stockid = billentry.get("mainbillid") == null ? 0L : billentry.getLong("mainbillid");
        DynamicObject invMaterial = billentry.getDynamicObject("material");
        StringBuilder expr = new StringBuilder(150);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        long masterid = invMaterial.get("masterid") == null ? 0L : invMaterial.getDynamicObject("masterid").getLong("id");
        expr.append("id = stockid and stockentry.materielmasterid = masterid");
        params.put("stockid", stockid);
        params.put("masterid", masterid);
        Object workcenter = billentry.get("workcenter");
        if (workcenter != null) {
            expr.append(" and stockentry.oprworkcenter = oprworkcenterid");
            params.put("oprworkcenterid", ((DynamicObject)workcenter).getPkValue());
        }
        if ((workstation = billentry.get("workstation")) != null) {
            expr.append(" and stockentry.workstation = workstationid");
            params.put("workstationid", ((DynamicObject)workstation).getPkValue());
        }
        DynamicObjectCollection subentryentity = billentry.getDynamicObjectCollection("subentry");
        subentryentity.clear();
        try (DataSet filterData = allDataSets.copy().filter(expr.toString(), params).orderBy(new String[]{"stockentry.wipqty desc"});){
            MainEntityType worocenterEntity = EntityMetadataCache.getDataEntityType((String)"mpdm_workcentre");
            MainEntityType workstationEntity = EntityMetadataCache.getDataEntityType((String)"mpdm_workstation");
            BigDecimal auditbaseqty = billentry.get("auditbaseqty") == null ? new BigDecimal("0.00") : billentry.getBigDecimal("auditbaseqty");
            BigDecimal baseqty = billentry.get("baseqty") == null ? new BigDecimal("0.00") : billentry.getBigDecimal("baseqty");
            for (Row filterDatum : filterData) {
                Object stationid;
                BigDecimal refbaseqty;
                BigDecimal refauditbaseqty;
                BigDecimal wipqty;
                BigDecimal bigDecimal = wipqty = filterDatum.get("stockentry.wipqty") == null ? new BigDecimal("0.00") : filterDatum.getBigDecimal("stockentry.wipqty");
                if (auditbaseqty.compareTo(wipqty) >= 0) {
                    refauditbaseqty = wipqty;
                    refbaseqty = wipqty;
                    auditbaseqty = auditbaseqty.subtract(wipqty);
                    baseqty = baseqty.subtract(wipqty);
                } else {
                    refauditbaseqty = auditbaseqty;
                    refbaseqty = baseqty;
                    auditbaseqty = new BigDecimal("0.00");
                }
                DynamicObject subentry = new DynamicObject(subentryentity.getDynamicObjectType());
                subentry.set("refmaterial", (Object)invMaterial);
                subentry.set("refunit", billentry.get("baseunit"));
                subentry.set("refbaseqty", (Object)refbaseqty);
                subentry.set("refauditbaseqty", (Object)refauditbaseqty);
                subentry.set("refstockno", filterDatum.get("billno"));
                subentry.set("refstockentryid", filterDatum.get("stockentry.id"));
                subentry.set("refstockentryseq", filterDatum.get("stockentry.seq"));
                subentry.set("backbaseqty", filterDatum.get("stockentry.rejectedqty"));
                subentry.set("wipqty", filterDatum.get("stockentry.wipqty"));
                subentry.set("workcener", filterDatum.get("stockentry.oprworkcenter"));
                subentry.set("refworkstation", filterDatum.get("stockentry.workstation"));
                Object workCenterid = filterDatum.get("stockentry.oprworkcenter");
                if (workCenterid != null) {
                    DynamicObject workcentere = new DynamicObject((DynamicObjectType)worocenterEntity);
                    workcentere.set("id", workCenterid);
                    subentry.set("workcener", (Object)workcentere);
                }
                if ((stationid = filterDatum.get("stockentry.workstation")) != null) {
                    DynamicObject workstatione = new DynamicObject((DynamicObjectType)workstationEntity);
                    workstatione.set("id", stationid);
                    subentry.set("refworkstation", (Object)workstatione);
                }
                subentryentity.add((Object)subentry);
                if (auditbaseqty.compareTo(BigDecimal.ZERO) > 0) continue;
                break;
            }
        }
    }

    static {
        entityNameMap.put("A", "pom_mftorder,pom_mftstock");
        entityNameMap.put("B", "pom_mroorder,pom_mrostock");
        entityNameMap.put("C", "om_mftorder,om_mftstock");
        entityNameMap.put("E", "prop_mftorder,prop_mftstock");
        orderRelationStr = new String[]{"orderno", "orderid", "orderentryid", "orderentryseq", "mainbillid", "mainbillentity", "mainbillnumber", "customer", "project", "workcard"};
        replaceStr = new String[]{"demanddate", "deliverdate", "tracknumber", "supplymode", "supplierid"};
    }
}

