/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.formplugin.mdc.mftreqbill.MdcApplyBillUtils;

public class MdcMftReqReplaceSetEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("billentry");
        IDataModel parentModel = this.getView().getParentView().getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        if (entryGrid != null) {
            int[] selectRows = entryGrid.getSelectRows();
            DynamicObjectCollection billentrys = parentModel.getEntryEntity("billentry");
            ArrayList<DynamicObject> mainDymList = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> repDymList = new ArrayList<DynamicObject>(16);
            this.setRepDym(selectRows, billentrys, mainDymList, repDymList);
            String[] names = new String[]{"m", ""};
            model.beginInit();
            for (String name : names) {
                TableValueSetter vs = new TableValueSetter(new String[0]);
                this.setTableValue(vs, name, mainDymList, repDymList);
                model.batchCreateNewEntryRow(name + "billentry", vs);
            }
            DynamicObjectCollection mbillentrys = model.getEntityEntity("mbillentry");
            int label = 1;
            for (DynamicObject mbillentry : mbillentrys) {
                if (!mbillentry.getBoolean("mismainreplace")) continue;
                label = 2;
            }
            if (label == 1) {
                model.setValue("mismainreplace", (Object)true, 0);
            }
            model.setValue("org", parentModel.getValue("invorg"));
            model.endInit();
            this.getView().updateView("mbillentry");
            this.getView().updateView("billentry");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("newentry".equals(e.getOperateKey())) {
            int mainSeq = this.getMainSeq();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            DynamicObjectCollection billentrys = model.getEntityEntity("billentry");
            model.setValue("priority", (Object)((DynamicObject)billentrys.get(billentrys.size() - 1)).getInt("seq"), billentrys.size() - 1);
            model.setValue("qty", this.getModel().getValue("mqty", mainSeq - 1), billentrys.size() - 1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        if ("material".equals(key) && "0".equals(model.getValue("priority", changeIndex).toString())) {
            model.setValue("priority", (Object)(changeIndex + 1), changeIndex);
            model.setValue("qty", this.getModel().getValue("mqty", this.getMainSeq() - 1), changeIndex);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey()) && this.valOk()) {
            this.returnParent();
        }
    }

    private void returnParent() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection billentrys = model.getEntityEntity("billentry");
        DynamicObjectCollection mbillentrys = model.getEntityEntity("mbillentry");
        AbstractFormDataModel parentModel = (AbstractFormDataModel)this.getView().getParentView().getModel();
        parentModel.beginInit();
        int mainSeq = this.getMainSeq();
        String replacegroup = this.getReplaceGroup(mainSeq);
        for (DynamicObject mbillentry : mbillentrys) {
            parentModel.setValue("replacegroup", (Object)replacegroup, mbillentry.getInt("mseq") - 1);
            parentModel.setValue("qty", mbillentry.get("mqty"), mbillentry.getInt("mseq") - 1);
            parentModel.setValue("auditqty", mbillentry.get("mqty"), mbillentry.getInt("mseq") - 1);
            DynamicObject mmaterial = mbillentry.getDynamicObject("mmaterial");
            BigDecimal baseQty = this.getBaseQty(mmaterial, mbillentry.getDynamicObject("munit"), mbillentry.getBigDecimal("mqty"));
            parentModel.setValue("baseqty", (Object)baseQty, mbillentry.getInt("mseq") - 1);
            parentModel.setValue("auditbaseqty", (Object)baseQty, mbillentry.getInt("mseq") - 1);
            parentModel.setValue("ismainreplace", mbillentry.get("mismainreplace"), mbillentry.getInt("mseq") - 1);
        }
        this.delParentRow();
        for (int i = billentrys.size() - 1; i >= 0; --i) {
            DynamicObject billentry = (DynamicObject)billentrys.get(i);
            DynamicObject material = billentry.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject masterid = material.getDynamicObject("masterid");
            int insertEntryRow = parentModel.insertEntryRow("billentry", mainSeq);
            parentModel.setValue("auxpty", billentry.get("auxpty"), insertEntryRow);
            parentModel.setValue("unit", billentry.get("unit"), insertEntryRow);
            parentModel.setValue("baseunit", masterid.get("baseunit"), insertEntryRow);
            parentModel.setValue("qty", billentry.get("qty"), insertEntryRow);
            parentModel.setValue("auditqty", billentry.get("qty"), insertEntryRow);
            BigDecimal baseQty = this.getBaseQty(material, billentry.getDynamicObject("unit"), billentry.getBigDecimal("qty"));
            parentModel.setValue("baseqty", (Object)baseQty, insertEntryRow);
            parentModel.setValue("auditbaseqty", (Object)baseQty, insertEntryRow);
            MdcApplyBillUtils.setValueByStr(parentModel, insertEntryRow, mainSeq - 1);
            parentModel.setValue("material", (Object)material, insertEntryRow);
            parentModel.setValue("materielmasterid", (Object)masterid, insertEntryRow);
            parentModel.setValue("materialname", (Object)masterid.getString("name"), insertEntryRow);
            parentModel.setValue("lengthunit", masterid.get("lengthunit"), insertEntryRow);
            parentModel.setValue("length", masterid.get("length"), insertEntryRow);
            parentModel.setValue("width", masterid.get("width"), insertEntryRow);
            parentModel.setValue("height", masterid.get("height"), insertEntryRow);
            parentModel.setValue("unit2nd", masterid.get("auxptyunit"), insertEntryRow);
            parentModel.setValue("isreplace", (Object)true, insertEntryRow);
            parentModel.setValue("replacegroup", (Object)replacegroup, insertEntryRow);
            parentModel.setValue("ismainreplace", billentry.get("ismainreplace"), insertEntryRow);
            parentModel.setValue("priority", billentry.get("priority"), insertEntryRow);
        }
        parentModel.endInit();
        this.getView().getParentView().updateView("billentry");
        this.getView().close();
    }

    private void delParentRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("billentry");
        IDataModel parentModel = this.getView().getParentView().getModel();
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection billentrys = parentModel.getEntryEntity("billentry");
        ArrayList<DynamicObject> mainDymList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> repDymList = new ArrayList<DynamicObject>(16);
        this.setRepDym(selectRows, billentrys, mainDymList, repDymList);
        if (!repDymList.isEmpty()) {
            int[] rowIndex = new int[repDymList.size()];
            for (int i = 0; i < repDymList.size(); ++i) {
                DynamicObject billentry = (DynamicObject)repDymList.get(i);
                rowIndex[i] = billentry.getInt("seq") - 1;
            }
            parentModel.deleteEntryRows("billentry", rowIndex);
        }
    }

    private boolean valOk() {
        ArrayList<String> errList = new ArrayList<String>(16);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection billentrys = model.getEntityEntity("billentry");
        DynamicObjectCollection mbillentrys = model.getEntityEntity("mbillentry");
        int i = 0;
        for (DynamicObject mentry : mbillentrys) {
            if (!mentry.getBoolean("mismainreplace")) continue;
            ++i;
        }
        if (i > 1 || i == 0) {
            errList.add(ResManager.loadKDString((String)"\u201c\u4e3b\u7269\u6599\u201d\u53ea\u80fd\u6709\u4e00\u4e2a\u66ff\u4ee3\u4e3b\u6599\u3002", (String)"MdcMftReqReplaceSetEdit_2", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
        HashMap<Integer, Integer> priorityMap = new HashMap<Integer, Integer>(16);
        HashSet<Integer> prioritySet = new HashSet<Integer>(16);
        for (DynamicObject mentry : billentrys) {
            int priority = mentry.getInt("priority");
            prioritySet.add(priority);
            if (!mentry.getBoolean("ismainreplace")) continue;
            if (priorityMap.get(priority) == null) {
                priorityMap.put(priority, 1);
                continue;
            }
            errList.add(ResManager.loadKDString((String)"\u201c\u66ff\u4ee3\u7269\u6599\u201d\u540c\u4e00\u4f18\u5148\u7ea7\u53ea\u80fd\u6709\u4e00\u4e2a\u66ff\u4ee3\u4e3b\u6599\u3002", (String)"MdcMftReqReplaceSetEdit_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            break;
        }
        for (Integer priority : prioritySet) {
            if (priorityMap.get(priority) != null) continue;
            errList.add(ResManager.loadKDString((String)"\u201c\u66ff\u4ee3\u7269\u6599\u201d\u540c\u4e00\u4f18\u5148\u7ea7\u53ea\u80fd\u6709\u4e00\u4e2a\u66ff\u4ee3\u4e3b\u6599\u3002", (String)"MdcMftReqReplaceSetEdit_3", (String)"scmc-mm-mdc", (Object[])new Object[0]));
            break;
        }
        if (billentrys.isEmpty()) {
            errList.add(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u66ff\u4ee3\u7269\u6599\u3002", (String)"MdcMftReqReplaceSetEdit_4", (String)"scmc-mm-mdc", (Object[])new Object[0]));
        }
        this.valMaterialEquals(mbillentrys, billentrys, errList);
        if (!errList.isEmpty()) {
            this.getView().showTipNotification(MdcApplyBillUtils.stripStr(((Object)errList).toString()));
            return false;
        }
        return true;
    }

    private void valMaterialEquals(DynamicObjectCollection mbillentrys, DynamicObjectCollection billentrys, List<String> errList) {
        for (int m = 0; m < mbillentrys.size(); ++m) {
            DynamicObject mbillentry = (DynamicObject)mbillentrys.get(m);
            DynamicObject mmaterial = mbillentry.getDynamicObject("mmaterial");
            for (int n = 0; n < billentrys.size(); ++n) {
                DynamicObject billentry = (DynamicObject)billentrys.get(n);
                DynamicObject material = billentry.getDynamicObject("material");
                if (material == null || !mmaterial.getPkValue().equals(material.getPkValue())) continue;
                errList.add(String.format(ResManager.loadKDString((String)"\u201c\u4e3b\u7269\u6599\u201d\u7b2c%1$s\u884c\u4e0e\u201c\u66ff\u4ee3\u7269\u6599\u201d\u7b2c%2$s\u884c\u5206\u5f55\u7269\u6599\u4e00\u81f4\u3002", (String)"MdcMftReqReplaceSetEdit_5", (String)"scmc-mm-mdc", (Object[])new Object[0]), m + 1, n + 1));
                return;
            }
        }
    }

    private BigDecimal getBaseQty(DynamicObject mmaterial, DynamicObject unit, BigDecimal qty) {
        DynamicObject masterid = mmaterial.getDynamicObject("masterid");
        DynamicObject baseunit = masterid.getDynamicObject("baseunit");
        return BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masterid, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseunit);
    }

    private String getReplaceGroup(int mainSeq) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String replacegroup = MdcApplyBillUtils.getRandomStr();
        DynamicObjectCollection mbillentrys = model.getEntityEntity("mbillentry");
        for (int i = 0; i < mbillentrys.size(); ++i) {
            DynamicObject mbillentry = (DynamicObject)mbillentrys.get(i);
            if (mbillentry.getInt("mseq") != mainSeq || "".equals(mbillentry.getString("mreplacegroup"))) continue;
            replacegroup = mbillentry.getString("mreplacegroup");
        }
        return replacegroup;
    }

    private int getMainSeq() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection mbillentrys = model.getEntityEntity("mbillentry");
        for (int i = 0; i < mbillentrys.size(); ++i) {
            DynamicObject mbillentry = (DynamicObject)mbillentrys.get(i);
            if (!mbillentry.getBoolean("mismainreplace")) continue;
            return mbillentry.getInt("mseq");
        }
        return ((DynamicObject)mbillentrys.get(0)).getInt("mseq");
    }

    private void setTableValue(TableValueSetter vs, String name, List<DynamicObject> mainDymList, List<DynamicObject> repDymList) {
        List<DynamicObject> dymList;
        vs.addField(name + "material", new Object[0]);
        vs.addField(name + "auxpty", new Object[0]);
        vs.addField(name + "unit", new Object[0]);
        vs.addField(name + "qty", new Object[0]);
        vs.addField(name + "ismainreplace", new Object[0]);
        vs.addField(name + "priority", new Object[0]);
        if ("m".equals(name)) {
            vs.addField("mseq", new Object[0]);
            vs.addField("mreplacegroup", new Object[0]);
            dymList = mainDymList;
        } else {
            vs.addField("cseq", new Object[0]);
            dymList = repDymList;
        }
        for (DynamicObject dym : dymList) {
            DynamicObject dvalue1 = dym.getDynamicObject("material");
            DynamicObject dvalue2 = dym.getDynamicObject("auxpty");
            DynamicObject dvalue3 = dym.getDynamicObject("unit");
            Long value1 = dvalue1 == null ? Long.valueOf("0") : (Long)dvalue1.getPkValue();
            Long value2 = dvalue2 == null ? Long.valueOf("0") : (Long)dvalue2.getPkValue();
            Long value3 = dvalue3 == null ? Long.valueOf("0") : (Long)dvalue3.getPkValue();
            Object value4 = dym.get("qty");
            Object value5 = dym.get("ismainreplace");
            Object value6 = dym.get("priority");
            if ("m".equals(name)) {
                Object value8 = dym.get("replacegroup");
                vs.addRow(new Object[]{value1, value2, value3, value4, value5, value6, dym.get("seq"), value8});
                continue;
            }
            vs.addRow(new Object[]{value1, value2, value3, value4, value5, value6, dym.get("seq")});
        }
    }

    private void setRepDym(int[] selectRows, DynamicObjectCollection billentrys, List<DynamicObject> mainDymList, List<DynamicObject> repDymList) {
        Object object;
        String replacegroup = "";
        for (Object index : selectRows) {
            DynamicObject billentry = (DynamicObject)billentrys.get(index);
            if (!"".equals(replacegroup)) continue;
            replacegroup = billentry.getString("replacegroup");
        }
        if (!"".equals(replacegroup)) {
            object = billentrys.iterator();
            while (object.hasNext()) {
                DynamicObject billentry = (DynamicObject)object.next();
                Boolean isreplace = billentry.getBoolean("isreplace");
                if (replacegroup.equals(billentry.getString("replacegroup")) && !isreplace.booleanValue() && !mainDymList.contains(billentry)) {
                    mainDymList.add(billentry);
                    continue;
                }
                if (!replacegroup.equals(billentry.getString("replacegroup")) || !isreplace.booleanValue() || repDymList.contains(billentry)) continue;
                repDymList.add(billentry);
            }
        } else {
            object = selectRows;
            int n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                Object index;
                index = object[i];
                mainDymList.add((DynamicObject)billentrys.get(index));
            }
        }
    }
}

