/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang.StringUtils;

public class MdcReqBillSubmitMaterialOnAddVal
extends AbstractValidator {
    public void validate() {
        Map<String, List<String>> orgMaterinfo = this.getOrgMaterinfo();
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject reqBill = rowDataEntity.getDataEntity();
            if (reqBill.getDynamicObject("org") == null) continue;
            String org = reqBill.getDynamicObject("org").getPkValue().toString();
            String sbillno = reqBill.getString("billno");
            StringBuilder errinfo = new StringBuilder();
            DynamicObjectCollection entrys = reqBill.getDynamicObjectCollection("billentry");
            HashSet<Integer> existSeq = new HashSet<Integer>(16);
            this.valEntrys(entrys, errinfo, existSeq, org);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if (existSeq.contains(i + 1)) continue;
                String billno = this.getDifBillno(entry, orgMaterinfo, org, sbillno);
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null) continue;
                DynamicObject master = material.getDynamicObject("masterid");
                if ("".equals(billno)) continue;
                errinfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5355\u7269\u6599\u201c%2$s\u201d\u3001\u201c%3$s\u201d\uff0c\u5728\u751f\u4ea7\u9886\u6599\u7533\u8bf7\u5355\u201c%4$s\u201d\u4e0a\u5b58\u5728\u76f8\u540c\u7684\u7533\u8bf7\u8bb0\u5f55\u3002", (String)"MdcReqBillSubmitMaterialOnAddVal_3", (String)"scmc-mm-mdc", (Object[])new Object[0]), i + 1, master.getString("number"), master.getString("name"), billno));
            }
            if ("".equals(errinfo.toString())) continue;
            this.addWarningMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"%s\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\u9886\u6599\u7533\u8bf7\uff1f", (String)"MdcReqBillSubmitMaterialOnAddVal_1", (String)"scmc-mm-mdc", (Object[])new Object[0]), errinfo.toString()));
        }
    }

    private void valEntrys(DynamicObjectCollection entrys, StringBuilder errinfo, Set<Integer> existSeq, String org) {
        HashMap<String, ArrayList<Integer>> infoSeq = new HashMap<String, ArrayList<Integer>>(16);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String key = this.getStr(entry, org);
            if ("".equals(key)) continue;
            ArrayList<Integer> seqList = (ArrayList<Integer>)infoSeq.get(key);
            if (seqList == null) {
                seqList = new ArrayList<Integer>(16);
            }
            seqList.add(i + 1);
            infoSeq.put(key, seqList);
        }
        for (Map.Entry m : infoSeq.entrySet()) {
            List value = (List)m.getValue();
            if (value == null || value.size() <= 1) continue;
            errinfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u5bf9\u5e94\u7684\u5de5\u5355\u7269\u6599\u76f8\u540c", (String)"MdcReqBillSubmitMaterialOnAddVal_2", (String)"scmc-mm-mdc", (Object[])new Object[0]), StringUtils.strip((String)value.toString(), (String)"[]")));
            for (Integer seq : value) {
                existSeq.add(seq);
            }
        }
    }

    private String getDifBillno(DynamicObject entry, Map<String, List<String>> orgMaterinfo, String org, String sbillno) {
        List<String> newlist;
        List<String> list;
        String billno = "";
        String key = this.getStr(entry, org);
        if (!"".equals(key) && (list = orgMaterinfo.get(key)) != null && !(newlist = this.getNewList(list, sbillno)).isEmpty()) {
            billno = StringUtils.strip((String)newlist.toString(), (String)"[]");
        }
        return billno;
    }

    private List<String> getNewList(List<String> list, String sbillno) {
        ArrayList<String> newlist = new ArrayList<String>(list.size());
        for (String billno : list) {
            if (billno.equals(sbillno) || newlist.contains(billno)) continue;
            newlist.add(billno);
        }
        return newlist;
    }

    private String getStr(DynamicObject entry, String org) {
        if (!"".equals(entry.getString("orderno"))) {
            String orderno = entry.getString("orderno");
            if (entry.getDynamicObject("material") != null) {
                String material = entry.getDynamicObject("material").getPkValue().toString();
                return this.getMaterialInfo(org, orderno, material);
            }
        }
        return "";
    }

    private Map<String, List<String>> getOrgMaterinfo() {
        HashMap<String, List<String>> orgMaterinfo = new HashMap<String, List<String>>(16);
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<String> orderSet = new HashSet<String>(16);
        HashSet<Long> materialSet = new HashSet<Long>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject reqBill = rowDataEntity.getDataEntity();
            if (reqBill.getDynamicObject("org") != null) {
                orgSet.add((Long)reqBill.getDynamicObject("org").getPkValue());
            }
            DynamicObjectCollection entrys = reqBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                if (!"".equals(entry.getString("orderno"))) {
                    orderSet.add(entry.getString("orderno"));
                }
                if (entry.getDynamicObject("material") == null) continue;
                materialSet.add((Long)entry.getDynamicObject("material").getPkValue());
            }
        }
        if (!(orgSet.isEmpty() || orderSet.isEmpty() || materialSet.isEmpty())) {
            QFilter q = new QFilter("org", "in", orgSet);
            q.and("billentry.orderno", "in", orderSet);
            q.and("billentry.material", "in", materialSet);
            DynamicObjectCollection querys = QueryServiceHelper.query((String)"im_mdc_mftreqbill", (String)"billno,org,billentry.orderno,billentry.material", (QFilter[])new QFilter[]{q});
            for (DynamicObject query : querys) {
                String material;
                String orderno;
                String org = query.getString("org");
                String key = this.getMaterialInfo(org, orderno = query.getString("billentry.orderno"), material = query.getString("billentry.material"));
                ArrayList<String> list = (ArrayList<String>)orgMaterinfo.get(key);
                if (list == null) {
                    list = new ArrayList<String>(16);
                }
                list.add(query.getString("billno"));
                orgMaterinfo.put(key, list);
            }
        }
        return orgMaterinfo;
    }

    private String getMaterialInfo(String org, String orderno, String material) {
        StringBuilder sb = new StringBuilder();
        sb.append(org);
        sb.append(orderno);
        sb.append(material);
        return sb.toString();
    }
}

