/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqbill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class MdcReqBillUnAuditReplaceLogOp
extends AbstractOperationServicePlugIn {
    private static String[] entryFields = new String[]{"materielmasterid", "material", "unit", "qty", "baseunit", "baseqty", "priority", "ismainreplace"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("billentry");
        keys.add("material");
        keys.add("baseqty");
        keys.add("qty");
        keys.add("auditqty");
        keys.add("rowstatus");
        keys.add("orderno");
        keys.add("replacegroup");
        keys.add("isreplace");
        for (String entryField : entryFields) {
            keys.add(entryField);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String name = this.billEntityType.getName();
        if (!"im_mdc_mftreqbill".equals(name)) {
            return;
        }
        DynamicObject[] bills = e.getDataEntities();
        HashSet<String> repGroupSet = new HashSet<String>(16);
        HashSet<Long> reqIdSet = new HashSet<Long>(16);
        HashSet<String> reqIdGroupSet = new HashSet<String>(16);
        HashMap<String, List<DynamicObject>> repDymMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject bill : bills) {
            this.setRepInfo(repGroupSet, reqIdSet, reqIdGroupSet, repDymMap, bill);
        }
        if (!repGroupSet.isEmpty()) {
            this.deleteRepLog(repGroupSet, reqIdSet, reqIdGroupSet);
        }
    }

    private void deleteRepLog(Set<String> repGroupSet, Set<Long> reqIdSet, Set<String> reqIdGroupSet) {
        HashMap<String, Long> repLogMap = new HashMap<String, Long>(16);
        QFilter q = new QFilter("replacegroup", "in", repGroupSet);
        q.and(new QFilter("srcbillid", "in", reqIdSet));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"im_mdc_replacelog", (String)"id,replacegroup,srcbillid", (QFilter[])new QFilter[]{q});
        for (DynamicObject obj : query) {
            String srcbillid = obj.get("srcbillid").toString();
            String replaceGroup = obj.get("replacegroup").toString();
            repLogMap.put(this.getStr(srcbillid, replaceGroup), obj.getLong("id"));
        }
        HashSet repLogIdSet = new HashSet(16);
        for (String reqIdGroup : reqIdGroupSet) {
            if (repLogMap.get(reqIdGroup) == null) continue;
            repLogIdSet.add(repLogMap.get(reqIdGroup));
        }
        if (!repLogIdSet.isEmpty()) {
            DeleteServiceHelper.delete((String)"im_mdc_replacelog", (QFilter[])new QFilter[]{new QFilter("id", "in", repLogIdSet)});
        }
    }

    private void setRepInfo(Set<String> repGroupSet, Set<Long> reqIdSet, Set<String> reqIdGroupSet, Map<String, List<DynamicObject>> repDymMap, DynamicObject bill) {
        Object pkValue = bill.getPkValue();
        reqIdSet.add((Long)pkValue);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            String repGroup = entry.getString("replacegroup");
            if ("".equals(repGroup)) continue;
            repGroupSet.add(repGroup);
            reqIdGroupSet.add(this.getStr(pkValue.toString(), repGroup));
            List<DynamicObject> list = repDymMap.get(this.getStr(pkValue.toString(), repGroup));
            if (list == null) {
                list = new ArrayList<DynamicObject>(16);
            }
            list.add(entry);
            repDymMap.put(this.getStr(pkValue.toString(), repGroup), list);
        }
    }

    private String getStr(String srcbillid, String replaceGroup) {
        return srcbillid + "," + replaceGroup;
    }
}

