/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.mdc.mftreqoutbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.common.mdc.enums.BillTypeEnum;

public class MftReqOutBillComponentsEdit
extends AbstractBillPlugIn
implements ClickListener {
    public static final String ENTITY_MATERIALREPLACE = "materialreplace";
    public static final String ENTITY_MATERIALREP = "materialrep";
    public static final String ENTITY_STOCKENTRYID = "stockentryid";
    public static final String ENTITY_STOCKENTRYSEQ = "stockentryseq";
    public static final String ENTITY_ENTITY = "billentry";
    public static final String KEY_OUTSTOCK_BILL = "om_mftstock";
    public static final String KEY_STOCK_BILL = "pom_mftstock";
    public static final String ENTITY_MANUBILL = "manubill";
    public static final String ENTITY_STOCKBILLNO = "stockbillno";
    public static final String ENTITYID_MATERIALREPLACE_F7 = "im_mdc_mftstockf7";
    public static final String ENTITYID_OUTMATERIALREPLACE_F7 = "im_mdc_outmftstockf7";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit workshop = (TextEdit)this.getView().getControl(ENTITY_MATERIALREPLACE);
        workshop.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billEntityName = this.getModel().getDataEntity().getDataEntityType().getName();
        this.getModel().setValue("billentity", (Object)billEntityName);
    }

    public void initImportData(InitImportDataEventArgs e) {
        Object operatorMap;
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        HashSet<String> operatornumbers = new HashSet<String>(sourceDataList.size());
        HashSet<String> operatorgroups = new HashSet<String>(sourceDataList.size());
        HashMap<String, Long> operatorAndGroup2Id = new HashMap<String, Long>(sourceDataList.size());
        for (Map sourceData : sourceDataList) {
            Object operatorgroupMap;
            operatorMap = (Map)sourceData.get("operator");
            if (operatorMap != null && operatorMap.get("operatornumber") != null) {
                operatornumbers.add(operatorMap.get("operatornumber").toString());
            }
            if ((operatorgroupMap = (Map)sourceData.get("operatorgroup")) == null || operatorgroupMap.get("number") == null) continue;
            operatorgroups.add(operatorgroupMap.get("number").toString());
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        qfilters.add(new QFilter("operatornumber", "in", operatornumbers));
        qfilters.add(new QFilter("opergrpnumber", "in", operatorgroups));
        DataSet dataset = QueryServiceHelper.queryDataSet((String)"initImportData", (String)"bd_operator", (String)"id,operatornumber,opergrpnumber", (QFilter[])qfilters.toArray(new QFilter[0]), null);
        operatorMap = null;
        try {
            for (Row row : dataset) {
                String operatornumber = row.getString("operatornumber");
                String opergrpnumber = row.getString("opergrpnumber");
                if (!StringUtils.isNotEmpty((CharSequence)operatornumber) || !StringUtils.isNotEmpty((CharSequence)opergrpnumber)) continue;
                operatorAndGroup2Id.put(operatornumber + "-" + opergrpnumber, row.getLong("id"));
            }
        }
        catch (Throwable operatorgroupMap) {
            operatorMap = operatorgroupMap;
            throw operatorgroupMap;
        }
        finally {
            if (dataset != null) {
                if (operatorMap != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable operatorgroupMap) {
                        ((Throwable)operatorMap).addSuppressed(operatorgroupMap);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        if (!operatorAndGroup2Id.isEmpty()) {
            for (Map sourceData : sourceDataList) {
                String key;
                Map operatorMap2 = (Map)sourceData.get("operator");
                Map operatorgroupMap = (Map)sourceData.get("operatorgroup");
                if (operatorMap2 == null || operatorMap2.get("operatornumber") == null || operatorgroupMap == null || operatorgroupMap.get("number") == null || operatorAndGroup2Id.get(key = operatorMap2.get("operatornumber").toString() + "-" + operatorgroupMap.get("number").toString()) == null) continue;
                operatorMap2.put("id", operatorAndGroup2Id.get(key));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (key.equals(ENTITY_MATERIALREPLACE)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY_ENTITY);
            String manubill = (String)this.getModel().getValue(ENTITY_MANUBILL, entryCurrentRowIndex);
            String name = this.getModel().getDataEntityType().getName();
            if (StringUtils.isBlank((CharSequence)manubill)) {
                String orderNoName = MftReqOutBillComponentsEdit.queryName(ENTITY_MANUBILL, name);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%2$s\u201d\u3002", (String)"MftReqOutBillComponentsEdit_0", (String)"scmc-mm-mdc", (Object[])new Object[0]), entryCurrentRowIndex + 1, orderNoName));
                evt.setCancel(true);
                return;
            }
            Long mainbillid = (Long)this.getModel().getValue("mainbillid");
            String stockName = ENTITYID_OUTMATERIALREPLACE_F7;
            if (StringUtils.equals((CharSequence)name, (CharSequence)BillTypeEnum.FEED_ORDER.getName())) {
                stockName = ENTITYID_MATERIALREPLACE_F7;
            }
            QFilter qfList = new QFilter("entryid", "=", (Object)mainbillid);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)stockName, (boolean)false);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ENTITY_MATERIALREPLACE);
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qfList.toArray()));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String materialreplace;
        super.propertyChanged(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTITY_ENTITY);
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        int rowIndex = entryGrid.getSelectRows()[0];
        String key = e.getProperty().getName();
        if (ENTITY_MATERIALREPLACE.equals(key) && StringUtils.isBlank((CharSequence)(materialreplace = (String)this.getModel().getValue(ENTITY_MATERIALREPLACE, rowIndex)))) {
            this.getModel().setValue(ENTITY_MATERIALREP, null, rowIndex);
            this.getModel().setValue(ENTITY_STOCKENTRYID, null, rowIndex);
            this.getModel().setValue(ENTITY_STOCKENTRYSEQ, null, rowIndex);
            this.getModel().setValue(ENTITY_STOCKBILLNO, null, rowIndex);
        }
        if (ENTITY_MANUBILL.equals(key)) {
            String orderno = (String)this.getModel().getValue(ENTITY_MANUBILL, rowIndex);
            this.getModel().setValue(ENTITY_MATERIALREPLACE, null, rowIndex);
        }
        if ("outinvtype".equals(key)) {
            Object outinvType = this.getModel().getValue("outinvtype", rowIndex);
            Long outinvTypeId = MftReqOutBillComponentsEdit.getDyObjId(outinvType);
            DynamicObject invScheme = (DynamicObject)this.getModel().getValue("invscheme");
            if (invScheme != null) {
                DynamicObjectCollection outInvTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
                for (DynamicObject dyn : outInvTypeEntry) {
                    Object outinvtype = dyn.get("outinvtype");
                    Long dyObjId = MftReqOutBillComponentsEdit.getDyObjId(outinvtype);
                    String outOwnerType = dyn.getString("outownertype1");
                    String outKeeperType = dyn.getString("outkeepertype1");
                    if (dyObjId == null || !dyObjId.equals(outinvTypeId) || "".equals(outOwnerType) || "".equals(outKeeperType)) continue;
                    this.getModel().setValue("outownertype", (Object)outOwnerType, rowIndex);
                    this.getModel().setValue("outkeepertype", (Object)outKeeperType, rowIndex);
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (ENTITY_MATERIALREPLACE.equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTITY_ENTITY);
            if (rows != null && !rows.isEmpty()) {
                DynamicObject masterid;
                DynamicObject mftstockf7;
                Object pkValue = rows.get(0).getPrimaryKeyValue();
                String name = this.getModel().getDataEntityType().getName();
                String stockName = ENTITYID_OUTMATERIALREPLACE_F7;
                String stock = KEY_OUTSTOCK_BILL;
                if (StringUtils.equals((CharSequence)name, (CharSequence)BillTypeEnum.FEED_ORDER.getName())) {
                    stockName = ENTITYID_MATERIALREPLACE_F7;
                    stock = KEY_STOCK_BILL;
                }
                if ((mftstockf7 = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)stockName)) == null) {
                    return;
                }
                DynamicObject materialid = (DynamicObject)mftstockf7.get("materialid");
                if (materialid != null && null != (masterid = materialid.getDynamicObject("masterid"))) {
                    String number = masterid.getString("number");
                    this.getModel().setValue(ENTITY_MATERIALREPLACE, (Object)number, entryCurrentRowIndex);
                }
                this.getModel().setValue(ENTITY_MATERIALREP, (Object)materialid, entryCurrentRowIndex);
                this.getModel().setValue(ENTITY_STOCKENTRYID, pkValue, entryCurrentRowIndex);
                this.getModel().setValue(ENTITY_STOCKENTRYSEQ, mftstockf7.get("rowseq"), entryCurrentRowIndex);
                Long mainbillid = (Long)this.getModel().getValue("mainbillid");
                DynamicObject stockBill = BusinessDataServiceHelper.loadSingle((Object)mainbillid, (String)stock, (String)"billno");
                if (null != stockBill) {
                    this.getModel().setValue(ENTITY_STOCKBILLNO, stockBill.get("billno"), entryCurrentRowIndex);
                }
            }
        }
    }

    public static String queryName(String field, String entityNum) {
        Map allFieldMap = EntityMetadataCache.getDataEntityType((String)entityNum).getAllFields();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFieldMap.get(field);
        if (iDataEntityProperty != null) {
            String strname = iDataEntityProperty.getName();
            LocaleString name = iDataEntityProperty.getDisplayName();
            if (!name.isEmpty()) {
                strname = name.toString();
            }
            return strname;
        }
        return null;
    }

    public static Long getDyObjId(Object dyObj) {
        if (dyObj == null) {
            return null;
        }
        if (dyObj instanceof DynamicObject) {
            return ((DynamicObject)dyObj).getLong("id");
        }
        if (dyObj instanceof Long) {
            return (Long)dyObj;
        }
        return null;
    }
}

